/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.processwarehousetask.WarehouseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.processwarehousetask.WarehouseOrderPickHndlgUnit;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.processwarehousetask.WarehouseTask;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.processwarehousetask.WarehouseTaskExceptionCode;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.processwarehousetask.WarehouseTaskSerialNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProcessWarehouseTaskService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultProcessWarehouseTaskService")
public class DefaultProcessWarehouseTaskService
implements ServiceWithNavigableEntities,
ProcessWarehouseTaskService {
    @Nonnull
    private final String servicePath;

    public DefaultProcessWarehouseTaskService() {
        this.servicePath = "/sap/opu/odata4/sap/api_warehouse_order_task_2/srvd_a2x/sap/warehouseorder/0001";
    }

    private DefaultProcessWarehouseTaskService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProcessWarehouseTaskService withServicePath(@Nonnull String servicePath) {
        return new DefaultProcessWarehouseTaskService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<WarehouseOrder> getAllWarehouseOrder() {
        return new GetAllRequestBuilder(this.servicePath, WarehouseOrder.class, "WarehouseOrder");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<WarehouseOrder> countWarehouseOrder() {
        return new CountRequestBuilder(this.servicePath, WarehouseOrder.class, "WarehouseOrder");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<WarehouseOrder> getWarehouseOrderByKey(String eWMWarehouse, String warehouseOrder) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("EWMWarehouse", eWMWarehouse);
        key.put("WarehouseOrder", warehouseOrder);
        return new GetByKeyRequestBuilder(this.servicePath, WarehouseOrder.class, key, "WarehouseOrder");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<WarehouseOrder> createWarehouseOrder(@Nonnull WarehouseOrder warehouseOrder) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)warehouseOrder, "WarehouseOrder");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<WarehouseOrder> updateWarehouseOrder(@Nonnull WarehouseOrder warehouseOrder) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)warehouseOrder, "WarehouseOrder");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<WarehouseOrderPickHndlgUnit> getAllWarehouseOrderPickHndlgUnit() {
        return new GetAllRequestBuilder(this.servicePath, WarehouseOrderPickHndlgUnit.class, "WarehouseOrderPickHndlgUnit");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<WarehouseOrderPickHndlgUnit> countWarehouseOrderPickHndlgUnit() {
        return new CountRequestBuilder(this.servicePath, WarehouseOrderPickHndlgUnit.class, "WarehouseOrderPickHndlgUnit");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<WarehouseOrderPickHndlgUnit> getWarehouseOrderPickHndlgUnitByKey(String eWMWarehouse, String warehouseOrder, String handlingUnitExternalID) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("EWMWarehouse", eWMWarehouse);
        key.put("WarehouseOrder", warehouseOrder);
        key.put("HandlingUnitExternalID", handlingUnitExternalID);
        return new GetByKeyRequestBuilder(this.servicePath, WarehouseOrderPickHndlgUnit.class, key, "WarehouseOrderPickHndlgUnit");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<WarehouseOrderPickHndlgUnit> createWarehouseOrderPickHndlgUnit(@Nonnull WarehouseOrderPickHndlgUnit warehouseOrderPickHndlgUnit) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)warehouseOrderPickHndlgUnit, "WarehouseOrderPickHndlgUnit");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<WarehouseTask> getAllWarehouseTask() {
        return new GetAllRequestBuilder(this.servicePath, WarehouseTask.class, "WarehouseTask");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<WarehouseTask> countWarehouseTask() {
        return new CountRequestBuilder(this.servicePath, WarehouseTask.class, "WarehouseTask");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<WarehouseTask> getWarehouseTaskByKey(String eWMWarehouse, String warehouseTask, String warehouseTaskItem) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("EWMWarehouse", eWMWarehouse);
        key.put("WarehouseTask", warehouseTask);
        key.put("WarehouseTaskItem", warehouseTaskItem);
        return new GetByKeyRequestBuilder(this.servicePath, WarehouseTask.class, key, "WarehouseTask");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<WarehouseTask> createWarehouseTask(@Nonnull WarehouseTask warehouseTask) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)warehouseTask, "WarehouseTask");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<WarehouseTaskExceptionCode> getAllWarehouseTaskExceptionCode() {
        return new GetAllRequestBuilder(this.servicePath, WarehouseTaskExceptionCode.class, "WarehouseTaskExceptionCode");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<WarehouseTaskExceptionCode> countWarehouseTaskExceptionCode() {
        return new CountRequestBuilder(this.servicePath, WarehouseTaskExceptionCode.class, "WarehouseTaskExceptionCode");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<WarehouseTaskExceptionCode> getWarehouseTaskExceptionCodeByKey(String eWMWarehouse, String warehouseTask, String warehouseTaskItem, String warehouseTaskExceptionCode, String businessContext, String businessContextExecutionStep) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("EWMWarehouse", eWMWarehouse);
        key.put("WarehouseTask", warehouseTask);
        key.put("WarehouseTaskItem", warehouseTaskItem);
        key.put("WarehouseTaskExceptionCode", warehouseTaskExceptionCode);
        key.put("BusinessContext", businessContext);
        key.put("BusinessContextExecutionStep", businessContextExecutionStep);
        return new GetByKeyRequestBuilder(this.servicePath, WarehouseTaskExceptionCode.class, key, "WarehouseTaskExceptionCode");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<WarehouseTaskSerialNumber> getAllWarehouseTaskSerialNumber() {
        return new GetAllRequestBuilder(this.servicePath, WarehouseTaskSerialNumber.class, "WarehouseTaskSerialNumber");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<WarehouseTaskSerialNumber> countWarehouseTaskSerialNumber() {
        return new CountRequestBuilder(this.servicePath, WarehouseTaskSerialNumber.class, "WarehouseTaskSerialNumber");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<WarehouseTaskSerialNumber> getWarehouseTaskSerialNumberByKey(String eWMWarehouse, String warehouseTask, String warehouseTaskItem, String eWMSerialNumber) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("EWMWarehouse", eWMWarehouse);
        key.put("WarehouseTask", warehouseTask);
        key.put("WarehouseTaskItem", warehouseTaskItem);
        key.put("EWMSerialNumber", eWMSerialNumber);
        return new GetByKeyRequestBuilder(this.servicePath, WarehouseTaskSerialNumber.class, key, "WarehouseTaskSerialNumber");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

