/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productavailabilityinfo.ATPRlvtProductMRPArea;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productavailabilityinfo.ATPRlvtProductStorLoc;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductAvailabilityInfoService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultProductAvailabilityInfoService")
public class DefaultProductAvailabilityInfoService
implements ServiceWithNavigableEntities,
ProductAvailabilityInfoService {
    @Nonnull
    private final String servicePath;

    public DefaultProductAvailabilityInfoService() {
        this.servicePath = "/sap/opu/odata4/sap/api_product_availy_info/srvd_a2x/sap/apiproductavailyinfo/0001";
    }

    private DefaultProductAvailabilityInfoService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductAvailabilityInfoService withServicePath(@Nonnull String servicePath) {
        return new DefaultProductAvailabilityInfoService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ATPRlvtProductMRPArea> getAllProductMRPArea() {
        return new GetAllRequestBuilder(this.servicePath, ATPRlvtProductMRPArea.class, "ProductMRPArea");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ATPRlvtProductMRPArea> countProductMRPArea() {
        return new CountRequestBuilder(this.servicePath, ATPRlvtProductMRPArea.class, "ProductMRPArea");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ATPRlvtProductMRPArea> getProductMRPAreaByKey(String product, String mRPArea) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Product", product);
        key.put("MRPArea", mRPArea);
        return new GetByKeyRequestBuilder(this.servicePath, ATPRlvtProductMRPArea.class, key, "ProductMRPArea");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<ATPRlvtProductMRPArea> createProductMRPArea(@Nonnull ATPRlvtProductMRPArea aTPRlvtProductMRPArea) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)aTPRlvtProductMRPArea, "ProductMRPArea");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ATPRlvtProductStorLoc> getAllProductStorageLocation() {
        return new GetAllRequestBuilder(this.servicePath, ATPRlvtProductStorLoc.class, "ProductStorageLocation");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ATPRlvtProductStorLoc> countProductStorageLocation() {
        return new CountRequestBuilder(this.servicePath, ATPRlvtProductStorLoc.class, "ProductStorageLocation");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ATPRlvtProductStorLoc> getProductStorageLocationByKey(String product, String storageLocation, String mRPArea) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Product", product);
        key.put("StorageLocation", storageLocation);
        key.put("MRPArea", mRPArea);
        return new GetByKeyRequestBuilder(this.servicePath, ATPRlvtProductStorLoc.class, key, "ProductStorageLocation");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<ATPRlvtProductStorLoc> createProductStorageLocation(@Nonnull ATPRlvtProductStorLoc aTPRlvtProductStorLoc) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)aTPRlvtProductStorLoc, "ProductStorageLocation");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

