/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productsubstitution.ProdSubstn;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductSubstitutionService;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultProductSubstitutionService")
public class DefaultProductSubstitutionService
implements ServiceWithNavigableEntities,
ProductSubstitutionService {
    @Nonnull
    private final String servicePath;

    public DefaultProductSubstitutionService() {
        this.servicePath = "/sap/opu/odata4/sap/api_productsubstitution/srvd_a2x/sap/productsubstitution/0001";
    }

    private DefaultProductSubstitutionService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductSubstitutionService withServicePath(@Nonnull String servicePath) {
        return new DefaultProductSubstitutionService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ProdSubstn> getAllProdSubstn() {
        return new GetAllRequestBuilder(this.servicePath, ProdSubstn.class, "A_ProdSubstn");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ProdSubstn> countProdSubstn() {
        return new CountRequestBuilder(this.servicePath, ProdSubstn.class, "A_ProdSubstn");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ProdSubstn> getProdSubstnByKey(UUID mDSubstnUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("MDSubstnUUID", mDSubstnUUID);
        return new GetByKeyRequestBuilder(this.servicePath, ProdSubstn.class, key, "A_ProdSubstn");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<ProdSubstn> createProdSubstn(@Nonnull ProdSubstn prodSubstn) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)prodSubstn, "A_ProdSubstn");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<ProdSubstn> updateProdSubstn(@Nonnull ProdSubstn prodSubstn) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)prodSubstn, "A_ProdSubstn");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<ProdSubstn> deleteProdSubstn(@Nonnull ProdSubstn prodSubstn) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)prodSubstn, "A_ProdSubstn");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

