/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producttype.ProductType;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producttype.ProductTypeText;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductTypeService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultProductTypeService")
public class DefaultProductTypeService
implements ServiceWithNavigableEntities,
ProductTypeService {
    @Nonnull
    private final String servicePath;

    public DefaultProductTypeService() {
        this.servicePath = "/sap/opu/odata4/sap/api_producttype/srvd_a2x/sap/producttype/0001";
    }

    private DefaultProductTypeService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultProductTypeService withServicePath(@Nonnull String servicePath) {
        return new DefaultProductTypeService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ProductType> getAllProductType() {
        return new GetAllRequestBuilder(this.servicePath, ProductType.class, "ProductType");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ProductType> countProductType() {
        return new CountRequestBuilder(this.servicePath, ProductType.class, "ProductType");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ProductType> getProductTypeByKey(String productType) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("ProductType", productType);
        return new GetByKeyRequestBuilder(this.servicePath, ProductType.class, key, "ProductType");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ProductTypeText> getAllProductTypeText() {
        return new GetAllRequestBuilder(this.servicePath, ProductTypeText.class, "ProductTypeText");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ProductTypeText> countProductTypeText() {
        return new CountRequestBuilder(this.servicePath, ProductTypeText.class, "ProductTypeText");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ProductTypeText> getProductTypeTextByKey(String productType, String language) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("ProductType", productType);
        key.put("Language", language);
        return new GetByKeyRequestBuilder(this.servicePath, ProductTypeText.class, key, "ProductTypeText");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

