/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.reservationdocument.ReservationDocumentHeader_2;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.reservationdocument.ReservationDocumentItem_2;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ReservationDocumentService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultReservationDocumentService")
public class DefaultReservationDocumentService
implements ServiceWithNavigableEntities,
ReservationDocumentService {
    @Nonnull
    private final String servicePath;

    public DefaultReservationDocumentService() {
        this.servicePath = "/sap/opu/odata4/sap/api_reservation_document/srvd_a2x/sap/apireservationdocument/0001";
    }

    private DefaultReservationDocumentService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultReservationDocumentService withServicePath(@Nonnull String servicePath) {
        return new DefaultReservationDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ReservationDocumentHeader_2> getAllReservationDocument() {
        return new GetAllRequestBuilder(this.servicePath, ReservationDocumentHeader_2.class, "ReservationDocument");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ReservationDocumentHeader_2> countReservationDocument() {
        return new CountRequestBuilder(this.servicePath, ReservationDocumentHeader_2.class, "ReservationDocument");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ReservationDocumentHeader_2> getReservationDocumentByKey(String reservation) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Reservation", reservation);
        return new GetByKeyRequestBuilder(this.servicePath, ReservationDocumentHeader_2.class, key, "ReservationDocument");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<ReservationDocumentHeader_2> createReservationDocument(@Nonnull ReservationDocumentHeader_2 reservationDocumentHeader_2) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)reservationDocumentHeader_2, "ReservationDocument");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<ReservationDocumentHeader_2> updateReservationDocument(@Nonnull ReservationDocumentHeader_2 reservationDocumentHeader_2) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)reservationDocumentHeader_2, "ReservationDocument");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<ReservationDocumentHeader_2> deleteReservationDocument(@Nonnull ReservationDocumentHeader_2 reservationDocumentHeader_2) {
        return new DeleteRequestBuilder(this.servicePath, (VdmEntity)reservationDocumentHeader_2, "ReservationDocument");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<ReservationDocumentItem_2> getAllReservationDocumentItem() {
        return new GetAllRequestBuilder(this.servicePath, ReservationDocumentItem_2.class, "ReservationDocumentItem");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<ReservationDocumentItem_2> countReservationDocumentItem() {
        return new CountRequestBuilder(this.servicePath, ReservationDocumentItem_2.class, "ReservationDocumentItem");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<ReservationDocumentItem_2> getReservationDocumentItemByKey(String reservation, String reservationItem, String recordType) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("Reservation", reservation);
        key.put("ReservationItem", reservationItem);
        key.put("RecordType", recordType);
        return new GetByKeyRequestBuilder(this.servicePath, ReservationDocumentItem_2.class, key, "ReservationDocumentItem");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<ReservationDocumentItem_2> updateReservationDocumentItem(@Nonnull ReservationDocumentItem_2 reservationDocumentItem_2) {
        return new UpdateRequestBuilder(this.servicePath, (VdmEntity)reservationDocumentItem_2, "ReservationDocumentItem");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

