/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplierlistforsourcing.SourcingSupplierList;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplierlistforsourcing.SrcgSuplrListBusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplierlistforsourcing.SrcgSuplrListCompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplierlistforsourcing.SrcgSuplrListMaterialGroup;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SupplierListForSourcingService;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultSupplierListForSourcingService")
public class DefaultSupplierListForSourcingService
implements ServiceWithNavigableEntities,
SupplierListForSourcingService {
    @Nonnull
    private final String servicePath;

    public DefaultSupplierListForSourcingService() {
        this.servicePath = "/sap/opu/odata4/sap/api_sourcingsupplierlist/srvd_a2x/sap/sourcingsupplierlist/0001";
    }

    private DefaultSupplierListForSourcingService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSupplierListForSourcingService withServicePath(@Nonnull String servicePath) {
        return new DefaultSupplierListForSourcingService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<SourcingSupplierList> getAllSourcingSupplierList() {
        return new GetAllRequestBuilder(this.servicePath, SourcingSupplierList.class, "SourcingSupplierList");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<SourcingSupplierList> countSourcingSupplierList() {
        return new CountRequestBuilder(this.servicePath, SourcingSupplierList.class, "SourcingSupplierList");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<SourcingSupplierList> getSourcingSupplierListByKey(UUID sourcingSupplierListUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("SourcingSupplierListUUID", sourcingSupplierListUUID);
        return new GetByKeyRequestBuilder(this.servicePath, SourcingSupplierList.class, key, "SourcingSupplierList");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<SourcingSupplierList> createSourcingSupplierList(@Nonnull SourcingSupplierList sourcingSupplierList) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)sourcingSupplierList, "SourcingSupplierList");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<SrcgSuplrListBusinessPartner> getAllSrcgSuplrListBusinessPartner() {
        return new GetAllRequestBuilder(this.servicePath, SrcgSuplrListBusinessPartner.class, "SrcgSuplrListBusinessPartner");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<SrcgSuplrListBusinessPartner> countSrcgSuplrListBusinessPartner() {
        return new CountRequestBuilder(this.servicePath, SrcgSuplrListBusinessPartner.class, "SrcgSuplrListBusinessPartner");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<SrcgSuplrListBusinessPartner> getSrcgSuplrListBusinessPartnerByKey(UUID srcgSuplrListBusPartUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("SrcgSuplrListBusPartUUID", srcgSuplrListBusPartUUID);
        return new GetByKeyRequestBuilder(this.servicePath, SrcgSuplrListBusinessPartner.class, key, "SrcgSuplrListBusinessPartner");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<SrcgSuplrListBusinessPartner> createSrcgSuplrListBusinessPartner(@Nonnull SrcgSuplrListBusinessPartner srcgSuplrListBusinessPartner) {
        return new CreateRequestBuilder(this.servicePath, (VdmEntity)srcgSuplrListBusinessPartner, "SrcgSuplrListBusinessPartner");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<SrcgSuplrListCompanyCode> getAllSrcgSuplrListCompanyCode() {
        return new GetAllRequestBuilder(this.servicePath, SrcgSuplrListCompanyCode.class, "SrcgSuplrListCompanyCode");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<SrcgSuplrListCompanyCode> countSrcgSuplrListCompanyCode() {
        return new CountRequestBuilder(this.servicePath, SrcgSuplrListCompanyCode.class, "SrcgSuplrListCompanyCode");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<SrcgSuplrListCompanyCode> getSrcgSuplrListCompanyCodeByKey(UUID companyCodeUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("CompanyCodeUUID", companyCodeUUID);
        return new GetByKeyRequestBuilder(this.servicePath, SrcgSuplrListCompanyCode.class, key, "SrcgSuplrListCompanyCode");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<SrcgSuplrListMaterialGroup> getAllSrcgSuplrListMaterialGroup() {
        return new GetAllRequestBuilder(this.servicePath, SrcgSuplrListMaterialGroup.class, "SrcgSuplrListMaterialGroup");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<SrcgSuplrListMaterialGroup> countSrcgSuplrListMaterialGroup() {
        return new CountRequestBuilder(this.servicePath, SrcgSuplrListMaterialGroup.class, "SrcgSuplrListMaterialGroup");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<SrcgSuplrListMaterialGroup> getSrcgSuplrListMaterialGroupByKey(UUID materialGroupUUID) {
        HashMap<String, UUID> key = new HashMap<String, UUID>();
        key.put("MaterialGroupUUID", materialGroupUUID);
        return new GetByKeyRequestBuilder(this.servicePath, SrcgSuplrListMaterialGroup.class, key, "SrcgSuplrListMaterialGroup");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

