/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.warehouse.Warehouse;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.warehouse.WarehouseStorageType;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.WarehouseService;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Named;
import lombok.Generated;

@Named(value="com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultWarehouseService")
public class DefaultWarehouseService
implements ServiceWithNavigableEntities,
WarehouseService {
    @Nonnull
    private final String servicePath;

    public DefaultWarehouseService() {
        this.servicePath = "/sap/opu/odata4/sap/api_warehouse_2/srvd_a2x/sap/warehouse/0001";
    }

    private DefaultWarehouseService(@Nonnull String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultWarehouseService withServicePath(@Nonnull String servicePath) {
        return new DefaultWarehouseService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<Warehouse> getAllWarehouse() {
        return new GetAllRequestBuilder(this.servicePath, Warehouse.class, "Warehouse");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<Warehouse> countWarehouse() {
        return new CountRequestBuilder(this.servicePath, Warehouse.class, "Warehouse");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<Warehouse> getWarehouseByKey(String eWMWarehouse) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("EWMWarehouse", eWMWarehouse);
        return new GetByKeyRequestBuilder(this.servicePath, Warehouse.class, key, "Warehouse");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<WarehouseStorageType> getAllWarehouseStorageType() {
        return new GetAllRequestBuilder(this.servicePath, WarehouseStorageType.class, "WarehouseStorageType");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<WarehouseStorageType> countWarehouseStorageType() {
        return new CountRequestBuilder(this.servicePath, WarehouseStorageType.class, "WarehouseStorageType");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<WarehouseStorageType> getWarehouseStorageTypeByKey(String eWMWarehouse, String eWMStorageType) {
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("EWMWarehouse", eWMWarehouse);
        key.put("EWMStorageType", eWMStorageType);
        return new GetByKeyRequestBuilder(this.servicePath, WarehouseStorageType.class, key, "WarehouseStorageType");
    }

    @Nonnull
    @Generated
    public String getServicePath() {
        return this.servicePath;
    }
}

