/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItem;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class StartReconcileFluentHelper
extends FluentHelperFunction<StartReconcileFluentHelper, BankReconciliationItem, BankReconciliationItem> {
    private final Map<String, Object> values = Maps.newHashMap();

    public StartReconcileFluentHelper(@Nonnull String servicePath, String companyCode, String houseBank, String houseBankAccount, LocalDateTime bankReconciliationDate) {
        super(servicePath);
        this.values.put("CompanyCode", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)companyCode));
        this.values.put("HouseBank", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)houseBank));
        this.values.put("HouseBankAccount", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)houseBankAccount));
        this.values.put("BankReconciliationDate", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)bankReconciliationDate));
    }

    @Nonnull
    protected Class<BankReconciliationItem> getEntityClass() {
        return BankReconciliationItem.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "StartReconcile";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public BankReconciliationItem execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (BankReconciliationItem)((Object)super.executeSingle(destination));
    }
}

