/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.AvailabilityRecord;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class DetermineAvailabilityOfFluentHelper
extends FluentHelperFunction<DetermineAvailabilityOfFluentHelper, AvailabilityRecord, AvailabilityRecord> {
    private final Map<String, Object> values = Maps.newHashMap();

    public DetermineAvailabilityOfFluentHelper(@Nonnull String servicePath, BigDecimal requestedQuantityInBaseUnit, String material, String supplyingPlant, String aTPCheckingRule) {
        super(servicePath);
        this.values.put("RequestedQuantityInBaseUnit", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Decimal).toUri((Object)requestedQuantityInBaseUnit));
        this.values.put("Material", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)material));
        this.values.put("SupplyingPlant", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)supplyingPlant));
        this.values.put("ATPCheckingRule", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)aTPCheckingRule));
    }

    @Nonnull
    protected Class<AvailabilityRecord> getEntityClass() {
        return AvailabilityRecord.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "DetermineAvailabilityOf";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpGet(uri);
    }

    @Deprecated
    @Nullable
    public AvailabilityRecord execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (AvailabilityRecord)((Object)super.executeSingle(destination));
    }
}

