/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class ResumeFluentHelper
extends FluentHelperFunction<ResumeFluentHelper, ProposalHeader, ProposalHeader> {
    private final Map<String, Object> values = Maps.newHashMap();

    public ResumeFluentHelper(@Nonnull String servicePath, String material, String plant, String mRPArea, LocalDateTime proposalStartDate, String proposalVersion) {
        super(servicePath);
        this.values.put("Material", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)material));
        this.values.put("Plant", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)plant));
        this.values.put("MRPArea", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)mRPArea));
        this.values.put("ProposalStartDate", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)proposalStartDate));
        this.values.put("ProposalVersion", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)proposalVersion));
    }

    @Nonnull
    protected Class<ProposalHeader> getEntityClass() {
        return ProposalHeader.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "Resume";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public ProposalHeader execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (ProposalHeader)((Object)super.executeSingle(destination));
    }
}

