/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class EquipmentPartner
extends VdmEntity<EquipmentPartner> {
    public static final EquipmentPartnerSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="Equipment")
    @JsonProperty(value="Equipment")
    @Nullable
    @ODataField(odataName="Equipment")
    private String equipment;
    public static final EquipmentPartnerField<String> EQUIPMENT = new EquipmentPartnerField("Equipment");
    @Key
    @SerializedName(value="PartnerFunction")
    @JsonProperty(value="PartnerFunction")
    @Nullable
    @ODataField(odataName="PartnerFunction")
    private String partnerFunction;
    public static final EquipmentPartnerField<String> PARTNER_FUNCTION = new EquipmentPartnerField("PartnerFunction");
    @Key
    @SerializedName(value="EquipmentPartnerObjectNmbr")
    @JsonProperty(value="EquipmentPartnerObjectNmbr")
    @Nullable
    @ODataField(odataName="EquipmentPartnerObjectNmbr")
    private String equipmentPartnerObjectNmbr;
    public static final EquipmentPartnerField<String> EQUIPMENT_PARTNER_OBJECT_NMBR = new EquipmentPartnerField("EquipmentPartnerObjectNmbr");
    @SerializedName(value="Partner")
    @JsonProperty(value="Partner")
    @Nullable
    @ODataField(odataName="Partner")
    private String partner;
    public static final EquipmentPartnerField<String> PARTNER = new EquipmentPartnerField("Partner");
    @SerializedName(value="CreatedByUser")
    @JsonProperty(value="CreatedByUser")
    @Nullable
    @ODataField(odataName="CreatedByUser")
    private String createdByUser;
    public static final EquipmentPartnerField<String> CREATED_BY_USER = new EquipmentPartnerField("CreatedByUser");
    @SerializedName(value="CreationDate")
    @JsonProperty(value="CreationDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="CreationDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime creationDate;
    public static final EquipmentPartnerField<LocalDateTime> CREATION_DATE = new EquipmentPartnerField("CreationDate");
    @SerializedName(value="to_Equipment")
    @JsonProperty(value="to_Equipment")
    @ODataField(odataName="to_Equipment")
    @Nullable
    private Equipment toEquipment;
    public static final EquipmentPartnerOneToOneLink<Equipment> TO_EQUIPMENT = new EquipmentPartnerOneToOneLink("to_Equipment");

    @Nonnull
    public Class<EquipmentPartner> getType() {
        return EquipmentPartner.class;
    }

    public void setEquipment(@Nullable String equipment) {
        this.rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    public void setPartnerFunction(@Nullable String partnerFunction) {
        this.rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    public void setEquipmentPartnerObjectNmbr(@Nullable String equipmentPartnerObjectNmbr) {
        this.rememberChangedField("EquipmentPartnerObjectNmbr", this.equipmentPartnerObjectNmbr);
        this.equipmentPartnerObjectNmbr = equipmentPartnerObjectNmbr;
    }

    public void setPartner(@Nullable String partner) {
        this.rememberChangedField("Partner", this.partner);
        this.partner = partner;
    }

    public void setCreatedByUser(@Nullable String createdByUser) {
        this.rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    public void setCreationDate(@Nullable LocalDateTime creationDate) {
        this.rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    protected String getEntityCollection() {
        return "EquipmentPartner";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("Equipment", this.getEquipment());
        result.put("PartnerFunction", this.getPartnerFunction());
        result.put("EquipmentPartnerObjectNmbr", this.getEquipmentPartnerObjectNmbr());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Equipment", this.getEquipment());
        values.put("PartnerFunction", this.getPartnerFunction());
        values.put("EquipmentPartnerObjectNmbr", this.getEquipmentPartnerObjectNmbr());
        values.put("Partner", this.getPartner());
        values.put("CreatedByUser", this.getCreatedByUser());
        values.put("CreationDate", this.getCreationDate());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Equipment") && ((value = values.remove("Equipment")) == null || !value.equals(this.getEquipment()))) {
            this.setEquipment((String)value);
        }
        if (values.containsKey("PartnerFunction") && ((value = values.remove("PartnerFunction")) == null || !value.equals(this.getPartnerFunction()))) {
            this.setPartnerFunction((String)value);
        }
        if (values.containsKey("EquipmentPartnerObjectNmbr") && ((value = values.remove("EquipmentPartnerObjectNmbr")) == null || !value.equals(this.getEquipmentPartnerObjectNmbr()))) {
            this.setEquipmentPartnerObjectNmbr((String)value);
        }
        if (values.containsKey("Partner") && ((value = values.remove("Partner")) == null || !value.equals(this.getPartner()))) {
            this.setPartner((String)value);
        }
        if (values.containsKey("CreatedByUser") && ((value = values.remove("CreatedByUser")) == null || !value.equals(this.getCreatedByUser()))) {
            this.setCreatedByUser((String)value);
        }
        if (values.containsKey("CreationDate") && ((value = values.remove("CreationDate")) == null || !value.equals(this.getCreationDate()))) {
            this.setCreationDate((LocalDateTime)value);
        }
        if (values.containsKey("to_Equipment") && (value = values.remove("to_Equipment")) instanceof Map) {
            if (this.toEquipment == null) {
                this.toEquipment = new Equipment();
            }
            Map inputMap = (Map)value;
            this.toEquipment.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> EquipmentPartnerField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new EquipmentPartnerField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> EquipmentPartnerField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new EquipmentPartnerField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_EQUIPMENT";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toEquipment != null) {
            values.put("to_Equipment", this.toEquipment);
        }
        return values;
    }

    @Nullable
    public Equipment fetchEquipment() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Equipment.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("Equipment=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.equipment));
        odataResourceUrl.append(",PartnerFunction=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.partnerFunction));
        odataResourceUrl.append(",EquipmentPartnerObjectNmbr=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.equipmentPartnerObjectNmbr));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Equipment");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        Equipment entity = (Equipment)((Object)result.as(Equipment.class));
        entity.attachToService(this.getServicePathForFetch(), destination);
        return entity;
    }

    @Nullable
    public Equipment getEquipmentOrFetch() throws ODataException {
        if (this.toEquipment == null) {
            this.toEquipment = this.fetchEquipment();
        }
        return this.toEquipment;
    }

    @Nonnull
    public Option<Equipment> getEquipmentIfPresent() {
        return Option.of((Object)((Object)this.toEquipment));
    }

    public void setEquipment(Equipment value) {
        this.toEquipment = value;
    }

    @Nonnull
    @Generated
    public static EquipmentPartnerBuilder builder() {
        return new EquipmentPartnerBuilder();
    }

    @Nullable
    @Generated
    public String getEquipment() {
        return this.equipment;
    }

    @Nullable
    @Generated
    public String getPartnerFunction() {
        return this.partnerFunction;
    }

    @Nullable
    @Generated
    public String getEquipmentPartnerObjectNmbr() {
        return this.equipmentPartnerObjectNmbr;
    }

    @Nullable
    @Generated
    public String getPartner() {
        return this.partner;
    }

    @Nullable
    @Generated
    public String getCreatedByUser() {
        return this.createdByUser;
    }

    @Nullable
    @Generated
    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public EquipmentPartner() {
    }

    @Generated
    public EquipmentPartner(@Nullable String equipment, @Nullable String partnerFunction, @Nullable String equipmentPartnerObjectNmbr, @Nullable String partner, @Nullable String createdByUser, @Nullable LocalDateTime creationDate, @Nullable Equipment toEquipment) {
        this.equipment = equipment;
        this.partnerFunction = partnerFunction;
        this.equipmentPartnerObjectNmbr = equipmentPartnerObjectNmbr;
        this.partner = partner;
        this.createdByUser = createdByUser;
        this.creationDate = creationDate;
        this.toEquipment = toEquipment;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "EquipmentPartner(super=" + super.toString() + ", equipment=" + this.equipment + ", partnerFunction=" + this.partnerFunction + ", equipmentPartnerObjectNmbr=" + this.equipmentPartnerObjectNmbr + ", partner=" + this.partner + ", createdByUser=" + this.createdByUser + ", creationDate=" + this.creationDate + ", toEquipment=" + (Object)((Object)this.toEquipment) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EquipmentPartner)) {
            return false;
        }
        EquipmentPartner other = (EquipmentPartner)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$equipment = this.equipment;
        String other$equipment = other.equipment;
        if (this$equipment == null ? other$equipment != null : !this$equipment.equals(other$equipment)) {
            return false;
        }
        String this$partnerFunction = this.partnerFunction;
        String other$partnerFunction = other.partnerFunction;
        if (this$partnerFunction == null ? other$partnerFunction != null : !this$partnerFunction.equals(other$partnerFunction)) {
            return false;
        }
        String this$equipmentPartnerObjectNmbr = this.equipmentPartnerObjectNmbr;
        String other$equipmentPartnerObjectNmbr = other.equipmentPartnerObjectNmbr;
        if (this$equipmentPartnerObjectNmbr == null ? other$equipmentPartnerObjectNmbr != null : !this$equipmentPartnerObjectNmbr.equals(other$equipmentPartnerObjectNmbr)) {
            return false;
        }
        String this$partner = this.partner;
        String other$partner = other.partner;
        if (this$partner == null ? other$partner != null : !this$partner.equals(other$partner)) {
            return false;
        }
        String this$createdByUser = this.createdByUser;
        String other$createdByUser = other.createdByUser;
        if (this$createdByUser == null ? other$createdByUser != null : !this$createdByUser.equals(other$createdByUser)) {
            return false;
        }
        LocalDateTime this$creationDate = this.creationDate;
        LocalDateTime other$creationDate = other.creationDate;
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        Equipment this$toEquipment = this.toEquipment;
        Equipment other$toEquipment = other.toEquipment;
        return !(this$toEquipment == null ? other$toEquipment != null : !((Object)((Object)this$toEquipment)).equals((Object)other$toEquipment));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EquipmentPartner;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $equipment = this.equipment;
        result = result * 59 + ($equipment == null ? 43 : $equipment.hashCode());
        String $partnerFunction = this.partnerFunction;
        result = result * 59 + ($partnerFunction == null ? 43 : $partnerFunction.hashCode());
        String $equipmentPartnerObjectNmbr = this.equipmentPartnerObjectNmbr;
        result = result * 59 + ($equipmentPartnerObjectNmbr == null ? 43 : $equipmentPartnerObjectNmbr.hashCode());
        String $partner = this.partner;
        result = result * 59 + ($partner == null ? 43 : $partner.hashCode());
        String $createdByUser = this.createdByUser;
        result = result * 59 + ($createdByUser == null ? 43 : $createdByUser.hashCode());
        LocalDateTime $creationDate = this.creationDate;
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        Equipment $toEquipment = this.toEquipment;
        result = result * 59 + ($toEquipment == null ? 43 : ((Object)((Object)$toEquipment)).hashCode());
        return result;
    }

    public static final class EquipmentPartnerBuilder {
        @Generated
        private String partnerFunction;
        @Generated
        private String equipmentPartnerObjectNmbr;
        @Generated
        private String partner;
        @Generated
        private String createdByUser;
        @Generated
        private LocalDateTime creationDate;
        private Equipment toEquipment;
        private String equipment = null;

        private EquipmentPartnerBuilder toEquipment(Equipment value) {
            this.toEquipment = value;
            return this;
        }

        @Nonnull
        public EquipmentPartnerBuilder equipment(Equipment value) {
            return this.toEquipment(value);
        }

        @Nonnull
        public EquipmentPartnerBuilder equipment(String value) {
            this.equipment = value;
            return this;
        }

        @Generated
        EquipmentPartnerBuilder() {
        }

        @Nonnull
        @JsonProperty(value="PartnerFunction")
        @Generated
        public EquipmentPartnerBuilder partnerFunction(@Nullable String partnerFunction) {
            this.partnerFunction = partnerFunction;
            return this;
        }

        @Nonnull
        @JsonProperty(value="EquipmentPartnerObjectNmbr")
        @Generated
        public EquipmentPartnerBuilder equipmentPartnerObjectNmbr(@Nullable String equipmentPartnerObjectNmbr) {
            this.equipmentPartnerObjectNmbr = equipmentPartnerObjectNmbr;
            return this;
        }

        @Nonnull
        @JsonProperty(value="Partner")
        @Generated
        public EquipmentPartnerBuilder partner(@Nullable String partner) {
            this.partner = partner;
            return this;
        }

        @Nonnull
        @JsonProperty(value="CreatedByUser")
        @Generated
        public EquipmentPartnerBuilder createdByUser(@Nullable String createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        @Nonnull
        @JsonProperty(value="CreationDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public EquipmentPartnerBuilder creationDate(@Nullable LocalDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Nonnull
        @Generated
        public EquipmentPartner build() {
            return new EquipmentPartner(this.equipment, this.partnerFunction, this.equipmentPartnerObjectNmbr, this.partner, this.createdByUser, this.creationDate, this.toEquipment);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "EquipmentPartner.EquipmentPartnerBuilder(equipment=" + this.equipment + ", partnerFunction=" + this.partnerFunction + ", equipmentPartnerObjectNmbr=" + this.equipmentPartnerObjectNmbr + ", partner=" + this.partner + ", createdByUser=" + this.createdByUser + ", creationDate=" + this.creationDate + ", toEquipment=" + (Object)((Object)this.toEquipment) + ")";
        }
    }
}

