/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class InstallEquipmentFluentHelper
extends FluentHelperFunction<InstallEquipmentFluentHelper, Equipment, Equipment> {
    private final Map<String, Object> values = Maps.newHashMap();

    public InstallEquipmentFluentHelper(@Nonnull String servicePath, String equipment, LocalDateTime validityEndDate, String superordinateEquipment, String equipInstallationPositionNmbr, String functionalLocation, LocalDateTime equipmentInstallationDate, LocalTime equipmentInstallationTime) {
        super(servicePath);
        this.values.put("Equipment", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)equipment));
        this.values.put("ValidityEndDate", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)validityEndDate));
        this.values.put("SuperordinateEquipment", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)superordinateEquipment));
        this.values.put("EquipInstallationPositionNmbr", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)equipInstallationPositionNmbr));
        this.values.put("FunctionalLocation", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)functionalLocation));
        this.values.put("EquipmentInstallationDate", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)equipmentInstallationDate));
        this.values.put("EquipmentInstallationTime", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Time).toUri((Object)equipmentInstallationTime));
    }

    @Nonnull
    protected Class<Equipment> getEntityClass() {
        return Equipment.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "InstallEquipment";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public Equipment execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (Equipment)((Object)super.executeSingle(destination));
    }
}

