/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeClassLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class RecipeClass
extends VdmEntity<RecipeClass> {
    public static final RecipeClassSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="RecipeUUID")
    @JsonProperty(value="RecipeUUID")
    @Nullable
    @ODataField(odataName="RecipeUUID")
    private UUID recipeUUID;
    public static final RecipeClassField<UUID> RECIPE_UUID = new RecipeClassField("RecipeUUID");
    @Key
    @SerializedName(value="ClassInternalID")
    @JsonProperty(value="ClassInternalID")
    @Nullable
    @ODataField(odataName="ClassInternalID")
    private String classInternalID;
    public static final RecipeClassField<String> CLASS_INTERNAL_ID = new RecipeClassField("ClassInternalID");
    @SerializedName(value="KeyDate")
    @JsonProperty(value="KeyDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="KeyDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime keyDate;
    public static final RecipeClassField<LocalDateTime> KEY_DATE = new RecipeClassField("KeyDate");
    @SerializedName(value="ClassType")
    @JsonProperty(value="ClassType")
    @Nullable
    @ODataField(odataName="ClassType")
    private String classType;
    public static final RecipeClassField<String> CLASS_TYPE = new RecipeClassField("ClassType");
    @SerializedName(value="to_Characteristics")
    @JsonProperty(value="to_Characteristics")
    @ODataField(odataName="to_Characteristics")
    private List<RecipeClassCharc> toCharacteristics;
    public static final RecipeClassLink<RecipeClassCharc> TO_CHARACTERISTICS = new RecipeClassLink("to_Characteristics");

    @Nonnull
    public Class<RecipeClass> getType() {
        return RecipeClass.class;
    }

    public void setRecipeUUID(@Nullable UUID recipeUUID) {
        this.rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    public void setClassInternalID(@Nullable String classInternalID) {
        this.rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    public void setKeyDate(@Nullable LocalDateTime keyDate) {
        this.rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    public void setClassType(@Nullable String classType) {
        this.rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    protected String getEntityCollection() {
        return "A_RecipeClass";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("RecipeUUID", this.getRecipeUUID());
        result.put("ClassInternalID", this.getClassInternalID());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("RecipeUUID", this.getRecipeUUID());
        values.put("ClassInternalID", this.getClassInternalID());
        values.put("KeyDate", this.getKeyDate());
        values.put("ClassType", this.getClassType());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("RecipeUUID") && ((value = values.remove("RecipeUUID")) == null || !value.equals(this.getRecipeUUID()))) {
            this.setRecipeUUID((UUID)value);
        }
        if (values.containsKey("ClassInternalID") && ((value = values.remove("ClassInternalID")) == null || !value.equals(this.getClassInternalID()))) {
            this.setClassInternalID((String)value);
        }
        if (values.containsKey("KeyDate") && ((value = values.remove("KeyDate")) == null || !value.equals(this.getKeyDate()))) {
            this.setKeyDate((LocalDateTime)value);
        }
        if (values.containsKey("ClassType") && ((value = values.remove("ClassType")) == null || !value.equals(this.getClassType()))) {
            this.setClassType((String)value);
        }
        if (values.containsKey("to_Characteristics") && (value = values.remove("to_Characteristics")) instanceof Iterable) {
            this.toCharacteristics = this.toCharacteristics == null ? Lists.newArrayList() : Lists.newArrayList(this.toCharacteristics);
            int i = 0;
            for (Object item : (Iterable)value) {
                RecipeClassCharc entity;
                if (!(item instanceof Map)) continue;
                if (this.toCharacteristics.size() > i) {
                    entity = this.toCharacteristics.get(i);
                } else {
                    entity = new RecipeClassCharc();
                    this.toCharacteristics.add(entity);
                }
                ++i;
                Map inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> RecipeClassField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new RecipeClassField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> RecipeClassField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new RecipeClassField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_RECIPE";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toCharacteristics != null) {
            values.put("to_Characteristics", this.toCharacteristics);
        }
        return values;
    }

    @Nonnull
    public List<RecipeClassCharc> fetchCharacteristics() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type RecipeClassCharc.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("RecipeUUID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Guid).toUri((Object)this.recipeUUID));
        odataResourceUrl.append(",ClassInternalID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.classInternalID));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Characteristics");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        List entityList = result.asList(RecipeClassCharc.class);
        for (RecipeClassCharc entity : entityList) {
            entity.attachToService(this.getServicePathForFetch(), destination);
        }
        return entityList;
    }

    @Nonnull
    public List<RecipeClassCharc> getCharacteristicsOrFetch() throws ODataException {
        if (this.toCharacteristics == null) {
            this.toCharacteristics = this.fetchCharacteristics();
        }
        return this.toCharacteristics;
    }

    @Nonnull
    public Option<List<RecipeClassCharc>> getCharacteristicsIfPresent() {
        return Option.of(this.toCharacteristics);
    }

    public void setCharacteristics(@Nonnull List<RecipeClassCharc> value) {
        if (this.toCharacteristics == null) {
            this.toCharacteristics = Lists.newArrayList();
        }
        this.toCharacteristics.clear();
        this.toCharacteristics.addAll(value);
    }

    public void addCharacteristics(RecipeClassCharc ... entity) {
        if (this.toCharacteristics == null) {
            this.toCharacteristics = Lists.newArrayList();
        }
        this.toCharacteristics.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nonnull
    @Generated
    public static RecipeClassBuilder builder() {
        return new RecipeClassBuilder();
    }

    @Nullable
    @Generated
    public UUID getRecipeUUID() {
        return this.recipeUUID;
    }

    @Nullable
    @Generated
    public String getClassInternalID() {
        return this.classInternalID;
    }

    @Nullable
    @Generated
    public LocalDateTime getKeyDate() {
        return this.keyDate;
    }

    @Nullable
    @Generated
    public String getClassType() {
        return this.classType;
    }

    @Generated
    public RecipeClass() {
    }

    @Generated
    public RecipeClass(@Nullable UUID recipeUUID, @Nullable String classInternalID, @Nullable LocalDateTime keyDate, @Nullable String classType, List<RecipeClassCharc> toCharacteristics) {
        this.recipeUUID = recipeUUID;
        this.classInternalID = classInternalID;
        this.keyDate = keyDate;
        this.classType = classType;
        this.toCharacteristics = toCharacteristics;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "RecipeClass(super=" + super.toString() + ", recipeUUID=" + this.recipeUUID + ", classInternalID=" + this.classInternalID + ", keyDate=" + this.keyDate + ", classType=" + this.classType + ", toCharacteristics=" + this.toCharacteristics + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeClass)) {
            return false;
        }
        RecipeClass other = (RecipeClass)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$recipeUUID = this.recipeUUID;
        UUID other$recipeUUID = other.recipeUUID;
        if (this$recipeUUID == null ? other$recipeUUID != null : !((Object)this$recipeUUID).equals(other$recipeUUID)) {
            return false;
        }
        String this$classInternalID = this.classInternalID;
        String other$classInternalID = other.classInternalID;
        if (this$classInternalID == null ? other$classInternalID != null : !this$classInternalID.equals(other$classInternalID)) {
            return false;
        }
        LocalDateTime this$keyDate = this.keyDate;
        LocalDateTime other$keyDate = other.keyDate;
        if (this$keyDate == null ? other$keyDate != null : !((Object)this$keyDate).equals(other$keyDate)) {
            return false;
        }
        String this$classType = this.classType;
        String other$classType = other.classType;
        if (this$classType == null ? other$classType != null : !this$classType.equals(other$classType)) {
            return false;
        }
        List<RecipeClassCharc> this$toCharacteristics = this.toCharacteristics;
        List<RecipeClassCharc> other$toCharacteristics = other.toCharacteristics;
        return !(this$toCharacteristics == null ? other$toCharacteristics != null : !((Object)this$toCharacteristics).equals(other$toCharacteristics));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RecipeClass;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $recipeUUID = this.recipeUUID;
        result = result * 59 + ($recipeUUID == null ? 43 : ((Object)$recipeUUID).hashCode());
        String $classInternalID = this.classInternalID;
        result = result * 59 + ($classInternalID == null ? 43 : $classInternalID.hashCode());
        LocalDateTime $keyDate = this.keyDate;
        result = result * 59 + ($keyDate == null ? 43 : ((Object)$keyDate).hashCode());
        String $classType = this.classType;
        result = result * 59 + ($classType == null ? 43 : $classType.hashCode());
        List<RecipeClassCharc> $toCharacteristics = this.toCharacteristics;
        result = result * 59 + ($toCharacteristics == null ? 43 : ((Object)$toCharacteristics).hashCode());
        return result;
    }

    public static final class RecipeClassBuilder {
        @Generated
        private UUID recipeUUID;
        @Generated
        private String classInternalID;
        @Generated
        private LocalDateTime keyDate;
        @Generated
        private String classType;
        private List<RecipeClassCharc> toCharacteristics = Lists.newArrayList();

        private RecipeClassBuilder toCharacteristics(List<RecipeClassCharc> value) {
            this.toCharacteristics.addAll(value);
            return this;
        }

        @Nonnull
        public RecipeClassBuilder characteristics(RecipeClassCharc ... value) {
            return this.toCharacteristics(Lists.newArrayList((Object[])value));
        }

        @Generated
        RecipeClassBuilder() {
        }

        @Nonnull
        @JsonProperty(value="RecipeUUID")
        @Generated
        public RecipeClassBuilder recipeUUID(@Nullable UUID recipeUUID) {
            this.recipeUUID = recipeUUID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClassInternalID")
        @Generated
        public RecipeClassBuilder classInternalID(@Nullable String classInternalID) {
            this.classInternalID = classInternalID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="KeyDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public RecipeClassBuilder keyDate(@Nullable LocalDateTime keyDate) {
            this.keyDate = keyDate;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClassType")
        @Generated
        public RecipeClassBuilder classType(@Nullable String classType) {
            this.classType = classType;
            return this;
        }

        @Nonnull
        @Generated
        public RecipeClass build() {
            return new RecipeClass(this.recipeUUID, this.classInternalID, this.keyDate, this.classType, this.toCharacteristics);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "RecipeClass.RecipeClassBuilder(recipeUUID=" + this.recipeUUID + ", classInternalID=" + this.classInternalID + ", keyDate=" + this.keyDate + ", classType=" + this.classType + ", toCharacteristics=" + this.toCharacteristics + ")";
        }
    }
}

