/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.ReleaseInvoiceExportParameters;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class ReleaseFluentHelper
extends FluentHelperFunction<ReleaseFluentHelper, ReleaseInvoiceExportParameters, ReleaseInvoiceExportParameters> {
    private final Map<String, Object> values = Maps.newHashMap();

    public ReleaseFluentHelper(@Nonnull String servicePath, Boolean discountDaysHaveToBeShifted, String fiscalYear, String supplierInvoice) {
        super(servicePath);
        this.values.put("DiscountDaysHaveToBeShifted", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Boolean).toUri((Object)discountDaysHaveToBeShifted));
        this.values.put("FiscalYear", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)fiscalYear));
        this.values.put("SupplierInvoice", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)supplierInvoice));
    }

    @Nonnull
    protected Class<ReleaseInvoiceExportParameters> getEntityClass() {
        return ReleaseInvoiceExportParameters.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "Release";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public ReleaseInvoiceExportParameters execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (ReleaseInvoiceExportParameters)((Object)super.executeSingle(destination));
    }
}

