/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CreateExportParameters;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class CreateFromRFQFluentHelper
extends FluentHelperFunction<CreateFromRFQFluentHelper, CreateExportParameters, CreateExportParameters> {
    private final Map<String, Object> values = Maps.newHashMap();

    public CreateFromRFQFluentHelper(@Nonnull String servicePath, LocalDateTime quotationSubmissionDate, String supplier, String requestForQuotation) {
        super(servicePath);
        this.values.put("QuotationSubmissionDate", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)quotationSubmissionDate));
        this.values.put("Supplier", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)supplier));
        this.values.put("RequestForQuotation", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)requestForQuotation));
    }

    @Nonnull
    protected Class<CreateExportParameters> getEntityClass() {
        return CreateExportParameters.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "CreateFromRFQ";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public CreateExportParameters execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (CreateExportParameters)((Object)super.executeSingle(destination));
    }
}

