/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentClassLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentClassOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class EquipmentClass
extends VdmEntity<EquipmentClass> {
    public static final EquipmentClassSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="Equipment")
    @JsonProperty(value="Equipment")
    @Nullable
    @ODataField(odataName="Equipment")
    private String equipment;
    public static final EquipmentClassField<String> EQUIPMENT = new EquipmentClassField("Equipment");
    @Key
    @SerializedName(value="ClassInternalID")
    @JsonProperty(value="ClassInternalID")
    @Nullable
    @ODataField(odataName="ClassInternalID")
    private String classInternalID;
    public static final EquipmentClassField<String> CLASS_INTERNAL_ID = new EquipmentClassField("ClassInternalID");
    @Key
    @SerializedName(value="ClassType")
    @JsonProperty(value="ClassType")
    @Nullable
    @ODataField(odataName="ClassType")
    private String classType;
    public static final EquipmentClassField<String> CLASS_TYPE = new EquipmentClassField("ClassType");
    @SerializedName(value="KeyDate")
    @JsonProperty(value="KeyDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="KeyDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime keyDate;
    public static final EquipmentClassField<LocalDateTime> KEY_DATE = new EquipmentClassField("KeyDate");
    @SerializedName(value="ChangeNumber")
    @JsonProperty(value="ChangeNumber")
    @Nullable
    @ODataField(odataName="ChangeNumber")
    private String changeNumber;
    public static final EquipmentClassField<String> CHANGE_NUMBER = new EquipmentClassField("ChangeNumber");
    @SerializedName(value="ClfnStatus")
    @JsonProperty(value="ClfnStatus")
    @Nullable
    @ODataField(odataName="ClfnStatus")
    private String clfnStatus;
    public static final EquipmentClassField<String> CLFN_STATUS = new EquipmentClassField("ClfnStatus");
    @SerializedName(value="ClassPositionNumber")
    @JsonProperty(value="ClassPositionNumber")
    @Nullable
    @ODataField(odataName="ClassPositionNumber")
    private Short classPositionNumber;
    public static final EquipmentClassField<Short> CLASS_POSITION_NUMBER = new EquipmentClassField("ClassPositionNumber");
    @SerializedName(value="ClassIsStandardClass")
    @JsonProperty(value="ClassIsStandardClass")
    @Nullable
    @ODataField(odataName="ClassIsStandardClass")
    private String classIsStandardClass;
    public static final EquipmentClassField<String> CLASS_IS_STANDARD_CLASS = new EquipmentClassField("ClassIsStandardClass");
    @SerializedName(value="ClfnObjectInternalID")
    @JsonProperty(value="ClfnObjectInternalID")
    @Nullable
    @ODataField(odataName="ClfnObjectInternalID")
    private String clfnObjectInternalID;
    public static final EquipmentClassField<String> CLFN_OBJECT_INTERNAL_ID = new EquipmentClassField("ClfnObjectInternalID");
    @SerializedName(value="ValidityEndDate")
    @JsonProperty(value="ValidityEndDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="ValidityEndDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime validityEndDate;
    public static final EquipmentClassField<LocalDateTime> VALIDITY_END_DATE = new EquipmentClassField("ValidityEndDate");
    @SerializedName(value="to_Characteristic")
    @JsonProperty(value="to_Characteristic")
    @ODataField(odataName="to_Characteristic")
    private List<EquipmentClassCharacteristic> toCharacteristic;
    @SerializedName(value="to_Equipment")
    @JsonProperty(value="to_Equipment")
    @ODataField(odataName="to_Equipment")
    @Nullable
    private Equipment toEquipment;
    public static final EquipmentClassLink<EquipmentClassCharacteristic> TO_CHARACTERISTIC = new EquipmentClassLink("to_Characteristic");
    public static final EquipmentClassOneToOneLink<Equipment> TO_EQUIPMENT = new EquipmentClassOneToOneLink("to_Equipment");

    @Nonnull
    public Class<EquipmentClass> getType() {
        return EquipmentClass.class;
    }

    public void setEquipment(@Nullable String equipment) {
        this.rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    public void setClassInternalID(@Nullable String classInternalID) {
        this.rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    public void setClassType(@Nullable String classType) {
        this.rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    public void setKeyDate(@Nullable LocalDateTime keyDate) {
        this.rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    public void setChangeNumber(@Nullable String changeNumber) {
        this.rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    public void setClfnStatus(@Nullable String clfnStatus) {
        this.rememberChangedField("ClfnStatus", this.clfnStatus);
        this.clfnStatus = clfnStatus;
    }

    public void setClassPositionNumber(@Nullable Short classPositionNumber) {
        this.rememberChangedField("ClassPositionNumber", this.classPositionNumber);
        this.classPositionNumber = classPositionNumber;
    }

    public void setClassIsStandardClass(@Nullable String classIsStandardClass) {
        this.rememberChangedField("ClassIsStandardClass", this.classIsStandardClass);
        this.classIsStandardClass = classIsStandardClass;
    }

    public void setClfnObjectInternalID(@Nullable String clfnObjectInternalID) {
        this.rememberChangedField("ClfnObjectInternalID", this.clfnObjectInternalID);
        this.clfnObjectInternalID = clfnObjectInternalID;
    }

    public void setValidityEndDate(@Nullable LocalDateTime validityEndDate) {
        this.rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    protected String getEntityCollection() {
        return "EquipmentClass";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("Equipment", this.getEquipment());
        result.put("ClassInternalID", this.getClassInternalID());
        result.put("ClassType", this.getClassType());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Equipment", this.getEquipment());
        values.put("ClassInternalID", this.getClassInternalID());
        values.put("ClassType", this.getClassType());
        values.put("KeyDate", this.getKeyDate());
        values.put("ChangeNumber", this.getChangeNumber());
        values.put("ClfnStatus", this.getClfnStatus());
        values.put("ClassPositionNumber", this.getClassPositionNumber());
        values.put("ClassIsStandardClass", this.getClassIsStandardClass());
        values.put("ClfnObjectInternalID", this.getClfnObjectInternalID());
        values.put("ValidityEndDate", this.getValidityEndDate());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Equipment") && ((value = values.remove("Equipment")) == null || !value.equals(this.getEquipment()))) {
            this.setEquipment((String)value);
        }
        if (values.containsKey("ClassInternalID") && ((value = values.remove("ClassInternalID")) == null || !value.equals(this.getClassInternalID()))) {
            this.setClassInternalID((String)value);
        }
        if (values.containsKey("ClassType") && ((value = values.remove("ClassType")) == null || !value.equals(this.getClassType()))) {
            this.setClassType((String)value);
        }
        if (values.containsKey("KeyDate") && ((value = values.remove("KeyDate")) == null || !value.equals(this.getKeyDate()))) {
            this.setKeyDate((LocalDateTime)value);
        }
        if (values.containsKey("ChangeNumber") && ((value = values.remove("ChangeNumber")) == null || !value.equals(this.getChangeNumber()))) {
            this.setChangeNumber((String)value);
        }
        if (values.containsKey("ClfnStatus") && ((value = values.remove("ClfnStatus")) == null || !value.equals(this.getClfnStatus()))) {
            this.setClfnStatus((String)value);
        }
        if (values.containsKey("ClassPositionNumber") && ((value = values.remove("ClassPositionNumber")) == null || !value.equals(this.getClassPositionNumber()))) {
            this.setClassPositionNumber((Short)value);
        }
        if (values.containsKey("ClassIsStandardClass") && ((value = values.remove("ClassIsStandardClass")) == null || !value.equals(this.getClassIsStandardClass()))) {
            this.setClassIsStandardClass((String)value);
        }
        if (values.containsKey("ClfnObjectInternalID") && ((value = values.remove("ClfnObjectInternalID")) == null || !value.equals(this.getClfnObjectInternalID()))) {
            this.setClfnObjectInternalID((String)value);
        }
        if (values.containsKey("ValidityEndDate") && ((value = values.remove("ValidityEndDate")) == null || !value.equals(this.getValidityEndDate()))) {
            this.setValidityEndDate((LocalDateTime)value);
        }
        if (values.containsKey("to_Characteristic") && (value = values.remove("to_Characteristic")) instanceof Iterable) {
            this.toCharacteristic = this.toCharacteristic == null ? Lists.newArrayList() : Lists.newArrayList(this.toCharacteristic);
            int i = 0;
            for (Object item : (Iterable)value) {
                EquipmentClassCharacteristic entity;
                if (!(item instanceof Map)) continue;
                if (this.toCharacteristic.size() > i) {
                    entity = this.toCharacteristic.get(i);
                } else {
                    entity = new EquipmentClassCharacteristic();
                    this.toCharacteristic.add(entity);
                }
                ++i;
                Map inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        if (values.containsKey("to_Equipment") && (value = values.remove("to_Equipment")) instanceof Map) {
            if (this.toEquipment == null) {
                this.toEquipment = new Equipment();
            }
            Map inputMap = (Map)value;
            this.toEquipment.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> EquipmentClassField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new EquipmentClassField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> EquipmentClassField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new EquipmentClassField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_EQUIPMENT";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toCharacteristic != null) {
            values.put("to_Characteristic", this.toCharacteristic);
        }
        if (this.toEquipment != null) {
            values.put("to_Equipment", this.toEquipment);
        }
        return values;
    }

    @Nonnull
    public List<EquipmentClassCharacteristic> fetchCharacteristic() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type EquipmentClassCharacteristic.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("Equipment=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.equipment));
        odataResourceUrl.append(",ClassInternalID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.classInternalID));
        odataResourceUrl.append(",ClassType=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.classType));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Characteristic");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        List entityList = result.asList(EquipmentClassCharacteristic.class);
        for (EquipmentClassCharacteristic entity : entityList) {
            entity.attachToService(this.getServicePathForFetch(), destination);
        }
        return entityList;
    }

    @Nonnull
    public List<EquipmentClassCharacteristic> getCharacteristicOrFetch() throws ODataException {
        if (this.toCharacteristic == null) {
            this.toCharacteristic = this.fetchCharacteristic();
        }
        return this.toCharacteristic;
    }

    @Nonnull
    public Option<List<EquipmentClassCharacteristic>> getCharacteristicIfPresent() {
        return Option.of(this.toCharacteristic);
    }

    public void setCharacteristic(@Nonnull List<EquipmentClassCharacteristic> value) {
        if (this.toCharacteristic == null) {
            this.toCharacteristic = Lists.newArrayList();
        }
        this.toCharacteristic.clear();
        this.toCharacteristic.addAll(value);
    }

    public void addCharacteristic(EquipmentClassCharacteristic ... entity) {
        if (this.toCharacteristic == null) {
            this.toCharacteristic = Lists.newArrayList();
        }
        this.toCharacteristic.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nullable
    public Equipment fetchEquipment() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Equipment.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("Equipment=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.equipment));
        odataResourceUrl.append(",ClassInternalID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.classInternalID));
        odataResourceUrl.append(",ClassType=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.classType));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Equipment");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        Equipment entity = (Equipment)((Object)result.as(Equipment.class));
        entity.attachToService(this.getServicePathForFetch(), destination);
        return entity;
    }

    @Nullable
    public Equipment getEquipmentOrFetch() throws ODataException {
        if (this.toEquipment == null) {
            this.toEquipment = this.fetchEquipment();
        }
        return this.toEquipment;
    }

    @Nonnull
    public Option<Equipment> getEquipmentIfPresent() {
        return Option.of((Object)((Object)this.toEquipment));
    }

    public void setEquipment(Equipment value) {
        this.toEquipment = value;
    }

    @Nonnull
    @Generated
    public static EquipmentClassBuilder builder() {
        return new EquipmentClassBuilder();
    }

    @Nullable
    @Generated
    public String getEquipment() {
        return this.equipment;
    }

    @Nullable
    @Generated
    public String getClassInternalID() {
        return this.classInternalID;
    }

    @Nullable
    @Generated
    public String getClassType() {
        return this.classType;
    }

    @Nullable
    @Generated
    public LocalDateTime getKeyDate() {
        return this.keyDate;
    }

    @Nullable
    @Generated
    public String getChangeNumber() {
        return this.changeNumber;
    }

    @Nullable
    @Generated
    public String getClfnStatus() {
        return this.clfnStatus;
    }

    @Nullable
    @Generated
    public Short getClassPositionNumber() {
        return this.classPositionNumber;
    }

    @Nullable
    @Generated
    public String getClassIsStandardClass() {
        return this.classIsStandardClass;
    }

    @Nullable
    @Generated
    public String getClfnObjectInternalID() {
        return this.clfnObjectInternalID;
    }

    @Nullable
    @Generated
    public LocalDateTime getValidityEndDate() {
        return this.validityEndDate;
    }

    @Generated
    public EquipmentClass() {
    }

    @Generated
    public EquipmentClass(@Nullable String equipment, @Nullable String classInternalID, @Nullable String classType, @Nullable LocalDateTime keyDate, @Nullable String changeNumber, @Nullable String clfnStatus, @Nullable Short classPositionNumber, @Nullable String classIsStandardClass, @Nullable String clfnObjectInternalID, @Nullable LocalDateTime validityEndDate, List<EquipmentClassCharacteristic> toCharacteristic, @Nullable Equipment toEquipment) {
        this.equipment = equipment;
        this.classInternalID = classInternalID;
        this.classType = classType;
        this.keyDate = keyDate;
        this.changeNumber = changeNumber;
        this.clfnStatus = clfnStatus;
        this.classPositionNumber = classPositionNumber;
        this.classIsStandardClass = classIsStandardClass;
        this.clfnObjectInternalID = clfnObjectInternalID;
        this.validityEndDate = validityEndDate;
        this.toCharacteristic = toCharacteristic;
        this.toEquipment = toEquipment;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "EquipmentClass(super=" + super.toString() + ", equipment=" + this.equipment + ", classInternalID=" + this.classInternalID + ", classType=" + this.classType + ", keyDate=" + this.keyDate + ", changeNumber=" + this.changeNumber + ", clfnStatus=" + this.clfnStatus + ", classPositionNumber=" + this.classPositionNumber + ", classIsStandardClass=" + this.classIsStandardClass + ", clfnObjectInternalID=" + this.clfnObjectInternalID + ", validityEndDate=" + this.validityEndDate + ", toCharacteristic=" + this.toCharacteristic + ", toEquipment=" + (Object)((Object)this.toEquipment) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EquipmentClass)) {
            return false;
        }
        EquipmentClass other = (EquipmentClass)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Short this$classPositionNumber = this.classPositionNumber;
        Short other$classPositionNumber = other.classPositionNumber;
        if (this$classPositionNumber == null ? other$classPositionNumber != null : !((Object)this$classPositionNumber).equals(other$classPositionNumber)) {
            return false;
        }
        String this$equipment = this.equipment;
        String other$equipment = other.equipment;
        if (this$equipment == null ? other$equipment != null : !this$equipment.equals(other$equipment)) {
            return false;
        }
        String this$classInternalID = this.classInternalID;
        String other$classInternalID = other.classInternalID;
        if (this$classInternalID == null ? other$classInternalID != null : !this$classInternalID.equals(other$classInternalID)) {
            return false;
        }
        String this$classType = this.classType;
        String other$classType = other.classType;
        if (this$classType == null ? other$classType != null : !this$classType.equals(other$classType)) {
            return false;
        }
        LocalDateTime this$keyDate = this.keyDate;
        LocalDateTime other$keyDate = other.keyDate;
        if (this$keyDate == null ? other$keyDate != null : !((Object)this$keyDate).equals(other$keyDate)) {
            return false;
        }
        String this$changeNumber = this.changeNumber;
        String other$changeNumber = other.changeNumber;
        if (this$changeNumber == null ? other$changeNumber != null : !this$changeNumber.equals(other$changeNumber)) {
            return false;
        }
        String this$clfnStatus = this.clfnStatus;
        String other$clfnStatus = other.clfnStatus;
        if (this$clfnStatus == null ? other$clfnStatus != null : !this$clfnStatus.equals(other$clfnStatus)) {
            return false;
        }
        String this$classIsStandardClass = this.classIsStandardClass;
        String other$classIsStandardClass = other.classIsStandardClass;
        if (this$classIsStandardClass == null ? other$classIsStandardClass != null : !this$classIsStandardClass.equals(other$classIsStandardClass)) {
            return false;
        }
        String this$clfnObjectInternalID = this.clfnObjectInternalID;
        String other$clfnObjectInternalID = other.clfnObjectInternalID;
        if (this$clfnObjectInternalID == null ? other$clfnObjectInternalID != null : !this$clfnObjectInternalID.equals(other$clfnObjectInternalID)) {
            return false;
        }
        LocalDateTime this$validityEndDate = this.validityEndDate;
        LocalDateTime other$validityEndDate = other.validityEndDate;
        if (this$validityEndDate == null ? other$validityEndDate != null : !((Object)this$validityEndDate).equals(other$validityEndDate)) {
            return false;
        }
        List<EquipmentClassCharacteristic> this$toCharacteristic = this.toCharacteristic;
        List<EquipmentClassCharacteristic> other$toCharacteristic = other.toCharacteristic;
        if (this$toCharacteristic == null ? other$toCharacteristic != null : !((Object)this$toCharacteristic).equals(other$toCharacteristic)) {
            return false;
        }
        Equipment this$toEquipment = this.toEquipment;
        Equipment other$toEquipment = other.toEquipment;
        return !(this$toEquipment == null ? other$toEquipment != null : !((Object)((Object)this$toEquipment)).equals((Object)other$toEquipment));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EquipmentClass;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Short $classPositionNumber = this.classPositionNumber;
        result = result * 59 + ($classPositionNumber == null ? 43 : ((Object)$classPositionNumber).hashCode());
        String $equipment = this.equipment;
        result = result * 59 + ($equipment == null ? 43 : $equipment.hashCode());
        String $classInternalID = this.classInternalID;
        result = result * 59 + ($classInternalID == null ? 43 : $classInternalID.hashCode());
        String $classType = this.classType;
        result = result * 59 + ($classType == null ? 43 : $classType.hashCode());
        LocalDateTime $keyDate = this.keyDate;
        result = result * 59 + ($keyDate == null ? 43 : ((Object)$keyDate).hashCode());
        String $changeNumber = this.changeNumber;
        result = result * 59 + ($changeNumber == null ? 43 : $changeNumber.hashCode());
        String $clfnStatus = this.clfnStatus;
        result = result * 59 + ($clfnStatus == null ? 43 : $clfnStatus.hashCode());
        String $classIsStandardClass = this.classIsStandardClass;
        result = result * 59 + ($classIsStandardClass == null ? 43 : $classIsStandardClass.hashCode());
        String $clfnObjectInternalID = this.clfnObjectInternalID;
        result = result * 59 + ($clfnObjectInternalID == null ? 43 : $clfnObjectInternalID.hashCode());
        LocalDateTime $validityEndDate = this.validityEndDate;
        result = result * 59 + ($validityEndDate == null ? 43 : ((Object)$validityEndDate).hashCode());
        List<EquipmentClassCharacteristic> $toCharacteristic = this.toCharacteristic;
        result = result * 59 + ($toCharacteristic == null ? 43 : ((Object)$toCharacteristic).hashCode());
        Equipment $toEquipment = this.toEquipment;
        result = result * 59 + ($toEquipment == null ? 43 : ((Object)((Object)$toEquipment)).hashCode());
        return result;
    }

    public static final class EquipmentClassBuilder {
        @Generated
        private String classInternalID;
        @Generated
        private String classType;
        @Generated
        private LocalDateTime keyDate;
        @Generated
        private String changeNumber;
        @Generated
        private String clfnStatus;
        @Generated
        private Short classPositionNumber;
        @Generated
        private String classIsStandardClass;
        @Generated
        private String clfnObjectInternalID;
        @Generated
        private LocalDateTime validityEndDate;
        private List<EquipmentClassCharacteristic> toCharacteristic = Lists.newArrayList();
        private Equipment toEquipment;
        private String equipment = null;

        private EquipmentClassBuilder toCharacteristic(List<EquipmentClassCharacteristic> value) {
            this.toCharacteristic.addAll(value);
            return this;
        }

        @Nonnull
        public EquipmentClassBuilder characteristic(EquipmentClassCharacteristic ... value) {
            return this.toCharacteristic(Lists.newArrayList((Object[])value));
        }

        private EquipmentClassBuilder toEquipment(Equipment value) {
            this.toEquipment = value;
            return this;
        }

        @Nonnull
        public EquipmentClassBuilder equipment(Equipment value) {
            return this.toEquipment(value);
        }

        @Nonnull
        public EquipmentClassBuilder equipment(String value) {
            this.equipment = value;
            return this;
        }

        @Generated
        EquipmentClassBuilder() {
        }

        @Nonnull
        @JsonProperty(value="ClassInternalID")
        @Generated
        public EquipmentClassBuilder classInternalID(@Nullable String classInternalID) {
            this.classInternalID = classInternalID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClassType")
        @Generated
        public EquipmentClassBuilder classType(@Nullable String classType) {
            this.classType = classType;
            return this;
        }

        @Nonnull
        @JsonProperty(value="KeyDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public EquipmentClassBuilder keyDate(@Nullable LocalDateTime keyDate) {
            this.keyDate = keyDate;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ChangeNumber")
        @Generated
        public EquipmentClassBuilder changeNumber(@Nullable String changeNumber) {
            this.changeNumber = changeNumber;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClfnStatus")
        @Generated
        public EquipmentClassBuilder clfnStatus(@Nullable String clfnStatus) {
            this.clfnStatus = clfnStatus;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClassPositionNumber")
        @Generated
        public EquipmentClassBuilder classPositionNumber(@Nullable Short classPositionNumber) {
            this.classPositionNumber = classPositionNumber;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClassIsStandardClass")
        @Generated
        public EquipmentClassBuilder classIsStandardClass(@Nullable String classIsStandardClass) {
            this.classIsStandardClass = classIsStandardClass;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClfnObjectInternalID")
        @Generated
        public EquipmentClassBuilder clfnObjectInternalID(@Nullable String clfnObjectInternalID) {
            this.clfnObjectInternalID = clfnObjectInternalID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ValidityEndDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public EquipmentClassBuilder validityEndDate(@Nullable LocalDateTime validityEndDate) {
            this.validityEndDate = validityEndDate;
            return this;
        }

        @Nonnull
        @Generated
        public EquipmentClass build() {
            return new EquipmentClass(this.equipment, this.classInternalID, this.classType, this.keyDate, this.changeNumber, this.clfnStatus, this.classPositionNumber, this.classIsStandardClass, this.clfnObjectInternalID, this.validityEndDate, this.toCharacteristic, this.toEquipment);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "EquipmentClass.EquipmentClassBuilder(equipment=" + this.equipment + ", classInternalID=" + this.classInternalID + ", classType=" + this.classType + ", keyDate=" + this.keyDate + ", changeNumber=" + this.changeNumber + ", clfnStatus=" + this.clfnStatus + ", classPositionNumber=" + this.classPositionNumber + ", classIsStandardClass=" + this.classIsStandardClass + ", clfnObjectInternalID=" + this.clfnObjectInternalID + ", validityEndDate=" + this.validityEndDate + ", toCharacteristic=" + this.toCharacteristic + ", toEquipment=" + (Object)((Object)this.toEquipment) + ")";
        }
    }
}

