/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentClassCharacteristicField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentClassCharacteristicLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentClassCharacteristicOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentClassCharacteristicSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class EquipmentClassCharacteristic
extends VdmEntity<EquipmentClassCharacteristic> {
    public static final EquipmentClassCharacteristicSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="Equipment")
    @JsonProperty(value="Equipment")
    @Nullable
    @ODataField(odataName="Equipment")
    private String equipment;
    public static final EquipmentClassCharacteristicField<String> EQUIPMENT = new EquipmentClassCharacteristicField("Equipment");
    @Key
    @SerializedName(value="ClassInternalID")
    @JsonProperty(value="ClassInternalID")
    @Nullable
    @ODataField(odataName="ClassInternalID")
    private String classInternalID;
    public static final EquipmentClassCharacteristicField<String> CLASS_INTERNAL_ID = new EquipmentClassCharacteristicField("ClassInternalID");
    @Key
    @SerializedName(value="CharacteristicInternalID")
    @JsonProperty(value="CharacteristicInternalID")
    @Nullable
    @ODataField(odataName="CharacteristicInternalID")
    private String characteristicInternalID;
    public static final EquipmentClassCharacteristicField<String> CHARACTERISTIC_INTERNAL_ID = new EquipmentClassCharacteristicField("CharacteristicInternalID");
    @SerializedName(value="Characteristic")
    @JsonProperty(value="Characteristic")
    @Nullable
    @ODataField(odataName="Characteristic")
    private String characteristic;
    public static final EquipmentClassCharacteristicField<String> CHARACTERISTIC = new EquipmentClassCharacteristicField("Characteristic");
    @SerializedName(value="CharcDataType")
    @JsonProperty(value="CharcDataType")
    @Nullable
    @ODataField(odataName="CharcDataType")
    private String charcDataType;
    public static final EquipmentClassCharacteristicField<String> CHARC_DATA_TYPE = new EquipmentClassCharacteristicField("CharcDataType");
    @SerializedName(value="KeyDate")
    @JsonProperty(value="KeyDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="KeyDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime keyDate;
    public static final EquipmentClassCharacteristicField<LocalDateTime> KEY_DATE = new EquipmentClassCharacteristicField("KeyDate");
    @SerializedName(value="ChangeNumber")
    @JsonProperty(value="ChangeNumber")
    @Nullable
    @ODataField(odataName="ChangeNumber")
    private String changeNumber;
    public static final EquipmentClassCharacteristicField<String> CHANGE_NUMBER = new EquipmentClassCharacteristicField("ChangeNumber");
    @SerializedName(value="ClassType")
    @JsonProperty(value="ClassType")
    @Nullable
    @ODataField(odataName="ClassType")
    private String classType;
    public static final EquipmentClassCharacteristicField<String> CLASS_TYPE = new EquipmentClassCharacteristicField("ClassType");
    @SerializedName(value="to_EquipmentClass")
    @JsonProperty(value="to_EquipmentClass")
    @ODataField(odataName="to_EquipmentClass")
    @Nullable
    private EquipmentClass toEquipmentClass;
    @SerializedName(value="to_Value")
    @JsonProperty(value="to_Value")
    @ODataField(odataName="to_Value")
    private List<EquipClassCharacteristicValue> toValue;
    public static final EquipmentClassCharacteristicOneToOneLink<EquipmentClass> TO_EQUIPMENT_CLASS = new EquipmentClassCharacteristicOneToOneLink("to_EquipmentClass");
    public static final EquipmentClassCharacteristicLink<EquipClassCharacteristicValue> TO_VALUE = new EquipmentClassCharacteristicLink("to_Value");

    @Nonnull
    public Class<EquipmentClassCharacteristic> getType() {
        return EquipmentClassCharacteristic.class;
    }

    public void setEquipment(@Nullable String equipment) {
        this.rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    public void setClassInternalID(@Nullable String classInternalID) {
        this.rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    public void setCharacteristicInternalID(@Nullable String characteristicInternalID) {
        this.rememberChangedField("CharacteristicInternalID", this.characteristicInternalID);
        this.characteristicInternalID = characteristicInternalID;
    }

    public void setCharacteristic(@Nullable String characteristic) {
        this.rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    public void setCharcDataType(@Nullable String charcDataType) {
        this.rememberChangedField("CharcDataType", this.charcDataType);
        this.charcDataType = charcDataType;
    }

    public void setKeyDate(@Nullable LocalDateTime keyDate) {
        this.rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    public void setChangeNumber(@Nullable String changeNumber) {
        this.rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    public void setClassType(@Nullable String classType) {
        this.rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    protected String getEntityCollection() {
        return "EquipmentClassCharacteristic";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("Equipment", this.getEquipment());
        result.put("ClassInternalID", this.getClassInternalID());
        result.put("CharacteristicInternalID", this.getCharacteristicInternalID());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Equipment", this.getEquipment());
        values.put("ClassInternalID", this.getClassInternalID());
        values.put("CharacteristicInternalID", this.getCharacteristicInternalID());
        values.put("Characteristic", this.getCharacteristic());
        values.put("CharcDataType", this.getCharcDataType());
        values.put("KeyDate", this.getKeyDate());
        values.put("ChangeNumber", this.getChangeNumber());
        values.put("ClassType", this.getClassType());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Equipment") && ((value = values.remove("Equipment")) == null || !value.equals(this.getEquipment()))) {
            this.setEquipment((String)value);
        }
        if (values.containsKey("ClassInternalID") && ((value = values.remove("ClassInternalID")) == null || !value.equals(this.getClassInternalID()))) {
            this.setClassInternalID((String)value);
        }
        if (values.containsKey("CharacteristicInternalID") && ((value = values.remove("CharacteristicInternalID")) == null || !value.equals(this.getCharacteristicInternalID()))) {
            this.setCharacteristicInternalID((String)value);
        }
        if (values.containsKey("Characteristic") && ((value = values.remove("Characteristic")) == null || !value.equals(this.getCharacteristic()))) {
            this.setCharacteristic((String)value);
        }
        if (values.containsKey("CharcDataType") && ((value = values.remove("CharcDataType")) == null || !value.equals(this.getCharcDataType()))) {
            this.setCharcDataType((String)value);
        }
        if (values.containsKey("KeyDate") && ((value = values.remove("KeyDate")) == null || !value.equals(this.getKeyDate()))) {
            this.setKeyDate((LocalDateTime)value);
        }
        if (values.containsKey("ChangeNumber") && ((value = values.remove("ChangeNumber")) == null || !value.equals(this.getChangeNumber()))) {
            this.setChangeNumber((String)value);
        }
        if (values.containsKey("ClassType") && ((value = values.remove("ClassType")) == null || !value.equals(this.getClassType()))) {
            this.setClassType((String)value);
        }
        if (values.containsKey("to_EquipmentClass") && (value = values.remove("to_EquipmentClass")) instanceof Map) {
            if (this.toEquipmentClass == null) {
                this.toEquipmentClass = new EquipmentClass();
            }
            Map inputMap = (Map)value;
            this.toEquipmentClass.fromMap(inputMap);
        }
        if (values.containsKey("to_Value") && (value = values.remove("to_Value")) instanceof Iterable) {
            this.toValue = this.toValue == null ? Lists.newArrayList() : Lists.newArrayList(this.toValue);
            int i = 0;
            for (Object item : (Iterable)value) {
                EquipClassCharacteristicValue entity;
                if (!(item instanceof Map)) continue;
                if (this.toValue.size() > i) {
                    entity = this.toValue.get(i);
                } else {
                    entity = new EquipClassCharacteristicValue();
                    this.toValue.add(entity);
                }
                ++i;
                Map inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> EquipmentClassCharacteristicField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new EquipmentClassCharacteristicField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> EquipmentClassCharacteristicField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new EquipmentClassCharacteristicField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_EQUIPMENT";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toEquipmentClass != null) {
            values.put("to_EquipmentClass", this.toEquipmentClass);
        }
        if (this.toValue != null) {
            values.put("to_Value", this.toValue);
        }
        return values;
    }

    @Nullable
    public EquipmentClass fetchEquipmentClass() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type EquipmentClass.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("Equipment=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.equipment));
        odataResourceUrl.append(",ClassInternalID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.classInternalID));
        odataResourceUrl.append(",CharacteristicInternalID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.characteristicInternalID));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_EquipmentClass");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        EquipmentClass entity = (EquipmentClass)((Object)result.as(EquipmentClass.class));
        entity.attachToService(this.getServicePathForFetch(), destination);
        return entity;
    }

    @Nullable
    public EquipmentClass getEquipmentClassOrFetch() throws ODataException {
        if (this.toEquipmentClass == null) {
            this.toEquipmentClass = this.fetchEquipmentClass();
        }
        return this.toEquipmentClass;
    }

    @Nonnull
    public Option<EquipmentClass> getEquipmentClassIfPresent() {
        return Option.of((Object)((Object)this.toEquipmentClass));
    }

    public void setEquipmentClass(EquipmentClass value) {
        this.toEquipmentClass = value;
    }

    @Nonnull
    public List<EquipClassCharacteristicValue> fetchValue() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type EquipClassCharacteristicValue.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("Equipment=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.equipment));
        odataResourceUrl.append(",ClassInternalID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.classInternalID));
        odataResourceUrl.append(",CharacteristicInternalID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.characteristicInternalID));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Value");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        List entityList = result.asList(EquipClassCharacteristicValue.class);
        for (EquipClassCharacteristicValue entity : entityList) {
            entity.attachToService(this.getServicePathForFetch(), destination);
        }
        return entityList;
    }

    @Nonnull
    public List<EquipClassCharacteristicValue> getValueOrFetch() throws ODataException {
        if (this.toValue == null) {
            this.toValue = this.fetchValue();
        }
        return this.toValue;
    }

    @Nonnull
    public Option<List<EquipClassCharacteristicValue>> getValueIfPresent() {
        return Option.of(this.toValue);
    }

    public void setValue(@Nonnull List<EquipClassCharacteristicValue> value) {
        if (this.toValue == null) {
            this.toValue = Lists.newArrayList();
        }
        this.toValue.clear();
        this.toValue.addAll(value);
    }

    public void addValue(EquipClassCharacteristicValue ... entity) {
        if (this.toValue == null) {
            this.toValue = Lists.newArrayList();
        }
        this.toValue.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nonnull
    @Generated
    public static EquipmentClassCharacteristicBuilder builder() {
        return new EquipmentClassCharacteristicBuilder();
    }

    @Nullable
    @Generated
    public String getEquipment() {
        return this.equipment;
    }

    @Nullable
    @Generated
    public String getClassInternalID() {
        return this.classInternalID;
    }

    @Nullable
    @Generated
    public String getCharacteristicInternalID() {
        return this.characteristicInternalID;
    }

    @Nullable
    @Generated
    public String getCharacteristic() {
        return this.characteristic;
    }

    @Nullable
    @Generated
    public String getCharcDataType() {
        return this.charcDataType;
    }

    @Nullable
    @Generated
    public LocalDateTime getKeyDate() {
        return this.keyDate;
    }

    @Nullable
    @Generated
    public String getChangeNumber() {
        return this.changeNumber;
    }

    @Nullable
    @Generated
    public String getClassType() {
        return this.classType;
    }

    @Generated
    public EquipmentClassCharacteristic() {
    }

    @Generated
    public EquipmentClassCharacteristic(@Nullable String equipment, @Nullable String classInternalID, @Nullable String characteristicInternalID, @Nullable String characteristic, @Nullable String charcDataType, @Nullable LocalDateTime keyDate, @Nullable String changeNumber, @Nullable String classType, @Nullable EquipmentClass toEquipmentClass, List<EquipClassCharacteristicValue> toValue) {
        this.equipment = equipment;
        this.classInternalID = classInternalID;
        this.characteristicInternalID = characteristicInternalID;
        this.characteristic = characteristic;
        this.charcDataType = charcDataType;
        this.keyDate = keyDate;
        this.changeNumber = changeNumber;
        this.classType = classType;
        this.toEquipmentClass = toEquipmentClass;
        this.toValue = toValue;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "EquipmentClassCharacteristic(super=" + super.toString() + ", equipment=" + this.equipment + ", classInternalID=" + this.classInternalID + ", characteristicInternalID=" + this.characteristicInternalID + ", characteristic=" + this.characteristic + ", charcDataType=" + this.charcDataType + ", keyDate=" + this.keyDate + ", changeNumber=" + this.changeNumber + ", classType=" + this.classType + ", toEquipmentClass=" + (Object)((Object)this.toEquipmentClass) + ", toValue=" + this.toValue + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EquipmentClassCharacteristic)) {
            return false;
        }
        EquipmentClassCharacteristic other = (EquipmentClassCharacteristic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$equipment = this.equipment;
        String other$equipment = other.equipment;
        if (this$equipment == null ? other$equipment != null : !this$equipment.equals(other$equipment)) {
            return false;
        }
        String this$classInternalID = this.classInternalID;
        String other$classInternalID = other.classInternalID;
        if (this$classInternalID == null ? other$classInternalID != null : !this$classInternalID.equals(other$classInternalID)) {
            return false;
        }
        String this$characteristicInternalID = this.characteristicInternalID;
        String other$characteristicInternalID = other.characteristicInternalID;
        if (this$characteristicInternalID == null ? other$characteristicInternalID != null : !this$characteristicInternalID.equals(other$characteristicInternalID)) {
            return false;
        }
        String this$characteristic = this.characteristic;
        String other$characteristic = other.characteristic;
        if (this$characteristic == null ? other$characteristic != null : !this$characteristic.equals(other$characteristic)) {
            return false;
        }
        String this$charcDataType = this.charcDataType;
        String other$charcDataType = other.charcDataType;
        if (this$charcDataType == null ? other$charcDataType != null : !this$charcDataType.equals(other$charcDataType)) {
            return false;
        }
        LocalDateTime this$keyDate = this.keyDate;
        LocalDateTime other$keyDate = other.keyDate;
        if (this$keyDate == null ? other$keyDate != null : !((Object)this$keyDate).equals(other$keyDate)) {
            return false;
        }
        String this$changeNumber = this.changeNumber;
        String other$changeNumber = other.changeNumber;
        if (this$changeNumber == null ? other$changeNumber != null : !this$changeNumber.equals(other$changeNumber)) {
            return false;
        }
        String this$classType = this.classType;
        String other$classType = other.classType;
        if (this$classType == null ? other$classType != null : !this$classType.equals(other$classType)) {
            return false;
        }
        EquipmentClass this$toEquipmentClass = this.toEquipmentClass;
        EquipmentClass other$toEquipmentClass = other.toEquipmentClass;
        if (this$toEquipmentClass == null ? other$toEquipmentClass != null : !((Object)((Object)this$toEquipmentClass)).equals((Object)other$toEquipmentClass)) {
            return false;
        }
        List<EquipClassCharacteristicValue> this$toValue = this.toValue;
        List<EquipClassCharacteristicValue> other$toValue = other.toValue;
        return !(this$toValue == null ? other$toValue != null : !((Object)this$toValue).equals(other$toValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EquipmentClassCharacteristic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $equipment = this.equipment;
        result = result * 59 + ($equipment == null ? 43 : $equipment.hashCode());
        String $classInternalID = this.classInternalID;
        result = result * 59 + ($classInternalID == null ? 43 : $classInternalID.hashCode());
        String $characteristicInternalID = this.characteristicInternalID;
        result = result * 59 + ($characteristicInternalID == null ? 43 : $characteristicInternalID.hashCode());
        String $characteristic = this.characteristic;
        result = result * 59 + ($characteristic == null ? 43 : $characteristic.hashCode());
        String $charcDataType = this.charcDataType;
        result = result * 59 + ($charcDataType == null ? 43 : $charcDataType.hashCode());
        LocalDateTime $keyDate = this.keyDate;
        result = result * 59 + ($keyDate == null ? 43 : ((Object)$keyDate).hashCode());
        String $changeNumber = this.changeNumber;
        result = result * 59 + ($changeNumber == null ? 43 : $changeNumber.hashCode());
        String $classType = this.classType;
        result = result * 59 + ($classType == null ? 43 : $classType.hashCode());
        EquipmentClass $toEquipmentClass = this.toEquipmentClass;
        result = result * 59 + ($toEquipmentClass == null ? 43 : ((Object)((Object)$toEquipmentClass)).hashCode());
        List<EquipClassCharacteristicValue> $toValue = this.toValue;
        result = result * 59 + ($toValue == null ? 43 : ((Object)$toValue).hashCode());
        return result;
    }

    public static final class EquipmentClassCharacteristicBuilder {
        @Generated
        private String equipment;
        @Generated
        private String classInternalID;
        @Generated
        private String characteristicInternalID;
        @Generated
        private String characteristic;
        @Generated
        private String charcDataType;
        @Generated
        private LocalDateTime keyDate;
        @Generated
        private String changeNumber;
        @Generated
        private String classType;
        private EquipmentClass toEquipmentClass;
        private List<EquipClassCharacteristicValue> toValue = Lists.newArrayList();

        private EquipmentClassCharacteristicBuilder toEquipmentClass(EquipmentClass value) {
            this.toEquipmentClass = value;
            return this;
        }

        @Nonnull
        public EquipmentClassCharacteristicBuilder equipmentClass(EquipmentClass value) {
            return this.toEquipmentClass(value);
        }

        private EquipmentClassCharacteristicBuilder toValue(List<EquipClassCharacteristicValue> value) {
            this.toValue.addAll(value);
            return this;
        }

        @Nonnull
        public EquipmentClassCharacteristicBuilder value(EquipClassCharacteristicValue ... value) {
            return this.toValue(Lists.newArrayList((Object[])value));
        }

        @Generated
        EquipmentClassCharacteristicBuilder() {
        }

        @Nonnull
        @JsonProperty(value="Equipment")
        @Generated
        public EquipmentClassCharacteristicBuilder equipment(@Nullable String equipment) {
            this.equipment = equipment;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClassInternalID")
        @Generated
        public EquipmentClassCharacteristicBuilder classInternalID(@Nullable String classInternalID) {
            this.classInternalID = classInternalID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="CharacteristicInternalID")
        @Generated
        public EquipmentClassCharacteristicBuilder characteristicInternalID(@Nullable String characteristicInternalID) {
            this.characteristicInternalID = characteristicInternalID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="Characteristic")
        @Generated
        public EquipmentClassCharacteristicBuilder characteristic(@Nullable String characteristic) {
            this.characteristic = characteristic;
            return this;
        }

        @Nonnull
        @JsonProperty(value="CharcDataType")
        @Generated
        public EquipmentClassCharacteristicBuilder charcDataType(@Nullable String charcDataType) {
            this.charcDataType = charcDataType;
            return this;
        }

        @Nonnull
        @JsonProperty(value="KeyDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public EquipmentClassCharacteristicBuilder keyDate(@Nullable LocalDateTime keyDate) {
            this.keyDate = keyDate;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ChangeNumber")
        @Generated
        public EquipmentClassCharacteristicBuilder changeNumber(@Nullable String changeNumber) {
            this.changeNumber = changeNumber;
            return this;
        }

        @Nonnull
        @JsonProperty(value="ClassType")
        @Generated
        public EquipmentClassCharacteristicBuilder classType(@Nullable String classType) {
            this.classType = classType;
            return this;
        }

        @Nonnull
        @Generated
        public EquipmentClassCharacteristic build() {
            return new EquipmentClassCharacteristic(this.equipment, this.classInternalID, this.characteristicInternalID, this.characteristic, this.charcDataType, this.keyDate, this.changeNumber, this.classType, this.toEquipmentClass, this.toValue);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder(equipment=" + this.equipment + ", classInternalID=" + this.classInternalID + ", characteristicInternalID=" + this.characteristicInternalID + ", characteristic=" + this.characteristic + ", charcDataType=" + this.charcDataType + ", keyDate=" + this.keyDate + ", changeNumber=" + this.changeNumber + ", classType=" + this.classType + ", toEquipmentClass=" + (Object)((Object)this.toEquipmentClass) + ", toValue=" + this.toValue + ")";
        }
    }
}

