/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentWarrantyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentWarrantyOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentWarrantySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class EquipmentWarranty
extends VdmEntity<EquipmentWarranty> {
    public static final EquipmentWarrantySelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="Equipment")
    @JsonProperty(value="Equipment")
    @Nullable
    @ODataField(odataName="Equipment")
    private String equipment;
    public static final EquipmentWarrantyField<String> EQUIPMENT = new EquipmentWarrantyField("Equipment");
    @Key
    @SerializedName(value="WarrantyType")
    @JsonProperty(value="WarrantyType")
    @Nullable
    @ODataField(odataName="WarrantyType")
    private String warrantyType;
    public static final EquipmentWarrantyField<String> WARRANTY_TYPE = new EquipmentWarrantyField("WarrantyType");
    @SerializedName(value="MasterWarranty")
    @JsonProperty(value="MasterWarranty")
    @Nullable
    @ODataField(odataName="MasterWarranty")
    private String masterWarranty;
    public static final EquipmentWarrantyField<String> MASTER_WARRANTY = new EquipmentWarrantyField("MasterWarranty");
    @SerializedName(value="WarrantyStartDate")
    @JsonProperty(value="WarrantyStartDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="WarrantyStartDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime warrantyStartDate;
    public static final EquipmentWarrantyField<LocalDateTime> WARRANTY_START_DATE = new EquipmentWarrantyField("WarrantyStartDate");
    @SerializedName(value="WarrantyEndDate")
    @JsonProperty(value="WarrantyEndDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="WarrantyEndDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime warrantyEndDate;
    public static final EquipmentWarrantyField<LocalDateTime> WARRANTY_END_DATE = new EquipmentWarrantyField("WarrantyEndDate");
    @SerializedName(value="WrntyIsInhtdFromSuperiorObject")
    @JsonProperty(value="WrntyIsInhtdFromSuperiorObject")
    @Nullable
    @ODataField(odataName="WrntyIsInhtdFromSuperiorObject")
    private String wrntyIsInhtdFromSuperiorObject;
    public static final EquipmentWarrantyField<String> WRNTY_IS_INHTD_FROM_SUPERIOR_OBJECT = new EquipmentWarrantyField("WrntyIsInhtdFromSuperiorObject");
    @SerializedName(value="WrntyIsPassedOnToChildObject")
    @JsonProperty(value="WrntyIsPassedOnToChildObject")
    @Nullable
    @ODataField(odataName="WrntyIsPassedOnToChildObject")
    private String wrntyIsPassedOnToChildObject;
    public static final EquipmentWarrantyField<String> WRNTY_IS_PASSED_ON_TO_CHILD_OBJECT = new EquipmentWarrantyField("WrntyIsPassedOnToChildObject");
    @SerializedName(value="to_Equipment")
    @JsonProperty(value="to_Equipment")
    @ODataField(odataName="to_Equipment")
    @Nullable
    private Equipment toEquipment;
    public static final EquipmentWarrantyOneToOneLink<Equipment> TO_EQUIPMENT = new EquipmentWarrantyOneToOneLink("to_Equipment");

    @Nonnull
    public Class<EquipmentWarranty> getType() {
        return EquipmentWarranty.class;
    }

    public void setEquipment(@Nullable String equipment) {
        this.rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    public void setWarrantyType(@Nullable String warrantyType) {
        this.rememberChangedField("WarrantyType", this.warrantyType);
        this.warrantyType = warrantyType;
    }

    public void setMasterWarranty(@Nullable String masterWarranty) {
        this.rememberChangedField("MasterWarranty", this.masterWarranty);
        this.masterWarranty = masterWarranty;
    }

    public void setWarrantyStartDate(@Nullable LocalDateTime warrantyStartDate) {
        this.rememberChangedField("WarrantyStartDate", this.warrantyStartDate);
        this.warrantyStartDate = warrantyStartDate;
    }

    public void setWarrantyEndDate(@Nullable LocalDateTime warrantyEndDate) {
        this.rememberChangedField("WarrantyEndDate", this.warrantyEndDate);
        this.warrantyEndDate = warrantyEndDate;
    }

    public void setWrntyIsInhtdFromSuperiorObject(@Nullable String wrntyIsInhtdFromSuperiorObject) {
        this.rememberChangedField("WrntyIsInhtdFromSuperiorObject", this.wrntyIsInhtdFromSuperiorObject);
        this.wrntyIsInhtdFromSuperiorObject = wrntyIsInhtdFromSuperiorObject;
    }

    public void setWrntyIsPassedOnToChildObject(@Nullable String wrntyIsPassedOnToChildObject) {
        this.rememberChangedField("WrntyIsPassedOnToChildObject", this.wrntyIsPassedOnToChildObject);
        this.wrntyIsPassedOnToChildObject = wrntyIsPassedOnToChildObject;
    }

    protected String getEntityCollection() {
        return "EquipmentWarranty";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("Equipment", this.getEquipment());
        result.put("WarrantyType", this.getWarrantyType());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Equipment", this.getEquipment());
        values.put("WarrantyType", this.getWarrantyType());
        values.put("MasterWarranty", this.getMasterWarranty());
        values.put("WarrantyStartDate", this.getWarrantyStartDate());
        values.put("WarrantyEndDate", this.getWarrantyEndDate());
        values.put("WrntyIsInhtdFromSuperiorObject", this.getWrntyIsInhtdFromSuperiorObject());
        values.put("WrntyIsPassedOnToChildObject", this.getWrntyIsPassedOnToChildObject());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Equipment") && ((value = values.remove("Equipment")) == null || !value.equals(this.getEquipment()))) {
            this.setEquipment((String)value);
        }
        if (values.containsKey("WarrantyType") && ((value = values.remove("WarrantyType")) == null || !value.equals(this.getWarrantyType()))) {
            this.setWarrantyType((String)value);
        }
        if (values.containsKey("MasterWarranty") && ((value = values.remove("MasterWarranty")) == null || !value.equals(this.getMasterWarranty()))) {
            this.setMasterWarranty((String)value);
        }
        if (values.containsKey("WarrantyStartDate") && ((value = values.remove("WarrantyStartDate")) == null || !value.equals(this.getWarrantyStartDate()))) {
            this.setWarrantyStartDate((LocalDateTime)value);
        }
        if (values.containsKey("WarrantyEndDate") && ((value = values.remove("WarrantyEndDate")) == null || !value.equals(this.getWarrantyEndDate()))) {
            this.setWarrantyEndDate((LocalDateTime)value);
        }
        if (values.containsKey("WrntyIsInhtdFromSuperiorObject") && ((value = values.remove("WrntyIsInhtdFromSuperiorObject")) == null || !value.equals(this.getWrntyIsInhtdFromSuperiorObject()))) {
            this.setWrntyIsInhtdFromSuperiorObject((String)value);
        }
        if (values.containsKey("WrntyIsPassedOnToChildObject") && ((value = values.remove("WrntyIsPassedOnToChildObject")) == null || !value.equals(this.getWrntyIsPassedOnToChildObject()))) {
            this.setWrntyIsPassedOnToChildObject((String)value);
        }
        if (values.containsKey("to_Equipment") && (value = values.remove("to_Equipment")) instanceof Map) {
            if (this.toEquipment == null) {
                this.toEquipment = new Equipment();
            }
            Map inputMap = (Map)value;
            this.toEquipment.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> EquipmentWarrantyField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new EquipmentWarrantyField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> EquipmentWarrantyField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new EquipmentWarrantyField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_EQUIPMENT";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toEquipment != null) {
            values.put("to_Equipment", this.toEquipment);
        }
        return values;
    }

    @Nullable
    public Equipment fetchEquipment() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Equipment.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("Equipment=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.equipment));
        odataResourceUrl.append(",WarrantyType=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.warrantyType));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Equipment");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        Equipment entity = (Equipment)((Object)result.as(Equipment.class));
        entity.attachToService(this.getServicePathForFetch(), destination);
        return entity;
    }

    @Nullable
    public Equipment getEquipmentOrFetch() throws ODataException {
        if (this.toEquipment == null) {
            this.toEquipment = this.fetchEquipment();
        }
        return this.toEquipment;
    }

    @Nonnull
    public Option<Equipment> getEquipmentIfPresent() {
        return Option.of((Object)((Object)this.toEquipment));
    }

    public void setEquipment(Equipment value) {
        this.toEquipment = value;
    }

    @Nonnull
    @Generated
    public static EquipmentWarrantyBuilder builder() {
        return new EquipmentWarrantyBuilder();
    }

    @Nullable
    @Generated
    public String getEquipment() {
        return this.equipment;
    }

    @Nullable
    @Generated
    public String getWarrantyType() {
        return this.warrantyType;
    }

    @Nullable
    @Generated
    public String getMasterWarranty() {
        return this.masterWarranty;
    }

    @Nullable
    @Generated
    public LocalDateTime getWarrantyStartDate() {
        return this.warrantyStartDate;
    }

    @Nullable
    @Generated
    public LocalDateTime getWarrantyEndDate() {
        return this.warrantyEndDate;
    }

    @Nullable
    @Generated
    public String getWrntyIsInhtdFromSuperiorObject() {
        return this.wrntyIsInhtdFromSuperiorObject;
    }

    @Nullable
    @Generated
    public String getWrntyIsPassedOnToChildObject() {
        return this.wrntyIsPassedOnToChildObject;
    }

    @Generated
    public EquipmentWarranty() {
    }

    @Generated
    public EquipmentWarranty(@Nullable String equipment, @Nullable String warrantyType, @Nullable String masterWarranty, @Nullable LocalDateTime warrantyStartDate, @Nullable LocalDateTime warrantyEndDate, @Nullable String wrntyIsInhtdFromSuperiorObject, @Nullable String wrntyIsPassedOnToChildObject, @Nullable Equipment toEquipment) {
        this.equipment = equipment;
        this.warrantyType = warrantyType;
        this.masterWarranty = masterWarranty;
        this.warrantyStartDate = warrantyStartDate;
        this.warrantyEndDate = warrantyEndDate;
        this.wrntyIsInhtdFromSuperiorObject = wrntyIsInhtdFromSuperiorObject;
        this.wrntyIsPassedOnToChildObject = wrntyIsPassedOnToChildObject;
        this.toEquipment = toEquipment;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "EquipmentWarranty(super=" + super.toString() + ", equipment=" + this.equipment + ", warrantyType=" + this.warrantyType + ", masterWarranty=" + this.masterWarranty + ", warrantyStartDate=" + this.warrantyStartDate + ", warrantyEndDate=" + this.warrantyEndDate + ", wrntyIsInhtdFromSuperiorObject=" + this.wrntyIsInhtdFromSuperiorObject + ", wrntyIsPassedOnToChildObject=" + this.wrntyIsPassedOnToChildObject + ", toEquipment=" + (Object)((Object)this.toEquipment) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EquipmentWarranty)) {
            return false;
        }
        EquipmentWarranty other = (EquipmentWarranty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$equipment = this.equipment;
        String other$equipment = other.equipment;
        if (this$equipment == null ? other$equipment != null : !this$equipment.equals(other$equipment)) {
            return false;
        }
        String this$warrantyType = this.warrantyType;
        String other$warrantyType = other.warrantyType;
        if (this$warrantyType == null ? other$warrantyType != null : !this$warrantyType.equals(other$warrantyType)) {
            return false;
        }
        String this$masterWarranty = this.masterWarranty;
        String other$masterWarranty = other.masterWarranty;
        if (this$masterWarranty == null ? other$masterWarranty != null : !this$masterWarranty.equals(other$masterWarranty)) {
            return false;
        }
        LocalDateTime this$warrantyStartDate = this.warrantyStartDate;
        LocalDateTime other$warrantyStartDate = other.warrantyStartDate;
        if (this$warrantyStartDate == null ? other$warrantyStartDate != null : !((Object)this$warrantyStartDate).equals(other$warrantyStartDate)) {
            return false;
        }
        LocalDateTime this$warrantyEndDate = this.warrantyEndDate;
        LocalDateTime other$warrantyEndDate = other.warrantyEndDate;
        if (this$warrantyEndDate == null ? other$warrantyEndDate != null : !((Object)this$warrantyEndDate).equals(other$warrantyEndDate)) {
            return false;
        }
        String this$wrntyIsInhtdFromSuperiorObject = this.wrntyIsInhtdFromSuperiorObject;
        String other$wrntyIsInhtdFromSuperiorObject = other.wrntyIsInhtdFromSuperiorObject;
        if (this$wrntyIsInhtdFromSuperiorObject == null ? other$wrntyIsInhtdFromSuperiorObject != null : !this$wrntyIsInhtdFromSuperiorObject.equals(other$wrntyIsInhtdFromSuperiorObject)) {
            return false;
        }
        String this$wrntyIsPassedOnToChildObject = this.wrntyIsPassedOnToChildObject;
        String other$wrntyIsPassedOnToChildObject = other.wrntyIsPassedOnToChildObject;
        if (this$wrntyIsPassedOnToChildObject == null ? other$wrntyIsPassedOnToChildObject != null : !this$wrntyIsPassedOnToChildObject.equals(other$wrntyIsPassedOnToChildObject)) {
            return false;
        }
        Equipment this$toEquipment = this.toEquipment;
        Equipment other$toEquipment = other.toEquipment;
        return !(this$toEquipment == null ? other$toEquipment != null : !((Object)((Object)this$toEquipment)).equals((Object)other$toEquipment));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EquipmentWarranty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $equipment = this.equipment;
        result = result * 59 + ($equipment == null ? 43 : $equipment.hashCode());
        String $warrantyType = this.warrantyType;
        result = result * 59 + ($warrantyType == null ? 43 : $warrantyType.hashCode());
        String $masterWarranty = this.masterWarranty;
        result = result * 59 + ($masterWarranty == null ? 43 : $masterWarranty.hashCode());
        LocalDateTime $warrantyStartDate = this.warrantyStartDate;
        result = result * 59 + ($warrantyStartDate == null ? 43 : ((Object)$warrantyStartDate).hashCode());
        LocalDateTime $warrantyEndDate = this.warrantyEndDate;
        result = result * 59 + ($warrantyEndDate == null ? 43 : ((Object)$warrantyEndDate).hashCode());
        String $wrntyIsInhtdFromSuperiorObject = this.wrntyIsInhtdFromSuperiorObject;
        result = result * 59 + ($wrntyIsInhtdFromSuperiorObject == null ? 43 : $wrntyIsInhtdFromSuperiorObject.hashCode());
        String $wrntyIsPassedOnToChildObject = this.wrntyIsPassedOnToChildObject;
        result = result * 59 + ($wrntyIsPassedOnToChildObject == null ? 43 : $wrntyIsPassedOnToChildObject.hashCode());
        Equipment $toEquipment = this.toEquipment;
        result = result * 59 + ($toEquipment == null ? 43 : ((Object)((Object)$toEquipment)).hashCode());
        return result;
    }

    public static final class EquipmentWarrantyBuilder {
        @Generated
        private String warrantyType;
        @Generated
        private String masterWarranty;
        @Generated
        private LocalDateTime warrantyStartDate;
        @Generated
        private LocalDateTime warrantyEndDate;
        @Generated
        private String wrntyIsInhtdFromSuperiorObject;
        @Generated
        private String wrntyIsPassedOnToChildObject;
        private Equipment toEquipment;
        private String equipment = null;

        private EquipmentWarrantyBuilder toEquipment(Equipment value) {
            this.toEquipment = value;
            return this;
        }

        @Nonnull
        public EquipmentWarrantyBuilder equipment(Equipment value) {
            return this.toEquipment(value);
        }

        @Nonnull
        public EquipmentWarrantyBuilder equipment(String value) {
            this.equipment = value;
            return this;
        }

        @Generated
        EquipmentWarrantyBuilder() {
        }

        @Nonnull
        @JsonProperty(value="WarrantyType")
        @Generated
        public EquipmentWarrantyBuilder warrantyType(@Nullable String warrantyType) {
            this.warrantyType = warrantyType;
            return this;
        }

        @Nonnull
        @JsonProperty(value="MasterWarranty")
        @Generated
        public EquipmentWarrantyBuilder masterWarranty(@Nullable String masterWarranty) {
            this.masterWarranty = masterWarranty;
            return this;
        }

        @Nonnull
        @JsonProperty(value="WarrantyStartDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public EquipmentWarrantyBuilder warrantyStartDate(@Nullable LocalDateTime warrantyStartDate) {
            this.warrantyStartDate = warrantyStartDate;
            return this;
        }

        @Nonnull
        @JsonProperty(value="WarrantyEndDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public EquipmentWarrantyBuilder warrantyEndDate(@Nullable LocalDateTime warrantyEndDate) {
            this.warrantyEndDate = warrantyEndDate;
            return this;
        }

        @Nonnull
        @JsonProperty(value="WrntyIsInhtdFromSuperiorObject")
        @Generated
        public EquipmentWarrantyBuilder wrntyIsInhtdFromSuperiorObject(@Nullable String wrntyIsInhtdFromSuperiorObject) {
            this.wrntyIsInhtdFromSuperiorObject = wrntyIsInhtdFromSuperiorObject;
            return this;
        }

        @Nonnull
        @JsonProperty(value="WrntyIsPassedOnToChildObject")
        @Generated
        public EquipmentWarrantyBuilder wrntyIsPassedOnToChildObject(@Nullable String wrntyIsPassedOnToChildObject) {
            this.wrntyIsPassedOnToChildObject = wrntyIsPassedOnToChildObject;
            return this;
        }

        @Nonnull
        @Generated
        public EquipmentWarranty build() {
            return new EquipmentWarranty(this.equipment, this.warrantyType, this.masterWarranty, this.warrantyStartDate, this.warrantyEndDate, this.wrntyIsInhtdFromSuperiorObject, this.wrntyIsPassedOnToChildObject, this.toEquipment);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "EquipmentWarranty.EquipmentWarrantyBuilder(equipment=" + this.equipment + ", warrantyType=" + this.warrantyType + ", masterWarranty=" + this.masterWarranty + ", warrantyStartDate=" + this.warrantyStartDate + ", warrantyEndDate=" + this.warrantyEndDate + ", wrntyIsInhtdFromSuperiorObject=" + this.wrntyIsInhtdFromSuperiorObject + ", wrntyIsPassedOnToChildObject=" + this.wrntyIsPassedOnToChildObject + ", toEquipment=" + (Object)((Object)this.toEquipment) + ")";
        }
    }
}

