/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.AddedKanbanContainer;
import java.math.BigDecimal;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class AddEventDrivenKanbanContainerFluentHelper
extends FluentHelperFunction<AddEventDrivenKanbanContainerFluentHelper, AddedKanbanContainer, List<AddedKanbanContainer>> {
    private final Map<String, Object> values = Maps.newHashMap();

    public AddEventDrivenKanbanContainerFluentHelper(@Nonnull String servicePath, @Nonnull String kanbanControlCycle, @Nullable BigDecimal requestedQuantityInBaseUnit, @Nullable ZonedDateTime requestedDeliveryDateTime, @Nullable String packingInstruction, @Nullable Short numberOfLoadCarriers) {
        super(servicePath);
        this.values.put("KanbanControlCycle", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)kanbanControlCycle));
        if (requestedQuantityInBaseUnit != null) {
            this.values.put("RequestedQuantityInBaseUnit", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Decimal).toUri((Object)requestedQuantityInBaseUnit));
        }
        if (requestedDeliveryDateTime != null) {
            this.values.put("RequestedDeliveryDateTime", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTimeOffset).toUri((Object)requestedDeliveryDateTime));
        }
        if (packingInstruction != null) {
            this.values.put("PackingInstruction", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)packingInstruction));
        }
        if (numberOfLoadCarriers != null) {
            this.values.put("NumberOfLoadCarriers", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Int16).toUri((Object)numberOfLoadCarriers));
        }
    }

    @Nonnull
    protected Class<AddedKanbanContainer> getEntityClass() {
        return AddedKanbanContainer.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "AddEventDrivenKanbanContainer";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nonnull
    public List<AddedKanbanContainer> execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return super.executeMultiple(destination);
    }
}

