/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.Segment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.field.SegmentTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.link.SegmentTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.selectable.SegmentTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class SegmentText
extends VdmEntity<SegmentText> {
    public static final SegmentTextSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="Language")
    @JsonProperty(value="Language")
    @Nullable
    @ODataField(odataName="Language")
    private String language;
    public static final SegmentTextField<String> LANGUAGE = new SegmentTextField("Language");
    @Key
    @SerializedName(value="Segment")
    @JsonProperty(value="Segment")
    @Nullable
    @ODataField(odataName="Segment")
    private String segment;
    public static final SegmentTextField<String> SEGMENT = new SegmentTextField("Segment");
    @SerializedName(value="SegmentName")
    @JsonProperty(value="SegmentName")
    @Nullable
    @ODataField(odataName="SegmentName")
    private String segmentName;
    public static final SegmentTextField<String> SEGMENT_NAME = new SegmentTextField("SegmentName");
    @SerializedName(value="to_Segment")
    @JsonProperty(value="to_Segment")
    @ODataField(odataName="to_Segment")
    @Nullable
    private Segment toSegment;
    public static final SegmentTextOneToOneLink<Segment> TO_SEGMENT = new SegmentTextOneToOneLink("to_Segment");

    @Nonnull
    public Class<SegmentText> getType() {
        return SegmentText.class;
    }

    public void setLanguage(@Nullable String language) {
        this.rememberChangedField("Language", this.language);
        this.language = language;
    }

    public void setSegment(@Nullable String segment) {
        this.rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    public void setSegmentName(@Nullable String segmentName) {
        this.rememberChangedField("SegmentName", this.segmentName);
        this.segmentName = segmentName;
    }

    protected String getEntityCollection() {
        return "A_SegmentText";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("Language", this.getLanguage());
        result.put("Segment", this.getSegment());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Language", this.getLanguage());
        values.put("Segment", this.getSegment());
        values.put("SegmentName", this.getSegmentName());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Language") && ((value = values.remove("Language")) == null || !value.equals(this.getLanguage()))) {
            this.setLanguage((String)value);
        }
        if (values.containsKey("Segment") && ((value = values.remove("Segment")) == null || !value.equals(this.getSegment()))) {
            this.setSegment((String)value);
        }
        if (values.containsKey("SegmentName") && ((value = values.remove("SegmentName")) == null || !value.equals(this.getSegmentName()))) {
            this.setSegmentName((String)value);
        }
        if (values.containsKey("to_Segment") && (value = values.remove("to_Segment")) instanceof Map) {
            if (this.toSegment == null) {
                this.toSegment = new Segment();
            }
            Map inputMap = (Map)value;
            this.toSegment.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> SegmentTextField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new SegmentTextField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> SegmentTextField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new SegmentTextField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_SEGMENT_SRV";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toSegment != null) {
            values.put("to_Segment", this.toSegment);
        }
        return values;
    }

    @Nullable
    public Segment fetchSegment() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Segment.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("Language=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.language));
        odataResourceUrl.append(",Segment=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.segment));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Segment");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        Segment entity = (Segment)((Object)result.as(Segment.class));
        entity.attachToService(this.getServicePathForFetch(), destination);
        return entity;
    }

    @Nullable
    public Segment getSegmentOrFetch() throws ODataException {
        if (this.toSegment == null) {
            this.toSegment = this.fetchSegment();
        }
        return this.toSegment;
    }

    @Nonnull
    public Option<Segment> getSegmentIfPresent() {
        return Option.of((Object)((Object)this.toSegment));
    }

    public void setSegment(Segment value) {
        this.toSegment = value;
    }

    @Nonnull
    @Generated
    public static SegmentTextBuilder builder() {
        return new SegmentTextBuilder();
    }

    @Nullable
    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    @Generated
    public String getSegment() {
        return this.segment;
    }

    @Nullable
    @Generated
    public String getSegmentName() {
        return this.segmentName;
    }

    @Generated
    public SegmentText() {
    }

    @Generated
    public SegmentText(@Nullable String language, @Nullable String segment, @Nullable String segmentName, @Nullable Segment toSegment) {
        this.language = language;
        this.segment = segment;
        this.segmentName = segmentName;
        this.toSegment = toSegment;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "SegmentText(super=" + super.toString() + ", language=" + this.language + ", segment=" + this.segment + ", segmentName=" + this.segmentName + ", toSegment=" + (Object)((Object)this.toSegment) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentText)) {
            return false;
        }
        SegmentText other = (SegmentText)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$language = this.language;
        String other$language = other.language;
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$segment = this.segment;
        String other$segment = other.segment;
        if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
            return false;
        }
        String this$segmentName = this.segmentName;
        String other$segmentName = other.segmentName;
        if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
            return false;
        }
        Segment this$toSegment = this.toSegment;
        Segment other$toSegment = other.toSegment;
        return !(this$toSegment == null ? other$toSegment != null : !((Object)((Object)this$toSegment)).equals((Object)other$toSegment));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SegmentText;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $language = this.language;
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $segment = this.segment;
        result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
        String $segmentName = this.segmentName;
        result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
        Segment $toSegment = this.toSegment;
        result = result * 59 + ($toSegment == null ? 43 : ((Object)((Object)$toSegment)).hashCode());
        return result;
    }

    public static final class SegmentTextBuilder {
        @Generated
        private String language;
        @Generated
        private String segmentName;
        private Segment toSegment;
        private String segment = null;

        private SegmentTextBuilder toSegment(Segment value) {
            this.toSegment = value;
            return this;
        }

        @Nonnull
        public SegmentTextBuilder segment(Segment value) {
            return this.toSegment(value);
        }

        @Nonnull
        public SegmentTextBuilder segment(String value) {
            this.segment = value;
            return this;
        }

        @Generated
        SegmentTextBuilder() {
        }

        @Nonnull
        @JsonProperty(value="Language")
        @Generated
        public SegmentTextBuilder language(@Nullable String language) {
            this.language = language;
            return this;
        }

        @Nonnull
        @JsonProperty(value="SegmentName")
        @Generated
        public SegmentTextBuilder segmentName(@Nullable String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        @Nonnull
        @Generated
        public SegmentText build() {
            return new SegmentText(this.language, this.segment, this.segmentName, this.toSegment);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "SegmentText.SegmentTextBuilder(language=" + this.language + ", segment=" + this.segment + ", segmentName=" + this.segmentName + ", toSegment=" + (Object)((Object)this.toSegment) + ")";
        }
    }
}

