/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataReadMediaBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataReadMediaRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.AttachmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.AttachmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class Attachment
extends VdmEntity<Attachment> {
    public static final AttachmentSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="AttachmentDocumentUUID")
    @JsonProperty(value="AttachmentDocumentUUID")
    @Nullable
    @ODataField(odataName="AttachmentDocumentUUID")
    private UUID attachmentDocumentUUID;
    public static final AttachmentField<UUID> ATTACHMENT_DOCUMENT_UUID = new AttachmentField("AttachmentDocumentUUID");
    @SerializedName(value="MimeType")
    @JsonProperty(value="MimeType")
    @Nullable
    @ODataField(odataName="MimeType")
    private String mimeType;
    public static final AttachmentField<String> MIME_TYPE = new AttachmentField("MimeType");
    @SerializedName(value="FileName")
    @JsonProperty(value="FileName")
    @Nullable
    @ODataField(odataName="FileName")
    private String fileName;
    public static final AttachmentField<String> FILE_NAME = new AttachmentField("FileName");

    @Nonnull
    public Class<Attachment> getType() {
        return Attachment.class;
    }

    public void setAttachmentDocumentUUID(@Nullable UUID attachmentDocumentUUID) {
        this.rememberChangedField("AttachmentDocumentUUID", this.attachmentDocumentUUID);
        this.attachmentDocumentUUID = attachmentDocumentUUID;
    }

    public void setMimeType(@Nullable String mimeType) {
        this.rememberChangedField("MimeType", this.mimeType);
        this.mimeType = mimeType;
    }

    public void setFileName(@Nullable String fileName) {
        this.rememberChangedField("FileName", this.fileName);
        this.fileName = fileName;
    }

    protected String getEntityCollection() {
        return "A_Attachment";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("AttachmentDocumentUUID", this.getAttachmentDocumentUUID());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("AttachmentDocumentUUID", this.getAttachmentDocumentUUID());
        values.put("MimeType", this.getMimeType());
        values.put("FileName", this.getFileName());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("AttachmentDocumentUUID") && ((value = values.remove("AttachmentDocumentUUID")) == null || !value.equals(this.getAttachmentDocumentUUID()))) {
            this.setAttachmentDocumentUUID((UUID)value);
        }
        if (values.containsKey("MimeType") && ((value = values.remove("MimeType")) == null || !value.equals(this.getMimeType()))) {
            this.setMimeType((String)value);
        }
        if (values.containsKey("FileName") && ((value = values.remove("FileName")) == null || !value.equals(this.getFileName()))) {
            this.setFileName((String)value);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> AttachmentField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new AttachmentField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> AttachmentField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new AttachmentField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    @Nonnull
    public InputStream fetchAsStream() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch media stream.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        ODataReadMediaRequest mediaRequest = ODataReadMediaBuilder.withEntity((String)this.getServicePathForFetch(), (String)this.getEntityCollection(), this.getKey()).build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        return mediaRequest.execute(httpClient).getMedia();
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_EHS_REPORT_INCIDENT_SRV";
    }

    @Nonnull
    @Generated
    public static AttachmentBuilder builder() {
        return new AttachmentBuilder();
    }

    @Nullable
    @Generated
    public UUID getAttachmentDocumentUUID() {
        return this.attachmentDocumentUUID;
    }

    @Nullable
    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Nullable
    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public Attachment() {
    }

    @Generated
    public Attachment(@Nullable UUID attachmentDocumentUUID, @Nullable String mimeType, @Nullable String fileName) {
        this.attachmentDocumentUUID = attachmentDocumentUUID;
        this.mimeType = mimeType;
        this.fileName = fileName;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "Attachment(super=" + super.toString() + ", attachmentDocumentUUID=" + this.attachmentDocumentUUID + ", mimeType=" + this.mimeType + ", fileName=" + this.fileName + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$attachmentDocumentUUID = this.attachmentDocumentUUID;
        UUID other$attachmentDocumentUUID = other.attachmentDocumentUUID;
        if (this$attachmentDocumentUUID == null ? other$attachmentDocumentUUID != null : !((Object)this$attachmentDocumentUUID).equals(other$attachmentDocumentUUID)) {
            return false;
        }
        String this$mimeType = this.mimeType;
        String other$mimeType = other.mimeType;
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$fileName = this.fileName;
        String other$fileName = other.fileName;
        return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Attachment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $attachmentDocumentUUID = this.attachmentDocumentUUID;
        result = result * 59 + ($attachmentDocumentUUID == null ? 43 : ((Object)$attachmentDocumentUUID).hashCode());
        String $mimeType = this.mimeType;
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $fileName = this.fileName;
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        return result;
    }

    @Generated
    public static class AttachmentBuilder {
        @Generated
        private UUID attachmentDocumentUUID;
        @Generated
        private String mimeType;
        @Generated
        private String fileName;

        @Generated
        AttachmentBuilder() {
        }

        @Nonnull
        @JsonProperty(value="AttachmentDocumentUUID")
        @Generated
        public AttachmentBuilder attachmentDocumentUUID(@Nullable UUID attachmentDocumentUUID) {
            this.attachmentDocumentUUID = attachmentDocumentUUID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="MimeType")
        @Generated
        public AttachmentBuilder mimeType(@Nullable String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Nonnull
        @JsonProperty(value="FileName")
        @Generated
        public AttachmentBuilder fileName(@Nullable String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Nonnull
        @Generated
        public Attachment build() {
            return new Attachment(this.attachmentDocumentUUID, this.mimeType, this.fileName);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "Attachment.AttachmentBuilder(attachmentDocumentUUID=" + this.attachmentDocumentUUID + ", mimeType=" + this.mimeType + ", fileName=" + this.fileName + ")";
        }
    }
}

