/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.IncidentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.IncidentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.IncidentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.IncidentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class Incident
extends VdmEntity<Incident> {
    public static final IncidentSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="IncidentUUID")
    @JsonProperty(value="IncidentUUID")
    @Nullable
    @ODataField(odataName="IncidentUUID")
    private UUID incidentUUID;
    public static final IncidentField<UUID> INCIDENT_UUID = new IncidentField("IncidentUUID");
    @SerializedName(value="IncidentCategory")
    @JsonProperty(value="IncidentCategory")
    @Nullable
    @ODataField(odataName="IncidentCategory")
    private String incidentCategory;
    public static final IncidentField<String> INCIDENT_CATEGORY = new IncidentField("IncidentCategory");
    @SerializedName(value="IncidentStatus")
    @JsonProperty(value="IncidentStatus")
    @Nullable
    @ODataField(odataName="IncidentStatus")
    private String incidentStatus;
    public static final IncidentField<String> INCIDENT_STATUS = new IncidentField("IncidentStatus");
    @SerializedName(value="IncidentTitle")
    @JsonProperty(value="IncidentTitle")
    @Nullable
    @ODataField(odataName="IncidentTitle")
    private String incidentTitle;
    public static final IncidentField<String> INCIDENT_TITLE = new IncidentField("IncidentTitle");
    @SerializedName(value="IncidentUTCDateTime")
    @JsonProperty(value="IncidentUTCDateTime")
    @Nullable
    @JsonSerialize(using=JacksonZonedDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonZonedDateTimeDeserializer.class)
    @JsonAdapter(value=ZonedDateTimeAdapter.class)
    @ODataField(odataName="IncidentUTCDateTime", converter=ZonedDateTimeCalendarConverter.class)
    private ZonedDateTime incidentUTCDateTime;
    public static final IncidentField<ZonedDateTime> INCIDENT_UTC_DATE_TIME = new IncidentField("IncidentUTCDateTime");
    @SerializedName(value="IncidentLocationDescription")
    @JsonProperty(value="IncidentLocationDescription")
    @Nullable
    @ODataField(odataName="IncidentLocationDescription")
    private String incidentLocationDescription;
    public static final IncidentField<String> INCIDENT_LOCATION_DESCRIPTION = new IncidentField("IncidentLocationDescription");
    @SerializedName(value="EHSLocationUUID")
    @JsonProperty(value="EHSLocationUUID")
    @Nullable
    @ODataField(odataName="EHSLocationUUID")
    private UUID eHSLocationUUID;
    public static final IncidentField<UUID> EHS_LOCATION_UUID = new IncidentField("EHSLocationUUID");
    @SerializedName(value="to_Attachments")
    @JsonProperty(value="to_Attachments")
    @ODataField(odataName="to_Attachments")
    private List<Attachment> toAttachments;
    @SerializedName(value="to_Persons")
    @JsonProperty(value="to_Persons")
    @ODataField(odataName="to_Persons")
    private List<Person> toPersons;
    @SerializedName(value="to_Location")
    @JsonProperty(value="to_Location")
    @ODataField(odataName="to_Location")
    @Nullable
    private Location toLocation;
    public static final IncidentLink<Attachment> TO_ATTACHMENTS = new IncidentLink("to_Attachments");
    public static final IncidentLink<Person> TO_PERSONS = new IncidentLink("to_Persons");
    public static final IncidentOneToOneLink<Location> TO_LOCATION = new IncidentOneToOneLink("to_Location");

    @Nonnull
    public Class<Incident> getType() {
        return Incident.class;
    }

    public void setIncidentUUID(@Nullable UUID incidentUUID) {
        this.rememberChangedField("IncidentUUID", this.incidentUUID);
        this.incidentUUID = incidentUUID;
    }

    public void setIncidentCategory(@Nullable String incidentCategory) {
        this.rememberChangedField("IncidentCategory", this.incidentCategory);
        this.incidentCategory = incidentCategory;
    }

    public void setIncidentStatus(@Nullable String incidentStatus) {
        this.rememberChangedField("IncidentStatus", this.incidentStatus);
        this.incidentStatus = incidentStatus;
    }

    public void setIncidentTitle(@Nullable String incidentTitle) {
        this.rememberChangedField("IncidentTitle", this.incidentTitle);
        this.incidentTitle = incidentTitle;
    }

    public void setIncidentUTCDateTime(@Nullable ZonedDateTime incidentUTCDateTime) {
        this.rememberChangedField("IncidentUTCDateTime", this.incidentUTCDateTime);
        this.incidentUTCDateTime = incidentUTCDateTime;
    }

    public void setIncidentLocationDescription(@Nullable String incidentLocationDescription) {
        this.rememberChangedField("IncidentLocationDescription", this.incidentLocationDescription);
        this.incidentLocationDescription = incidentLocationDescription;
    }

    public void setEHSLocationUUID(@Nullable UUID eHSLocationUUID) {
        this.rememberChangedField("EHSLocationUUID", this.eHSLocationUUID);
        this.eHSLocationUUID = eHSLocationUUID;
    }

    protected String getEntityCollection() {
        return "A_Incident";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("IncidentUUID", this.getIncidentUUID());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("IncidentUUID", this.getIncidentUUID());
        values.put("IncidentCategory", this.getIncidentCategory());
        values.put("IncidentStatus", this.getIncidentStatus());
        values.put("IncidentTitle", this.getIncidentTitle());
        values.put("IncidentUTCDateTime", this.getIncidentUTCDateTime());
        values.put("IncidentLocationDescription", this.getIncidentLocationDescription());
        values.put("EHSLocationUUID", this.getEHSLocationUUID());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Map inputMap;
        VdmEntity entity;
        int i;
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("IncidentUUID") && ((value = values.remove("IncidentUUID")) == null || !value.equals(this.getIncidentUUID()))) {
            this.setIncidentUUID((UUID)value);
        }
        if (values.containsKey("IncidentCategory") && ((value = values.remove("IncidentCategory")) == null || !value.equals(this.getIncidentCategory()))) {
            this.setIncidentCategory((String)value);
        }
        if (values.containsKey("IncidentStatus") && ((value = values.remove("IncidentStatus")) == null || !value.equals(this.getIncidentStatus()))) {
            this.setIncidentStatus((String)value);
        }
        if (values.containsKey("IncidentTitle") && ((value = values.remove("IncidentTitle")) == null || !value.equals(this.getIncidentTitle()))) {
            this.setIncidentTitle((String)value);
        }
        if (values.containsKey("IncidentUTCDateTime") && ((value = values.remove("IncidentUTCDateTime")) == null || !value.equals(this.getIncidentUTCDateTime()))) {
            this.setIncidentUTCDateTime((ZonedDateTime)value);
        }
        if (values.containsKey("IncidentLocationDescription") && ((value = values.remove("IncidentLocationDescription")) == null || !value.equals(this.getIncidentLocationDescription()))) {
            this.setIncidentLocationDescription((String)value);
        }
        if (values.containsKey("EHSLocationUUID") && ((value = values.remove("EHSLocationUUID")) == null || !value.equals(this.getEHSLocationUUID()))) {
            this.setEHSLocationUUID((UUID)value);
        }
        if (values.containsKey("to_Attachments") && (value = values.remove("to_Attachments")) instanceof Iterable) {
            this.toAttachments = this.toAttachments == null ? Lists.newArrayList() : Lists.newArrayList(this.toAttachments);
            i = 0;
            for (Object item : (Iterable)value) {
                if (!(item instanceof Map)) continue;
                if (this.toAttachments.size() > i) {
                    entity = this.toAttachments.get(i);
                } else {
                    entity = new Attachment();
                    this.toAttachments.add((Attachment)entity);
                }
                ++i;
                inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        if (values.containsKey("to_Persons") && (value = values.remove("to_Persons")) instanceof Iterable) {
            this.toPersons = this.toPersons == null ? Lists.newArrayList() : Lists.newArrayList(this.toPersons);
            i = 0;
            for (Object item : (Iterable)value) {
                if (!(item instanceof Map)) continue;
                if (this.toPersons.size() > i) {
                    entity = this.toPersons.get(i);
                } else {
                    entity = new Person();
                    this.toPersons.add((Person)entity);
                }
                ++i;
                inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        if (values.containsKey("to_Location") && (value = values.remove("to_Location")) instanceof Map) {
            if (this.toLocation == null) {
                this.toLocation = new Location();
            }
            Map inputMap2 = (Map)value;
            this.toLocation.fromMap(inputMap2);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> IncidentField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new IncidentField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> IncidentField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new IncidentField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_EHS_REPORT_INCIDENT_SRV";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toAttachments != null) {
            values.put("to_Attachments", this.toAttachments);
        }
        if (this.toPersons != null) {
            values.put("to_Persons", this.toPersons);
        }
        if (this.toLocation != null) {
            values.put("to_Location", this.toLocation);
        }
        return values;
    }

    @Nonnull
    public List<Attachment> fetchAttachments() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Attachment.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("IncidentUUID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Guid).toUri((Object)this.incidentUUID));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Attachments");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        List entityList = result.asList(Attachment.class);
        for (Attachment entity : entityList) {
            entity.attachToService(this.getServicePathForFetch(), destination);
        }
        return entityList;
    }

    @Nonnull
    public List<Attachment> getAttachmentsOrFetch() throws ODataException {
        if (this.toAttachments == null) {
            this.toAttachments = this.fetchAttachments();
        }
        return this.toAttachments;
    }

    @Nonnull
    public Option<List<Attachment>> getAttachmentsIfPresent() {
        return Option.of(this.toAttachments);
    }

    public void setAttachments(@Nonnull List<Attachment> value) {
        if (this.toAttachments == null) {
            this.toAttachments = Lists.newArrayList();
        }
        this.toAttachments.clear();
        this.toAttachments.addAll(value);
    }

    public void addAttachments(Attachment ... entity) {
        if (this.toAttachments == null) {
            this.toAttachments = Lists.newArrayList();
        }
        this.toAttachments.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nonnull
    public List<Person> fetchPersons() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Person.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("IncidentUUID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Guid).toUri((Object)this.incidentUUID));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Persons");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        List entityList = result.asList(Person.class);
        for (Person entity : entityList) {
            entity.attachToService(this.getServicePathForFetch(), destination);
        }
        return entityList;
    }

    @Nonnull
    public List<Person> getPersonsOrFetch() throws ODataException {
        if (this.toPersons == null) {
            this.toPersons = this.fetchPersons();
        }
        return this.toPersons;
    }

    @Nonnull
    public Option<List<Person>> getPersonsIfPresent() {
        return Option.of(this.toPersons);
    }

    public void setPersons(@Nonnull List<Person> value) {
        if (this.toPersons == null) {
            this.toPersons = Lists.newArrayList();
        }
        this.toPersons.clear();
        this.toPersons.addAll(value);
    }

    public void addPersons(Person ... entity) {
        if (this.toPersons == null) {
            this.toPersons = Lists.newArrayList();
        }
        this.toPersons.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nullable
    public Location fetchLocation() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Location.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("IncidentUUID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Guid).toUri((Object)this.incidentUUID));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Location");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        Location entity = (Location)((Object)result.as(Location.class));
        entity.attachToService(this.getServicePathForFetch(), destination);
        return entity;
    }

    @Nullable
    public Location getLocationOrFetch() throws ODataException {
        if (this.toLocation == null) {
            this.toLocation = this.fetchLocation();
        }
        return this.toLocation;
    }

    @Nonnull
    public Option<Location> getLocationIfPresent() {
        return Option.of((Object)((Object)this.toLocation));
    }

    public void setLocation(Location value) {
        this.toLocation = value;
    }

    @Nonnull
    @Generated
    public static IncidentBuilder builder() {
        return new IncidentBuilder();
    }

    @Nullable
    @Generated
    public UUID getIncidentUUID() {
        return this.incidentUUID;
    }

    @Nullable
    @Generated
    public String getIncidentCategory() {
        return this.incidentCategory;
    }

    @Nullable
    @Generated
    public String getIncidentStatus() {
        return this.incidentStatus;
    }

    @Nullable
    @Generated
    public String getIncidentTitle() {
        return this.incidentTitle;
    }

    @Nullable
    @Generated
    public ZonedDateTime getIncidentUTCDateTime() {
        return this.incidentUTCDateTime;
    }

    @Nullable
    @Generated
    public String getIncidentLocationDescription() {
        return this.incidentLocationDescription;
    }

    @Nullable
    @Generated
    public UUID getEHSLocationUUID() {
        return this.eHSLocationUUID;
    }

    @Generated
    public Incident() {
    }

    @Generated
    public Incident(@Nullable UUID incidentUUID, @Nullable String incidentCategory, @Nullable String incidentStatus, @Nullable String incidentTitle, @Nullable ZonedDateTime incidentUTCDateTime, @Nullable String incidentLocationDescription, @Nullable UUID eHSLocationUUID, List<Attachment> toAttachments, List<Person> toPersons, @Nullable Location toLocation) {
        this.incidentUUID = incidentUUID;
        this.incidentCategory = incidentCategory;
        this.incidentStatus = incidentStatus;
        this.incidentTitle = incidentTitle;
        this.incidentUTCDateTime = incidentUTCDateTime;
        this.incidentLocationDescription = incidentLocationDescription;
        this.eHSLocationUUID = eHSLocationUUID;
        this.toAttachments = toAttachments;
        this.toPersons = toPersons;
        this.toLocation = toLocation;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "Incident(super=" + super.toString() + ", incidentUUID=" + this.incidentUUID + ", incidentCategory=" + this.incidentCategory + ", incidentStatus=" + this.incidentStatus + ", incidentTitle=" + this.incidentTitle + ", incidentUTCDateTime=" + this.incidentUTCDateTime + ", incidentLocationDescription=" + this.incidentLocationDescription + ", eHSLocationUUID=" + this.eHSLocationUUID + ", toAttachments=" + this.toAttachments + ", toPersons=" + this.toPersons + ", toLocation=" + (Object)((Object)this.toLocation) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Incident)) {
            return false;
        }
        Incident other = (Incident)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$incidentUUID = this.incidentUUID;
        UUID other$incidentUUID = other.incidentUUID;
        if (this$incidentUUID == null ? other$incidentUUID != null : !((Object)this$incidentUUID).equals(other$incidentUUID)) {
            return false;
        }
        String this$incidentCategory = this.incidentCategory;
        String other$incidentCategory = other.incidentCategory;
        if (this$incidentCategory == null ? other$incidentCategory != null : !this$incidentCategory.equals(other$incidentCategory)) {
            return false;
        }
        String this$incidentStatus = this.incidentStatus;
        String other$incidentStatus = other.incidentStatus;
        if (this$incidentStatus == null ? other$incidentStatus != null : !this$incidentStatus.equals(other$incidentStatus)) {
            return false;
        }
        String this$incidentTitle = this.incidentTitle;
        String other$incidentTitle = other.incidentTitle;
        if (this$incidentTitle == null ? other$incidentTitle != null : !this$incidentTitle.equals(other$incidentTitle)) {
            return false;
        }
        ZonedDateTime this$incidentUTCDateTime = this.incidentUTCDateTime;
        ZonedDateTime other$incidentUTCDateTime = other.incidentUTCDateTime;
        if (this$incidentUTCDateTime == null ? other$incidentUTCDateTime != null : !((Object)this$incidentUTCDateTime).equals(other$incidentUTCDateTime)) {
            return false;
        }
        String this$incidentLocationDescription = this.incidentLocationDescription;
        String other$incidentLocationDescription = other.incidentLocationDescription;
        if (this$incidentLocationDescription == null ? other$incidentLocationDescription != null : !this$incidentLocationDescription.equals(other$incidentLocationDescription)) {
            return false;
        }
        UUID this$eHSLocationUUID = this.eHSLocationUUID;
        UUID other$eHSLocationUUID = other.eHSLocationUUID;
        if (this$eHSLocationUUID == null ? other$eHSLocationUUID != null : !((Object)this$eHSLocationUUID).equals(other$eHSLocationUUID)) {
            return false;
        }
        List<Attachment> this$toAttachments = this.toAttachments;
        List<Attachment> other$toAttachments = other.toAttachments;
        if (this$toAttachments == null ? other$toAttachments != null : !((Object)this$toAttachments).equals(other$toAttachments)) {
            return false;
        }
        List<Person> this$toPersons = this.toPersons;
        List<Person> other$toPersons = other.toPersons;
        if (this$toPersons == null ? other$toPersons != null : !((Object)this$toPersons).equals(other$toPersons)) {
            return false;
        }
        Location this$toLocation = this.toLocation;
        Location other$toLocation = other.toLocation;
        return !(this$toLocation == null ? other$toLocation != null : !((Object)((Object)this$toLocation)).equals((Object)other$toLocation));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Incident;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $incidentUUID = this.incidentUUID;
        result = result * 59 + ($incidentUUID == null ? 43 : ((Object)$incidentUUID).hashCode());
        String $incidentCategory = this.incidentCategory;
        result = result * 59 + ($incidentCategory == null ? 43 : $incidentCategory.hashCode());
        String $incidentStatus = this.incidentStatus;
        result = result * 59 + ($incidentStatus == null ? 43 : $incidentStatus.hashCode());
        String $incidentTitle = this.incidentTitle;
        result = result * 59 + ($incidentTitle == null ? 43 : $incidentTitle.hashCode());
        ZonedDateTime $incidentUTCDateTime = this.incidentUTCDateTime;
        result = result * 59 + ($incidentUTCDateTime == null ? 43 : ((Object)$incidentUTCDateTime).hashCode());
        String $incidentLocationDescription = this.incidentLocationDescription;
        result = result * 59 + ($incidentLocationDescription == null ? 43 : $incidentLocationDescription.hashCode());
        UUID $eHSLocationUUID = this.eHSLocationUUID;
        result = result * 59 + ($eHSLocationUUID == null ? 43 : ((Object)$eHSLocationUUID).hashCode());
        List<Attachment> $toAttachments = this.toAttachments;
        result = result * 59 + ($toAttachments == null ? 43 : ((Object)$toAttachments).hashCode());
        List<Person> $toPersons = this.toPersons;
        result = result * 59 + ($toPersons == null ? 43 : ((Object)$toPersons).hashCode());
        Location $toLocation = this.toLocation;
        result = result * 59 + ($toLocation == null ? 43 : ((Object)((Object)$toLocation)).hashCode());
        return result;
    }

    public static final class IncidentBuilder {
        @Generated
        private UUID incidentUUID;
        @Generated
        private String incidentCategory;
        @Generated
        private String incidentStatus;
        @Generated
        private String incidentTitle;
        @Generated
        private ZonedDateTime incidentUTCDateTime;
        @Generated
        private String incidentLocationDescription;
        @Generated
        private UUID eHSLocationUUID;
        private List<Attachment> toAttachments = Lists.newArrayList();
        private List<Person> toPersons = Lists.newArrayList();
        private Location toLocation;

        private IncidentBuilder toAttachments(List<Attachment> value) {
            this.toAttachments.addAll(value);
            return this;
        }

        @Nonnull
        public IncidentBuilder attachments(Attachment ... value) {
            return this.toAttachments(Lists.newArrayList((Object[])value));
        }

        private IncidentBuilder toPersons(List<Person> value) {
            this.toPersons.addAll(value);
            return this;
        }

        @Nonnull
        public IncidentBuilder persons(Person ... value) {
            return this.toPersons(Lists.newArrayList((Object[])value));
        }

        private IncidentBuilder toLocation(Location value) {
            this.toLocation = value;
            return this;
        }

        @Nonnull
        public IncidentBuilder location(Location value) {
            return this.toLocation(value);
        }

        @Generated
        IncidentBuilder() {
        }

        @Nonnull
        @JsonProperty(value="IncidentUUID")
        @Generated
        public IncidentBuilder incidentUUID(@Nullable UUID incidentUUID) {
            this.incidentUUID = incidentUUID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="IncidentCategory")
        @Generated
        public IncidentBuilder incidentCategory(@Nullable String incidentCategory) {
            this.incidentCategory = incidentCategory;
            return this;
        }

        @Nonnull
        @JsonProperty(value="IncidentStatus")
        @Generated
        public IncidentBuilder incidentStatus(@Nullable String incidentStatus) {
            this.incidentStatus = incidentStatus;
            return this;
        }

        @Nonnull
        @JsonProperty(value="IncidentTitle")
        @Generated
        public IncidentBuilder incidentTitle(@Nullable String incidentTitle) {
            this.incidentTitle = incidentTitle;
            return this;
        }

        @Nonnull
        @JsonProperty(value="IncidentUTCDateTime")
        @JsonDeserialize(using=JacksonZonedDateTimeDeserializer.class)
        @Generated
        public IncidentBuilder incidentUTCDateTime(@Nullable ZonedDateTime incidentUTCDateTime) {
            this.incidentUTCDateTime = incidentUTCDateTime;
            return this;
        }

        @Nonnull
        @JsonProperty(value="IncidentLocationDescription")
        @Generated
        public IncidentBuilder incidentLocationDescription(@Nullable String incidentLocationDescription) {
            this.incidentLocationDescription = incidentLocationDescription;
            return this;
        }

        @Nonnull
        @JsonProperty(value="EHSLocationUUID")
        @Generated
        public IncidentBuilder eHSLocationUUID(@Nullable UUID eHSLocationUUID) {
            this.eHSLocationUUID = eHSLocationUUID;
            return this;
        }

        @Nonnull
        @Generated
        public Incident build() {
            return new Incident(this.incidentUUID, this.incidentCategory, this.incidentStatus, this.incidentTitle, this.incidentUTCDateTime, this.incidentLocationDescription, this.eHSLocationUUID, this.toAttachments, this.toPersons, this.toLocation);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "Incident.IncidentBuilder(incidentUUID=" + this.incidentUUID + ", incidentCategory=" + this.incidentCategory + ", incidentStatus=" + this.incidentStatus + ", incidentTitle=" + this.incidentTitle + ", incidentUTCDateTime=" + this.incidentUTCDateTime + ", incidentLocationDescription=" + this.incidentLocationDescription + ", eHSLocationUUID=" + this.eHSLocationUUID + ", toAttachments=" + this.toAttachments + ", toPersons=" + this.toPersons + ", toLocation=" + (Object)((Object)this.toLocation) + ")";
        }
    }
}

