/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.jointventurebilling.AttachmentLink;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class GetAttachmentLinksFluentHelper
extends FluentHelperFunction<GetAttachmentLinksFluentHelper, AttachmentLink, List<AttachmentLink>> {
    private final Map<String, Object> values = Maps.newHashMap();

    public GetAttachmentLinksFluentHelper(@Nonnull String servicePath, @Nonnull String companyCode, @Nonnull String fiscalYear, @Nonnull String fiscalPeriod, @Nullable String jointVenturePartner) {
        super(servicePath);
        this.values.put("CompanyCode", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)companyCode));
        this.values.put("FiscalYear", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)fiscalYear));
        this.values.put("FiscalPeriod", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)fiscalPeriod));
        if (jointVenturePartner != null) {
            this.values.put("JointVenturePartner", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)jointVenturePartner));
        }
    }

    @Nonnull
    protected Class<AttachmentLink> getEntityClass() {
        return AttachmentLink.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "GetAttachmentLinks";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpGet(uri);
    }

    @Deprecated
    @Nonnull
    public List<AttachmentLink> execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return super.executeMultiple(destination);
    }
}

