/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialdocument.MaterialDocumentItem;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class CancelItemFluentHelper
extends FluentHelperFunction<CancelItemFluentHelper, MaterialDocumentItem, MaterialDocumentItem> {
    private final Map<String, Object> values = Maps.newHashMap();

    public CancelItemFluentHelper(@Nonnull String servicePath, @Nonnull String materialDocumentYear, @Nonnull String materialDocument, @Nonnull String materialDocumentItem, @Nullable LocalDateTime postingDate) {
        super(servicePath);
        this.values.put("MaterialDocumentYear", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)materialDocumentYear));
        this.values.put("MaterialDocument", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)materialDocument));
        this.values.put("MaterialDocumentItem", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)materialDocumentItem));
        if (postingDate != null) {
            this.values.put("PostingDate", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)postingDate));
        }
    }

    @Nonnull
    protected Class<MaterialDocumentItem> getEntityClass() {
        return MaterialDocumentItem.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "CancelItem";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public MaterialDocumentItem execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (MaterialDocumentItem)((Object)super.executeSingle(destination));
    }
}

