/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.materialprice.PriceChangeDocument;
import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class InventoryPriceChangeFluentHelper
extends FluentHelperFunction<InventoryPriceChangeFluentHelper, PriceChangeDocument, PriceChangeDocument> {
    private final Map<String, Object> values = Maps.newHashMap();

    public InventoryPriceChangeFluentHelper(@Nonnull String servicePath, @Nonnull String currency, @Nonnull String currencyRole, @Nonnull String material, @Nonnull BigDecimal inventoryPrice, @Nonnull LocalDateTime postingDate, @Nonnull BigDecimal materialPriceUnitQty, @Nonnull String valuationArea, @Nonnull String inventoryValuationType) {
        super(servicePath);
        this.values.put("Currency", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)currency));
        this.values.put("CurrencyRole", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)currencyRole));
        this.values.put("Material", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)material));
        this.values.put("InventoryPrice", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Decimal).toUri((Object)inventoryPrice));
        this.values.put("PostingDate", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)postingDate));
        this.values.put("MaterialPriceUnitQty", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Decimal).toUri((Object)materialPriceUnitQty));
        this.values.put("ValuationArea", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)valuationArea));
        this.values.put("InventoryValuationType", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)inventoryValuationType));
    }

    @Nonnull
    protected Class<PriceChangeDocument> getEntityClass() {
        return PriceChangeDocument.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "InventoryPriceChange";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public PriceChangeDocument execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (PriceChangeDocument)((Object)super.executeSingle(destination));
    }
}

