/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderv2.ProcessOrder_2;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class ConvertPlndOrderFluentHelper
extends FluentHelperFunction<ConvertPlndOrderFluentHelper, ProcessOrder_2, ProcessOrder_2> {
    private final Map<String, Object> values = Maps.newHashMap();

    public ConvertPlndOrderFluentHelper(@Nonnull String servicePath, @Nullable String manufacturingOrder, @Nonnull String plannedOrder, @Nullable String manufacturingOrderType) {
        super(servicePath);
        if (manufacturingOrder != null) {
            this.values.put("ManufacturingOrder", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)manufacturingOrder));
        }
        this.values.put("PlannedOrder", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)plannedOrder));
        if (manufacturingOrderType != null) {
            this.values.put("ManufacturingOrderType", ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)manufacturingOrderType));
        }
    }

    @Nonnull
    protected Class<ProcessOrder_2> getEntityClass() {
        return ProcessOrder_2.class;
    }

    @Nonnull
    protected String getFunctionName() {
        return "ConvertPlndOrder";
    }

    @Nullable
    protected JsonElement refineJsonResponse(@Nullable JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has(this.getFunctionName())) {
            jsonElement = ((JsonObject)jsonElement).get(this.getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Nonnull
    protected Map<String, Object> getParameters() {
        return this.values;
    }

    @Nonnull
    protected HttpUriRequest createRequest(@Nonnull URI uri) {
        return new HttpPost(uri);
    }

    @Deprecated
    @Nullable
    public ProcessOrder_2 execute(@Nonnull HttpDestinationProperties destination) throws ODataException {
        return (ProcessOrder_2)((Object)super.executeSingle(destination));
    }
}

