/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.field.ProductSalesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.selectable.ProductSalesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class ProductSales
extends VdmEntity<ProductSales> {
    public static final ProductSalesSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="Product")
    @JsonProperty(value="Product")
    @Nullable
    @ODataField(odataName="Product")
    private String product;
    public static final ProductSalesField<String> PRODUCT = new ProductSalesField("Product");
    @SerializedName(value="SalesStatus")
    @JsonProperty(value="SalesStatus")
    @Nullable
    @ODataField(odataName="SalesStatus")
    private String salesStatus;
    public static final ProductSalesField<String> SALES_STATUS = new ProductSalesField("SalesStatus");
    @SerializedName(value="SalesStatusValidityDate")
    @JsonProperty(value="SalesStatusValidityDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="SalesStatusValidityDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime salesStatusValidityDate;
    public static final ProductSalesField<LocalDateTime> SALES_STATUS_VALIDITY_DATE = new ProductSalesField("SalesStatusValidityDate");
    @SerializedName(value="TaxClassification")
    @JsonProperty(value="TaxClassification")
    @Nullable
    @ODataField(odataName="TaxClassification")
    private String taxClassification;
    public static final ProductSalesField<String> TAX_CLASSIFICATION = new ProductSalesField("TaxClassification");
    @SerializedName(value="TransportationGroup")
    @JsonProperty(value="TransportationGroup")
    @Nullable
    @ODataField(odataName="TransportationGroup")
    private String transportationGroup;
    public static final ProductSalesField<String> TRANSPORTATION_GROUP = new ProductSalesField("TransportationGroup");

    @Nonnull
    public Class<ProductSales> getType() {
        return ProductSales.class;
    }

    public void setProduct(@Nullable String product) {
        this.rememberChangedField("Product", this.product);
        this.product = product;
    }

    public void setSalesStatus(@Nullable String salesStatus) {
        this.rememberChangedField("SalesStatus", this.salesStatus);
        this.salesStatus = salesStatus;
    }

    public void setSalesStatusValidityDate(@Nullable LocalDateTime salesStatusValidityDate) {
        this.rememberChangedField("SalesStatusValidityDate", this.salesStatusValidityDate);
        this.salesStatusValidityDate = salesStatusValidityDate;
    }

    public void setTaxClassification(@Nullable String taxClassification) {
        this.rememberChangedField("TaxClassification", this.taxClassification);
        this.taxClassification = taxClassification;
    }

    public void setTransportationGroup(@Nullable String transportationGroup) {
        this.rememberChangedField("TransportationGroup", this.transportationGroup);
        this.transportationGroup = transportationGroup;
    }

    protected String getEntityCollection() {
        return "A_ProductSales";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("Product", this.getProduct());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("Product", this.getProduct());
        values.put("SalesStatus", this.getSalesStatus());
        values.put("SalesStatusValidityDate", this.getSalesStatusValidityDate());
        values.put("TaxClassification", this.getTaxClassification());
        values.put("TransportationGroup", this.getTransportationGroup());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("Product") && ((value = values.remove("Product")) == null || !value.equals(this.getProduct()))) {
            this.setProduct((String)value);
        }
        if (values.containsKey("SalesStatus") && ((value = values.remove("SalesStatus")) == null || !value.equals(this.getSalesStatus()))) {
            this.setSalesStatus((String)value);
        }
        if (values.containsKey("SalesStatusValidityDate") && ((value = values.remove("SalesStatusValidityDate")) == null || !value.equals(this.getSalesStatusValidityDate()))) {
            this.setSalesStatusValidityDate((LocalDateTime)value);
        }
        if (values.containsKey("TaxClassification") && ((value = values.remove("TaxClassification")) == null || !value.equals(this.getTaxClassification()))) {
            this.setTaxClassification((String)value);
        }
        if (values.containsKey("TransportationGroup") && ((value = values.remove("TransportationGroup")) == null || !value.equals(this.getTransportationGroup()))) {
            this.setTransportationGroup((String)value);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> ProductSalesField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new ProductSalesField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> ProductSalesField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new ProductSalesField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_PRODUCT_SRV";
    }

    @Nonnull
    @Generated
    public static ProductSalesBuilder builder() {
        return new ProductSalesBuilder();
    }

    @Nullable
    @Generated
    public String getProduct() {
        return this.product;
    }

    @Nullable
    @Generated
    public String getSalesStatus() {
        return this.salesStatus;
    }

    @Nullable
    @Generated
    public LocalDateTime getSalesStatusValidityDate() {
        return this.salesStatusValidityDate;
    }

    @Nullable
    @Generated
    public String getTaxClassification() {
        return this.taxClassification;
    }

    @Nullable
    @Generated
    public String getTransportationGroup() {
        return this.transportationGroup;
    }

    @Generated
    public ProductSales() {
    }

    @Generated
    public ProductSales(@Nullable String product, @Nullable String salesStatus, @Nullable LocalDateTime salesStatusValidityDate, @Nullable String taxClassification, @Nullable String transportationGroup) {
        this.product = product;
        this.salesStatus = salesStatus;
        this.salesStatusValidityDate = salesStatusValidityDate;
        this.taxClassification = taxClassification;
        this.transportationGroup = transportationGroup;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ProductSales(super=" + super.toString() + ", product=" + this.product + ", salesStatus=" + this.salesStatus + ", salesStatusValidityDate=" + this.salesStatusValidityDate + ", taxClassification=" + this.taxClassification + ", transportationGroup=" + this.transportationGroup + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductSales)) {
            return false;
        }
        ProductSales other = (ProductSales)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$product = this.product;
        String other$product = other.product;
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$salesStatus = this.salesStatus;
        String other$salesStatus = other.salesStatus;
        if (this$salesStatus == null ? other$salesStatus != null : !this$salesStatus.equals(other$salesStatus)) {
            return false;
        }
        LocalDateTime this$salesStatusValidityDate = this.salesStatusValidityDate;
        LocalDateTime other$salesStatusValidityDate = other.salesStatusValidityDate;
        if (this$salesStatusValidityDate == null ? other$salesStatusValidityDate != null : !((Object)this$salesStatusValidityDate).equals(other$salesStatusValidityDate)) {
            return false;
        }
        String this$taxClassification = this.taxClassification;
        String other$taxClassification = other.taxClassification;
        if (this$taxClassification == null ? other$taxClassification != null : !this$taxClassification.equals(other$taxClassification)) {
            return false;
        }
        String this$transportationGroup = this.transportationGroup;
        String other$transportationGroup = other.transportationGroup;
        return !(this$transportationGroup == null ? other$transportationGroup != null : !this$transportationGroup.equals(other$transportationGroup));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ProductSales;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $product = this.product;
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $salesStatus = this.salesStatus;
        result = result * 59 + ($salesStatus == null ? 43 : $salesStatus.hashCode());
        LocalDateTime $salesStatusValidityDate = this.salesStatusValidityDate;
        result = result * 59 + ($salesStatusValidityDate == null ? 43 : ((Object)$salesStatusValidityDate).hashCode());
        String $taxClassification = this.taxClassification;
        result = result * 59 + ($taxClassification == null ? 43 : $taxClassification.hashCode());
        String $transportationGroup = this.transportationGroup;
        result = result * 59 + ($transportationGroup == null ? 43 : $transportationGroup.hashCode());
        return result;
    }

    @Generated
    public static class ProductSalesBuilder {
        @Generated
        private String product;
        @Generated
        private String salesStatus;
        @Generated
        private LocalDateTime salesStatusValidityDate;
        @Generated
        private String taxClassification;
        @Generated
        private String transportationGroup;

        @Generated
        ProductSalesBuilder() {
        }

        @Nonnull
        @JsonProperty(value="Product")
        @Generated
        public ProductSalesBuilder product(@Nullable String product) {
            this.product = product;
            return this;
        }

        @Nonnull
        @JsonProperty(value="SalesStatus")
        @Generated
        public ProductSalesBuilder salesStatus(@Nullable String salesStatus) {
            this.salesStatus = salesStatus;
            return this;
        }

        @Nonnull
        @JsonProperty(value="SalesStatusValidityDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public ProductSalesBuilder salesStatusValidityDate(@Nullable LocalDateTime salesStatusValidityDate) {
            this.salesStatusValidityDate = salesStatusValidityDate;
            return this;
        }

        @Nonnull
        @JsonProperty(value="TaxClassification")
        @Generated
        public ProductSalesBuilder taxClassification(@Nullable String taxClassification) {
            this.taxClassification = taxClassification;
            return this;
        }

        @Nonnull
        @JsonProperty(value="TransportationGroup")
        @Generated
        public ProductSalesBuilder transportationGroup(@Nullable String transportationGroup) {
            this.transportationGroup = transportationGroup;
            return this;
        }

        @Nonnull
        @Generated
        public ProductSales build() {
            return new ProductSales(this.product, this.salesStatus, this.salesStatusValidityDate, this.taxClassification, this.transportationGroup);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "ProductSales.ProductSalesBuilder(product=" + this.product + ", salesStatus=" + this.salesStatus + ", salesStatusValidityDate=" + this.salesStatusValidityDate + ", taxClassification=" + this.taxClassification + ", transportationGroup=" + this.transportationGroup + ")";
        }
    }
}

