/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class RecipeText
extends VdmEntity<RecipeText> {
    public static final RecipeTextSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="RecipeUUID")
    @JsonProperty(value="RecipeUUID")
    @Nullable
    @ODataField(odataName="RecipeUUID")
    private UUID recipeUUID;
    public static final RecipeTextField<UUID> RECIPE_UUID = new RecipeTextField("RecipeUUID");
    @Key
    @SerializedName(value="Language")
    @JsonProperty(value="Language")
    @Nullable
    @ODataField(odataName="Language")
    private String language;
    public static final RecipeTextField<String> LANGUAGE = new RecipeTextField("Language");
    @SerializedName(value="RecipeDescription")
    @JsonProperty(value="RecipeDescription")
    @Nullable
    @ODataField(odataName="RecipeDescription")
    private String recipeDescription;
    public static final RecipeTextField<String> RECIPE_DESCRIPTION = new RecipeTextField("RecipeDescription");
    @SerializedName(value="RecipeLastChangeDateTime")
    @JsonProperty(value="RecipeLastChangeDateTime")
    @Nullable
    @JsonSerialize(using=JacksonZonedDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonZonedDateTimeDeserializer.class)
    @JsonAdapter(value=ZonedDateTimeAdapter.class)
    @ODataField(odataName="RecipeLastChangeDateTime", converter=ZonedDateTimeCalendarConverter.class)
    private ZonedDateTime recipeLastChangeDateTime;
    public static final RecipeTextField<ZonedDateTime> RECIPE_LAST_CHANGE_DATE_TIME = new RecipeTextField("RecipeLastChangeDateTime");
    @SerializedName(value="Recipe")
    @JsonProperty(value="Recipe")
    @Nullable
    @ODataField(odataName="Recipe")
    private String recipe;
    public static final RecipeTextField<String> RECIPE = new RecipeTextField("Recipe");
    @SerializedName(value="to_Recipe")
    @JsonProperty(value="to_Recipe")
    @ODataField(odataName="to_Recipe")
    @Nullable
    private Recipe toRecipe;
    public static final RecipeTextOneToOneLink<Recipe> TO_RECIPE = new RecipeTextOneToOneLink("to_Recipe");

    @Nonnull
    public Class<RecipeText> getType() {
        return RecipeText.class;
    }

    public void setRecipeUUID(@Nullable UUID recipeUUID) {
        this.rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    public void setLanguage(@Nullable String language) {
        this.rememberChangedField("Language", this.language);
        this.language = language;
    }

    public void setRecipeDescription(@Nullable String recipeDescription) {
        this.rememberChangedField("RecipeDescription", this.recipeDescription);
        this.recipeDescription = recipeDescription;
    }

    public void setRecipeLastChangeDateTime(@Nullable ZonedDateTime recipeLastChangeDateTime) {
        this.rememberChangedField("RecipeLastChangeDateTime", this.recipeLastChangeDateTime);
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
    }

    public void setRecipe(@Nullable String recipe) {
        this.rememberChangedField("Recipe", this.recipe);
        this.recipe = recipe;
    }

    protected String getEntityCollection() {
        return "A_RecipeText";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("RecipeUUID", this.getRecipeUUID());
        result.put("Language", this.getLanguage());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("RecipeUUID", this.getRecipeUUID());
        values.put("Language", this.getLanguage());
        values.put("RecipeDescription", this.getRecipeDescription());
        values.put("RecipeLastChangeDateTime", this.getRecipeLastChangeDateTime());
        values.put("Recipe", this.getRecipe());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("RecipeUUID") && ((value = values.remove("RecipeUUID")) == null || !value.equals(this.getRecipeUUID()))) {
            this.setRecipeUUID((UUID)value);
        }
        if (values.containsKey("Language") && ((value = values.remove("Language")) == null || !value.equals(this.getLanguage()))) {
            this.setLanguage((String)value);
        }
        if (values.containsKey("RecipeDescription") && ((value = values.remove("RecipeDescription")) == null || !value.equals(this.getRecipeDescription()))) {
            this.setRecipeDescription((String)value);
        }
        if (values.containsKey("RecipeLastChangeDateTime") && ((value = values.remove("RecipeLastChangeDateTime")) == null || !value.equals(this.getRecipeLastChangeDateTime()))) {
            this.setRecipeLastChangeDateTime((ZonedDateTime)value);
        }
        if (values.containsKey("Recipe") && ((value = values.remove("Recipe")) == null || !value.equals(this.getRecipe()))) {
            this.setRecipe((String)value);
        }
        if (values.containsKey("to_Recipe") && (value = values.remove("to_Recipe")) instanceof Map) {
            if (this.toRecipe == null) {
                this.toRecipe = new Recipe();
            }
            Map inputMap = (Map)value;
            this.toRecipe.fromMap(inputMap);
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> RecipeTextField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new RecipeTextField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> RecipeTextField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new RecipeTextField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_RECIPE";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toRecipe != null) {
            values.put("to_Recipe", this.toRecipe);
        }
        return values;
    }

    @Nullable
    public Recipe fetchRecipe() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type Recipe.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("RecipeUUID=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.Guid).toUri((Object)this.recipeUUID));
        odataResourceUrl.append(",Language=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.language));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("to_Recipe");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        Recipe entity = (Recipe)((Object)result.as(Recipe.class));
        entity.attachToService(this.getServicePathForFetch(), destination);
        return entity;
    }

    @Nullable
    public Recipe getRecipeOrFetch() throws ODataException {
        if (this.toRecipe == null) {
            this.toRecipe = this.fetchRecipe();
        }
        return this.toRecipe;
    }

    @Nonnull
    public Option<Recipe> getRecipeIfPresent() {
        return Option.of((Object)((Object)this.toRecipe));
    }

    public void setRecipe(Recipe value) {
        this.toRecipe = value;
    }

    @Nonnull
    @Generated
    public static RecipeTextBuilder builder() {
        return new RecipeTextBuilder();
    }

    @Nullable
    @Generated
    public UUID getRecipeUUID() {
        return this.recipeUUID;
    }

    @Nullable
    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    @Generated
    public String getRecipeDescription() {
        return this.recipeDescription;
    }

    @Nullable
    @Generated
    public ZonedDateTime getRecipeLastChangeDateTime() {
        return this.recipeLastChangeDateTime;
    }

    @Nullable
    @Generated
    public String getRecipe() {
        return this.recipe;
    }

    @Generated
    public RecipeText() {
    }

    @Generated
    public RecipeText(@Nullable UUID recipeUUID, @Nullable String language, @Nullable String recipeDescription, @Nullable ZonedDateTime recipeLastChangeDateTime, @Nullable String recipe, @Nullable Recipe toRecipe) {
        this.recipeUUID = recipeUUID;
        this.language = language;
        this.recipeDescription = recipeDescription;
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
        this.recipe = recipe;
        this.toRecipe = toRecipe;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "RecipeText(super=" + super.toString() + ", recipeUUID=" + this.recipeUUID + ", language=" + this.language + ", recipeDescription=" + this.recipeDescription + ", recipeLastChangeDateTime=" + this.recipeLastChangeDateTime + ", recipe=" + this.recipe + ", toRecipe=" + (Object)((Object)this.toRecipe) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeText)) {
            return false;
        }
        RecipeText other = (RecipeText)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$recipeUUID = this.recipeUUID;
        UUID other$recipeUUID = other.recipeUUID;
        if (this$recipeUUID == null ? other$recipeUUID != null : !((Object)this$recipeUUID).equals(other$recipeUUID)) {
            return false;
        }
        String this$language = this.language;
        String other$language = other.language;
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$recipeDescription = this.recipeDescription;
        String other$recipeDescription = other.recipeDescription;
        if (this$recipeDescription == null ? other$recipeDescription != null : !this$recipeDescription.equals(other$recipeDescription)) {
            return false;
        }
        ZonedDateTime this$recipeLastChangeDateTime = this.recipeLastChangeDateTime;
        ZonedDateTime other$recipeLastChangeDateTime = other.recipeLastChangeDateTime;
        if (this$recipeLastChangeDateTime == null ? other$recipeLastChangeDateTime != null : !((Object)this$recipeLastChangeDateTime).equals(other$recipeLastChangeDateTime)) {
            return false;
        }
        String this$recipe = this.recipe;
        String other$recipe = other.recipe;
        if (this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe)) {
            return false;
        }
        Recipe this$toRecipe = this.toRecipe;
        Recipe other$toRecipe = other.toRecipe;
        return !(this$toRecipe == null ? other$toRecipe != null : !((Object)((Object)this$toRecipe)).equals((Object)other$toRecipe));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RecipeText;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $recipeUUID = this.recipeUUID;
        result = result * 59 + ($recipeUUID == null ? 43 : ((Object)$recipeUUID).hashCode());
        String $language = this.language;
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $recipeDescription = this.recipeDescription;
        result = result * 59 + ($recipeDescription == null ? 43 : $recipeDescription.hashCode());
        ZonedDateTime $recipeLastChangeDateTime = this.recipeLastChangeDateTime;
        result = result * 59 + ($recipeLastChangeDateTime == null ? 43 : ((Object)$recipeLastChangeDateTime).hashCode());
        String $recipe = this.recipe;
        result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
        Recipe $toRecipe = this.toRecipe;
        result = result * 59 + ($toRecipe == null ? 43 : ((Object)((Object)$toRecipe)).hashCode());
        return result;
    }

    public static final class RecipeTextBuilder {
        @Generated
        private UUID recipeUUID;
        @Generated
        private String language;
        @Generated
        private String recipeDescription;
        @Generated
        private ZonedDateTime recipeLastChangeDateTime;
        private Recipe toRecipe;
        private String recipe = null;

        private RecipeTextBuilder toRecipe(Recipe value) {
            this.toRecipe = value;
            return this;
        }

        @Nonnull
        public RecipeTextBuilder recipe(Recipe value) {
            return this.toRecipe(value);
        }

        @Nonnull
        public RecipeTextBuilder recipe(String value) {
            this.recipe = value;
            return this;
        }

        @Generated
        RecipeTextBuilder() {
        }

        @Nonnull
        @JsonProperty(value="RecipeUUID")
        @Generated
        public RecipeTextBuilder recipeUUID(@Nullable UUID recipeUUID) {
            this.recipeUUID = recipeUUID;
            return this;
        }

        @Nonnull
        @JsonProperty(value="Language")
        @Generated
        public RecipeTextBuilder language(@Nullable String language) {
            this.language = language;
            return this;
        }

        @Nonnull
        @JsonProperty(value="RecipeDescription")
        @Generated
        public RecipeTextBuilder recipeDescription(@Nullable String recipeDescription) {
            this.recipeDescription = recipeDescription;
            return this;
        }

        @Nonnull
        @JsonProperty(value="RecipeLastChangeDateTime")
        @JsonDeserialize(using=JacksonZonedDateTimeDeserializer.class)
        @Generated
        public RecipeTextBuilder recipeLastChangeDateTime(@Nullable ZonedDateTime recipeLastChangeDateTime) {
            this.recipeLastChangeDateTime = recipeLastChangeDateTime;
            return this;
        }

        @Nonnull
        @Generated
        public RecipeText build() {
            return new RecipeText(this.recipeUUID, this.language, this.recipeDescription, this.recipeLastChangeDateTime, this.recipe, this.toRecipe);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "RecipeText.RecipeTextBuilder(recipeUUID=" + this.recipeUUID + ", language=" + this.language + ", recipeDescription=" + this.recipeDescription + ", recipeLastChangeDateTime=" + this.recipeLastChangeDateTime + ", recipe=" + this.recipe + ", toRecipe=" + (Object)((Object)this.toRecipe) + ")";
        }
    }
}

