/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.GRTransactionDataResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.field.GRTransactionDataParametersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.link.GRTransactionDataParametersLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.transactiondataforgroupreporting.selectable.GRTransactionDataParametersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

@JsonAdapter(value=ODataVdmEntityAdapterFactory.class)
public class GRTransactionDataParameters
extends VdmEntity<GRTransactionDataParameters> {
    public static final GRTransactionDataParametersSelectable ALL_FIELDS = () -> "*";
    @Key
    @SerializedName(value="P_ConsolidationUnitHierId")
    @JsonProperty(value="P_ConsolidationUnitHierId")
    @Nullable
    @ODataField(odataName="P_ConsolidationUnitHierId")
    private String p_ConsolidationUnitHierId;
    public static final GRTransactionDataParametersField<String> P_CONSOLIDATION_UNIT_HIER_ID = new GRTransactionDataParametersField("P_ConsolidationUnitHierId");
    @Key
    @SerializedName(value="P_ConsolidationPrftCtrHierId")
    @JsonProperty(value="P_ConsolidationPrftCtrHierId")
    @Nullable
    @ODataField(odataName="P_ConsolidationPrftCtrHierId")
    private String p_ConsolidationPrftCtrHierId;
    public static final GRTransactionDataParametersField<String> P_CONSOLIDATION_PRFT_CTR_HIER_ID = new GRTransactionDataParametersField("P_ConsolidationPrftCtrHierId");
    @Key
    @SerializedName(value="P_ConsolidationSegmentHierId")
    @JsonProperty(value="P_ConsolidationSegmentHierId")
    @Nullable
    @ODataField(odataName="P_ConsolidationSegmentHierId")
    private String p_ConsolidationSegmentHierId;
    public static final GRTransactionDataParametersField<String> P_CONSOLIDATION_SEGMENT_HIER_ID = new GRTransactionDataParametersField("P_ConsolidationSegmentHierId");
    @Key
    @SerializedName(value="P_KeyDate")
    @JsonProperty(value="P_KeyDate")
    @Nullable
    @JsonSerialize(using=JacksonLocalDateTimeSerializer.class)
    @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
    @JsonAdapter(value=LocalDateTimeAdapter.class)
    @ODataField(odataName="P_KeyDate", converter=LocalDateTimeCalendarConverter.class)
    private LocalDateTime p_KeyDate;
    public static final GRTransactionDataParametersField<LocalDateTime> P_KEY_DATE = new GRTransactionDataParametersField("P_KeyDate");
    @SerializedName(value="Results")
    @JsonProperty(value="Results")
    @ODataField(odataName="Results")
    private List<GRTransactionDataResult> toResults;
    public static final GRTransactionDataParametersLink<GRTransactionDataResult> TO_RESULTS = new GRTransactionDataParametersLink("Results");

    @Nonnull
    public Class<GRTransactionDataParameters> getType() {
        return GRTransactionDataParameters.class;
    }

    public void setP_ConsolidationUnitHierId(@Nullable String p_ConsolidationUnitHierId) {
        this.rememberChangedField("P_ConsolidationUnitHierId", this.p_ConsolidationUnitHierId);
        this.p_ConsolidationUnitHierId = p_ConsolidationUnitHierId;
    }

    public void setP_ConsolidationPrftCtrHierId(@Nullable String p_ConsolidationPrftCtrHierId) {
        this.rememberChangedField("P_ConsolidationPrftCtrHierId", this.p_ConsolidationPrftCtrHierId);
        this.p_ConsolidationPrftCtrHierId = p_ConsolidationPrftCtrHierId;
    }

    public void setP_ConsolidationSegmentHierId(@Nullable String p_ConsolidationSegmentHierId) {
        this.rememberChangedField("P_ConsolidationSegmentHierId", this.p_ConsolidationSegmentHierId);
        this.p_ConsolidationSegmentHierId = p_ConsolidationSegmentHierId;
    }

    public void setP_KeyDate(@Nullable LocalDateTime p_KeyDate) {
        this.rememberChangedField("P_KeyDate", this.p_KeyDate);
        this.p_KeyDate = p_KeyDate;
    }

    protected String getEntityCollection() {
        return "GRTransactionData";
    }

    @Nonnull
    protected Map<String, Object> getKey() {
        HashMap result = Maps.newHashMap();
        result.put("P_ConsolidationUnitHierId", this.getP_ConsolidationUnitHierId());
        result.put("P_ConsolidationPrftCtrHierId", this.getP_ConsolidationPrftCtrHierId());
        result.put("P_ConsolidationSegmentHierId", this.getP_ConsolidationSegmentHierId());
        result.put("P_KeyDate", this.getP_KeyDate());
        return result;
    }

    @Nonnull
    protected Map<String, Object> toMapOfFields() {
        Map values = super.toMapOfFields();
        values.put("P_ConsolidationUnitHierId", this.getP_ConsolidationUnitHierId());
        values.put("P_ConsolidationPrftCtrHierId", this.getP_ConsolidationPrftCtrHierId());
        values.put("P_ConsolidationSegmentHierId", this.getP_ConsolidationSegmentHierId());
        values.put("P_KeyDate", this.getP_KeyDate());
        return values;
    }

    protected void fromMap(Map<String, Object> inputValues) {
        Object value;
        HashMap values = Maps.newHashMap(inputValues);
        if (values.containsKey("P_ConsolidationUnitHierId") && ((value = values.remove("P_ConsolidationUnitHierId")) == null || !value.equals(this.getP_ConsolidationUnitHierId()))) {
            this.setP_ConsolidationUnitHierId((String)value);
        }
        if (values.containsKey("P_ConsolidationPrftCtrHierId") && ((value = values.remove("P_ConsolidationPrftCtrHierId")) == null || !value.equals(this.getP_ConsolidationPrftCtrHierId()))) {
            this.setP_ConsolidationPrftCtrHierId((String)value);
        }
        if (values.containsKey("P_ConsolidationSegmentHierId") && ((value = values.remove("P_ConsolidationSegmentHierId")) == null || !value.equals(this.getP_ConsolidationSegmentHierId()))) {
            this.setP_ConsolidationSegmentHierId((String)value);
        }
        if (values.containsKey("P_KeyDate") && ((value = values.remove("P_KeyDate")) == null || !value.equals(this.getP_KeyDate()))) {
            this.setP_KeyDate((LocalDateTime)value);
        }
        if (values.containsKey("Results") && (value = values.remove("Results")) instanceof Iterable) {
            this.toResults = this.toResults == null ? Lists.newArrayList() : Lists.newArrayList(this.toResults);
            int i = 0;
            for (Object item : (Iterable)value) {
                GRTransactionDataResult entity;
                if (!(item instanceof Map)) continue;
                if (this.toResults.size() > i) {
                    entity = this.toResults.get(i);
                } else {
                    entity = new GRTransactionDataResult();
                    this.toResults.add(entity);
                }
                ++i;
                Map inputMap = (Map)item;
                entity.fromMap(inputMap);
            }
        }
        super.fromMap((Map)values);
    }

    @Nonnull
    public static <T> GRTransactionDataParametersField<T> field(@Nonnull String fieldName, @Nonnull Class<T> fieldType) {
        return new GRTransactionDataParametersField(fieldName);
    }

    @Nonnull
    public static <T, DomainT> GRTransactionDataParametersField<T> field(@Nonnull String fieldName, @Nonnull TypeConverter<T, DomainT> typeConverter) {
        return new GRTransactionDataParametersField<T>(fieldName, typeConverter);
    }

    @Nullable
    public HttpDestinationProperties getDestinationForFetch() {
        return super.getDestinationForFetch();
    }

    protected void setServicePathForFetch(@Nullable String servicePathForFetch) {
        super.setServicePathForFetch(servicePathForFetch);
    }

    public void attachToService(@Nullable String servicePath, @Nonnull HttpDestinationProperties destination) {
        super.attachToService(servicePath, destination);
    }

    protected String getDefaultServicePath() {
        return "/sap/opu/odata/sap/API_GRTRANSACTIONDATA_SRV";
    }

    @Nonnull
    protected Map<String, Object> toMapOfNavigationProperties() {
        Map values = super.toMapOfNavigationProperties();
        if (this.toResults != null) {
            values.put("Results", this.toResults);
        }
        return values;
    }

    @Nonnull
    public List<GRTransactionDataResult> fetchResults() throws ODataException {
        HttpDestinationProperties destination = this.getDestinationForFetch();
        if (destination == null) {
            throw new ODataException(ODataExceptionType.OTHER, "Failed to fetch related objects of type GRTransactionDataResult.", (Throwable)new IllegalStateException("Unable to execute OData query. The entity was created locally without an assigned HttpDestination. This method is applicable only on entities which were retrieved or created using the OData VDM."));
        }
        StringBuilder odataResourceUrl = new StringBuilder(this.getEntityCollection());
        odataResourceUrl.append("(");
        odataResourceUrl.append("P_ConsolidationUnitHierId=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.p_ConsolidationUnitHierId));
        odataResourceUrl.append(",P_ConsolidationPrftCtrHierId=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.p_ConsolidationPrftCtrHierId));
        odataResourceUrl.append(",P_ConsolidationSegmentHierId=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.String).toUri((Object)this.p_ConsolidationSegmentHierId));
        odataResourceUrl.append(",P_KeyDate=");
        odataResourceUrl.append(ODataTypeValueSerializer.of((EdmSimpleTypeKind)EdmSimpleTypeKind.DateTime).toUri((Object)this.p_KeyDate));
        odataResourceUrl.append(")/");
        odataResourceUrl.append("Results");
        ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)this.getServicePathForFetch(), (String)odataResourceUrl.toString()).withoutMetadata();
        ODataQuery query = builder.build();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
        ODataQueryResult result = query.execute(httpClient);
        List entityList = result.asList(GRTransactionDataResult.class);
        for (GRTransactionDataResult entity : entityList) {
            entity.attachToService(this.getServicePathForFetch(), destination);
        }
        return entityList;
    }

    @Nonnull
    public List<GRTransactionDataResult> getResultsOrFetch() throws ODataException {
        if (this.toResults == null) {
            this.toResults = this.fetchResults();
        }
        return this.toResults;
    }

    @Nonnull
    public Option<List<GRTransactionDataResult>> getResultsIfPresent() {
        return Option.of(this.toResults);
    }

    public void setResults(@Nonnull List<GRTransactionDataResult> value) {
        if (this.toResults == null) {
            this.toResults = Lists.newArrayList();
        }
        this.toResults.clear();
        this.toResults.addAll(value);
    }

    public void addResults(GRTransactionDataResult ... entity) {
        if (this.toResults == null) {
            this.toResults = Lists.newArrayList();
        }
        this.toResults.addAll(Lists.newArrayList((Object[])entity));
    }

    @Nonnull
    @Generated
    public static GRTransactionDataParametersBuilder builder() {
        return new GRTransactionDataParametersBuilder();
    }

    @Nullable
    @Generated
    public String getP_ConsolidationUnitHierId() {
        return this.p_ConsolidationUnitHierId;
    }

    @Nullable
    @Generated
    public String getP_ConsolidationPrftCtrHierId() {
        return this.p_ConsolidationPrftCtrHierId;
    }

    @Nullable
    @Generated
    public String getP_ConsolidationSegmentHierId() {
        return this.p_ConsolidationSegmentHierId;
    }

    @Nullable
    @Generated
    public LocalDateTime getP_KeyDate() {
        return this.p_KeyDate;
    }

    @Generated
    public GRTransactionDataParameters() {
    }

    @Generated
    public GRTransactionDataParameters(@Nullable String p_ConsolidationUnitHierId, @Nullable String p_ConsolidationPrftCtrHierId, @Nullable String p_ConsolidationSegmentHierId, @Nullable LocalDateTime p_KeyDate, List<GRTransactionDataResult> toResults) {
        this.p_ConsolidationUnitHierId = p_ConsolidationUnitHierId;
        this.p_ConsolidationPrftCtrHierId = p_ConsolidationPrftCtrHierId;
        this.p_ConsolidationSegmentHierId = p_ConsolidationSegmentHierId;
        this.p_KeyDate = p_KeyDate;
        this.toResults = toResults;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "GRTransactionDataParameters(super=" + super.toString() + ", p_ConsolidationUnitHierId=" + this.p_ConsolidationUnitHierId + ", p_ConsolidationPrftCtrHierId=" + this.p_ConsolidationPrftCtrHierId + ", p_ConsolidationSegmentHierId=" + this.p_ConsolidationSegmentHierId + ", p_KeyDate=" + this.p_KeyDate + ", toResults=" + this.toResults + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GRTransactionDataParameters)) {
            return false;
        }
        GRTransactionDataParameters other = (GRTransactionDataParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$p_ConsolidationUnitHierId = this.p_ConsolidationUnitHierId;
        String other$p_ConsolidationUnitHierId = other.p_ConsolidationUnitHierId;
        if (this$p_ConsolidationUnitHierId == null ? other$p_ConsolidationUnitHierId != null : !this$p_ConsolidationUnitHierId.equals(other$p_ConsolidationUnitHierId)) {
            return false;
        }
        String this$p_ConsolidationPrftCtrHierId = this.p_ConsolidationPrftCtrHierId;
        String other$p_ConsolidationPrftCtrHierId = other.p_ConsolidationPrftCtrHierId;
        if (this$p_ConsolidationPrftCtrHierId == null ? other$p_ConsolidationPrftCtrHierId != null : !this$p_ConsolidationPrftCtrHierId.equals(other$p_ConsolidationPrftCtrHierId)) {
            return false;
        }
        String this$p_ConsolidationSegmentHierId = this.p_ConsolidationSegmentHierId;
        String other$p_ConsolidationSegmentHierId = other.p_ConsolidationSegmentHierId;
        if (this$p_ConsolidationSegmentHierId == null ? other$p_ConsolidationSegmentHierId != null : !this$p_ConsolidationSegmentHierId.equals(other$p_ConsolidationSegmentHierId)) {
            return false;
        }
        LocalDateTime this$p_KeyDate = this.p_KeyDate;
        LocalDateTime other$p_KeyDate = other.p_KeyDate;
        if (this$p_KeyDate == null ? other$p_KeyDate != null : !((Object)this$p_KeyDate).equals(other$p_KeyDate)) {
            return false;
        }
        List<GRTransactionDataResult> this$toResults = this.toResults;
        List<GRTransactionDataResult> other$toResults = other.toResults;
        return !(this$toResults == null ? other$toResults != null : !((Object)this$toResults).equals(other$toResults));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof GRTransactionDataParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $p_ConsolidationUnitHierId = this.p_ConsolidationUnitHierId;
        result = result * 59 + ($p_ConsolidationUnitHierId == null ? 43 : $p_ConsolidationUnitHierId.hashCode());
        String $p_ConsolidationPrftCtrHierId = this.p_ConsolidationPrftCtrHierId;
        result = result * 59 + ($p_ConsolidationPrftCtrHierId == null ? 43 : $p_ConsolidationPrftCtrHierId.hashCode());
        String $p_ConsolidationSegmentHierId = this.p_ConsolidationSegmentHierId;
        result = result * 59 + ($p_ConsolidationSegmentHierId == null ? 43 : $p_ConsolidationSegmentHierId.hashCode());
        LocalDateTime $p_KeyDate = this.p_KeyDate;
        result = result * 59 + ($p_KeyDate == null ? 43 : ((Object)$p_KeyDate).hashCode());
        List<GRTransactionDataResult> $toResults = this.toResults;
        result = result * 59 + ($toResults == null ? 43 : ((Object)$toResults).hashCode());
        return result;
    }

    public static final class GRTransactionDataParametersBuilder {
        @Generated
        private String p_ConsolidationUnitHierId;
        @Generated
        private String p_ConsolidationPrftCtrHierId;
        @Generated
        private String p_ConsolidationSegmentHierId;
        @Generated
        private LocalDateTime p_KeyDate;
        private List<GRTransactionDataResult> toResults = Lists.newArrayList();

        private GRTransactionDataParametersBuilder toResults(List<GRTransactionDataResult> value) {
            this.toResults.addAll(value);
            return this;
        }

        @Nonnull
        public GRTransactionDataParametersBuilder results(GRTransactionDataResult ... value) {
            return this.toResults(Lists.newArrayList((Object[])value));
        }

        @Generated
        GRTransactionDataParametersBuilder() {
        }

        @Nonnull
        @JsonProperty(value="P_ConsolidationUnitHierId")
        @Generated
        public GRTransactionDataParametersBuilder p_ConsolidationUnitHierId(@Nullable String p_ConsolidationUnitHierId) {
            this.p_ConsolidationUnitHierId = p_ConsolidationUnitHierId;
            return this;
        }

        @Nonnull
        @JsonProperty(value="P_ConsolidationPrftCtrHierId")
        @Generated
        public GRTransactionDataParametersBuilder p_ConsolidationPrftCtrHierId(@Nullable String p_ConsolidationPrftCtrHierId) {
            this.p_ConsolidationPrftCtrHierId = p_ConsolidationPrftCtrHierId;
            return this;
        }

        @Nonnull
        @JsonProperty(value="P_ConsolidationSegmentHierId")
        @Generated
        public GRTransactionDataParametersBuilder p_ConsolidationSegmentHierId(@Nullable String p_ConsolidationSegmentHierId) {
            this.p_ConsolidationSegmentHierId = p_ConsolidationSegmentHierId;
            return this;
        }

        @Nonnull
        @JsonProperty(value="P_KeyDate")
        @JsonDeserialize(using=JacksonLocalDateTimeDeserializer.class)
        @Generated
        public GRTransactionDataParametersBuilder p_KeyDate(@Nullable LocalDateTime p_KeyDate) {
            this.p_KeyDate = p_KeyDate;
            return this;
        }

        @Nonnull
        @Generated
        public GRTransactionDataParameters build() {
            return new GRTransactionDataParameters(this.p_ConsolidationUnitHierId, this.p_ConsolidationPrftCtrHierId, this.p_ConsolidationSegmentHierId, this.p_KeyDate, this.toResults);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "GRTransactionDataParameters.GRTransactionDataParametersBuilder(p_ConsolidationUnitHierId=" + this.p_ConsolidationUnitHierId + ", p_ConsolidationPrftCtrHierId=" + this.p_ConsolidationPrftCtrHierId + ", p_ConsolidationSegmentHierId=" + this.p_ConsolidationSegmentHierId + ", p_KeyDate=" + this.p_KeyDate + ", toResults=" + this.toResults + ")";
        }
    }
}

