/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.field.OperationalAcctgDocItemCubeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.selectable.OperationalAcctgDocItemCubeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Operational Accounting Document Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_OperationalAcctgDocItemCubeType</b>
 * </p>
 *
 */
@Data
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OperationalAcctgDocItemCube extends VdmEntity<OperationalAcctgDocItemCube>
{

    /**
     * Selector for all available fields of OperationalAcctgDocItemCube.
     *
     */
    public final static OperationalAcctgDocItemCubeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COMPANY_CODE =
        new OperationalAcctgDocItemCubeField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FISCAL_YEAR =
        new OperationalAcctgDocItemCubeField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Journal Entry
     */
    @Key
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @return Journal Entry Posting View Item
     */
    @Key
    @SerializedName( "AccountingDocumentItem" )
    @JsonProperty( "AccountingDocumentItem" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentItem" )
    private String accountingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_ITEM =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Code Name
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COMPANY_CODE_NAME =
        new OperationalAcctgDocItemCubeField<String>("CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CHART_OF_ACCOUNTS =
        new OperationalAcctgDocItemCubeField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItemType</b>
     * </p>
     *
     * @return Identification of the Line Item
     */
    @SerializedName( "AccountingDocumentItemType" )
    @JsonProperty( "AccountingDocumentItemType" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentItemType" )
    private String accountingDocumentItemType;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentItemType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_ITEM_TYPE =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentItemType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @return Clearing Date
     */
    @SerializedName( "ClearingDate" )
    @JsonProperty( "ClearingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ClearingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime clearingDate;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> CLEARING_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("ClearingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingCreationDate</b>
     * </p>
     *
     * @return Clearing Creation Date
     */
    @SerializedName( "ClearingCreationDate" )
    @JsonProperty( "ClearingCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ClearingCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime clearingCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>ClearingCreationDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> CLEARING_CREATION_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("ClearingCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @return Clearing Journal Entry
     */
    @SerializedName( "ClearingAccountingDocument" )
    @JsonProperty( "ClearingAccountingDocument" )
    @Nullable
    @ODataField( odataName = "ClearingAccountingDocument" )
    private String clearingAccountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>ClearingAccountingDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CLEARING_ACCOUNTING_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("ClearingAccountingDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCleared</b>
     * </p>
     *
     * @return Clearing Status: Is Cleared
     */
    @SerializedName( "IsCleared" )
    @JsonProperty( "IsCleared" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCleared" )
    private Boolean isCleared;
    /**
     * Use with available fluent helpers to apply the <b>IsCleared</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_CLEARED =
        new OperationalAcctgDocItemCubeField<Boolean>("IsCleared");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @return Posting Key
     */
    @SerializedName( "PostingKey" )
    @JsonProperty( "PostingKey" )
    @Nullable
    @ODataField( odataName = "PostingKey" )
    private String postingKey;
    /**
     * Use with available fluent helpers to apply the <b>PostingKey</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> POSTING_KEY =
        new OperationalAcctgDocItemCubeField<String>("PostingKey");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "FinancialAccountType" )
    @JsonProperty( "FinancialAccountType" )
    @Nullable
    @ODataField( odataName = "FinancialAccountType" )
    private String financialAccountType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FINANCIAL_ACCOUNT_TYPE =
        new OperationalAcctgDocItemCubeField<String>("FinancialAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @return Special G/L Indicator
     */
    @SerializedName( "SpecialGLCode" )
    @JsonProperty( "SpecialGLCode" )
    @Nullable
    @ODataField( odataName = "SpecialGLCode" )
    private String specialGLCode;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SPECIAL_GL_CODE =
        new OperationalAcctgDocItemCubeField<String>("SpecialGLCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLTransactionType</b>
     * </p>
     *
     * @return Special G/L Transaction Type
     */
    @SerializedName( "SpecialGLTransactionType" )
    @JsonProperty( "SpecialGLTransactionType" )
    @Nullable
    @ODataField( odataName = "SpecialGLTransactionType" )
    private String specialGLTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLTransactionType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SPECIAL_GL_TRANSACTION_TYPE =
        new OperationalAcctgDocItemCubeField<String>("SpecialGLTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DEBIT_CREDIT_CODE =
        new OperationalAcctgDocItemCubeField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BUSINESS_AREA =
        new OperationalAcctgDocItemCubeField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @return Business Area Name
     */
    @SerializedName( "BusinessAreaName" )
    @JsonProperty( "BusinessAreaName" )
    @Nullable
    @ODataField( odataName = "BusinessAreaName" )
    private String businessAreaName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessAreaName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BUSINESS_AREA_NAME =
        new OperationalAcctgDocItemCubeField<String>("BusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Partner Business Area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_BUSINESS_AREA =
        new OperationalAcctgDocItemCubeField<String>("PartnerBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TAX_CODE =
        new OperationalAcctgDocItemCubeField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @return Withholding Tax Code
     */
    @SerializedName( "WithholdingTaxCode" )
    @JsonProperty( "WithholdingTaxCode" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxCode" )
    private String withholdingTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> WITHHOLDING_TAX_CODE =
        new OperationalAcctgDocItemCubeField<String>("WithholdingTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaxType</b>
     * </p>
     *
     * @return Tax Type
     */
    @SerializedName( "TaxType" )
    @JsonProperty( "TaxType" )
    @Nullable
    @ODataField( odataName = "TaxType" )
    private String taxType;
    /**
     * Use with available fluent helpers to apply the <b>TaxType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TAX_TYPE =
        new OperationalAcctgDocItemCubeField<String>("TaxType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @return Transaction Key
     */
    @SerializedName( "TransactionTypeDetermination" )
    @JsonProperty( "TransactionTypeDetermination" )
    @Nullable
    @ODataField( odataName = "TransactionTypeDetermination" )
    private String transactionTypeDetermination;
    /**
     * Use with available fluent helpers to apply the <b>TransactionTypeDetermination</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TRANSACTION_TYPE_DETERMINATION =
        new OperationalAcctgDocItemCubeField<String>("TransactionTypeDetermination");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @return Value Date
     */
    @SerializedName( "ValueDate" )
    @JsonProperty( "ValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime valueDate;
    /**
     * Use with available fluent helpers to apply the <b>ValueDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> VALUE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("ValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Reference
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ASSIGNMENT_REFERENCE =
        new OperationalAcctgDocItemCubeField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DOCUMENT_ITEM_TEXT =
        new OperationalAcctgDocItemCubeField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_COMPANY =
        new OperationalAcctgDocItemCubeField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Financial Transaction Type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FINANCIAL_TRANSACTION_TYPE =
        new OperationalAcctgDocItemCubeField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @return Corporate Group Account
     */
    @SerializedName( "CorporateGroupAccount" )
    @JsonProperty( "CorporateGroupAccount" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccount" )
    private String corporateGroupAccount;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CORPORATE_GROUP_ACCOUNT =
        new OperationalAcctgDocItemCubeField<String>("CorporateGroupAccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningLevel</b>
     * </p>
     *
     * @return Planning Level
     */
    @SerializedName( "PlanningLevel" )
    @JsonProperty( "PlanningLevel" )
    @Nullable
    @ODataField( odataName = "PlanningLevel" )
    private String planningLevel;
    /**
     * Use with available fluent helpers to apply the <b>PlanningLevel</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PLANNING_LEVEL =
        new OperationalAcctgDocItemCubeField<String>("PlanningLevel");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CONTROLLING_AREA =
        new OperationalAcctgDocItemCubeField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area Name
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CONTROLLING_AREA_NAME =
        new OperationalAcctgDocItemCubeField<String>("ControllingAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COST_CENTER =
        new OperationalAcctgDocItemCubeField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @return Cost Center Name
     */
    @SerializedName( "CostCenterName" )
    @JsonProperty( "CostCenterName" )
    @Nullable
    @ODataField( odataName = "CostCenterName" )
    private String costCenterName;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COST_CENTER_NAME =
        new OperationalAcctgDocItemCubeField<String>("CostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PROJECT =
        new OperationalAcctgDocItemCubeField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ORDER_ID =
        new OperationalAcctgDocItemCubeField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @return Billing Document
     */
    @SerializedName( "BillingDocument" )
    @JsonProperty( "BillingDocument" )
    @Nullable
    @ODataField( odataName = "BillingDocument" )
    private String billingDocument;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BILLING_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("BillingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SALES_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SALES_DOCUMENT_ITEM =
        new OperationalAcctgDocItemCubeField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Schedule Line
     */
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SCHEDULE_LINE =
        new OperationalAcctgDocItemCubeField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Fixed Asset
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> MASTER_FIXED_ASSET =
        new OperationalAcctgDocItemCubeField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FIXED_ASSET =
        new OperationalAcctgDocItemCubeField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @return Asset Transaction Type
     */
    @SerializedName( "AssetTransactionType" )
    @JsonProperty( "AssetTransactionType" )
    @Nullable
    @ODataField( odataName = "AssetTransactionType" )
    private String assetTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>AssetTransactionType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ASSET_TRANSACTION_TYPE =
        new OperationalAcctgDocItemCubeField<String>("AssetTransactionType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @return Asset Value Date
     */
    @SerializedName( "AssetValueDate" )
    @JsonProperty( "AssetValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AssetValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime assetValueDate;
    /**
     * Use with available fluent helpers to apply the <b>AssetValueDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> ASSET_VALUE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("AssetValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PERSONNEL_NUMBER =
        new OperationalAcctgDocItemCubeField<String>("PersonnelNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSalesRelated</b>
     * </p>
     *
     * @return Is Sales Related
     */
    @SerializedName( "IsSalesRelated" )
    @JsonProperty( "IsSalesRelated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSalesRelated" )
    private Boolean isSalesRelated;
    /**
     * Use with available fluent helpers to apply the <b>IsSalesRelated</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_SALES_RELATED =
        new OperationalAcctgDocItemCubeField<Boolean>("IsSalesRelated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LineItemDisplayIsEnabled</b>
     * </p>
     *
     * @return Indicator: Can Line Items Be Displayed by Account?
     */
    @SerializedName( "LineItemDisplayIsEnabled" )
    @JsonProperty( "LineItemDisplayIsEnabled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LineItemDisplayIsEnabled" )
    private Boolean lineItemDisplayIsEnabled;
    /**
     * Use with available fluent helpers to apply the <b>LineItemDisplayIsEnabled</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> LINE_ITEM_DISPLAY_IS_ENABLED =
        new OperationalAcctgDocItemCubeField<Boolean>("LineItemDisplayIsEnabled");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @return Managed on an Open Item Basis
     */
    @SerializedName( "IsOpenItemManaged" )
    @JsonProperty( "IsOpenItemManaged" )
    @Nullable
    @ODataField( odataName = "IsOpenItemManaged" )
    private String isOpenItemManaged;
    /**
     * Use with available fluent helpers to apply the <b>IsOpenItemManaged</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> IS_OPEN_ITEM_MANAGED =
        new OperationalAcctgDocItemCubeField<String>("IsOpenItemManaged");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNotCashDiscountLiable</b>
     * </p>
     *
     * @return Is Not Cash Discount Liable
     */
    @SerializedName( "IsNotCashDiscountLiable" )
    @JsonProperty( "IsNotCashDiscountLiable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNotCashDiscountLiable" )
    private Boolean isNotCashDiscountLiable;
    /**
     * Use with available fluent helpers to apply the <b>IsNotCashDiscountLiable</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_NOT_CASH_DISCOUNT_LIABLE =
        new OperationalAcctgDocItemCubeField<Boolean>("IsNotCashDiscountLiable");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsAutomaticallyCreated</b>
     * </p>
     *
     * @return Is Automatically Created
     */
    @SerializedName( "IsAutomaticallyCreated" )
    @JsonProperty( "IsAutomaticallyCreated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsAutomaticallyCreated" )
    private Boolean isAutomaticallyCreated;
    /**
     * Use with available fluent helpers to apply the <b>IsAutomaticallyCreated</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_AUTOMATICALLY_CREATED =
        new OperationalAcctgDocItemCubeField<Boolean>("IsAutomaticallyCreated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUsedInPaymentTransaction</b>
     * </p>
     *
     * @return Is Used In Payment Transaction
     */
    @SerializedName( "IsUsedInPaymentTransaction" )
    @JsonProperty( "IsUsedInPaymentTransaction" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsUsedInPaymentTransaction" )
    private Boolean isUsedInPaymentTransaction;
    /**
     * Use with available fluent helpers to apply the <b>IsUsedInPaymentTransaction</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_USED_IN_PAYMENT_TRANSACTION =
        new OperationalAcctgDocItemCubeField<Boolean>("IsUsedInPaymentTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationalGLAccount</b>
     * </p>
     *
     * @return Operational General Ledger Account
     */
    @SerializedName( "OperationalGLAccount" )
    @JsonProperty( "OperationalGLAccount" )
    @Nullable
    @ODataField( odataName = "OperationalGLAccount" )
    private String operationalGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>OperationalGLAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> OPERATIONAL_GL_ACCOUNT =
        new OperationalAcctgDocItemCubeField<String>("OperationalGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> GL_ACCOUNT =
        new OperationalAcctgDocItemCubeField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountName</b>
     * </p>
     *
     * @return G/L Account Name
     */
    @SerializedName( "GLAccountName" )
    @JsonProperty( "GLAccountName" )
    @Nullable
    @ODataField( odataName = "GLAccountName" )
    private String gLAccountName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> GL_ACCOUNT_NAME =
        new OperationalAcctgDocItemCubeField<String>("GLAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountLongName</b>
     * </p>
     *
     * @return G/L Account Long Name
     */
    @SerializedName( "GLAccountLongName" )
    @JsonProperty( "GLAccountLongName" )
    @Nullable
    @ODataField( odataName = "GLAccountLongName" )
    private String gLAccountLongName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountLongName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> GL_ACCOUNT_LONG_NAME =
        new OperationalAcctgDocItemCubeField<String>("GLAccountLongName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CUSTOMER =
        new OperationalAcctgDocItemCubeField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @return Name of Customer
     */
    @SerializedName( "CustomerName" )
    @JsonProperty( "CustomerName" )
    @Nullable
    @ODataField( odataName = "CustomerName" )
    private String customerName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CUSTOMER_NAME =
        new OperationalAcctgDocItemCubeField<String>("CustomerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SUPPLIER =
        new OperationalAcctgDocItemCubeField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @return Name of Supplier
     */
    @SerializedName( "SupplierName" )
    @JsonProperty( "SupplierName" )
    @Nullable
    @ODataField( odataName = "SupplierName" )
    private String supplierName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SUPPLIER_NAME =
        new OperationalAcctgDocItemCubeField<String>("SupplierName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BranchAccount</b>
     * </p>
     *
     * @return Branch Account
     */
    @SerializedName( "BranchAccount" )
    @JsonProperty( "BranchAccount" )
    @Nullable
    @ODataField( odataName = "BranchAccount" )
    private String branchAccount;
    /**
     * Use with available fluent helpers to apply the <b>BranchAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BRANCH_ACCOUNT =
        new OperationalAcctgDocItemCubeField<String>("BranchAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @return Is Balance Sheet Account
     */
    @SerializedName( "IsBalanceSheetAccount" )
    @JsonProperty( "IsBalanceSheetAccount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBalanceSheetAccount" )
    private Boolean isBalanceSheetAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsBalanceSheetAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_BALANCE_SHEET_ACCOUNT =
        new OperationalAcctgDocItemCubeField<Boolean>("IsBalanceSheetAccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProfitLossAccountType</b>
     * </p>
     *
     * @return Profit Loss Account Type
     */
    @SerializedName( "ProfitLossAccountType" )
    @JsonProperty( "ProfitLossAccountType" )
    @Nullable
    @ODataField( odataName = "ProfitLossAccountType" )
    private String profitLossAccountType;
    /**
     * Use with available fluent helpers to apply the <b>ProfitLossAccountType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PROFIT_LOSS_ACCOUNT_TYPE =
        new OperationalAcctgDocItemCubeField<String>("ProfitLossAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLAccountAssignment</b>
     * </p>
     *
     * @return Assignment Number for Special G/L Accounts
     */
    @SerializedName( "SpecialGLAccountAssignment" )
    @JsonProperty( "SpecialGLAccountAssignment" )
    @Nullable
    @ODataField( odataName = "SpecialGLAccountAssignment" )
    private String specialGLAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLAccountAssignment</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SPECIAL_GL_ACCOUNT_ASSIGNMENT =
        new OperationalAcctgDocItemCubeField<String>("SpecialGLAccountAssignment");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueCalculationBaseDate</b>
     * </p>
     *
     * @return Due Calculation Base Date
     */
    @SerializedName( "DueCalculationBaseDate" )
    @JsonProperty( "DueCalculationBaseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DueCalculationBaseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime dueCalculationBaseDate;
    /**
     * Use with available fluent helpers to apply the <b>DueCalculationBaseDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> DUE_CALCULATION_BASE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("DueCalculationBaseDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_TERMS =
        new OperationalAcctgDocItemCubeField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash Discount Days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new OperationalAcctgDocItemCubeField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash Discount Days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new OperationalAcctgDocItemCubeField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> NET_PAYMENT_DAYS =
        new OperationalAcctgDocItemCubeField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_METHOD =
        new OperationalAcctgDocItemCubeField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     *
     * @return Payment Blocking Reason
     */
    @SerializedName( "PaymentBlockingReason" )
    @JsonProperty( "PaymentBlockingReason" )
    @Nullable
    @ODataField( odataName = "PaymentBlockingReason" )
    private String paymentBlockingReason;
    /**
     * Use with available fluent helpers to apply the <b>PaymentBlockingReason</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_BLOCKING_REASON =
        new OperationalAcctgDocItemCubeField<String>("PaymentBlockingReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedCashDiscount</b>
     * </p>
     *
     * @return Fixed Cash Discount
     */
    @SerializedName( "FixedCashDiscount" )
    @JsonProperty( "FixedCashDiscount" )
    @Nullable
    @ODataField( odataName = "FixedCashDiscount" )
    private String fixedCashDiscount;
    /**
     * Use with available fluent helpers to apply the <b>FixedCashDiscount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FIXED_CASH_DISCOUNT =
        new OperationalAcctgDocItemCubeField<String>("FixedCashDiscount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank Key
     */
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> HOUSE_BANK =
        new OperationalAcctgDocItemCubeField<String>("HouseBank");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPBankAccountInternalID</b>
     * </p>
     *
     * @return Business Partner Bank Account Internal ID
     */
    @SerializedName( "BPBankAccountInternalID" )
    @JsonProperty( "BPBankAccountInternalID" )
    @Nullable
    @ODataField( odataName = "BPBankAccountInternalID" )
    private String bPBankAccountInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BPBankAccountInternalID</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BP_BANK_ACCOUNT_INTERNAL_ID =
        new OperationalAcctgDocItemCubeField<String>("BPBankAccountInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxDistributionCode1</b>
     * </p>
     *
     * @return Tax Code 1 for Distribution
     */
    @SerializedName( "TaxDistributionCode1" )
    @JsonProperty( "TaxDistributionCode1" )
    @Nullable
    @ODataField( odataName = "TaxDistributionCode1" )
    private String taxDistributionCode1;
    /**
     * Use with available fluent helpers to apply the <b>TaxDistributionCode1</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TAX_DISTRIBUTION_CODE1 =
        new OperationalAcctgDocItemCubeField<String>("TaxDistributionCode1");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxDistributionCode2</b>
     * </p>
     *
     * @return Tax Code 2 for Distribution
     */
    @SerializedName( "TaxDistributionCode2" )
    @JsonProperty( "TaxDistributionCode2" )
    @Nullable
    @ODataField( odataName = "TaxDistributionCode2" )
    private String taxDistributionCode2;
    /**
     * Use with available fluent helpers to apply the <b>TaxDistributionCode2</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TAX_DISTRIBUTION_CODE2 =
        new OperationalAcctgDocItemCubeField<String>("TaxDistributionCode2");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxDistributionCode3</b>
     * </p>
     *
     * @return Tax Code 3 for Distribution
     */
    @SerializedName( "TaxDistributionCode3" )
    @JsonProperty( "TaxDistributionCode3" )
    @Nullable
    @ODataField( odataName = "TaxDistributionCode3" )
    private String taxDistributionCode3;
    /**
     * Use with available fluent helpers to apply the <b>TaxDistributionCode3</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TAX_DISTRIBUTION_CODE3 =
        new OperationalAcctgDocItemCubeField<String>("TaxDistributionCode3");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReference</b>
     * </p>
     *
     * @return Invoice Reference
     */
    @SerializedName( "InvoiceReference" )
    @JsonProperty( "InvoiceReference" )
    @Nullable
    @ODataField( odataName = "InvoiceReference" )
    private String invoiceReference;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReference</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> INVOICE_REFERENCE =
        new OperationalAcctgDocItemCubeField<String>("InvoiceReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReferenceFiscalYear</b>
     * </p>
     *
     * @return Invoice Reference Fiscal Year
     */
    @SerializedName( "InvoiceReferenceFiscalYear" )
    @JsonProperty( "InvoiceReferenceFiscalYear" )
    @Nullable
    @ODataField( odataName = "InvoiceReferenceFiscalYear" )
    private String invoiceReferenceFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReferenceFiscalYear</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> INVOICE_REFERENCE_FISCAL_YEAR =
        new OperationalAcctgDocItemCubeField<String>("InvoiceReferenceFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceItemReference</b>
     * </p>
     *
     * @return Invoice Item Reference
     */
    @SerializedName( "InvoiceItemReference" )
    @JsonProperty( "InvoiceItemReference" )
    @Nullable
    @ODataField( odataName = "InvoiceItemReference" )
    private String invoiceItemReference;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceItemReference</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> INVOICE_ITEM_REFERENCE =
        new OperationalAcctgDocItemCubeField<String>("InvoiceItemReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @return Follow-On Document Type
     */
    @SerializedName( "FollowOnDocumentType" )
    @JsonProperty( "FollowOnDocumentType" )
    @Nullable
    @ODataField( odataName = "FollowOnDocumentType" )
    private String followOnDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>FollowOnDocumentType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FOLLOW_ON_DOCUMENT_TYPE =
        new OperationalAcctgDocItemCubeField<String>("FollowOnDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StateCentralBankPaymentReason</b>
     * </p>
     *
     * @return State Central Bank Indicator
     */
    @SerializedName( "StateCentralBankPaymentReason" )
    @JsonProperty( "StateCentralBankPaymentReason" )
    @Nullable
    @ODataField( odataName = "StateCentralBankPaymentReason" )
    private String stateCentralBankPaymentReason;
    /**
     * Use with available fluent helpers to apply the <b>StateCentralBankPaymentReason</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> STATE_CENTRAL_BANK_PAYMENT_REASON =
        new OperationalAcctgDocItemCubeField<String>("StateCentralBankPaymentReason");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingCountry</b>
     * </p>
     *
     * @return Supplying Country/Region
     */
    @SerializedName( "SupplyingCountry" )
    @JsonProperty( "SupplyingCountry" )
    @Nullable
    @ODataField( odataName = "SupplyingCountry" )
    private String supplyingCountry;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingCountry</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SUPPLYING_COUNTRY =
        new OperationalAcctgDocItemCubeField<String>("SupplyingCountry");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceList</b>
     * </p>
     *
     * @return Invoice List
     */
    @SerializedName( "InvoiceList" )
    @JsonProperty( "InvoiceList" )
    @Nullable
    @ODataField( odataName = "InvoiceList" )
    private String invoiceList;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceList</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> INVOICE_LIST =
        new OperationalAcctgDocItemCubeField<String>("InvoiceList");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfExchangeUsage</b>
     * </p>
     *
     * @return Bill of Exchange Usage Type
     */
    @SerializedName( "BillOfExchangeUsage" )
    @JsonProperty( "BillOfExchangeUsage" )
    @Nullable
    @ODataField( odataName = "BillOfExchangeUsage" )
    private String billOfExchangeUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfExchangeUsage</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BILL_OF_EXCHANGE_USAGE =
        new OperationalAcctgDocItemCubeField<String>("BillOfExchangeUsage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningKey</b>
     * </p>
     *
     * @return Dunning Key
     */
    @SerializedName( "DunningKey" )
    @JsonProperty( "DunningKey" )
    @Nullable
    @ODataField( odataName = "DunningKey" )
    private String dunningKey;
    /**
     * Use with available fluent helpers to apply the <b>DunningKey</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DUNNING_KEY =
        new OperationalAcctgDocItemCubeField<String>("DunningKey");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningBlockingReason</b>
     * </p>
     *
     * @return Dunning Blocking Reason
     */
    @SerializedName( "DunningBlockingReason" )
    @JsonProperty( "DunningBlockingReason" )
    @Nullable
    @ODataField( odataName = "DunningBlockingReason" )
    private String dunningBlockingReason;
    /**
     * Use with available fluent helpers to apply the <b>DunningBlockingReason</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DUNNING_BLOCKING_REASON =
        new OperationalAcctgDocItemCubeField<String>("DunningBlockingReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastDunningDate</b>
     * </p>
     *
     * @return Date of Last Dunning Notice
     */
    @SerializedName( "LastDunningDate" )
    @JsonProperty( "LastDunningDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastDunningDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastDunningDate;
    /**
     * Use with available fluent helpers to apply the <b>LastDunningDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> LAST_DUNNING_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("LastDunningDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningLevel</b>
     * </p>
     *
     * @return Dunning Level
     */
    @SerializedName( "DunningLevel" )
    @JsonProperty( "DunningLevel" )
    @Nullable
    @ODataField( odataName = "DunningLevel" )
    private String dunningLevel;
    /**
     * Use with available fluent helpers to apply the <b>DunningLevel</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DUNNING_LEVEL =
        new OperationalAcctgDocItemCubeField<String>("DunningLevel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DunningArea</b>
     * </p>
     *
     * @return Dunning Area
     */
    @SerializedName( "DunningArea" )
    @JsonProperty( "DunningArea" )
    @Nullable
    @ODataField( odataName = "DunningArea" )
    private String dunningArea;
    /**
     * Use with available fluent helpers to apply the <b>DunningArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DUNNING_AREA =
        new OperationalAcctgDocItemCubeField<String>("DunningArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCertificate</b>
     * </p>
     *
     * @return Withholding Tax Certificate
     */
    @SerializedName( "WithholdingTaxCertificate" )
    @JsonProperty( "WithholdingTaxCertificate" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxCertificate" )
    private String withholdingTaxCertificate;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxCertificate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> WITHHOLDING_TAX_CERTIFICATE =
        new OperationalAcctgDocItemCubeField<String>("WithholdingTaxCertificate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> MATERIAL =
        new OperationalAcctgDocItemCubeField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PRODUCT =
        new OperationalAcctgDocItemCubeField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PLANT =
        new OperationalAcctgDocItemCubeField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PURCHASING_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PURCHASING_DOCUMENT_ITEM =
        new OperationalAcctgDocItemCubeField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @return Sequential Number of Account Assignment
     */
    @SerializedName( "AccountAssignmentNumber" )
    @JsonProperty( "AccountAssignmentNumber" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentNumber" )
    private String accountAssignmentNumber;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentNumber</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNT_ASSIGNMENT_NUMBER =
        new OperationalAcctgDocItemCubeField<String>("AccountAssignmentNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @return Is completely delivered
     */
    @SerializedName( "IsCompletelyDelivered" )
    @JsonProperty( "IsCompletelyDelivered" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCompletelyDelivered" )
    private Boolean isCompletelyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>IsCompletelyDelivered</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_COMPLETELY_DELIVERED =
        new OperationalAcctgDocItemCubeField<Boolean>("IsCompletelyDelivered");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceControl</b>
     * </p>
     *
     * @return Material Price Control Indicator
     */
    @SerializedName( "MaterialPriceControl" )
    @JsonProperty( "MaterialPriceControl" )
    @Nullable
    @ODataField( odataName = "MaterialPriceControl" )
    private String materialPriceControl;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPriceControl</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> MATERIAL_PRICE_CONTROL =
        new OperationalAcctgDocItemCubeField<String>("MaterialPriceControl");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> VALUATION_AREA =
        new OperationalAcctgDocItemCubeField<String>("ValuationArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> INVENTORY_VALUATION_TYPE =
        new OperationalAcctgDocItemCubeField<String>("InventoryValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @return VAT Registration
     */
    @SerializedName( "VATRegistration" )
    @JsonProperty( "VATRegistration" )
    @Nullable
    @ODataField( odataName = "VATRegistration" )
    private String vATRegistration;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistration</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> VAT_REGISTRATION =
        new OperationalAcctgDocItemCubeField<String>("VATRegistration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DelivOfGoodsDestCountry</b>
     * </p>
     *
     * @return Country/Region of Destination for Delivery of Goods
     */
    @SerializedName( "DelivOfGoodsDestCountry" )
    @JsonProperty( "DelivOfGoodsDestCountry" )
    @Nullable
    @ODataField( odataName = "DelivOfGoodsDestCountry" )
    private String delivOfGoodsDestCountry;
    /**
     * Use with available fluent helpers to apply the <b>DelivOfGoodsDestCountry</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DELIV_OF_GOODS_DEST_COUNTRY =
        new OperationalAcctgDocItemCubeField<String>("DelivOfGoodsDestCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDifferenceReason</b>
     * </p>
     *
     * @return Payment Difference Reason
     */
    @SerializedName( "PaymentDifferenceReason" )
    @JsonProperty( "PaymentDifferenceReason" )
    @Nullable
    @ODataField( odataName = "PaymentDifferenceReason" )
    private String paymentDifferenceReason;
    /**
     * Use with available fluent helpers to apply the <b>PaymentDifferenceReason</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_DIFFERENCE_REASON =
        new OperationalAcctgDocItemCubeField<String>("PaymentDifferenceReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PROFIT_CENTER =
        new OperationalAcctgDocItemCubeField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @return Description of Profit Center
     */
    @SerializedName( "ProfitCenterName" )
    @JsonProperty( "ProfitCenterName" )
    @Nullable
    @ODataField( odataName = "ProfitCenterName" )
    private String profitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PROFIT_CENTER_NAME =
        new OperationalAcctgDocItemCubeField<String>("ProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @return Joint Venture
     */
    @SerializedName( "JointVenture" )
    @JsonProperty( "JointVenture" )
    @Nullable
    @ODataField( odataName = "JointVenture" )
    private String jointVenture;
    /**
     * Use with available fluent helpers to apply the <b>JointVenture</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> JOINT_VENTURE =
        new OperationalAcctgDocItemCubeField<String>("JointVenture");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @return Recovery Indicator
     */
    @SerializedName( "JointVentureCostRecoveryCode" )
    @JsonProperty( "JointVentureCostRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureCostRecoveryCode" )
    private String jointVentureCostRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureCostRecoveryCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> JOINT_VENTURE_COST_RECOVERY_CODE =
        new OperationalAcctgDocItemCubeField<String>("JointVentureCostRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     *
     * @return Joint Venture Equity Group
     */
    @SerializedName( "JointVentureEquityGroup" )
    @JsonProperty( "JointVentureEquityGroup" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityGroup" )
    private String jointVentureEquityGroup;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityGroup</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> JOINT_VENTURE_EQUITY_GROUP =
        new OperationalAcctgDocItemCubeField<String>("JointVentureEquityGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryContractType</b>
     * </p>
     *
     * @return Treasury Contract Type
     */
    @SerializedName( "TreasuryContractType" )
    @JsonProperty( "TreasuryContractType" )
    @Nullable
    @ODataField( odataName = "TreasuryContractType" )
    private String treasuryContractType;
    /**
     * Use with available fluent helpers to apply the <b>TreasuryContractType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TREASURY_CONTRACT_TYPE =
        new OperationalAcctgDocItemCubeField<String>("TreasuryContractType");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>AssetContract</b>
     * </p>
     *
     * @return Asset Contract
     */
    @SerializedName( "AssetContract" )
    @JsonProperty( "AssetContract" )
    @Nullable
    @ODataField( odataName = "AssetContract" )
    private String assetContract;
    /**
     * Use with available fluent helpers to apply the <b>AssetContract</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ASSET_CONTRACT =
        new OperationalAcctgDocItemCubeField<String>("AssetContract");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CashFlowType</b>
     * </p>
     *
     * @return Flow Type
     */
    @SerializedName( "CashFlowType" )
    @JsonProperty( "CashFlowType" )
    @Nullable
    @ODataField( odataName = "CashFlowType" )
    private String cashFlowType;
    /**
     * Use with available fluent helpers to apply the <b>CashFlowType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CASH_FLOW_TYPE =
        new OperationalAcctgDocItemCubeField<String>("CashFlowType");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TAX_JURISDICTION =
        new OperationalAcctgDocItemCubeField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @return Internal Key for Real Estate Object
     */
    @SerializedName( "RealEstateObject" )
    @JsonProperty( "RealEstateObject" )
    @Nullable
    @ODataField( odataName = "RealEstateObject" )
    private String realEstateObject;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateObject</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REAL_ESTATE_OBJECT =
        new OperationalAcctgDocItemCubeField<String>("RealEstateObject");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @return Reference Date for Settlement
     */
    @SerializedName( "SettlementReferenceDate" )
    @JsonProperty( "SettlementReferenceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementReferenceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime settlementReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> SETTLEMENT_REFERENCE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("SettlementReferenceDate");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @return Commitment Item
     */
    @SerializedName( "CommitmentItem" )
    @JsonProperty( "CommitmentItem" )
    @Nullable
    @ODataField( odataName = "CommitmentItem" )
    private String commitmentItem;
    /**
     * Use with available fluent helpers to apply the <b>CommitmentItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COMMITMENT_ITEM =
        new OperationalAcctgDocItemCubeField<String>("CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COST_OBJECT =
        new OperationalAcctgDocItemCubeField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PROJECT_NETWORK =
        new OperationalAcctgDocItemCubeField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal Bill of Operations ID
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new OperationalAcctgDocItemCubeField<String>("OrderInternalBillOfOperations");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @return Order Internal Bill of Operations Item
     */
    @SerializedName( "OrderIntBillOfOperationsItem" )
    @JsonProperty( "OrderIntBillOfOperationsItem" )
    @Nullable
    @ODataField( odataName = "OrderIntBillOfOperationsItem" )
    private String orderIntBillOfOperationsItem;
    /**
     * Use with available fluent helpers to apply the <b>OrderIntBillOfOperationsItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ORDER_INT_BILL_OF_OPERATIONS_ITEM =
        new OperationalAcctgDocItemCubeField<String>("OrderIntBillOfOperationsItem");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element (Internal Number Without Conversion)
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> WBS_ELEMENT_INTERNAL_ID =
        new OperationalAcctgDocItemCubeField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Deprecated: Profitability Segment
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PROFITABILITY_SEGMENT =
        new OperationalAcctgDocItemCubeField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @return Joint Venture Equity Type
     */
    @SerializedName( "JointVentureEquityType" )
    @JsonProperty( "JointVentureEquityType" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityType" )
    private String jointVentureEquityType;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> JOINT_VENTURE_EQUITY_TYPE =
        new OperationalAcctgDocItemCubeField<String>("JointVentureEquityType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     *
     * @return Is EU Triangular Deal
     */
    @SerializedName( "IsEUTriangularDeal" )
    @JsonProperty( "IsEUTriangularDeal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsEUTriangularDeal" )
    private Boolean isEUTriangularDeal;
    /**
     * Use with available fluent helpers to apply the <b>IsEUTriangularDeal</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_EU_TRIANGULAR_DEAL =
        new OperationalAcctgDocItemCubeField<Boolean>("IsEUTriangularDeal");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @return Origin Group as Subdivision of Cost Element
     */
    @SerializedName( "CostOriginGroup" )
    @JsonProperty( "CostOriginGroup" )
    @Nullable
    @ODataField( odataName = "CostOriginGroup" )
    private String costOriginGroup;
    /**
     * Use with available fluent helpers to apply the <b>CostOriginGroup</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COST_ORIGIN_GROUP =
        new OperationalAcctgDocItemCubeField<String>("CostOriginGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrencyDetnMethod</b>
     * </p>
     *
     * @return Company Code Currency Determination Method
     */
    @SerializedName( "CompanyCodeCurrencyDetnMethod" )
    @JsonProperty( "CompanyCodeCurrencyDetnMethod" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrencyDetnMethod" )
    private String companyCodeCurrencyDetnMethod;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrencyDetnMethod</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COMPANY_CODE_CURRENCY_DETN_METHOD =
        new OperationalAcctgDocItemCubeField<String>("CompanyCodeCurrencyDetnMethod");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClearingIsReversed</b>
     * </p>
     *
     * @return Clearing Is Reversed
     */
    @SerializedName( "ClearingIsReversed" )
    @JsonProperty( "ClearingIsReversed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ClearingIsReversed" )
    private Boolean clearingIsReversed;
    /**
     * Use with available fluent helpers to apply the <b>ClearingIsReversed</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> CLEARING_IS_REVERSED =
        new OperationalAcctgDocItemCubeField<Boolean>("ClearingIsReversed");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplement</b>
     * </p>
     *
     * @return Payment Method Supplement
     */
    @SerializedName( "PaymentMethodSupplement" )
    @JsonProperty( "PaymentMethodSupplement" )
    @Nullable
    @ODataField( odataName = "PaymentMethodSupplement" )
    private String paymentMethodSupplement;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethodSupplement</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_METHOD_SUPPLEMENT =
        new OperationalAcctgDocItemCubeField<String>("PaymentMethodSupplement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @return Alternative G/L Account Number In Company Code
     */
    @SerializedName( "AlternativeGLAccount" )
    @JsonProperty( "AlternativeGLAccount" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccount" )
    private String alternativeGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ALTERNATIVE_GL_ACCOUNT =
        new OperationalAcctgDocItemCubeField<String>("AlternativeGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @return Funds Management Center
     */
    @SerializedName( "FundsCenter" )
    @JsonProperty( "FundsCenter" )
    @Nullable
    @ODataField( odataName = "FundsCenter" )
    private String fundsCenter;
    /**
     * Use with available fluent helpers to apply the <b>FundsCenter</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FUNDS_CENTER =
        new OperationalAcctgDocItemCubeField<String>("FundsCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FUND =
        new OperationalAcctgDocItemCubeField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @SerializedName( "PartnerProfitCenter" )
    @JsonProperty( "PartnerProfitCenter" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter" )
    private String partnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_PROFIT_CENTER =
        new OperationalAcctgDocItemCubeField<String>("PartnerProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference1IDByBusinessPartner</b>
     * </p>
     *
     * @return ID of Reference 1 by Business Partner
     */
    @SerializedName( "Reference1IDByBusinessPartner" )
    @JsonProperty( "Reference1IDByBusinessPartner" )
    @Nullable
    @ODataField( odataName = "Reference1IDByBusinessPartner" )
    private String reference1IDByBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference1IDByBusinessPartner</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REFERENCE1_I_D_BY_BUSINESS_PARTNER =
        new OperationalAcctgDocItemCubeField<String>("Reference1IDByBusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference2IDByBusinessPartner</b>
     * </p>
     *
     * @return ID of Reference 2 by Business Partner
     */
    @SerializedName( "Reference2IDByBusinessPartner" )
    @JsonProperty( "Reference2IDByBusinessPartner" )
    @Nullable
    @ODataField( odataName = "Reference2IDByBusinessPartner" )
    private String reference2IDByBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference2IDByBusinessPartner</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REFERENCE2_I_D_BY_BUSINESS_PARTNER =
        new OperationalAcctgDocItemCubeField<String>("Reference2IDByBusinessPartner");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNegativePosting</b>
     * </p>
     *
     * @return Is Negative Posting
     */
    @SerializedName( "IsNegativePosting" )
    @JsonProperty( "IsNegativePosting" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNegativePosting" )
    private Boolean isNegativePosting;
    /**
     * Use with available fluent helpers to apply the <b>IsNegativePosting</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_NEGATIVE_POSTING =
        new OperationalAcctgDocItemCubeField<Boolean>("IsNegativePosting");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardItem</b>
     * </p>
     *
     * @return Payment Card Item
     */
    @SerializedName( "PaymentCardItem" )
    @JsonProperty( "PaymentCardItem" )
    @Nullable
    @ODataField( odataName = "PaymentCardItem" )
    private String paymentCardItem;
    /**
     * Use with available fluent helpers to apply the <b>PaymentCardItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_CARD_ITEM =
        new OperationalAcctgDocItemCubeField<String>("PaymentCardItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardPaymentSettlement</b>
     * </p>
     *
     * @return Payment Card Payment Settlement
     */
    @SerializedName( "PaymentCardPaymentSettlement" )
    @JsonProperty( "PaymentCardPaymentSettlement" )
    @Nullable
    @ODataField( odataName = "PaymentCardPaymentSettlement" )
    private String paymentCardPaymentSettlement;
    /**
     * Use with available fluent helpers to apply the <b>PaymentCardPaymentSettlement</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_CARD_PAYMENT_SETTLEMENT =
        new OperationalAcctgDocItemCubeField<String>("PaymentCardPaymentSettlement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @return Credit Control Area
     */
    @SerializedName( "CreditControlArea" )
    @JsonProperty( "CreditControlArea" )
    @Nullable
    @ODataField( odataName = "CreditControlArea" )
    private String creditControlArea;
    /**
     * Use with available fluent helpers to apply the <b>CreditControlArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CREDIT_CONTROL_AREA =
        new OperationalAcctgDocItemCubeField<String>("CreditControlArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference3IDByBusinessPartner</b>
     * </p>
     *
     * @return ID of Reference 3 by Business Partner
     */
    @SerializedName( "Reference3IDByBusinessPartner" )
    @JsonProperty( "Reference3IDByBusinessPartner" )
    @Nullable
    @ODataField( odataName = "Reference3IDByBusinessPartner" )
    private String reference3IDByBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference3IDByBusinessPartner</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REFERENCE3_I_D_BY_BUSINESS_PARTNER =
        new OperationalAcctgDocItemCubeField<String>("Reference3IDByBusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction1</b>
     * </p>
     *
     * @return Data Exchange Instruction 1
     */
    @SerializedName( "DataExchangeInstruction1" )
    @JsonProperty( "DataExchangeInstruction1" )
    @Nullable
    @ODataField( odataName = "DataExchangeInstruction1" )
    private String dataExchangeInstruction1;
    /**
     * Use with available fluent helpers to apply the <b>DataExchangeInstruction1</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DATA_EXCHANGE_INSTRUCTION1 =
        new OperationalAcctgDocItemCubeField<String>("DataExchangeInstruction1");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction2</b>
     * </p>
     *
     * @return Data Exchange Instruction 2
     */
    @SerializedName( "DataExchangeInstruction2" )
    @JsonProperty( "DataExchangeInstruction2" )
    @Nullable
    @ODataField( odataName = "DataExchangeInstruction2" )
    private String dataExchangeInstruction2;
    /**
     * Use with available fluent helpers to apply the <b>DataExchangeInstruction2</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DATA_EXCHANGE_INSTRUCTION2 =
        new OperationalAcctgDocItemCubeField<String>("DataExchangeInstruction2");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction3</b>
     * </p>
     *
     * @return Data Exchange Instruction 3
     */
    @SerializedName( "DataExchangeInstruction3" )
    @JsonProperty( "DataExchangeInstruction3" )
    @Nullable
    @ODataField( odataName = "DataExchangeInstruction3" )
    private String dataExchangeInstruction3;
    /**
     * Use with available fluent helpers to apply the <b>DataExchangeInstruction3</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DATA_EXCHANGE_INSTRUCTION3 =
        new OperationalAcctgDocItemCubeField<String>("DataExchangeInstruction3");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction4</b>
     * </p>
     *
     * @return Data Exchange Instruction 4
     */
    @SerializedName( "DataExchangeInstruction4" )
    @JsonProperty( "DataExchangeInstruction4" )
    @Nullable
    @ODataField( odataName = "DataExchangeInstruction4" )
    private String dataExchangeInstruction4;
    /**
     * Use with available fluent helpers to apply the <b>DataExchangeInstruction4</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DATA_EXCHANGE_INSTRUCTION4 =
        new OperationalAcctgDocItemCubeField<String>("DataExchangeInstruction4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REGION =
        new OperationalAcctgDocItemCubeField<String>("Region");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasPaymentOrder</b>
     * </p>
     *
     * @return Indicator: Payment Order Exists for this Item
     */
    @SerializedName( "HasPaymentOrder" )
    @JsonProperty( "HasPaymentOrder" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HasPaymentOrder" )
    private Boolean hasPaymentOrder;
    /**
     * Use with available fluent helpers to apply the <b>HasPaymentOrder</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> HAS_PAYMENT_ORDER =
        new OperationalAcctgDocItemCubeField<Boolean>("HasPaymentOrder");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @return Payment Reference
     */
    @SerializedName( "PaymentReference" )
    @JsonProperty( "PaymentReference" )
    @Nullable
    @ODataField( odataName = "PaymentReference" )
    private String paymentReference;
    /**
     * Use with available fluent helpers to apply the <b>PaymentReference</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_REFERENCE =
        new OperationalAcctgDocItemCubeField<String>("PaymentReference");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @return Date for Determination of Tax Rates
     */
    @SerializedName( "TaxDeterminationDate" )
    @JsonProperty( "TaxDeterminationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxDeterminationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxDeterminationDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxDeterminationDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> TAX_DETERMINATION_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("TaxDeterminationDate");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingItem</b>
     * </p>
     *
     * @return Clearing Item
     */
    @SerializedName( "ClearingItem" )
    @JsonProperty( "ClearingItem" )
    @Nullable
    @ODataField( odataName = "ClearingItem" )
    private BigDecimal clearingItem;
    /**
     * Use with available fluent helpers to apply the <b>ClearingItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CLEARING_ITEM =
        new OperationalAcctgDocItemCubeField<BigDecimal>("ClearingItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @return Business Place
     */
    @SerializedName( "BusinessPlace" )
    @JsonProperty( "BusinessPlace" )
    @Nullable
    @ODataField( odataName = "BusinessPlace" )
    private String businessPlace;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlace</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BUSINESS_PLACE =
        new OperationalAcctgDocItemCubeField<String>("BusinessPlace");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxSection</b>
     * </p>
     *
     * @return Tax Section
     */
    @SerializedName( "TaxSection" )
    @JsonProperty( "TaxSection" )
    @Nullable
    @ODataField( odataName = "TaxSection" )
    private String taxSection;
    /**
     * Use with available fluent helpers to apply the <b>TaxSection</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TAX_SECTION =
        new OperationalAcctgDocItemCubeField<String>("TaxSection");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COST_CTR_ACTIVITY_TYPE =
        new OperationalAcctgDocItemCubeField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountsReceivableIsPledged</b>
     * </p>
     *
     * @return Accounts Receivable Is Pledged
     */
    @SerializedName( "AccountsReceivableIsPledged" )
    @JsonProperty( "AccountsReceivableIsPledged" )
    @Nullable
    @ODataField( odataName = "AccountsReceivableIsPledged" )
    private String accountsReceivableIsPledged;
    /**
     * Use with available fluent helpers to apply the <b>AccountsReceivableIsPledged</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTS_RECEIVABLE_IS_PLEDGED =
        new OperationalAcctgDocItemCubeField<String>("AccountsReceivableIsPledged");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BUSINESS_PROCESS =
        new OperationalAcctgDocItemCubeField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> GRANT_ID =
        new OperationalAcctgDocItemCubeField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FUNCTIONAL_AREA =
        new OperationalAcctgDocItemCubeField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @return Functional Area Name
     */
    @SerializedName( "FunctionalAreaName" )
    @JsonProperty( "FunctionalAreaName" )
    @Nullable
    @ODataField( odataName = "FunctionalAreaName" )
    private String functionalAreaName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FUNCTIONAL_AREA_NAME =
        new OperationalAcctgDocItemCubeField<String>("FunctionalAreaName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerIsInExecution</b>
     * </p>
     *
     * @return Customer Is In Execution
     */
    @SerializedName( "CustomerIsInExecution" )
    @JsonProperty( "CustomerIsInExecution" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CustomerIsInExecution" )
    private Boolean customerIsInExecution;
    /**
     * Use with available fluent helpers to apply the <b>CustomerIsInExecution</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> CUSTOMER_IS_IN_EXECUTION =
        new OperationalAcctgDocItemCubeField<Boolean>("CustomerIsInExecution");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FundedProgram</b>
     * </p>
     *
     * @return Funded Program
     */
    @SerializedName( "FundedProgram" )
    @JsonProperty( "FundedProgram" )
    @Nullable
    @ODataField( odataName = "FundedProgram" )
    private String fundedProgram;
    /**
     * Use with available fluent helpers to apply the <b>FundedProgram</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FUNDED_PROGRAM =
        new OperationalAcctgDocItemCubeField<String>("FundedProgram");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Clearing Journal Entry
     */
    @SerializedName( "ClearingDocFiscalYear" )
    @JsonProperty( "ClearingDocFiscalYear" )
    @Nullable
    @ODataField( odataName = "ClearingDocFiscalYear" )
    private String clearingDocFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDocFiscalYear</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CLEARING_DOC_FISCAL_YEAR =
        new OperationalAcctgDocItemCubeField<String>("ClearingDocFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @return Ledger Journal Entry Item
     */
    @SerializedName( "LedgerGLLineItem" )
    @JsonProperty( "LedgerGLLineItem" )
    @Nullable
    @ODataField( odataName = "LedgerGLLineItem" )
    private String ledgerGLLineItem;
    /**
     * Use with available fluent helpers to apply the <b>LedgerGLLineItem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> LEDGER_GL_LINE_ITEM =
        new OperationalAcctgDocItemCubeField<String>("LedgerGLLineItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SEGMENT =
        new OperationalAcctgDocItemCubeField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     *
     * @return Segment Name
     */
    @SerializedName( "SegmentName" )
    @JsonProperty( "SegmentName" )
    @Nullable
    @ODataField( odataName = "SegmentName" )
    private String segmentName;
    /**
     * Use with available fluent helpers to apply the <b>SegmentName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SEGMENT_NAME =
        new OperationalAcctgDocItemCubeField<String>("SegmentName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @return Partner Segment for Segmental Reporting
     */
    @SerializedName( "PartnerSegment" )
    @JsonProperty( "PartnerSegment" )
    @Nullable
    @ODataField( odataName = "PartnerSegment" )
    private String partnerSegment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_SEGMENT =
        new OperationalAcctgDocItemCubeField<String>("PartnerSegment");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @return Partner Functional Area
     */
    @SerializedName( "PartnerFunctionalArea" )
    @JsonProperty( "PartnerFunctionalArea" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea" )
    private String partnerFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_FUNCTIONAL_AREA =
        new OperationalAcctgDocItemCubeField<String>("PartnerFunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @return House Bank Account
     */
    @SerializedName( "HouseBankAccount" )
    @JsonProperty( "HouseBankAccount" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount" )
    private String houseBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> HOUSE_BANK_ACCOUNT =
        new OperationalAcctgDocItemCubeField<String>("HouseBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @return Cost Element
     */
    @SerializedName( "CostElement" )
    @JsonProperty( "CostElement" )
    @Nullable
    @ODataField( odataName = "CostElement" )
    private String costElement;
    /**
     * Use with available fluent helpers to apply the <b>CostElement</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COST_ELEMENT =
        new OperationalAcctgDocItemCubeField<String>("CostElement");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Unique Reference to Mandate for each Payee
     */
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SEPA_MANDATE =
        new OperationalAcctgDocItemCubeField<String>("SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Document Type
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REFERENCE_DOCUMENT_TYPE =
        new OperationalAcctgDocItemCubeField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     *
     * @return Original Reference Document
     */
    @SerializedName( "OriginalReferenceDocument" )
    @JsonProperty( "OriginalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "OriginalReferenceDocument" )
    private String originalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>OriginalReferenceDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ORIGINAL_REFERENCE_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("OriginalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @return Logical System of Reference Document
     */
    @SerializedName( "ReferenceDocumentLogicalSystem" )
    @JsonProperty( "ReferenceDocumentLogicalSystem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentLogicalSystem" )
    private String referenceDocumentLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentLogicalSystem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REFERENCE_DOCUMENT_LOGICAL_SYSTEM =
        new OperationalAcctgDocItemCubeField<String>("ReferenceDocumentLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItemRef</b>
     * </p>
     *
     * @return Journal Entry Line Item Reference
     */
    @SerializedName( "AccountingDocumentItemRef" )
    @JsonProperty( "AccountingDocumentItemRef" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentItemRef" )
    private String accountingDocumentItemRef;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentItemRef</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_ITEM_REF =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentItemRef");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FISCAL_PERIOD =
        new OperationalAcctgDocItemCubeField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @return Journal Entry Category
     */
    @SerializedName( "AccountingDocumentCategory" )
    @JsonProperty( "AccountingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentCategory" )
    private String accountingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCategory</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_CATEGORY =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategoryName</b>
     * </p>
     *
     * @return Journal Entry Category Name
     */
    @SerializedName( "AccountingDocumentCategoryName" )
    @JsonProperty( "AccountingDocumentCategoryName" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentCategoryName" )
    private String accountingDocumentCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCategoryName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_CATEGORY_NAME =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentCategoryName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> POSTING_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Journal Entry Date
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> DOCUMENT_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @return Journal Entry Type
     */
    @SerializedName( "AccountingDocumentType" )
    @JsonProperty( "AccountingDocumentType" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentType" )
    private String accountingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_TYPE =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @return Document Type Name
     */
    @SerializedName( "AccountingDocumentTypeName" )
    @JsonProperty( "AccountingDocumentTypeName" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentTypeName" )
    private String accountingDocumentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentTypeName</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_TYPE_NAME =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentTypeName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetDueDate</b>
     * </p>
     *
     * @return Due Date for Net Payment
     */
    @SerializedName( "NetDueDate" )
    @JsonProperty( "NetDueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "NetDueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime netDueDate;
    /**
     * Use with available fluent helpers to apply the <b>NetDueDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> NET_DUE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("NetDueDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1DueDate</b>
     * </p>
     *
     * @return Due Date for Cash Discount 1
     */
    @SerializedName( "CashDiscount1DueDate" )
    @JsonProperty( "CashDiscount1DueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CashDiscount1DueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime cashDiscount1DueDate;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1DueDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> CASH_DISCOUNT1_DUE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("CashDiscount1DueDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2DueDate</b>
     * </p>
     *
     * @return Cash Discount 2 Due Date
     */
    @SerializedName( "CashDiscount2DueDate" )
    @JsonProperty( "CashDiscount2DueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CashDiscount2DueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime cashDiscount2DueDate;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2DueDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> CASH_DISCOUNT2_DUE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("CashDiscount2DueDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @return Offsetting Account
     */
    @SerializedName( "OffsettingAccount" )
    @JsonProperty( "OffsettingAccount" )
    @Nullable
    @ODataField( odataName = "OffsettingAccount" )
    private String offsettingAccount;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> OFFSETTING_ACCOUNT =
        new OperationalAcctgDocItemCubeField<String>("OffsettingAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @return Offsetting Account Type
     */
    @SerializedName( "OffsettingAccountType" )
    @JsonProperty( "OffsettingAccountType" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountType" )
    private String offsettingAccountType;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> OFFSETTING_ACCOUNT_TYPE =
        new OperationalAcctgDocItemCubeField<String>("OffsettingAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @return Partner Fund
     */
    @SerializedName( "PartnerFund" )
    @JsonProperty( "PartnerFund" )
    @Nullable
    @ODataField( odataName = "PartnerFund" )
    private String partnerFund;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFund</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_FUND =
        new OperationalAcctgDocItemCubeField<String>("PartnerFund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @return Partner Grant
     */
    @SerializedName( "PartnerGrant" )
    @JsonProperty( "PartnerGrant" )
    @Nullable
    @ODataField( odataName = "PartnerGrant" )
    private String partnerGrant;
    /**
     * Use with available fluent helpers to apply the <b>PartnerGrant</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_GRANT =
        new OperationalAcctgDocItemCubeField<String>("PartnerGrant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BUDGET_PERIOD =
        new OperationalAcctgDocItemCubeField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @return FM: Partner Budget Period
     */
    @SerializedName( "PartnerBudgetPeriod" )
    @JsonProperty( "PartnerBudgetPeriod" )
    @Nullable
    @ODataField( odataName = "PartnerBudgetPeriod" )
    private String partnerBudgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBudgetPeriod</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PARTNER_BUDGET_PERIOD =
        new OperationalAcctgDocItemCubeField<String>("PartnerBudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BranchCode</b>
     * </p>
     *
     * @return Branch Code
     */
    @SerializedName( "BranchCode" )
    @JsonProperty( "BranchCode" )
    @Nullable
    @ODataField( odataName = "BranchCode" )
    private String branchCode;
    /**
     * Use with available fluent helpers to apply the <b>BranchCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BRANCH_CODE =
        new OperationalAcctgDocItemCubeField<String>("BranchCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> COMPANY_CODE_CURRENCY =
        new OperationalAcctgDocItemCubeField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "AmountInCompanyCodeCurrency" )
    @JsonProperty( "AmountInCompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInCompanyCodeCurrency" )
    private BigDecimal amountInCompanyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInCompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> AMOUNT_IN_COMPANY_CODE_CURRENCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("AmountInCompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Signed Tax Amount in Company Code Currency
     */
    @SerializedName( "TaxAmountInCoCodeCrcy" )
    @JsonProperty( "TaxAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "TaxAmountInCoCodeCrcy" )
    private BigDecimal taxAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> TAX_AMOUNT_IN_CO_CODE_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("TaxAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Tax Base Amount in Company Code Currency
     */
    @SerializedName( "TaxBaseAmountInCoCodeCrcy" )
    @JsonProperty( "TaxBaseAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "TaxBaseAmountInCoCodeCrcy" )
    private BigDecimal taxBaseAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxBaseAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> TAX_BASE_AMOUNT_IN_CO_CODE_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("TaxBaseAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationDiffAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Valuation Difference Amount In Company Code Currency
     */
    @SerializedName( "ValuationDiffAmtInCoCodeCrcy" )
    @JsonProperty( "ValuationDiffAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "ValuationDiffAmtInCoCodeCrcy" )
    private BigDecimal valuationDiffAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>ValuationDiffAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> VALUATION_DIFF_AMT_IN_CO_CODE_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("ValuationDiffAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Cash Discount Amount in Company Code Currency
     */
    @SerializedName( "CashDiscountAmtInCoCodeCrcy" )
    @JsonProperty( "CashDiscountAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "CashDiscountAmtInCoCodeCrcy" )
    private BigDecimal cashDiscountAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CASH_DISCOUNT_AMT_IN_CO_CODE_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("CashDiscountAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Invoice Amount in Company Code Currency
     */
    @SerializedName( "InvoiceAmtInCoCodeCrcy" )
    @JsonProperty( "InvoiceAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "InvoiceAmtInCoCodeCrcy" )
    private BigDecimal invoiceAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> INVOICE_AMT_IN_CO_CODE_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("InvoiceAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TRANSACTION_CURRENCY =
        new OperationalAcctgDocItemCubeField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Amount in Transaction Currency
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OriginalTaxBaseAmount</b>
     * </p>
     *
     * @return Original Tax Base Amount in Transaction Currency
     */
    @SerializedName( "OriginalTaxBaseAmount" )
    @JsonProperty( "OriginalTaxBaseAmount" )
    @Nullable
    @ODataField( odataName = "OriginalTaxBaseAmount" )
    private BigDecimal originalTaxBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>OriginalTaxBaseAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> ORIGINAL_TAX_BASE_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("OriginalTaxBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Transaction Currency
     */
    @SerializedName( "TaxAmount" )
    @JsonProperty( "TaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxAmount" )
    private BigDecimal taxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> TAX_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("TaxAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountInTransCrcy</b>
     * </p>
     *
     * @return Tax Base Amount in Transaction Currency
     */
    @SerializedName( "TaxBaseAmountInTransCrcy" )
    @JsonProperty( "TaxBaseAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "TaxBaseAmountInTransCrcy" )
    private BigDecimal taxBaseAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxBaseAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> TAX_BASE_AMOUNT_IN_TRANS_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("TaxBaseAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxBaseAmount</b>
     * </p>
     *
     * @return Withholding Tax Base Amount
     */
    @SerializedName( "WithholdingTaxBaseAmount" )
    @JsonProperty( "WithholdingTaxBaseAmount" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxBaseAmount" )
    private BigDecimal withholdingTaxBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxBaseAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> WITHHOLDING_TAX_BASE_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("WithholdingTaxBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedAmtInTransactionCrcy</b>
     * </p>
     *
     * @return Planned Amount in Transaction Currency
     */
    @SerializedName( "PlannedAmtInTransactionCrcy" )
    @JsonProperty( "PlannedAmtInTransactionCrcy" )
    @Nullable
    @ODataField( odataName = "PlannedAmtInTransactionCrcy" )
    private BigDecimal plannedAmtInTransactionCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PlannedAmtInTransactionCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> PLANNED_AMT_IN_TRANSACTION_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("PlannedAmtInTransactionCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountBaseAmount</b>
     * </p>
     *
     * @return Cash Discount Base Amount
     */
    @SerializedName( "CashDiscountBaseAmount" )
    @JsonProperty( "CashDiscountBaseAmount" )
    @Nullable
    @ODataField( odataName = "CashDiscountBaseAmount" )
    private BigDecimal cashDiscountBaseAmount;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountBaseAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CASH_DISCOUNT_BASE_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("CashDiscountBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmount</b>
     * </p>
     *
     * @return Cash Discount Amount
     */
    @SerializedName( "CashDiscountAmount" )
    @JsonProperty( "CashDiscountAmount" )
    @Nullable
    @ODataField( odataName = "CashDiscountAmount" )
    private BigDecimal cashDiscountAmount;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> CASH_DISCOUNT_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("CashDiscountAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentAmount</b>
     * </p>
     *
     * @return Net Payment Amount
     */
    @SerializedName( "NetPaymentAmount" )
    @JsonProperty( "NetPaymentAmount" )
    @Nullable
    @ODataField( odataName = "NetPaymentAmount" )
    private BigDecimal netPaymentAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> NET_PAYMENT_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("NetPaymentAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxAmount</b>
     * </p>
     *
     * @return Withholding Tax Amount
     */
    @SerializedName( "WithholdingTaxAmount" )
    @JsonProperty( "WithholdingTaxAmount" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxAmount" )
    private BigDecimal withholdingTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> WITHHOLDING_TAX_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("WithholdingTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxExemptionAmt</b>
     * </p>
     *
     * @return Withholding Tax-Exemption Amount
     */
    @SerializedName( "WithholdingTaxExemptionAmt" )
    @JsonProperty( "WithholdingTaxExemptionAmt" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxExemptionAmt" )
    private BigDecimal withholdingTaxExemptionAmt;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxExemptionAmt</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> WITHHOLDING_TAX_EXEMPTION_AMT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("WithholdingTaxExemptionAmt");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceAmountInFrgnCurrency</b>
     * </p>
     *
     * @return Invoice Amount in Foreign Currency
     */
    @SerializedName( "InvoiceAmountInFrgnCurrency" )
    @JsonProperty( "InvoiceAmountInFrgnCurrency" )
    @Nullable
    @ODataField( odataName = "InvoiceAmountInFrgnCurrency" )
    private BigDecimal invoiceAmountInFrgnCurrency;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceAmountInFrgnCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> INVOICE_AMOUNT_IN_FRGN_CURRENCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("InvoiceAmountInFrgnCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @return Balance Transaction Currency
     */
    @SerializedName( "BalanceTransactionCurrency" )
    @JsonProperty( "BalanceTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "BalanceTransactionCurrency" )
    private String balanceTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>BalanceTransactionCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BALANCE_TRANSACTION_CURRENCY =
        new OperationalAcctgDocItemCubeField<String>("BalanceTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInBalanceTransacCrcy</b>
     * </p>
     *
     * @return Amount in Balance Transaction Currency
     */
    @SerializedName( "AmountInBalanceTransacCrcy" )
    @JsonProperty( "AmountInBalanceTransacCrcy" )
    @Nullable
    @ODataField( odataName = "AmountInBalanceTransacCrcy" )
    private BigDecimal amountInBalanceTransacCrcy;
    /**
     * Use with available fluent helpers to apply the <b>AmountInBalanceTransacCrcy</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> AMOUNT_IN_BALANCE_TRANSAC_CRCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("AmountInBalanceTransacCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency1</b>
     * </p>
     *
     * @return Additional Currency 1
     */
    @SerializedName( "AdditionalCurrency1" )
    @JsonProperty( "AdditionalCurrency1" )
    @Nullable
    @ODataField( odataName = "AdditionalCurrency1" )
    private String additionalCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCurrency1</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ADDITIONAL_CURRENCY1 =
        new OperationalAcctgDocItemCubeField<String>("AdditionalCurrency1");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationDiffAmtInAddlCrcy1</b>
     * </p>
     *
     * @return Valuation Difference Amount in Additional Currency 1
     */
    @SerializedName( "ValuationDiffAmtInAddlCrcy1" )
    @JsonProperty( "ValuationDiffAmtInAddlCrcy1" )
    @Nullable
    @ODataField( odataName = "ValuationDiffAmtInAddlCrcy1" )
    private BigDecimal valuationDiffAmtInAddlCrcy1;
    /**
     * Use with available fluent helpers to apply the <b>ValuationDiffAmtInAddlCrcy1</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> VALUATION_DIFF_AMT_IN_ADDL_CRCY1 =
        new OperationalAcctgDocItemCubeField<BigDecimal>("ValuationDiffAmtInAddlCrcy1");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInAdditionalCurrency1</b>
     * </p>
     *
     * @return Amount in Additional Currency 1
     */
    @SerializedName( "AmountInAdditionalCurrency1" )
    @JsonProperty( "AmountInAdditionalCurrency1" )
    @Nullable
    @ODataField( odataName = "AmountInAdditionalCurrency1" )
    private BigDecimal amountInAdditionalCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>AmountInAdditionalCurrency1</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> AMOUNT_IN_ADDITIONAL_CURRENCY1 =
        new OperationalAcctgDocItemCubeField<BigDecimal>("AmountInAdditionalCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency2</b>
     * </p>
     *
     * @return Additional Currency 2
     */
    @SerializedName( "AdditionalCurrency2" )
    @JsonProperty( "AdditionalCurrency2" )
    @Nullable
    @ODataField( odataName = "AdditionalCurrency2" )
    private String additionalCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCurrency2</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ADDITIONAL_CURRENCY2 =
        new OperationalAcctgDocItemCubeField<String>("AdditionalCurrency2");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInAdditionalCurrency2</b>
     * </p>
     *
     * @return Amount in Additional Currency 2
     */
    @SerializedName( "AmountInAdditionalCurrency2" )
    @JsonProperty( "AmountInAdditionalCurrency2" )
    @Nullable
    @ODataField( odataName = "AmountInAdditionalCurrency2" )
    private BigDecimal amountInAdditionalCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>AmountInAdditionalCurrency2</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> AMOUNT_IN_ADDITIONAL_CURRENCY2 =
        new OperationalAcctgDocItemCubeField<BigDecimal>("AmountInAdditionalCurrency2");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationDiffAmtInAddlCrcy2</b>
     * </p>
     *
     * @return Valuation Difference Amount in Additional Currency 2
     */
    @SerializedName( "ValuationDiffAmtInAddlCrcy2" )
    @JsonProperty( "ValuationDiffAmtInAddlCrcy2" )
    @Nullable
    @ODataField( odataName = "ValuationDiffAmtInAddlCrcy2" )
    private BigDecimal valuationDiffAmtInAddlCrcy2;
    /**
     * Use with available fluent helpers to apply the <b>ValuationDiffAmtInAddlCrcy2</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> VALUATION_DIFF_AMT_IN_ADDL_CRCY2 =
        new OperationalAcctgDocItemCubeField<BigDecimal>("ValuationDiffAmtInAddlCrcy2");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     *
     * @return Currency for Automatic Payment
     */
    @SerializedName( "PaymentCurrency" )
    @JsonProperty( "PaymentCurrency" )
    @Nullable
    @ODataField( odataName = "PaymentCurrency" )
    private String paymentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PaymentCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PAYMENT_CURRENCY =
        new OperationalAcctgDocItemCubeField<String>("PaymentCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInPaymentCurrency</b>
     * </p>
     *
     * @return Amount in Payment Currency
     */
    @SerializedName( "AmountInPaymentCurrency" )
    @JsonProperty( "AmountInPaymentCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInPaymentCurrency" )
    private BigDecimal amountInPaymentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInPaymentCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> AMOUNT_IN_PAYMENT_CURRENCY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("AmountInPaymentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlAreaCurrency</b>
     * </p>
     *
     * @return Credit Control Area Currency
     */
    @SerializedName( "CreditControlAreaCurrency" )
    @JsonProperty( "CreditControlAreaCurrency" )
    @Nullable
    @ODataField( odataName = "CreditControlAreaCurrency" )
    private String creditControlAreaCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CreditControlAreaCurrency</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> CREDIT_CONTROL_AREA_CURRENCY =
        new OperationalAcctgDocItemCubeField<String>("CreditControlAreaCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HedgedAmount</b>
     * </p>
     *
     * @return Credit Management: Hedged Amount
     */
    @SerializedName( "HedgedAmount" )
    @JsonProperty( "HedgedAmount" )
    @Nullable
    @ODataField( odataName = "HedgedAmount" )
    private BigDecimal hedgedAmount;
    /**
     * Use with available fluent helpers to apply the <b>HedgedAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> HEDGED_AMOUNT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("HedgedAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BASE_UNIT =
        new OperationalAcctgDocItemCubeField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> QUANTITY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementEntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "GoodsMovementEntryUnit" )
    @JsonProperty( "GoodsMovementEntryUnit" )
    @Nullable
    @ODataField( odataName = "GoodsMovementEntryUnit" )
    private String goodsMovementEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementEntryUnit</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> GOODS_MOVEMENT_ENTRY_UNIT =
        new OperationalAcctgDocItemCubeField<String>("GoodsMovementEntryUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @return Quantity in Entry Unit of Measure
     */
    @SerializedName( "QuantityInEntryUnit" )
    @JsonProperty( "QuantityInEntryUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInEntryUnit" )
    private BigDecimal quantityInEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInEntryUnit</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> QUANTITY_IN_ENTRY_UNIT =
        new OperationalAcctgDocItemCubeField<BigDecimal>("QuantityInEntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentPriceUnit</b>
     * </p>
     *
     * @return Purchasing Document Price Unit
     */
    @SerializedName( "PurchasingDocumentPriceUnit" )
    @JsonProperty( "PurchasingDocumentPriceUnit" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentPriceUnit" )
    private String purchasingDocumentPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentPriceUnit</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> PURCHASING_DOCUMENT_PRICE_UNIT =
        new OperationalAcctgDocItemCubeField<String>("PurchasingDocumentPriceUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQty</b>
     * </p>
     *
     * @return Purchase Order Quantity
     */
    @SerializedName( "PurchaseOrderQty" )
    @JsonProperty( "PurchaseOrderQty" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQty" )
    private BigDecimal purchaseOrderQty;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQty</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> PURCHASE_ORDER_QTY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("PurchaseOrderQty");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @return Material Price Unit Quantity
     */
    @SerializedName( "MaterialPriceUnitQty" )
    @JsonProperty( "MaterialPriceUnitQty" )
    @Nullable
    @ODataField( odataName = "MaterialPriceUnitQty" )
    private BigDecimal materialPriceUnitQty;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPriceUnitQty</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> MATERIAL_PRICE_UNIT_QTY =
        new OperationalAcctgDocItemCubeField<BigDecimal>("MaterialPriceUnitQty");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfItems</b>
     * </p>
     *
     * @return Number of Items
     */
    @SerializedName( "NumberOfItems" )
    @JsonProperty( "NumberOfItems" )
    @Nullable
    @ODataField( odataName = "NumberOfItems" )
    private BigDecimal numberOfItems;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfItems</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> NUMBER_OF_ITEMS =
        new OperationalAcctgDocItemCubeField<BigDecimal>("NumberOfItems");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCreationDate</b>
     * </p>
     *
     * @return Accounting Document Entry Date
     */
    @SerializedName( "AccountingDocumentCreationDate" )
    @JsonProperty( "AccountingDocumentCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AccountingDocumentCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime accountingDocumentCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCreationDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> ACCOUNTING_DOCUMENT_CREATION_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("AccountingDocumentCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Creation Time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalTime> CREATION_TIME =
        new OperationalAcctgDocItemCubeField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Change Date
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> LAST_CHANGE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @return Exchange Rate Date
     */
    @SerializedName( "ExchangeRateDate" )
    @JsonProperty( "ExchangeRateDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ExchangeRateDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime exchangeRateDate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> EXCHANGE_RATE_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("ExchangeRateDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @return User that created the journal entry
     */
    @SerializedName( "AccountingDocCreatedByUser" )
    @JsonProperty( "AccountingDocCreatedByUser" )
    @Nullable
    @ODataField( odataName = "AccountingDocCreatedByUser" )
    private String accountingDocCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocCreatedByUser</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOC_CREATED_BY_USER =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCode</b>
     * </p>
     *
     * @return Transaction Code
     */
    @SerializedName( "TransactionCode" )
    @JsonProperty( "TransactionCode" )
    @Nullable
    @ODataField( odataName = "TransactionCode" )
    private String transactionCode;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> TRANSACTION_CODE =
        new OperationalAcctgDocItemCubeField<String>("TransactionCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyTransaction</b>
     * </p>
     *
     * @return Intercompany Transaction Number
     */
    @SerializedName( "IntercompanyTransaction" )
    @JsonProperty( "IntercompanyTransaction" )
    @Nullable
    @ODataField( odataName = "IntercompanyTransaction" )
    private String intercompanyTransaction;
    /**
     * Use with available fluent helpers to apply the <b>IntercompanyTransaction</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> INTERCOMPANY_TRANSACTION =
        new OperationalAcctgDocItemCubeField<String>("IntercompanyTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @return Document Reference ID
     */
    @SerializedName( "DocumentReferenceID" )
    @JsonProperty( "DocumentReferenceID" )
    @Nullable
    @ODataField( odataName = "DocumentReferenceID" )
    private String documentReferenceID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReferenceID</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> DOCUMENT_REFERENCE_ID =
        new OperationalAcctgDocItemCubeField<String>("DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecurringAccountingDocument</b>
     * </p>
     *
     * @return Recurring Journal Entry
     */
    @SerializedName( "RecurringAccountingDocument" )
    @JsonProperty( "RecurringAccountingDocument" )
    @Nullable
    @ODataField( odataName = "RecurringAccountingDocument" )
    private String recurringAccountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>RecurringAccountingDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> RECURRING_ACCOUNTING_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("RecurringAccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @return Reverse Document
     */
    @SerializedName( "ReverseDocument" )
    @JsonProperty( "ReverseDocument" )
    @Nullable
    @ODataField( odataName = "ReverseDocument" )
    private String reverseDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REVERSE_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("ReverseDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @return Reverse Document Fiscal Year
     */
    @SerializedName( "ReverseDocumentFiscalYear" )
    @JsonProperty( "ReverseDocumentFiscalYear" )
    @Nullable
    @ODataField( odataName = "ReverseDocumentFiscalYear" )
    private String reverseDocumentFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ReverseDocumentFiscalYear</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REVERSE_DOCUMENT_FISCAL_YEAR =
        new OperationalAcctgDocItemCubeField<String>("ReverseDocumentFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentHeaderText</b>
     * </p>
     *
     * @return Document Header Text
     */
    @SerializedName( "AccountingDocumentHeaderText" )
    @JsonProperty( "AccountingDocumentHeaderText" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentHeaderText" )
    private String accountingDocumentHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentHeaderText</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_HEADER_TEXT =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentHeaderText");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @return Exchange Rate
     */
    @SerializedName( "ExchangeRate" )
    @JsonProperty( "ExchangeRate" )
    @Nullable
    @ODataField( odataName = "ExchangeRate" )
    private BigDecimal exchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> EXCHANGE_RATE =
        new OperationalAcctgDocItemCubeField<BigDecimal>("ExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @return Business Transaction Category
     */
    @SerializedName( "BusinessTransactionType" )
    @JsonProperty( "BusinessTransactionType" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionType" )
    private String businessTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BUSINESS_TRANSACTION_TYPE =
        new OperationalAcctgDocItemCubeField<String>("BusinessTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BatchInputSession</b>
     * </p>
     *
     * @return Batch Input Session
     */
    @SerializedName( "BatchInputSession" )
    @JsonProperty( "BatchInputSession" )
    @Nullable
    @ODataField( odataName = "BatchInputSession" )
    private String batchInputSession;
    /**
     * Use with available fluent helpers to apply the <b>BatchInputSession</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BATCH_INPUT_SESSION =
        new OperationalAcctgDocItemCubeField<String>("BatchInputSession");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> FINANCIAL_MANAGEMENT_AREA =
        new OperationalAcctgDocItemCubeField<String>("FinancialManagementArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReversalIsPlanned</b>
     * </p>
     *
     * @return Indicator: Reversal Is Planned for Document
     */
    @SerializedName( "ReversalIsPlanned" )
    @JsonProperty( "ReversalIsPlanned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReversalIsPlanned" )
    private Boolean reversalIsPlanned;
    /**
     * Use with available fluent helpers to apply the <b>ReversalIsPlanned</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> REVERSAL_IS_PLANNED =
        new OperationalAcctgDocItemCubeField<Boolean>("ReversalIsPlanned");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedReversalDate</b>
     * </p>
     *
     * @return Planned Date for the Reversal Posting
     */
    @SerializedName( "PlannedReversalDate" )
    @JsonProperty( "PlannedReversalDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedReversalDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedReversalDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedReversalDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> PLANNED_REVERSAL_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("PlannedReversalDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxIsCalculatedAutomatically</b>
     * </p>
     *
     * @return Tax Is Automatically Calculated
     */
    @SerializedName( "TaxIsCalculatedAutomatically" )
    @JsonProperty( "TaxIsCalculatedAutomatically" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TaxIsCalculatedAutomatically" )
    private Boolean taxIsCalculatedAutomatically;
    /**
     * Use with available fluent helpers to apply the <b>TaxIsCalculatedAutomatically</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> TAX_IS_CALCULATED_AUTOMATICALLY =
        new OperationalAcctgDocItemCubeField<Boolean>("TaxIsCalculatedAutomatically");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountIsNetAmount</b>
     * </p>
     *
     * @return Tax Base Amount is Net Amount
     */
    @SerializedName( "TaxBaseAmountIsNetAmount" )
    @JsonProperty( "TaxBaseAmountIsNetAmount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TaxBaseAmountIsNetAmount" )
    private Boolean taxBaseAmountIsNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxBaseAmountIsNetAmount</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> TAX_BASE_AMOUNT_IS_NET_AMOUNT =
        new OperationalAcctgDocItemCubeField<Boolean>("TaxBaseAmountIsNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceCompanyCode</b>
     * </p>
     *
     * @return Source Company Code
     */
    @SerializedName( "SourceCompanyCode" )
    @JsonProperty( "SourceCompanyCode" )
    @Nullable
    @ODataField( odataName = "SourceCompanyCode" )
    private String sourceCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>SourceCompanyCode</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SOURCE_COMPANY_CODE =
        new OperationalAcctgDocItemCubeField<String>("SourceCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> LOGICAL_SYSTEM =
        new OperationalAcctgDocItemCubeField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>TaxExchangeRate</b>
     * </p>
     *
     * @return Tax Exchange Rate
     */
    @SerializedName( "TaxExchangeRate" )
    @JsonProperty( "TaxExchangeRate" )
    @Nullable
    @ODataField( odataName = "TaxExchangeRate" )
    private BigDecimal taxExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>TaxExchangeRate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<BigDecimal> TAX_EXCHANGE_RATE =
        new OperationalAcctgDocItemCubeField<BigDecimal>("TaxExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReason</b>
     * </p>
     *
     * @return Reason for Reversal or Inverse Posting
     */
    @SerializedName( "ReversalReason" )
    @JsonProperty( "ReversalReason" )
    @Nullable
    @ODataField( odataName = "ReversalReason" )
    private String reversalReason;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReason</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REVERSAL_REASON =
        new OperationalAcctgDocItemCubeField<String>("ReversalReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @return Branch
     */
    @SerializedName( "Branch" )
    @JsonProperty( "Branch" )
    @Nullable
    @ODataField( odataName = "Branch" )
    private String branch;
    /**
     * Use with available fluent helpers to apply the <b>Branch</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> BRANCH =
        new OperationalAcctgDocItemCubeField<String>("Branch");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference1InDocumentHeader</b>
     * </p>
     *
     * @return Internal ID of Reference Key 1 in Document Header
     */
    @SerializedName( "Reference1InDocumentHeader" )
    @JsonProperty( "Reference1InDocumentHeader" )
    @Nullable
    @ODataField( odataName = "Reference1InDocumentHeader" )
    private String reference1InDocumentHeader;
    /**
     * Use with available fluent helpers to apply the <b>Reference1InDocumentHeader</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REFERENCE1_IN_DOCUMENT_HEADER =
        new OperationalAcctgDocItemCubeField<String>("Reference1InDocumentHeader");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference2InDocumentHeader</b>
     * </p>
     *
     * @return Internal ID of Reference Key 2 in Document Header
     */
    @SerializedName( "Reference2InDocumentHeader" )
    @JsonProperty( "Reference2InDocumentHeader" )
    @Nullable
    @ODataField( odataName = "Reference2InDocumentHeader" )
    private String reference2InDocumentHeader;
    /**
     * Use with available fluent helpers to apply the <b>Reference2InDocumentHeader</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> REFERENCE2_IN_DOCUMENT_HEADER =
        new OperationalAcctgDocItemCubeField<String>("Reference2InDocumentHeader");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReceiptDate</b>
     * </p>
     *
     * @return Invoice Receipt Date
     */
    @SerializedName( "InvoiceReceiptDate" )
    @JsonProperty( "InvoiceReceiptDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InvoiceReceiptDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime invoiceReceiptDate;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceReceiptDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> INVOICE_RECEIPT_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("InvoiceReceiptDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> LEDGER =
        new OperationalAcctgDocItemCubeField<String>("Ledger");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGroup</b>
     * </p>
     *
     * @return Ledger Group
     */
    @SerializedName( "LedgerGroup" )
    @JsonProperty( "LedgerGroup" )
    @Nullable
    @ODataField( odataName = "LedgerGroup" )
    private String ledgerGroup;
    /**
     * Use with available fluent helpers to apply the <b>LedgerGroup</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> LEDGER_GROUP =
        new OperationalAcctgDocItemCubeField<String>("LedgerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeReferenceDocument</b>
     * </p>
     *
     * @return Alternative Reference Document
     */
    @SerializedName( "AlternativeReferenceDocument" )
    @JsonProperty( "AlternativeReferenceDocument" )
    @Nullable
    @ODataField( odataName = "AlternativeReferenceDocument" )
    private String alternativeReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeReferenceDocument</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ALTERNATIVE_REFERENCE_DOCUMENT =
        new OperationalAcctgDocItemCubeField<String>("AlternativeReferenceDocument");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxReportingDate</b>
     * </p>
     *
     * @return Tax Reporting Date
     */
    @SerializedName( "TaxReportingDate" )
    @JsonProperty( "TaxReportingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxReportingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxReportingDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxReportingDate</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<LocalDateTime> TAX_REPORTING_DATE =
        new OperationalAcctgDocItemCubeField<LocalDateTime>("TaxReportingDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentClass</b>
     * </p>
     *
     * @return Accounting Document Class
     */
    @SerializedName( "AccountingDocumentClass" )
    @JsonProperty( "AccountingDocumentClass" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentClass" )
    private String accountingDocumentClass;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentClass</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> ACCOUNTING_DOCUMENT_CLASS =
        new OperationalAcctgDocItemCubeField<String>("AccountingDocumentClass");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateType</b>
     * </p>
     *
     * @return Exchange Rate Type
     */
    @SerializedName( "ExchangeRateType" )
    @JsonProperty( "ExchangeRateType" )
    @Nullable
    @ODataField( odataName = "ExchangeRateType" )
    private String exchangeRateType;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateType</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> EXCHANGE_RATE_TYPE =
        new OperationalAcctgDocItemCubeField<String>("ExchangeRateType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LatePaymentReason</b>
     * </p>
     *
     * @return Late Payment Reason
     */
    @SerializedName( "LatePaymentReason" )
    @JsonProperty( "LatePaymentReason" )
    @Nullable
    @ODataField( odataName = "LatePaymentReason" )
    private String latePaymentReason;
    /**
     * Use with available fluent helpers to apply the <b>LatePaymentReason</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> LATE_PAYMENT_REASON =
        new OperationalAcctgDocItemCubeField<String>("LatePaymentReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCondition</b>
     * </p>
     *
     * @return Sales Document Condition
     */
    @SerializedName( "SalesDocumentCondition" )
    @JsonProperty( "SalesDocumentCondition" )
    @Nullable
    @ODataField( odataName = "SalesDocumentCondition" )
    private String salesDocumentCondition;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentCondition</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<String> SALES_DOCUMENT_CONDITION =
        new OperationalAcctgDocItemCubeField<String>("SalesDocumentCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @return Indicator: Item is Reversing Another Item
     */
    @SerializedName( "IsReversal" )
    @JsonProperty( "IsReversal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversal" )
    private Boolean isReversal;
    /**
     * Use with available fluent helpers to apply the <b>IsReversal</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_REVERSAL =
        new OperationalAcctgDocItemCubeField<Boolean>("IsReversal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @return Indicator: Item is Reversed
     */
    @SerializedName( "IsReversed" )
    @JsonProperty( "IsReversed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversed" )
    private Boolean isReversed;
    /**
     * Use with available fluent helpers to apply the <b>IsReversed</b> field to query operations.
     *
     */
    public final static OperationalAcctgDocItemCubeField<Boolean> IS_REVERSED =
        new OperationalAcctgDocItemCubeField<Boolean>("IsReversed");

    @Nonnull
    @Override
    public Class<OperationalAcctgDocItemCube> getType()
    {
        return OperationalAcctgDocItemCube.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Journal Entry
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @param accountingDocumentItem
     *            Journal Entry Posting View Item
     */
    public void setAccountingDocumentItem( @Nullable final String accountingDocumentItem )
    {
        rememberChangedField("AccountingDocumentItem", this.accountingDocumentItem);
        this.accountingDocumentItem = accountingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Code Name
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItemType</b>
     * </p>
     *
     * @param accountingDocumentItemType
     *            Identification of the Line Item
     */
    public void setAccountingDocumentItemType( @Nullable final String accountingDocumentItemType )
    {
        rememberChangedField("AccountingDocumentItemType", this.accountingDocumentItemType);
        this.accountingDocumentItemType = accountingDocumentItemType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @param clearingDate
     *            Clearing Date
     */
    public void setClearingDate( @Nullable final LocalDateTime clearingDate )
    {
        rememberChangedField("ClearingDate", this.clearingDate);
        this.clearingDate = clearingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingCreationDate</b>
     * </p>
     *
     * @param clearingCreationDate
     *            Clearing Creation Date
     */
    public void setClearingCreationDate( @Nullable final LocalDateTime clearingCreationDate )
    {
        rememberChangedField("ClearingCreationDate", this.clearingCreationDate);
        this.clearingCreationDate = clearingCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @param clearingAccountingDocument
     *            Clearing Journal Entry
     */
    public void setClearingAccountingDocument( @Nullable final String clearingAccountingDocument )
    {
        rememberChangedField("ClearingAccountingDocument", this.clearingAccountingDocument);
        this.clearingAccountingDocument = clearingAccountingDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCleared</b>
     * </p>
     *
     * @param isCleared
     *            Clearing Status: Is Cleared
     */
    public void setIsCleared( @Nullable final Boolean isCleared )
    {
        rememberChangedField("IsCleared", this.isCleared);
        this.isCleared = isCleared;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @param postingKey
     *            Posting Key
     */
    public void setPostingKey( @Nullable final String postingKey )
    {
        rememberChangedField("PostingKey", this.postingKey);
        this.postingKey = postingKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @param financialAccountType
     *            Account Type
     */
    public void setFinancialAccountType( @Nullable final String financialAccountType )
    {
        rememberChangedField("FinancialAccountType", this.financialAccountType);
        this.financialAccountType = financialAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @param specialGLCode
     *            Special G/L Indicator
     */
    public void setSpecialGLCode( @Nullable final String specialGLCode )
    {
        rememberChangedField("SpecialGLCode", this.specialGLCode);
        this.specialGLCode = specialGLCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLTransactionType</b>
     * </p>
     *
     * @param specialGLTransactionType
     *            Special G/L Transaction Type
     */
    public void setSpecialGLTransactionType( @Nullable final String specialGLTransactionType )
    {
        rememberChangedField("SpecialGLTransactionType", this.specialGLTransactionType);
        this.specialGLTransactionType = specialGLTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Code
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @param businessAreaName
     *            Business Area Name
     */
    public void setBusinessAreaName( @Nullable final String businessAreaName )
    {
        rememberChangedField("BusinessAreaName", this.businessAreaName);
        this.businessAreaName = businessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Partner Business Area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @param withholdingTaxCode
     *            Withholding Tax Code
     */
    public void setWithholdingTaxCode( @Nullable final String withholdingTaxCode )
    {
        rememberChangedField("WithholdingTaxCode", this.withholdingTaxCode);
        this.withholdingTaxCode = withholdingTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaxType</b>
     * </p>
     *
     * @param taxType
     *            Tax Type
     */
    public void setTaxType( @Nullable final String taxType )
    {
        rememberChangedField("TaxType", this.taxType);
        this.taxType = taxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @param transactionTypeDetermination
     *            Transaction Key
     */
    public void setTransactionTypeDetermination( @Nullable final String transactionTypeDetermination )
    {
        rememberChangedField("TransactionTypeDetermination", this.transactionTypeDetermination);
        this.transactionTypeDetermination = transactionTypeDetermination;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @param valueDate
     *            Value Date
     */
    public void setValueDate( @Nullable final LocalDateTime valueDate )
    {
        rememberChangedField("ValueDate", this.valueDate);
        this.valueDate = valueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Reference
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Item Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Financial Transaction Type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @param corporateGroupAccount
     *            Corporate Group Account
     */
    public void setCorporateGroupAccount( @Nullable final String corporateGroupAccount )
    {
        rememberChangedField("CorporateGroupAccount", this.corporateGroupAccount);
        this.corporateGroupAccount = corporateGroupAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningLevel</b>
     * </p>
     *
     * @param planningLevel
     *            Planning Level
     */
    public void setPlanningLevel( @Nullable final String planningLevel )
    {
        rememberChangedField("PlanningLevel", this.planningLevel);
        this.planningLevel = planningLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area Name
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @param costCenterName
     *            Cost Center Name
     */
    public void setCostCenterName( @Nullable final String costCenterName )
    {
        rememberChangedField("CostCenterName", this.costCenterName);
        this.costCenterName = costCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @param billingDocument
     *            Billing Document
     */
    public void setBillingDocument( @Nullable final String billingDocument )
    {
        rememberChangedField("BillingDocument", this.billingDocument);
        this.billingDocument = billingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Schedule Line
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Fixed Asset
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @param assetTransactionType
     *            Asset Transaction Type
     */
    public void setAssetTransactionType( @Nullable final String assetTransactionType )
    {
        rememberChangedField("AssetTransactionType", this.assetTransactionType);
        this.assetTransactionType = assetTransactionType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @param assetValueDate
     *            Asset Value Date
     */
    public void setAssetValueDate( @Nullable final LocalDateTime assetValueDate )
    {
        rememberChangedField("AssetValueDate", this.assetValueDate);
        this.assetValueDate = assetValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSalesRelated</b>
     * </p>
     *
     * @param isSalesRelated
     *            Is Sales Related
     */
    public void setIsSalesRelated( @Nullable final Boolean isSalesRelated )
    {
        rememberChangedField("IsSalesRelated", this.isSalesRelated);
        this.isSalesRelated = isSalesRelated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LineItemDisplayIsEnabled</b>
     * </p>
     *
     * @param lineItemDisplayIsEnabled
     *            Indicator: Can Line Items Be Displayed by Account?
     */
    public void setLineItemDisplayIsEnabled( @Nullable final Boolean lineItemDisplayIsEnabled )
    {
        rememberChangedField("LineItemDisplayIsEnabled", this.lineItemDisplayIsEnabled);
        this.lineItemDisplayIsEnabled = lineItemDisplayIsEnabled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @param isOpenItemManaged
     *            Managed on an Open Item Basis
     */
    public void setIsOpenItemManaged( @Nullable final String isOpenItemManaged )
    {
        rememberChangedField("IsOpenItemManaged", this.isOpenItemManaged);
        this.isOpenItemManaged = isOpenItemManaged;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNotCashDiscountLiable</b>
     * </p>
     *
     * @param isNotCashDiscountLiable
     *            Is Not Cash Discount Liable
     */
    public void setIsNotCashDiscountLiable( @Nullable final Boolean isNotCashDiscountLiable )
    {
        rememberChangedField("IsNotCashDiscountLiable", this.isNotCashDiscountLiable);
        this.isNotCashDiscountLiable = isNotCashDiscountLiable;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsAutomaticallyCreated</b>
     * </p>
     *
     * @param isAutomaticallyCreated
     *            Is Automatically Created
     */
    public void setIsAutomaticallyCreated( @Nullable final Boolean isAutomaticallyCreated )
    {
        rememberChangedField("IsAutomaticallyCreated", this.isAutomaticallyCreated);
        this.isAutomaticallyCreated = isAutomaticallyCreated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUsedInPaymentTransaction</b>
     * </p>
     *
     * @param isUsedInPaymentTransaction
     *            Is Used In Payment Transaction
     */
    public void setIsUsedInPaymentTransaction( @Nullable final Boolean isUsedInPaymentTransaction )
    {
        rememberChangedField("IsUsedInPaymentTransaction", this.isUsedInPaymentTransaction);
        this.isUsedInPaymentTransaction = isUsedInPaymentTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OperationalGLAccount</b>
     * </p>
     *
     * @param operationalGLAccount
     *            Operational General Ledger Account
     */
    public void setOperationalGLAccount( @Nullable final String operationalGLAccount )
    {
        rememberChangedField("OperationalGLAccount", this.operationalGLAccount);
        this.operationalGLAccount = operationalGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountName</b>
     * </p>
     *
     * @param gLAccountName
     *            G/L Account Name
     */
    public void setGLAccountName( @Nullable final String gLAccountName )
    {
        rememberChangedField("GLAccountName", this.gLAccountName);
        this.gLAccountName = gLAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountLongName</b>
     * </p>
     *
     * @param gLAccountLongName
     *            G/L Account Long Name
     */
    public void setGLAccountLongName( @Nullable final String gLAccountLongName )
    {
        rememberChangedField("GLAccountLongName", this.gLAccountLongName);
        this.gLAccountLongName = gLAccountLongName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @param customerName
     *            Name of Customer
     */
    public void setCustomerName( @Nullable final String customerName )
    {
        rememberChangedField("CustomerName", this.customerName);
        this.customerName = customerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @param supplierName
     *            Name of Supplier
     */
    public void setSupplierName( @Nullable final String supplierName )
    {
        rememberChangedField("SupplierName", this.supplierName);
        this.supplierName = supplierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BranchAccount</b>
     * </p>
     *
     * @param branchAccount
     *            Branch Account
     */
    public void setBranchAccount( @Nullable final String branchAccount )
    {
        rememberChangedField("BranchAccount", this.branchAccount);
        this.branchAccount = branchAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @param isBalanceSheetAccount
     *            Is Balance Sheet Account
     */
    public void setIsBalanceSheetAccount( @Nullable final Boolean isBalanceSheetAccount )
    {
        rememberChangedField("IsBalanceSheetAccount", this.isBalanceSheetAccount);
        this.isBalanceSheetAccount = isBalanceSheetAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProfitLossAccountType</b>
     * </p>
     *
     * @param profitLossAccountType
     *            Profit Loss Account Type
     */
    public void setProfitLossAccountType( @Nullable final String profitLossAccountType )
    {
        rememberChangedField("ProfitLossAccountType", this.profitLossAccountType);
        this.profitLossAccountType = profitLossAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLAccountAssignment</b>
     * </p>
     *
     * @param specialGLAccountAssignment
     *            Assignment Number for Special G/L Accounts
     */
    public void setSpecialGLAccountAssignment( @Nullable final String specialGLAccountAssignment )
    {
        rememberChangedField("SpecialGLAccountAssignment", this.specialGLAccountAssignment);
        this.specialGLAccountAssignment = specialGLAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueCalculationBaseDate</b>
     * </p>
     *
     * @param dueCalculationBaseDate
     *            Due Calculation Base Date
     */
    public void setDueCalculationBaseDate( @Nullable final LocalDateTime dueCalculationBaseDate )
    {
        rememberChangedField("DueCalculationBaseDate", this.dueCalculationBaseDate);
        this.dueCalculationBaseDate = dueCalculationBaseDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash Discount Days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash Discount Days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     *
     * @param paymentBlockingReason
     *            Payment Blocking Reason
     */
    public void setPaymentBlockingReason( @Nullable final String paymentBlockingReason )
    {
        rememberChangedField("PaymentBlockingReason", this.paymentBlockingReason);
        this.paymentBlockingReason = paymentBlockingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedCashDiscount</b>
     * </p>
     *
     * @param fixedCashDiscount
     *            Fixed Cash Discount
     */
    public void setFixedCashDiscount( @Nullable final String fixedCashDiscount )
    {
        rememberChangedField("FixedCashDiscount", this.fixedCashDiscount);
        this.fixedCashDiscount = fixedCashDiscount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank Key
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPBankAccountInternalID</b>
     * </p>
     *
     * @param bPBankAccountInternalID
     *            Business Partner Bank Account Internal ID
     */
    public void setBPBankAccountInternalID( @Nullable final String bPBankAccountInternalID )
    {
        rememberChangedField("BPBankAccountInternalID", this.bPBankAccountInternalID);
        this.bPBankAccountInternalID = bPBankAccountInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxDistributionCode1</b>
     * </p>
     *
     * @param taxDistributionCode1
     *            Tax Code 1 for Distribution
     */
    public void setTaxDistributionCode1( @Nullable final String taxDistributionCode1 )
    {
        rememberChangedField("TaxDistributionCode1", this.taxDistributionCode1);
        this.taxDistributionCode1 = taxDistributionCode1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxDistributionCode2</b>
     * </p>
     *
     * @param taxDistributionCode2
     *            Tax Code 2 for Distribution
     */
    public void setTaxDistributionCode2( @Nullable final String taxDistributionCode2 )
    {
        rememberChangedField("TaxDistributionCode2", this.taxDistributionCode2);
        this.taxDistributionCode2 = taxDistributionCode2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxDistributionCode3</b>
     * </p>
     *
     * @param taxDistributionCode3
     *            Tax Code 3 for Distribution
     */
    public void setTaxDistributionCode3( @Nullable final String taxDistributionCode3 )
    {
        rememberChangedField("TaxDistributionCode3", this.taxDistributionCode3);
        this.taxDistributionCode3 = taxDistributionCode3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReference</b>
     * </p>
     *
     * @param invoiceReference
     *            Invoice Reference
     */
    public void setInvoiceReference( @Nullable final String invoiceReference )
    {
        rememberChangedField("InvoiceReference", this.invoiceReference);
        this.invoiceReference = invoiceReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReferenceFiscalYear</b>
     * </p>
     *
     * @param invoiceReferenceFiscalYear
     *            Invoice Reference Fiscal Year
     */
    public void setInvoiceReferenceFiscalYear( @Nullable final String invoiceReferenceFiscalYear )
    {
        rememberChangedField("InvoiceReferenceFiscalYear", this.invoiceReferenceFiscalYear);
        this.invoiceReferenceFiscalYear = invoiceReferenceFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceItemReference</b>
     * </p>
     *
     * @param invoiceItemReference
     *            Invoice Item Reference
     */
    public void setInvoiceItemReference( @Nullable final String invoiceItemReference )
    {
        rememberChangedField("InvoiceItemReference", this.invoiceItemReference);
        this.invoiceItemReference = invoiceItemReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FollowOnDocumentType</b>
     * </p>
     *
     * @param followOnDocumentType
     *            Follow-On Document Type
     */
    public void setFollowOnDocumentType( @Nullable final String followOnDocumentType )
    {
        rememberChangedField("FollowOnDocumentType", this.followOnDocumentType);
        this.followOnDocumentType = followOnDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StateCentralBankPaymentReason</b>
     * </p>
     *
     * @param stateCentralBankPaymentReason
     *            State Central Bank Indicator
     */
    public void setStateCentralBankPaymentReason( @Nullable final String stateCentralBankPaymentReason )
    {
        rememberChangedField("StateCentralBankPaymentReason", this.stateCentralBankPaymentReason);
        this.stateCentralBankPaymentReason = stateCentralBankPaymentReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingCountry</b>
     * </p>
     *
     * @param supplyingCountry
     *            Supplying Country/Region
     */
    public void setSupplyingCountry( @Nullable final String supplyingCountry )
    {
        rememberChangedField("SupplyingCountry", this.supplyingCountry);
        this.supplyingCountry = supplyingCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceList</b>
     * </p>
     *
     * @param invoiceList
     *            Invoice List
     */
    public void setInvoiceList( @Nullable final String invoiceList )
    {
        rememberChangedField("InvoiceList", this.invoiceList);
        this.invoiceList = invoiceList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfExchangeUsage</b>
     * </p>
     *
     * @param billOfExchangeUsage
     *            Bill of Exchange Usage Type
     */
    public void setBillOfExchangeUsage( @Nullable final String billOfExchangeUsage )
    {
        rememberChangedField("BillOfExchangeUsage", this.billOfExchangeUsage);
        this.billOfExchangeUsage = billOfExchangeUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningKey</b>
     * </p>
     *
     * @param dunningKey
     *            Dunning Key
     */
    public void setDunningKey( @Nullable final String dunningKey )
    {
        rememberChangedField("DunningKey", this.dunningKey);
        this.dunningKey = dunningKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningBlockingReason</b>
     * </p>
     *
     * @param dunningBlockingReason
     *            Dunning Blocking Reason
     */
    public void setDunningBlockingReason( @Nullable final String dunningBlockingReason )
    {
        rememberChangedField("DunningBlockingReason", this.dunningBlockingReason);
        this.dunningBlockingReason = dunningBlockingReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastDunningDate</b>
     * </p>
     *
     * @param lastDunningDate
     *            Date of Last Dunning Notice
     */
    public void setLastDunningDate( @Nullable final LocalDateTime lastDunningDate )
    {
        rememberChangedField("LastDunningDate", this.lastDunningDate);
        this.lastDunningDate = lastDunningDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DunningLevel</b>
     * </p>
     *
     * @param dunningLevel
     *            Dunning Level
     */
    public void setDunningLevel( @Nullable final String dunningLevel )
    {
        rememberChangedField("DunningLevel", this.dunningLevel);
        this.dunningLevel = dunningLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DunningArea</b>
     * </p>
     *
     * @param dunningArea
     *            Dunning Area
     */
    public void setDunningArea( @Nullable final String dunningArea )
    {
        rememberChangedField("DunningArea", this.dunningArea);
        this.dunningArea = dunningArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCertificate</b>
     * </p>
     *
     * @param withholdingTaxCertificate
     *            Withholding Tax Certificate
     */
    public void setWithholdingTaxCertificate( @Nullable final String withholdingTaxCertificate )
    {
        rememberChangedField("WithholdingTaxCertificate", this.withholdingTaxCertificate);
        this.withholdingTaxCertificate = withholdingTaxCertificate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @param accountAssignmentNumber
     *            Sequential Number of Account Assignment
     */
    public void setAccountAssignmentNumber( @Nullable final String accountAssignmentNumber )
    {
        rememberChangedField("AccountAssignmentNumber", this.accountAssignmentNumber);
        this.accountAssignmentNumber = accountAssignmentNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @param isCompletelyDelivered
     *            Is completely delivered
     */
    public void setIsCompletelyDelivered( @Nullable final Boolean isCompletelyDelivered )
    {
        rememberChangedField("IsCompletelyDelivered", this.isCompletelyDelivered);
        this.isCompletelyDelivered = isCompletelyDelivered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceControl</b>
     * </p>
     *
     * @param materialPriceControl
     *            Material Price Control Indicator
     */
    public void setMaterialPriceControl( @Nullable final String materialPriceControl )
    {
        rememberChangedField("MaterialPriceControl", this.materialPriceControl);
        this.materialPriceControl = materialPriceControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @param vATRegistration
     *            VAT Registration
     */
    public void setVATRegistration( @Nullable final String vATRegistration )
    {
        rememberChangedField("VATRegistration", this.vATRegistration);
        this.vATRegistration = vATRegistration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DelivOfGoodsDestCountry</b>
     * </p>
     *
     * @param delivOfGoodsDestCountry
     *            Country/Region of Destination for Delivery of Goods
     */
    public void setDelivOfGoodsDestCountry( @Nullable final String delivOfGoodsDestCountry )
    {
        rememberChangedField("DelivOfGoodsDestCountry", this.delivOfGoodsDestCountry);
        this.delivOfGoodsDestCountry = delivOfGoodsDestCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDifferenceReason</b>
     * </p>
     *
     * @param paymentDifferenceReason
     *            Payment Difference Reason
     */
    public void setPaymentDifferenceReason( @Nullable final String paymentDifferenceReason )
    {
        rememberChangedField("PaymentDifferenceReason", this.paymentDifferenceReason);
        this.paymentDifferenceReason = paymentDifferenceReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @param profitCenterName
     *            Description of Profit Center
     */
    public void setProfitCenterName( @Nullable final String profitCenterName )
    {
        rememberChangedField("ProfitCenterName", this.profitCenterName);
        this.profitCenterName = profitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @param jointVentureCostRecoveryCode
     *            Recovery Indicator
     */
    public void setJointVentureCostRecoveryCode( @Nullable final String jointVentureCostRecoveryCode )
    {
        rememberChangedField("JointVentureCostRecoveryCode", this.jointVentureCostRecoveryCode);
        this.jointVentureCostRecoveryCode = jointVentureCostRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     *
     * @param jointVentureEquityGroup
     *            Joint Venture Equity Group
     */
    public void setJointVentureEquityGroup( @Nullable final String jointVentureEquityGroup )
    {
        rememberChangedField("JointVentureEquityGroup", this.jointVentureEquityGroup);
        this.jointVentureEquityGroup = jointVentureEquityGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TreasuryContractType</b>
     * </p>
     *
     * @param treasuryContractType
     *            Treasury Contract Type
     */
    public void setTreasuryContractType( @Nullable final String treasuryContractType )
    {
        rememberChangedField("TreasuryContractType", this.treasuryContractType);
        this.treasuryContractType = treasuryContractType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>AssetContract</b>
     * </p>
     *
     * @param assetContract
     *            Asset Contract
     */
    public void setAssetContract( @Nullable final String assetContract )
    {
        rememberChangedField("AssetContract", this.assetContract);
        this.assetContract = assetContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CashFlowType</b>
     * </p>
     *
     * @param cashFlowType
     *            Flow Type
     */
    public void setCashFlowType( @Nullable final String cashFlowType )
    {
        rememberChangedField("CashFlowType", this.cashFlowType);
        this.cashFlowType = cashFlowType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @param realEstateObject
     *            Internal Key for Real Estate Object
     */
    public void setRealEstateObject( @Nullable final String realEstateObject )
    {
        rememberChangedField("RealEstateObject", this.realEstateObject);
        this.realEstateObject = realEstateObject;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @param settlementReferenceDate
     *            Reference Date for Settlement
     */
    public void setSettlementReferenceDate( @Nullable final LocalDateTime settlementReferenceDate )
    {
        rememberChangedField("SettlementReferenceDate", this.settlementReferenceDate);
        this.settlementReferenceDate = settlementReferenceDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @param commitmentItem
     *            Commitment Item
     */
    public void setCommitmentItem( @Nullable final String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal Bill of Operations ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            Order Internal Bill of Operations Item
     */
    public void setOrderIntBillOfOperationsItem( @Nullable final String orderIntBillOfOperationsItem )
    {
        rememberChangedField("OrderIntBillOfOperationsItem", this.orderIntBillOfOperationsItem);
        this.orderIntBillOfOperationsItem = orderIntBillOfOperationsItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element (Internal Number Without Conversion)
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Deprecated: Profitability Segment
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @param jointVentureEquityType
     *            Joint Venture Equity Type
     */
    public void setJointVentureEquityType( @Nullable final String jointVentureEquityType )
    {
        rememberChangedField("JointVentureEquityType", this.jointVentureEquityType);
        this.jointVentureEquityType = jointVentureEquityType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     *
     * @param isEUTriangularDeal
     *            Is EU Triangular Deal
     */
    public void setIsEUTriangularDeal( @Nullable final Boolean isEUTriangularDeal )
    {
        rememberChangedField("IsEUTriangularDeal", this.isEUTriangularDeal);
        this.isEUTriangularDeal = isEUTriangularDeal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @param costOriginGroup
     *            Origin Group as Subdivision of Cost Element
     */
    public void setCostOriginGroup( @Nullable final String costOriginGroup )
    {
        rememberChangedField("CostOriginGroup", this.costOriginGroup);
        this.costOriginGroup = costOriginGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrencyDetnMethod</b>
     * </p>
     *
     * @param companyCodeCurrencyDetnMethod
     *            Company Code Currency Determination Method
     */
    public void setCompanyCodeCurrencyDetnMethod( @Nullable final String companyCodeCurrencyDetnMethod )
    {
        rememberChangedField("CompanyCodeCurrencyDetnMethod", this.companyCodeCurrencyDetnMethod);
        this.companyCodeCurrencyDetnMethod = companyCodeCurrencyDetnMethod;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClearingIsReversed</b>
     * </p>
     *
     * @param clearingIsReversed
     *            Clearing Is Reversed
     */
    public void setClearingIsReversed( @Nullable final Boolean clearingIsReversed )
    {
        rememberChangedField("ClearingIsReversed", this.clearingIsReversed);
        this.clearingIsReversed = clearingIsReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodSupplement</b>
     * </p>
     *
     * @param paymentMethodSupplement
     *            Payment Method Supplement
     */
    public void setPaymentMethodSupplement( @Nullable final String paymentMethodSupplement )
    {
        rememberChangedField("PaymentMethodSupplement", this.paymentMethodSupplement);
        this.paymentMethodSupplement = paymentMethodSupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @param alternativeGLAccount
     *            Alternative G/L Account Number In Company Code
     */
    public void setAlternativeGLAccount( @Nullable final String alternativeGLAccount )
    {
        rememberChangedField("AlternativeGLAccount", this.alternativeGLAccount);
        this.alternativeGLAccount = alternativeGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @param fundsCenter
     *            Funds Management Center
     */
    public void setFundsCenter( @Nullable final String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @param partnerProfitCenter
     *            Partner Profit Center
     */
    public void setPartnerProfitCenter( @Nullable final String partnerProfitCenter )
    {
        rememberChangedField("PartnerProfitCenter", this.partnerProfitCenter);
        this.partnerProfitCenter = partnerProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference1IDByBusinessPartner</b>
     * </p>
     *
     * @param reference1IDByBusinessPartner
     *            ID of Reference 1 by Business Partner
     */
    public void setReference1IDByBusinessPartner( @Nullable final String reference1IDByBusinessPartner )
    {
        rememberChangedField("Reference1IDByBusinessPartner", this.reference1IDByBusinessPartner);
        this.reference1IDByBusinessPartner = reference1IDByBusinessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference2IDByBusinessPartner</b>
     * </p>
     *
     * @param reference2IDByBusinessPartner
     *            ID of Reference 2 by Business Partner
     */
    public void setReference2IDByBusinessPartner( @Nullable final String reference2IDByBusinessPartner )
    {
        rememberChangedField("Reference2IDByBusinessPartner", this.reference2IDByBusinessPartner);
        this.reference2IDByBusinessPartner = reference2IDByBusinessPartner;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNegativePosting</b>
     * </p>
     *
     * @param isNegativePosting
     *            Is Negative Posting
     */
    public void setIsNegativePosting( @Nullable final Boolean isNegativePosting )
    {
        rememberChangedField("IsNegativePosting", this.isNegativePosting);
        this.isNegativePosting = isNegativePosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardItem</b>
     * </p>
     *
     * @param paymentCardItem
     *            Payment Card Item
     */
    public void setPaymentCardItem( @Nullable final String paymentCardItem )
    {
        rememberChangedField("PaymentCardItem", this.paymentCardItem);
        this.paymentCardItem = paymentCardItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardPaymentSettlement</b>
     * </p>
     *
     * @param paymentCardPaymentSettlement
     *            Payment Card Payment Settlement
     */
    public void setPaymentCardPaymentSettlement( @Nullable final String paymentCardPaymentSettlement )
    {
        rememberChangedField("PaymentCardPaymentSettlement", this.paymentCardPaymentSettlement);
        this.paymentCardPaymentSettlement = paymentCardPaymentSettlement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @param creditControlArea
     *            Credit Control Area
     */
    public void setCreditControlArea( @Nullable final String creditControlArea )
    {
        rememberChangedField("CreditControlArea", this.creditControlArea);
        this.creditControlArea = creditControlArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference3IDByBusinessPartner</b>
     * </p>
     *
     * @param reference3IDByBusinessPartner
     *            ID of Reference 3 by Business Partner
     */
    public void setReference3IDByBusinessPartner( @Nullable final String reference3IDByBusinessPartner )
    {
        rememberChangedField("Reference3IDByBusinessPartner", this.reference3IDByBusinessPartner);
        this.reference3IDByBusinessPartner = reference3IDByBusinessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction1</b>
     * </p>
     *
     * @param dataExchangeInstruction1
     *            Data Exchange Instruction 1
     */
    public void setDataExchangeInstruction1( @Nullable final String dataExchangeInstruction1 )
    {
        rememberChangedField("DataExchangeInstruction1", this.dataExchangeInstruction1);
        this.dataExchangeInstruction1 = dataExchangeInstruction1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction2</b>
     * </p>
     *
     * @param dataExchangeInstruction2
     *            Data Exchange Instruction 2
     */
    public void setDataExchangeInstruction2( @Nullable final String dataExchangeInstruction2 )
    {
        rememberChangedField("DataExchangeInstruction2", this.dataExchangeInstruction2);
        this.dataExchangeInstruction2 = dataExchangeInstruction2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction3</b>
     * </p>
     *
     * @param dataExchangeInstruction3
     *            Data Exchange Instruction 3
     */
    public void setDataExchangeInstruction3( @Nullable final String dataExchangeInstruction3 )
    {
        rememberChangedField("DataExchangeInstruction3", this.dataExchangeInstruction3);
        this.dataExchangeInstruction3 = dataExchangeInstruction3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DataExchangeInstruction4</b>
     * </p>
     *
     * @param dataExchangeInstruction4
     *            Data Exchange Instruction 4
     */
    public void setDataExchangeInstruction4( @Nullable final String dataExchangeInstruction4 )
    {
        rememberChangedField("DataExchangeInstruction4", this.dataExchangeInstruction4);
        this.dataExchangeInstruction4 = dataExchangeInstruction4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HasPaymentOrder</b>
     * </p>
     *
     * @param hasPaymentOrder
     *            Indicator: Payment Order Exists for this Item
     */
    public void setHasPaymentOrder( @Nullable final Boolean hasPaymentOrder )
    {
        rememberChangedField("HasPaymentOrder", this.hasPaymentOrder);
        this.hasPaymentOrder = hasPaymentOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @param paymentReference
     *            Payment Reference
     */
    public void setPaymentReference( @Nullable final String paymentReference )
    {
        rememberChangedField("PaymentReference", this.paymentReference);
        this.paymentReference = paymentReference;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @param taxDeterminationDate
     *            Date for Determination of Tax Rates
     */
    public void setTaxDeterminationDate( @Nullable final LocalDateTime taxDeterminationDate )
    {
        rememberChangedField("TaxDeterminationDate", this.taxDeterminationDate);
        this.taxDeterminationDate = taxDeterminationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClearingItem</b>
     * </p>
     *
     * @param clearingItem
     *            Clearing Item
     */
    public void setClearingItem( @Nullable final BigDecimal clearingItem )
    {
        rememberChangedField("ClearingItem", this.clearingItem);
        this.clearingItem = clearingItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     *
     * @param businessPlace
     *            Business Place
     */
    public void setBusinessPlace( @Nullable final String businessPlace )
    {
        rememberChangedField("BusinessPlace", this.businessPlace);
        this.businessPlace = businessPlace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxSection</b>
     * </p>
     *
     * @param taxSection
     *            Tax Section
     */
    public void setTaxSection( @Nullable final String taxSection )
    {
        rememberChangedField("TaxSection", this.taxSection);
        this.taxSection = taxSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountsReceivableIsPledged</b>
     * </p>
     *
     * @param accountsReceivableIsPledged
     *            Accounts Receivable Is Pledged
     */
    public void setAccountsReceivableIsPledged( @Nullable final String accountsReceivableIsPledged )
    {
        rememberChangedField("AccountsReceivableIsPledged", this.accountsReceivableIsPledged);
        this.accountsReceivableIsPledged = accountsReceivableIsPledged;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @param functionalAreaName
     *            Functional Area Name
     */
    public void setFunctionalAreaName( @Nullable final String functionalAreaName )
    {
        rememberChangedField("FunctionalAreaName", this.functionalAreaName);
        this.functionalAreaName = functionalAreaName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerIsInExecution</b>
     * </p>
     *
     * @param customerIsInExecution
     *            Customer Is In Execution
     */
    public void setCustomerIsInExecution( @Nullable final Boolean customerIsInExecution )
    {
        rememberChangedField("CustomerIsInExecution", this.customerIsInExecution);
        this.customerIsInExecution = customerIsInExecution;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FundedProgram</b>
     * </p>
     *
     * @param fundedProgram
     *            Funded Program
     */
    public void setFundedProgram( @Nullable final String fundedProgram )
    {
        rememberChangedField("FundedProgram", this.fundedProgram);
        this.fundedProgram = fundedProgram;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @param clearingDocFiscalYear
     *            Fiscal Year of Clearing Journal Entry
     */
    public void setClearingDocFiscalYear( @Nullable final String clearingDocFiscalYear )
    {
        rememberChangedField("ClearingDocFiscalYear", this.clearingDocFiscalYear);
        this.clearingDocFiscalYear = clearingDocFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     */
    public void setLedgerGLLineItem( @Nullable final String ledgerGLLineItem )
    {
        rememberChangedField("LedgerGLLineItem", this.ledgerGLLineItem);
        this.ledgerGLLineItem = ledgerGLLineItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     *
     * @param segmentName
     *            Segment Name
     */
    public void setSegmentName( @Nullable final String segmentName )
    {
        rememberChangedField("SegmentName", this.segmentName);
        this.segmentName = segmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @param partnerSegment
     *            Partner Segment for Segmental Reporting
     */
    public void setPartnerSegment( @Nullable final String partnerSegment )
    {
        rememberChangedField("PartnerSegment", this.partnerSegment);
        this.partnerSegment = partnerSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @param partnerFunctionalArea
     *            Partner Functional Area
     */
    public void setPartnerFunctionalArea( @Nullable final String partnerFunctionalArea )
    {
        rememberChangedField("PartnerFunctionalArea", this.partnerFunctionalArea);
        this.partnerFunctionalArea = partnerFunctionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @param houseBankAccount
     *            House Bank Account
     */
    public void setHouseBankAccount( @Nullable final String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @param costElement
     *            Cost Element
     */
    public void setCostElement( @Nullable final String costElement )
    {
        rememberChangedField("CostElement", this.costElement);
        this.costElement = costElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Unique Reference to Mandate for each Payee
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     *
     * @param originalReferenceDocument
     *            Original Reference Document
     */
    public void setOriginalReferenceDocument( @Nullable final String originalReferenceDocument )
    {
        rememberChangedField("OriginalReferenceDocument", this.originalReferenceDocument);
        this.originalReferenceDocument = originalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @param referenceDocumentLogicalSystem
     *            Logical System of Reference Document
     */
    public void setReferenceDocumentLogicalSystem( @Nullable final String referenceDocumentLogicalSystem )
    {
        rememberChangedField("ReferenceDocumentLogicalSystem", this.referenceDocumentLogicalSystem);
        this.referenceDocumentLogicalSystem = referenceDocumentLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItemRef</b>
     * </p>
     *
     * @param accountingDocumentItemRef
     *            Journal Entry Line Item Reference
     */
    public void setAccountingDocumentItemRef( @Nullable final String accountingDocumentItemRef )
    {
        rememberChangedField("AccountingDocumentItemRef", this.accountingDocumentItemRef);
        this.accountingDocumentItemRef = accountingDocumentItemRef;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @param accountingDocumentCategory
     *            Journal Entry Category
     */
    public void setAccountingDocumentCategory( @Nullable final String accountingDocumentCategory )
    {
        rememberChangedField("AccountingDocumentCategory", this.accountingDocumentCategory);
        this.accountingDocumentCategory = accountingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategoryName</b>
     * </p>
     *
     * @param accountingDocumentCategoryName
     *            Journal Entry Category Name
     */
    public void setAccountingDocumentCategoryName( @Nullable final String accountingDocumentCategoryName )
    {
        rememberChangedField("AccountingDocumentCategoryName", this.accountingDocumentCategoryName);
        this.accountingDocumentCategoryName = accountingDocumentCategoryName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Journal Entry Date
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @param accountingDocumentType
     *            Journal Entry Type
     */
    public void setAccountingDocumentType( @Nullable final String accountingDocumentType )
    {
        rememberChangedField("AccountingDocumentType", this.accountingDocumentType);
        this.accountingDocumentType = accountingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @param accountingDocumentTypeName
     *            Document Type Name
     */
    public void setAccountingDocumentTypeName( @Nullable final String accountingDocumentTypeName )
    {
        rememberChangedField("AccountingDocumentTypeName", this.accountingDocumentTypeName);
        this.accountingDocumentTypeName = accountingDocumentTypeName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetDueDate</b>
     * </p>
     *
     * @param netDueDate
     *            Due Date for Net Payment
     */
    public void setNetDueDate( @Nullable final LocalDateTime netDueDate )
    {
        rememberChangedField("NetDueDate", this.netDueDate);
        this.netDueDate = netDueDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1DueDate</b>
     * </p>
     *
     * @param cashDiscount1DueDate
     *            Due Date for Cash Discount 1
     */
    public void setCashDiscount1DueDate( @Nullable final LocalDateTime cashDiscount1DueDate )
    {
        rememberChangedField("CashDiscount1DueDate", this.cashDiscount1DueDate);
        this.cashDiscount1DueDate = cashDiscount1DueDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2DueDate</b>
     * </p>
     *
     * @param cashDiscount2DueDate
     *            Cash Discount 2 Due Date
     */
    public void setCashDiscount2DueDate( @Nullable final LocalDateTime cashDiscount2DueDate )
    {
        rememberChangedField("CashDiscount2DueDate", this.cashDiscount2DueDate);
        this.cashDiscount2DueDate = cashDiscount2DueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @param offsettingAccount
     *            Offsetting Account
     */
    public void setOffsettingAccount( @Nullable final String offsettingAccount )
    {
        rememberChangedField("OffsettingAccount", this.offsettingAccount);
        this.offsettingAccount = offsettingAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @param offsettingAccountType
     *            Offsetting Account Type
     */
    public void setOffsettingAccountType( @Nullable final String offsettingAccountType )
    {
        rememberChangedField("OffsettingAccountType", this.offsettingAccountType);
        this.offsettingAccountType = offsettingAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @param partnerFund
     *            Partner Fund
     */
    public void setPartnerFund( @Nullable final String partnerFund )
    {
        rememberChangedField("PartnerFund", this.partnerFund);
        this.partnerFund = partnerFund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @param partnerGrant
     *            Partner Grant
     */
    public void setPartnerGrant( @Nullable final String partnerGrant )
    {
        rememberChangedField("PartnerGrant", this.partnerGrant);
        this.partnerGrant = partnerGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @param partnerBudgetPeriod
     *            FM: Partner Budget Period
     */
    public void setPartnerBudgetPeriod( @Nullable final String partnerBudgetPeriod )
    {
        rememberChangedField("PartnerBudgetPeriod", this.partnerBudgetPeriod);
        this.partnerBudgetPeriod = partnerBudgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BranchCode</b>
     * </p>
     *
     * @param branchCode
     *            Branch Code
     */
    public void setBranchCode( @Nullable final String branchCode )
    {
        rememberChangedField("BranchCode", this.branchCode);
        this.branchCode = branchCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @param amountInCompanyCodeCurrency
     *            Amount in Company Code Currency
     */
    public void setAmountInCompanyCodeCurrency( @Nullable final BigDecimal amountInCompanyCodeCurrency )
    {
        rememberChangedField("AmountInCompanyCodeCurrency", this.amountInCompanyCodeCurrency);
        this.amountInCompanyCodeCurrency = amountInCompanyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param taxAmountInCoCodeCrcy
     *            Signed Tax Amount in Company Code Currency
     */
    public void setTaxAmountInCoCodeCrcy( @Nullable final BigDecimal taxAmountInCoCodeCrcy )
    {
        rememberChangedField("TaxAmountInCoCodeCrcy", this.taxAmountInCoCodeCrcy);
        this.taxAmountInCoCodeCrcy = taxAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param taxBaseAmountInCoCodeCrcy
     *            Tax Base Amount in Company Code Currency
     */
    public void setTaxBaseAmountInCoCodeCrcy( @Nullable final BigDecimal taxBaseAmountInCoCodeCrcy )
    {
        rememberChangedField("TaxBaseAmountInCoCodeCrcy", this.taxBaseAmountInCoCodeCrcy);
        this.taxBaseAmountInCoCodeCrcy = taxBaseAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationDiffAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param valuationDiffAmtInCoCodeCrcy
     *            Valuation Difference Amount In Company Code Currency
     */
    public void setValuationDiffAmtInCoCodeCrcy( @Nullable final BigDecimal valuationDiffAmtInCoCodeCrcy )
    {
        rememberChangedField("ValuationDiffAmtInCoCodeCrcy", this.valuationDiffAmtInCoCodeCrcy);
        this.valuationDiffAmtInCoCodeCrcy = valuationDiffAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param cashDiscountAmtInCoCodeCrcy
     *            Cash Discount Amount in Company Code Currency
     */
    public void setCashDiscountAmtInCoCodeCrcy( @Nullable final BigDecimal cashDiscountAmtInCoCodeCrcy )
    {
        rememberChangedField("CashDiscountAmtInCoCodeCrcy", this.cashDiscountAmtInCoCodeCrcy);
        this.cashDiscountAmtInCoCodeCrcy = cashDiscountAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param invoiceAmtInCoCodeCrcy
     *            Invoice Amount in Company Code Currency
     */
    public void setInvoiceAmtInCoCodeCrcy( @Nullable final BigDecimal invoiceAmtInCoCodeCrcy )
    {
        rememberChangedField("InvoiceAmtInCoCodeCrcy", this.invoiceAmtInCoCodeCrcy);
        this.invoiceAmtInCoCodeCrcy = invoiceAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Amount in Transaction Currency
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OriginalTaxBaseAmount</b>
     * </p>
     *
     * @param originalTaxBaseAmount
     *            Original Tax Base Amount in Transaction Currency
     */
    public void setOriginalTaxBaseAmount( @Nullable final BigDecimal originalTaxBaseAmount )
    {
        rememberChangedField("OriginalTaxBaseAmount", this.originalTaxBaseAmount);
        this.originalTaxBaseAmount = originalTaxBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @param taxAmount
     *            Tax Amount in Transaction Currency
     */
    public void setTaxAmount( @Nullable final BigDecimal taxAmount )
    {
        rememberChangedField("TaxAmount", this.taxAmount);
        this.taxAmount = taxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountInTransCrcy</b>
     * </p>
     *
     * @param taxBaseAmountInTransCrcy
     *            Tax Base Amount in Transaction Currency
     */
    public void setTaxBaseAmountInTransCrcy( @Nullable final BigDecimal taxBaseAmountInTransCrcy )
    {
        rememberChangedField("TaxBaseAmountInTransCrcy", this.taxBaseAmountInTransCrcy);
        this.taxBaseAmountInTransCrcy = taxBaseAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxBaseAmount</b>
     * </p>
     *
     * @param withholdingTaxBaseAmount
     *            Withholding Tax Base Amount
     */
    public void setWithholdingTaxBaseAmount( @Nullable final BigDecimal withholdingTaxBaseAmount )
    {
        rememberChangedField("WithholdingTaxBaseAmount", this.withholdingTaxBaseAmount);
        this.withholdingTaxBaseAmount = withholdingTaxBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedAmtInTransactionCrcy</b>
     * </p>
     *
     * @param plannedAmtInTransactionCrcy
     *            Planned Amount in Transaction Currency
     */
    public void setPlannedAmtInTransactionCrcy( @Nullable final BigDecimal plannedAmtInTransactionCrcy )
    {
        rememberChangedField("PlannedAmtInTransactionCrcy", this.plannedAmtInTransactionCrcy);
        this.plannedAmtInTransactionCrcy = plannedAmtInTransactionCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountBaseAmount</b>
     * </p>
     *
     * @param cashDiscountBaseAmount
     *            Cash Discount Base Amount
     */
    public void setCashDiscountBaseAmount( @Nullable final BigDecimal cashDiscountBaseAmount )
    {
        rememberChangedField("CashDiscountBaseAmount", this.cashDiscountBaseAmount);
        this.cashDiscountBaseAmount = cashDiscountBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmount</b>
     * </p>
     *
     * @param cashDiscountAmount
     *            Cash Discount Amount
     */
    public void setCashDiscountAmount( @Nullable final BigDecimal cashDiscountAmount )
    {
        rememberChangedField("CashDiscountAmount", this.cashDiscountAmount);
        this.cashDiscountAmount = cashDiscountAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentAmount</b>
     * </p>
     *
     * @param netPaymentAmount
     *            Net Payment Amount
     */
    public void setNetPaymentAmount( @Nullable final BigDecimal netPaymentAmount )
    {
        rememberChangedField("NetPaymentAmount", this.netPaymentAmount);
        this.netPaymentAmount = netPaymentAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxAmount</b>
     * </p>
     *
     * @param withholdingTaxAmount
     *            Withholding Tax Amount
     */
    public void setWithholdingTaxAmount( @Nullable final BigDecimal withholdingTaxAmount )
    {
        rememberChangedField("WithholdingTaxAmount", this.withholdingTaxAmount);
        this.withholdingTaxAmount = withholdingTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxExemptionAmt</b>
     * </p>
     *
     * @param withholdingTaxExemptionAmt
     *            Withholding Tax-Exemption Amount
     */
    public void setWithholdingTaxExemptionAmt( @Nullable final BigDecimal withholdingTaxExemptionAmt )
    {
        rememberChangedField("WithholdingTaxExemptionAmt", this.withholdingTaxExemptionAmt);
        this.withholdingTaxExemptionAmt = withholdingTaxExemptionAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceAmountInFrgnCurrency</b>
     * </p>
     *
     * @param invoiceAmountInFrgnCurrency
     *            Invoice Amount in Foreign Currency
     */
    public void setInvoiceAmountInFrgnCurrency( @Nullable final BigDecimal invoiceAmountInFrgnCurrency )
    {
        rememberChangedField("InvoiceAmountInFrgnCurrency", this.invoiceAmountInFrgnCurrency);
        this.invoiceAmountInFrgnCurrency = invoiceAmountInFrgnCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @param balanceTransactionCurrency
     *            Balance Transaction Currency
     */
    public void setBalanceTransactionCurrency( @Nullable final String balanceTransactionCurrency )
    {
        rememberChangedField("BalanceTransactionCurrency", this.balanceTransactionCurrency);
        this.balanceTransactionCurrency = balanceTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInBalanceTransacCrcy</b>
     * </p>
     *
     * @param amountInBalanceTransacCrcy
     *            Amount in Balance Transaction Currency
     */
    public void setAmountInBalanceTransacCrcy( @Nullable final BigDecimal amountInBalanceTransacCrcy )
    {
        rememberChangedField("AmountInBalanceTransacCrcy", this.amountInBalanceTransacCrcy);
        this.amountInBalanceTransacCrcy = amountInBalanceTransacCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency1</b>
     * </p>
     *
     * @param additionalCurrency1
     *            Additional Currency 1
     */
    public void setAdditionalCurrency1( @Nullable final String additionalCurrency1 )
    {
        rememberChangedField("AdditionalCurrency1", this.additionalCurrency1);
        this.additionalCurrency1 = additionalCurrency1;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationDiffAmtInAddlCrcy1</b>
     * </p>
     *
     * @param valuationDiffAmtInAddlCrcy1
     *            Valuation Difference Amount in Additional Currency 1
     */
    public void setValuationDiffAmtInAddlCrcy1( @Nullable final BigDecimal valuationDiffAmtInAddlCrcy1 )
    {
        rememberChangedField("ValuationDiffAmtInAddlCrcy1", this.valuationDiffAmtInAddlCrcy1);
        this.valuationDiffAmtInAddlCrcy1 = valuationDiffAmtInAddlCrcy1;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInAdditionalCurrency1</b>
     * </p>
     *
     * @param amountInAdditionalCurrency1
     *            Amount in Additional Currency 1
     */
    public void setAmountInAdditionalCurrency1( @Nullable final BigDecimal amountInAdditionalCurrency1 )
    {
        rememberChangedField("AmountInAdditionalCurrency1", this.amountInAdditionalCurrency1);
        this.amountInAdditionalCurrency1 = amountInAdditionalCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency2</b>
     * </p>
     *
     * @param additionalCurrency2
     *            Additional Currency 2
     */
    public void setAdditionalCurrency2( @Nullable final String additionalCurrency2 )
    {
        rememberChangedField("AdditionalCurrency2", this.additionalCurrency2);
        this.additionalCurrency2 = additionalCurrency2;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInAdditionalCurrency2</b>
     * </p>
     *
     * @param amountInAdditionalCurrency2
     *            Amount in Additional Currency 2
     */
    public void setAmountInAdditionalCurrency2( @Nullable final BigDecimal amountInAdditionalCurrency2 )
    {
        rememberChangedField("AmountInAdditionalCurrency2", this.amountInAdditionalCurrency2);
        this.amountInAdditionalCurrency2 = amountInAdditionalCurrency2;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationDiffAmtInAddlCrcy2</b>
     * </p>
     *
     * @param valuationDiffAmtInAddlCrcy2
     *            Valuation Difference Amount in Additional Currency 2
     */
    public void setValuationDiffAmtInAddlCrcy2( @Nullable final BigDecimal valuationDiffAmtInAddlCrcy2 )
    {
        rememberChangedField("ValuationDiffAmtInAddlCrcy2", this.valuationDiffAmtInAddlCrcy2);
        this.valuationDiffAmtInAddlCrcy2 = valuationDiffAmtInAddlCrcy2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     *
     * @param paymentCurrency
     *            Currency for Automatic Payment
     */
    public void setPaymentCurrency( @Nullable final String paymentCurrency )
    {
        rememberChangedField("PaymentCurrency", this.paymentCurrency);
        this.paymentCurrency = paymentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInPaymentCurrency</b>
     * </p>
     *
     * @param amountInPaymentCurrency
     *            Amount in Payment Currency
     */
    public void setAmountInPaymentCurrency( @Nullable final BigDecimal amountInPaymentCurrency )
    {
        rememberChangedField("AmountInPaymentCurrency", this.amountInPaymentCurrency);
        this.amountInPaymentCurrency = amountInPaymentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlAreaCurrency</b>
     * </p>
     *
     * @param creditControlAreaCurrency
     *            Credit Control Area Currency
     */
    public void setCreditControlAreaCurrency( @Nullable final String creditControlAreaCurrency )
    {
        rememberChangedField("CreditControlAreaCurrency", this.creditControlAreaCurrency);
        this.creditControlAreaCurrency = creditControlAreaCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HedgedAmount</b>
     * </p>
     *
     * @param hedgedAmount
     *            Credit Management: Hedged Amount
     */
    public void setHedgedAmount( @Nullable final BigDecimal hedgedAmount )
    {
        rememberChangedField("HedgedAmount", this.hedgedAmount);
        this.hedgedAmount = hedgedAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementEntryUnit</b>
     * </p>
     *
     * @param goodsMovementEntryUnit
     *            Unit of entry
     */
    public void setGoodsMovementEntryUnit( @Nullable final String goodsMovementEntryUnit )
    {
        rememberChangedField("GoodsMovementEntryUnit", this.goodsMovementEntryUnit);
        this.goodsMovementEntryUnit = goodsMovementEntryUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @param quantityInEntryUnit
     *            Quantity in Entry Unit of Measure
     */
    public void setQuantityInEntryUnit( @Nullable final BigDecimal quantityInEntryUnit )
    {
        rememberChangedField("QuantityInEntryUnit", this.quantityInEntryUnit);
        this.quantityInEntryUnit = quantityInEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentPriceUnit</b>
     * </p>
     *
     * @param purchasingDocumentPriceUnit
     *            Purchasing Document Price Unit
     */
    public void setPurchasingDocumentPriceUnit( @Nullable final String purchasingDocumentPriceUnit )
    {
        rememberChangedField("PurchasingDocumentPriceUnit", this.purchasingDocumentPriceUnit);
        this.purchasingDocumentPriceUnit = purchasingDocumentPriceUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQty</b>
     * </p>
     *
     * @param purchaseOrderQty
     *            Purchase Order Quantity
     */
    public void setPurchaseOrderQty( @Nullable final BigDecimal purchaseOrderQty )
    {
        rememberChangedField("PurchaseOrderQty", this.purchaseOrderQty);
        this.purchaseOrderQty = purchaseOrderQty;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @param materialPriceUnitQty
     *            Material Price Unit Quantity
     */
    public void setMaterialPriceUnitQty( @Nullable final BigDecimal materialPriceUnitQty )
    {
        rememberChangedField("MaterialPriceUnitQty", this.materialPriceUnitQty);
        this.materialPriceUnitQty = materialPriceUnitQty;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfItems</b>
     * </p>
     *
     * @param numberOfItems
     *            Number of Items
     */
    public void setNumberOfItems( @Nullable final BigDecimal numberOfItems )
    {
        rememberChangedField("NumberOfItems", this.numberOfItems);
        this.numberOfItems = numberOfItems;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCreationDate</b>
     * </p>
     *
     * @param accountingDocumentCreationDate
     *            Accounting Document Entry Date
     */
    public void setAccountingDocumentCreationDate( @Nullable final LocalDateTime accountingDocumentCreationDate )
    {
        rememberChangedField("AccountingDocumentCreationDate", this.accountingDocumentCreationDate);
        this.accountingDocumentCreationDate = accountingDocumentCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Creation Time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Change Date
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @param exchangeRateDate
     *            Exchange Rate Date
     */
    public void setExchangeRateDate( @Nullable final LocalDateTime exchangeRateDate )
    {
        rememberChangedField("ExchangeRateDate", this.exchangeRateDate);
        this.exchangeRateDate = exchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @param accountingDocCreatedByUser
     *            User that created the journal entry
     */
    public void setAccountingDocCreatedByUser( @Nullable final String accountingDocCreatedByUser )
    {
        rememberChangedField("AccountingDocCreatedByUser", this.accountingDocCreatedByUser);
        this.accountingDocCreatedByUser = accountingDocCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCode</b>
     * </p>
     *
     * @param transactionCode
     *            Transaction Code
     */
    public void setTransactionCode( @Nullable final String transactionCode )
    {
        rememberChangedField("TransactionCode", this.transactionCode);
        this.transactionCode = transactionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyTransaction</b>
     * </p>
     *
     * @param intercompanyTransaction
     *            Intercompany Transaction Number
     */
    public void setIntercompanyTransaction( @Nullable final String intercompanyTransaction )
    {
        rememberChangedField("IntercompanyTransaction", this.intercompanyTransaction);
        this.intercompanyTransaction = intercompanyTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @param documentReferenceID
     *            Document Reference ID
     */
    public void setDocumentReferenceID( @Nullable final String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecurringAccountingDocument</b>
     * </p>
     *
     * @param recurringAccountingDocument
     *            Recurring Journal Entry
     */
    public void setRecurringAccountingDocument( @Nullable final String recurringAccountingDocument )
    {
        rememberChangedField("RecurringAccountingDocument", this.recurringAccountingDocument);
        this.recurringAccountingDocument = recurringAccountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocument</b>
     * </p>
     *
     * @param reverseDocument
     *            Reverse Document
     */
    public void setReverseDocument( @Nullable final String reverseDocument )
    {
        rememberChangedField("ReverseDocument", this.reverseDocument);
        this.reverseDocument = reverseDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReverseDocumentFiscalYear</b>
     * </p>
     *
     * @param reverseDocumentFiscalYear
     *            Reverse Document Fiscal Year
     */
    public void setReverseDocumentFiscalYear( @Nullable final String reverseDocumentFiscalYear )
    {
        rememberChangedField("ReverseDocumentFiscalYear", this.reverseDocumentFiscalYear);
        this.reverseDocumentFiscalYear = reverseDocumentFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentHeaderText</b>
     * </p>
     *
     * @param accountingDocumentHeaderText
     *            Document Header Text
     */
    public void setAccountingDocumentHeaderText( @Nullable final String accountingDocumentHeaderText )
    {
        rememberChangedField("AccountingDocumentHeaderText", this.accountingDocumentHeaderText);
        this.accountingDocumentHeaderText = accountingDocumentHeaderText;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *            Exchange Rate
     */
    public void setExchangeRate( @Nullable final BigDecimal exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @param businessTransactionType
     *            Business Transaction Category
     */
    public void setBusinessTransactionType( @Nullable final String businessTransactionType )
    {
        rememberChangedField("BusinessTransactionType", this.businessTransactionType);
        this.businessTransactionType = businessTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BatchInputSession</b>
     * </p>
     *
     * @param batchInputSession
     *            Batch Input Session
     */
    public void setBatchInputSession( @Nullable final String batchInputSession )
    {
        rememberChangedField("BatchInputSession", this.batchInputSession);
        this.batchInputSession = batchInputSession;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReversalIsPlanned</b>
     * </p>
     *
     * @param reversalIsPlanned
     *            Indicator: Reversal Is Planned for Document
     */
    public void setReversalIsPlanned( @Nullable final Boolean reversalIsPlanned )
    {
        rememberChangedField("ReversalIsPlanned", this.reversalIsPlanned);
        this.reversalIsPlanned = reversalIsPlanned;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedReversalDate</b>
     * </p>
     *
     * @param plannedReversalDate
     *            Planned Date for the Reversal Posting
     */
    public void setPlannedReversalDate( @Nullable final LocalDateTime plannedReversalDate )
    {
        rememberChangedField("PlannedReversalDate", this.plannedReversalDate);
        this.plannedReversalDate = plannedReversalDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxIsCalculatedAutomatically</b>
     * </p>
     *
     * @param taxIsCalculatedAutomatically
     *            Tax Is Automatically Calculated
     */
    public void setTaxIsCalculatedAutomatically( @Nullable final Boolean taxIsCalculatedAutomatically )
    {
        rememberChangedField("TaxIsCalculatedAutomatically", this.taxIsCalculatedAutomatically);
        this.taxIsCalculatedAutomatically = taxIsCalculatedAutomatically;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxBaseAmountIsNetAmount</b>
     * </p>
     *
     * @param taxBaseAmountIsNetAmount
     *            Tax Base Amount is Net Amount
     */
    public void setTaxBaseAmountIsNetAmount( @Nullable final Boolean taxBaseAmountIsNetAmount )
    {
        rememberChangedField("TaxBaseAmountIsNetAmount", this.taxBaseAmountIsNetAmount);
        this.taxBaseAmountIsNetAmount = taxBaseAmountIsNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceCompanyCode</b>
     * </p>
     *
     * @param sourceCompanyCode
     *            Source Company Code
     */
    public void setSourceCompanyCode( @Nullable final String sourceCompanyCode )
    {
        rememberChangedField("SourceCompanyCode", this.sourceCompanyCode);
        this.sourceCompanyCode = sourceCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>TaxExchangeRate</b>
     * </p>
     *
     * @param taxExchangeRate
     *            Tax Exchange Rate
     */
    public void setTaxExchangeRate( @Nullable final BigDecimal taxExchangeRate )
    {
        rememberChangedField("TaxExchangeRate", this.taxExchangeRate);
        this.taxExchangeRate = taxExchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReason</b>
     * </p>
     *
     * @param reversalReason
     *            Reason for Reversal or Inverse Posting
     */
    public void setReversalReason( @Nullable final String reversalReason )
    {
        rememberChangedField("ReversalReason", this.reversalReason);
        this.reversalReason = reversalReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @param branch
     *            Branch
     */
    public void setBranch( @Nullable final String branch )
    {
        rememberChangedField("Branch", this.branch);
        this.branch = branch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference1InDocumentHeader</b>
     * </p>
     *
     * @param reference1InDocumentHeader
     *            Internal ID of Reference Key 1 in Document Header
     */
    public void setReference1InDocumentHeader( @Nullable final String reference1InDocumentHeader )
    {
        rememberChangedField("Reference1InDocumentHeader", this.reference1InDocumentHeader);
        this.reference1InDocumentHeader = reference1InDocumentHeader;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference2InDocumentHeader</b>
     * </p>
     *
     * @param reference2InDocumentHeader
     *            Internal ID of Reference Key 2 in Document Header
     */
    public void setReference2InDocumentHeader( @Nullable final String reference2InDocumentHeader )
    {
        rememberChangedField("Reference2InDocumentHeader", this.reference2InDocumentHeader);
        this.reference2InDocumentHeader = reference2InDocumentHeader;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceReceiptDate</b>
     * </p>
     *
     * @param invoiceReceiptDate
     *            Invoice Receipt Date
     */
    public void setInvoiceReceiptDate( @Nullable final LocalDateTime invoiceReceiptDate )
    {
        rememberChangedField("InvoiceReceiptDate", this.invoiceReceiptDate);
        this.invoiceReceiptDate = invoiceReceiptDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGroup</b>
     * </p>
     *
     * @param ledgerGroup
     *            Ledger Group
     */
    public void setLedgerGroup( @Nullable final String ledgerGroup )
    {
        rememberChangedField("LedgerGroup", this.ledgerGroup);
        this.ledgerGroup = ledgerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeReferenceDocument</b>
     * </p>
     *
     * @param alternativeReferenceDocument
     *            Alternative Reference Document
     */
    public void setAlternativeReferenceDocument( @Nullable final String alternativeReferenceDocument )
    {
        rememberChangedField("AlternativeReferenceDocument", this.alternativeReferenceDocument);
        this.alternativeReferenceDocument = alternativeReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxReportingDate</b>
     * </p>
     *
     * @param taxReportingDate
     *            Tax Reporting Date
     */
    public void setTaxReportingDate( @Nullable final LocalDateTime taxReportingDate )
    {
        rememberChangedField("TaxReportingDate", this.taxReportingDate);
        this.taxReportingDate = taxReportingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentClass</b>
     * </p>
     *
     * @param accountingDocumentClass
     *            Accounting Document Class
     */
    public void setAccountingDocumentClass( @Nullable final String accountingDocumentClass )
    {
        rememberChangedField("AccountingDocumentClass", this.accountingDocumentClass);
        this.accountingDocumentClass = accountingDocumentClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateType</b>
     * </p>
     *
     * @param exchangeRateType
     *            Exchange Rate Type
     */
    public void setExchangeRateType( @Nullable final String exchangeRateType )
    {
        rememberChangedField("ExchangeRateType", this.exchangeRateType);
        this.exchangeRateType = exchangeRateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LatePaymentReason</b>
     * </p>
     *
     * @param latePaymentReason
     *            Late Payment Reason
     */
    public void setLatePaymentReason( @Nullable final String latePaymentReason )
    {
        rememberChangedField("LatePaymentReason", this.latePaymentReason);
        this.latePaymentReason = latePaymentReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentCondition</b>
     * </p>
     *
     * @param salesDocumentCondition
     *            Sales Document Condition
     */
    public void setSalesDocumentCondition( @Nullable final String salesDocumentCondition )
    {
        rememberChangedField("SalesDocumentCondition", this.salesDocumentCondition);
        this.salesDocumentCondition = salesDocumentCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *            Indicator: Item is Reversing Another Item
     */
    public void setIsReversal( @Nullable final Boolean isReversal )
    {
        rememberChangedField("IsReversal", this.isReversal);
        this.isReversal = isReversal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *            Indicator: Item is Reversed
     */
    public void setIsReversed( @Nullable final Boolean isReversed )
    {
        rememberChangedField("IsReversed", this.isReversed);
        this.isReversed = isReversed;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_OperationalAcctgDocItemCube";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("FiscalYear", getFiscalYear());
        result.put("AccountingDocument", getAccountingDocument());
        result.put("AccountingDocumentItem", getAccountingDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("FiscalYear", getFiscalYear());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("AccountingDocumentItem", getAccountingDocumentItem());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("AccountingDocumentItemType", getAccountingDocumentItemType());
        values.put("ClearingDate", getClearingDate());
        values.put("ClearingCreationDate", getClearingCreationDate());
        values.put("ClearingAccountingDocument", getClearingAccountingDocument());
        values.put("IsCleared", getIsCleared());
        values.put("PostingKey", getPostingKey());
        values.put("FinancialAccountType", getFinancialAccountType());
        values.put("SpecialGLCode", getSpecialGLCode());
        values.put("SpecialGLTransactionType", getSpecialGLTransactionType());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessAreaName", getBusinessAreaName());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("TaxCode", getTaxCode());
        values.put("WithholdingTaxCode", getWithholdingTaxCode());
        values.put("TaxType", getTaxType());
        values.put("TransactionTypeDetermination", getTransactionTypeDetermination());
        values.put("ValueDate", getValueDate());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("CorporateGroupAccount", getCorporateGroupAccount());
        values.put("PlanningLevel", getPlanningLevel());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaName", getControllingAreaName());
        values.put("CostCenter", getCostCenter());
        values.put("CostCenterName", getCostCenterName());
        values.put("Project", getProject());
        values.put("OrderID", getOrderID());
        values.put("BillingDocument", getBillingDocument());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("AssetTransactionType", getAssetTransactionType());
        values.put("AssetValueDate", getAssetValueDate());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("IsSalesRelated", getIsSalesRelated());
        values.put("LineItemDisplayIsEnabled", getLineItemDisplayIsEnabled());
        values.put("IsOpenItemManaged", getIsOpenItemManaged());
        values.put("IsNotCashDiscountLiable", getIsNotCashDiscountLiable());
        values.put("IsAutomaticallyCreated", getIsAutomaticallyCreated());
        values.put("IsUsedInPaymentTransaction", getIsUsedInPaymentTransaction());
        values.put("OperationalGLAccount", getOperationalGLAccount());
        values.put("GLAccount", getGLAccount());
        values.put("GLAccountName", getGLAccountName());
        values.put("GLAccountLongName", getGLAccountLongName());
        values.put("Customer", getCustomer());
        values.put("CustomerName", getCustomerName());
        values.put("Supplier", getSupplier());
        values.put("SupplierName", getSupplierName());
        values.put("BranchAccount", getBranchAccount());
        values.put("IsBalanceSheetAccount", getIsBalanceSheetAccount());
        values.put("ProfitLossAccountType", getProfitLossAccountType());
        values.put("SpecialGLAccountAssignment", getSpecialGLAccountAssignment());
        values.put("DueCalculationBaseDate", getDueCalculationBaseDate());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("PaymentBlockingReason", getPaymentBlockingReason());
        values.put("FixedCashDiscount", getFixedCashDiscount());
        values.put("HouseBank", getHouseBank());
        values.put("BPBankAccountInternalID", getBPBankAccountInternalID());
        values.put("TaxDistributionCode1", getTaxDistributionCode1());
        values.put("TaxDistributionCode2", getTaxDistributionCode2());
        values.put("TaxDistributionCode3", getTaxDistributionCode3());
        values.put("InvoiceReference", getInvoiceReference());
        values.put("InvoiceReferenceFiscalYear", getInvoiceReferenceFiscalYear());
        values.put("InvoiceItemReference", getInvoiceItemReference());
        values.put("FollowOnDocumentType", getFollowOnDocumentType());
        values.put("StateCentralBankPaymentReason", getStateCentralBankPaymentReason());
        values.put("SupplyingCountry", getSupplyingCountry());
        values.put("InvoiceList", getInvoiceList());
        values.put("BillOfExchangeUsage", getBillOfExchangeUsage());
        values.put("DunningKey", getDunningKey());
        values.put("DunningBlockingReason", getDunningBlockingReason());
        values.put("LastDunningDate", getLastDunningDate());
        values.put("DunningLevel", getDunningLevel());
        values.put("DunningArea", getDunningArea());
        values.put("WithholdingTaxCertificate", getWithholdingTaxCertificate());
        values.put("Material", getMaterial());
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("AccountAssignmentNumber", getAccountAssignmentNumber());
        values.put("IsCompletelyDelivered", getIsCompletelyDelivered());
        values.put("MaterialPriceControl", getMaterialPriceControl());
        values.put("ValuationArea", getValuationArea());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("VATRegistration", getVATRegistration());
        values.put("DelivOfGoodsDestCountry", getDelivOfGoodsDestCountry());
        values.put("PaymentDifferenceReason", getPaymentDifferenceReason());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenterName", getProfitCenterName());
        values.put("JointVenture", getJointVenture());
        values.put("JointVentureCostRecoveryCode", getJointVentureCostRecoveryCode());
        values.put("JointVentureEquityGroup", getJointVentureEquityGroup());
        values.put("TreasuryContractType", getTreasuryContractType());
        values.put("AssetContract", getAssetContract());
        values.put("CashFlowType", getCashFlowType());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("RealEstateObject", getRealEstateObject());
        values.put("SettlementReferenceDate", getSettlementReferenceDate());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("CostObject", getCostObject());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("OrderIntBillOfOperationsItem", getOrderIntBillOfOperationsItem());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("JointVentureEquityType", getJointVentureEquityType());
        values.put("IsEUTriangularDeal", getIsEUTriangularDeal());
        values.put("CostOriginGroup", getCostOriginGroup());
        values.put("CompanyCodeCurrencyDetnMethod", getCompanyCodeCurrencyDetnMethod());
        values.put("ClearingIsReversed", getClearingIsReversed());
        values.put("PaymentMethodSupplement", getPaymentMethodSupplement());
        values.put("AlternativeGLAccount", getAlternativeGLAccount());
        values.put("FundsCenter", getFundsCenter());
        values.put("Fund", getFund());
        values.put("PartnerProfitCenter", getPartnerProfitCenter());
        values.put("Reference1IDByBusinessPartner", getReference1IDByBusinessPartner());
        values.put("Reference2IDByBusinessPartner", getReference2IDByBusinessPartner());
        values.put("IsNegativePosting", getIsNegativePosting());
        values.put("PaymentCardItem", getPaymentCardItem());
        values.put("PaymentCardPaymentSettlement", getPaymentCardPaymentSettlement());
        values.put("CreditControlArea", getCreditControlArea());
        values.put("Reference3IDByBusinessPartner", getReference3IDByBusinessPartner());
        values.put("DataExchangeInstruction1", getDataExchangeInstruction1());
        values.put("DataExchangeInstruction2", getDataExchangeInstruction2());
        values.put("DataExchangeInstruction3", getDataExchangeInstruction3());
        values.put("DataExchangeInstruction4", getDataExchangeInstruction4());
        values.put("Region", getRegion());
        values.put("HasPaymentOrder", getHasPaymentOrder());
        values.put("PaymentReference", getPaymentReference());
        values.put("TaxDeterminationDate", getTaxDeterminationDate());
        values.put("ClearingItem", getClearingItem());
        values.put("BusinessPlace", getBusinessPlace());
        values.put("TaxSection", getTaxSection());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("AccountsReceivableIsPledged", getAccountsReceivableIsPledged());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("GrantID", getGrantID());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("FunctionalAreaName", getFunctionalAreaName());
        values.put("CustomerIsInExecution", getCustomerIsInExecution());
        values.put("FundedProgram", getFundedProgram());
        values.put("ClearingDocFiscalYear", getClearingDocFiscalYear());
        values.put("LedgerGLLineItem", getLedgerGLLineItem());
        values.put("Segment", getSegment());
        values.put("SegmentName", getSegmentName());
        values.put("PartnerSegment", getPartnerSegment());
        values.put("PartnerFunctionalArea", getPartnerFunctionalArea());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("CostElement", getCostElement());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("OriginalReferenceDocument", getOriginalReferenceDocument());
        values.put("ReferenceDocumentLogicalSystem", getReferenceDocumentLogicalSystem());
        values.put("AccountingDocumentItemRef", getAccountingDocumentItemRef());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("AccountingDocumentCategory", getAccountingDocumentCategory());
        values.put("AccountingDocumentCategoryName", getAccountingDocumentCategoryName());
        values.put("PostingDate", getPostingDate());
        values.put("DocumentDate", getDocumentDate());
        values.put("AccountingDocumentType", getAccountingDocumentType());
        values.put("AccountingDocumentTypeName", getAccountingDocumentTypeName());
        values.put("NetDueDate", getNetDueDate());
        values.put("CashDiscount1DueDate", getCashDiscount1DueDate());
        values.put("CashDiscount2DueDate", getCashDiscount2DueDate());
        values.put("OffsettingAccount", getOffsettingAccount());
        values.put("OffsettingAccountType", getOffsettingAccountType());
        values.put("PartnerFund", getPartnerFund());
        values.put("PartnerGrant", getPartnerGrant());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("PartnerBudgetPeriod", getPartnerBudgetPeriod());
        values.put("BranchCode", getBranchCode());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AmountInCompanyCodeCurrency", getAmountInCompanyCodeCurrency());
        values.put("TaxAmountInCoCodeCrcy", getTaxAmountInCoCodeCrcy());
        values.put("TaxBaseAmountInCoCodeCrcy", getTaxBaseAmountInCoCodeCrcy());
        values.put("ValuationDiffAmtInCoCodeCrcy", getValuationDiffAmtInCoCodeCrcy());
        values.put("CashDiscountAmtInCoCodeCrcy", getCashDiscountAmtInCoCodeCrcy());
        values.put("InvoiceAmtInCoCodeCrcy", getInvoiceAmtInCoCodeCrcy());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("OriginalTaxBaseAmount", getOriginalTaxBaseAmount());
        values.put("TaxAmount", getTaxAmount());
        values.put("TaxBaseAmountInTransCrcy", getTaxBaseAmountInTransCrcy());
        values.put("WithholdingTaxBaseAmount", getWithholdingTaxBaseAmount());
        values.put("PlannedAmtInTransactionCrcy", getPlannedAmtInTransactionCrcy());
        values.put("CashDiscountBaseAmount", getCashDiscountBaseAmount());
        values.put("CashDiscountAmount", getCashDiscountAmount());
        values.put("NetPaymentAmount", getNetPaymentAmount());
        values.put("WithholdingTaxAmount", getWithholdingTaxAmount());
        values.put("WithholdingTaxExemptionAmt", getWithholdingTaxExemptionAmt());
        values.put("InvoiceAmountInFrgnCurrency", getInvoiceAmountInFrgnCurrency());
        values.put("BalanceTransactionCurrency", getBalanceTransactionCurrency());
        values.put("AmountInBalanceTransacCrcy", getAmountInBalanceTransacCrcy());
        values.put("AdditionalCurrency1", getAdditionalCurrency1());
        values.put("ValuationDiffAmtInAddlCrcy1", getValuationDiffAmtInAddlCrcy1());
        values.put("AmountInAdditionalCurrency1", getAmountInAdditionalCurrency1());
        values.put("AdditionalCurrency2", getAdditionalCurrency2());
        values.put("AmountInAdditionalCurrency2", getAmountInAdditionalCurrency2());
        values.put("ValuationDiffAmtInAddlCrcy2", getValuationDiffAmtInAddlCrcy2());
        values.put("PaymentCurrency", getPaymentCurrency());
        values.put("AmountInPaymentCurrency", getAmountInPaymentCurrency());
        values.put("CreditControlAreaCurrency", getCreditControlAreaCurrency());
        values.put("HedgedAmount", getHedgedAmount());
        values.put("BaseUnit", getBaseUnit());
        values.put("Quantity", getQuantity());
        values.put("GoodsMovementEntryUnit", getGoodsMovementEntryUnit());
        values.put("QuantityInEntryUnit", getQuantityInEntryUnit());
        values.put("PurchasingDocumentPriceUnit", getPurchasingDocumentPriceUnit());
        values.put("PurchaseOrderQty", getPurchaseOrderQty());
        values.put("MaterialPriceUnitQty", getMaterialPriceUnitQty());
        values.put("NumberOfItems", getNumberOfItems());
        values.put("AccountingDocumentCreationDate", getAccountingDocumentCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ExchangeRateDate", getExchangeRateDate());
        values.put("AccountingDocCreatedByUser", getAccountingDocCreatedByUser());
        values.put("TransactionCode", getTransactionCode());
        values.put("IntercompanyTransaction", getIntercompanyTransaction());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("RecurringAccountingDocument", getRecurringAccountingDocument());
        values.put("ReverseDocument", getReverseDocument());
        values.put("ReverseDocumentFiscalYear", getReverseDocumentFiscalYear());
        values.put("AccountingDocumentHeaderText", getAccountingDocumentHeaderText());
        values.put("ExchangeRate", getExchangeRate());
        values.put("BusinessTransactionType", getBusinessTransactionType());
        values.put("BatchInputSession", getBatchInputSession());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("ReversalIsPlanned", getReversalIsPlanned());
        values.put("PlannedReversalDate", getPlannedReversalDate());
        values.put("TaxIsCalculatedAutomatically", getTaxIsCalculatedAutomatically());
        values.put("TaxBaseAmountIsNetAmount", getTaxBaseAmountIsNetAmount());
        values.put("SourceCompanyCode", getSourceCompanyCode());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("TaxExchangeRate", getTaxExchangeRate());
        values.put("ReversalReason", getReversalReason());
        values.put("Branch", getBranch());
        values.put("Reference1InDocumentHeader", getReference1InDocumentHeader());
        values.put("Reference2InDocumentHeader", getReference2InDocumentHeader());
        values.put("InvoiceReceiptDate", getInvoiceReceiptDate());
        values.put("Ledger", getLedger());
        values.put("LedgerGroup", getLedgerGroup());
        values.put("AlternativeReferenceDocument", getAlternativeReferenceDocument());
        values.put("TaxReportingDate", getTaxReportingDate());
        values.put("AccountingDocumentClass", getAccountingDocumentClass());
        values.put("ExchangeRateType", getExchangeRateType());
        values.put("LatePaymentReason", getLatePaymentReason());
        values.put("SalesDocumentCondition", getSalesDocumentCondition());
        values.put("IsReversal", getIsReversal());
        values.put("IsReversed", getIsReversed());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentItem") ) {
                final Object value = values.remove("AccountingDocumentItem");
                if( (value == null) || (!value.equals(getAccountingDocumentItem())) ) {
                    setAccountingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentItemType") ) {
                final Object value = values.remove("AccountingDocumentItemType");
                if( (value == null) || (!value.equals(getAccountingDocumentItemType())) ) {
                    setAccountingDocumentItemType(((String) value));
                }
            }
            if( values.containsKey("ClearingDate") ) {
                final Object value = values.remove("ClearingDate");
                if( (value == null) || (!value.equals(getClearingDate())) ) {
                    setClearingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClearingCreationDate") ) {
                final Object value = values.remove("ClearingCreationDate");
                if( (value == null) || (!value.equals(getClearingCreationDate())) ) {
                    setClearingCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClearingAccountingDocument") ) {
                final Object value = values.remove("ClearingAccountingDocument");
                if( (value == null) || (!value.equals(getClearingAccountingDocument())) ) {
                    setClearingAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("IsCleared") ) {
                final Object value = values.remove("IsCleared");
                if( (value == null) || (!value.equals(getIsCleared())) ) {
                    setIsCleared(((Boolean) value));
                }
            }
            if( values.containsKey("PostingKey") ) {
                final Object value = values.remove("PostingKey");
                if( (value == null) || (!value.equals(getPostingKey())) ) {
                    setPostingKey(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountType") ) {
                final Object value = values.remove("FinancialAccountType");
                if( (value == null) || (!value.equals(getFinancialAccountType())) ) {
                    setFinancialAccountType(((String) value));
                }
            }
            if( values.containsKey("SpecialGLCode") ) {
                final Object value = values.remove("SpecialGLCode");
                if( (value == null) || (!value.equals(getSpecialGLCode())) ) {
                    setSpecialGLCode(((String) value));
                }
            }
            if( values.containsKey("SpecialGLTransactionType") ) {
                final Object value = values.remove("SpecialGLTransactionType");
                if( (value == null) || (!value.equals(getSpecialGLTransactionType())) ) {
                    setSpecialGLTransactionType(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("BusinessAreaName") ) {
                final Object value = values.remove("BusinessAreaName");
                if( (value == null) || (!value.equals(getBusinessAreaName())) ) {
                    setBusinessAreaName(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("WithholdingTaxCode") ) {
                final Object value = values.remove("WithholdingTaxCode");
                if( (value == null) || (!value.equals(getWithholdingTaxCode())) ) {
                    setWithholdingTaxCode(((String) value));
                }
            }
            if( values.containsKey("TaxType") ) {
                final Object value = values.remove("TaxType");
                if( (value == null) || (!value.equals(getTaxType())) ) {
                    setTaxType(((String) value));
                }
            }
            if( values.containsKey("TransactionTypeDetermination") ) {
                final Object value = values.remove("TransactionTypeDetermination");
                if( (value == null) || (!value.equals(getTransactionTypeDetermination())) ) {
                    setTransactionTypeDetermination(((String) value));
                }
            }
            if( values.containsKey("ValueDate") ) {
                final Object value = values.remove("ValueDate");
                if( (value == null) || (!value.equals(getValueDate())) ) {
                    setValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupAccount") ) {
                final Object value = values.remove("CorporateGroupAccount");
                if( (value == null) || (!value.equals(getCorporateGroupAccount())) ) {
                    setCorporateGroupAccount(((String) value));
                }
            }
            if( values.containsKey("PlanningLevel") ) {
                final Object value = values.remove("PlanningLevel");
                if( (value == null) || (!value.equals(getPlanningLevel())) ) {
                    setPlanningLevel(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenterName") ) {
                final Object value = values.remove("CostCenterName");
                if( (value == null) || (!value.equals(getCostCenterName())) ) {
                    setCostCenterName(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("BillingDocument") ) {
                final Object value = values.remove("BillingDocument");
                if( (value == null) || (!value.equals(getBillingDocument())) ) {
                    setBillingDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("AssetTransactionType") ) {
                final Object value = values.remove("AssetTransactionType");
                if( (value == null) || (!value.equals(getAssetTransactionType())) ) {
                    setAssetTransactionType(((String) value));
                }
            }
            if( values.containsKey("AssetValueDate") ) {
                final Object value = values.remove("AssetValueDate");
                if( (value == null) || (!value.equals(getAssetValueDate())) ) {
                    setAssetValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("IsSalesRelated") ) {
                final Object value = values.remove("IsSalesRelated");
                if( (value == null) || (!value.equals(getIsSalesRelated())) ) {
                    setIsSalesRelated(((Boolean) value));
                }
            }
            if( values.containsKey("LineItemDisplayIsEnabled") ) {
                final Object value = values.remove("LineItemDisplayIsEnabled");
                if( (value == null) || (!value.equals(getLineItemDisplayIsEnabled())) ) {
                    setLineItemDisplayIsEnabled(((Boolean) value));
                }
            }
            if( values.containsKey("IsOpenItemManaged") ) {
                final Object value = values.remove("IsOpenItemManaged");
                if( (value == null) || (!value.equals(getIsOpenItemManaged())) ) {
                    setIsOpenItemManaged(((String) value));
                }
            }
            if( values.containsKey("IsNotCashDiscountLiable") ) {
                final Object value = values.remove("IsNotCashDiscountLiable");
                if( (value == null) || (!value.equals(getIsNotCashDiscountLiable())) ) {
                    setIsNotCashDiscountLiable(((Boolean) value));
                }
            }
            if( values.containsKey("IsAutomaticallyCreated") ) {
                final Object value = values.remove("IsAutomaticallyCreated");
                if( (value == null) || (!value.equals(getIsAutomaticallyCreated())) ) {
                    setIsAutomaticallyCreated(((Boolean) value));
                }
            }
            if( values.containsKey("IsUsedInPaymentTransaction") ) {
                final Object value = values.remove("IsUsedInPaymentTransaction");
                if( (value == null) || (!value.equals(getIsUsedInPaymentTransaction())) ) {
                    setIsUsedInPaymentTransaction(((Boolean) value));
                }
            }
            if( values.containsKey("OperationalGLAccount") ) {
                final Object value = values.remove("OperationalGLAccount");
                if( (value == null) || (!value.equals(getOperationalGLAccount())) ) {
                    setOperationalGLAccount(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("GLAccountName") ) {
                final Object value = values.remove("GLAccountName");
                if( (value == null) || (!value.equals(getGLAccountName())) ) {
                    setGLAccountName(((String) value));
                }
            }
            if( values.containsKey("GLAccountLongName") ) {
                final Object value = values.remove("GLAccountLongName");
                if( (value == null) || (!value.equals(getGLAccountLongName())) ) {
                    setGLAccountLongName(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerName") ) {
                final Object value = values.remove("CustomerName");
                if( (value == null) || (!value.equals(getCustomerName())) ) {
                    setCustomerName(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierName") ) {
                final Object value = values.remove("SupplierName");
                if( (value == null) || (!value.equals(getSupplierName())) ) {
                    setSupplierName(((String) value));
                }
            }
            if( values.containsKey("BranchAccount") ) {
                final Object value = values.remove("BranchAccount");
                if( (value == null) || (!value.equals(getBranchAccount())) ) {
                    setBranchAccount(((String) value));
                }
            }
            if( values.containsKey("IsBalanceSheetAccount") ) {
                final Object value = values.remove("IsBalanceSheetAccount");
                if( (value == null) || (!value.equals(getIsBalanceSheetAccount())) ) {
                    setIsBalanceSheetAccount(((Boolean) value));
                }
            }
            if( values.containsKey("ProfitLossAccountType") ) {
                final Object value = values.remove("ProfitLossAccountType");
                if( (value == null) || (!value.equals(getProfitLossAccountType())) ) {
                    setProfitLossAccountType(((String) value));
                }
            }
            if( values.containsKey("SpecialGLAccountAssignment") ) {
                final Object value = values.remove("SpecialGLAccountAssignment");
                if( (value == null) || (!value.equals(getSpecialGLAccountAssignment())) ) {
                    setSpecialGLAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("DueCalculationBaseDate") ) {
                final Object value = values.remove("DueCalculationBaseDate");
                if( (value == null) || (!value.equals(getDueCalculationBaseDate())) ) {
                    setDueCalculationBaseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("PaymentBlockingReason") ) {
                final Object value = values.remove("PaymentBlockingReason");
                if( (value == null) || (!value.equals(getPaymentBlockingReason())) ) {
                    setPaymentBlockingReason(((String) value));
                }
            }
            if( values.containsKey("FixedCashDiscount") ) {
                final Object value = values.remove("FixedCashDiscount");
                if( (value == null) || (!value.equals(getFixedCashDiscount())) ) {
                    setFixedCashDiscount(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("BPBankAccountInternalID") ) {
                final Object value = values.remove("BPBankAccountInternalID");
                if( (value == null) || (!value.equals(getBPBankAccountInternalID())) ) {
                    setBPBankAccountInternalID(((String) value));
                }
            }
            if( values.containsKey("TaxDistributionCode1") ) {
                final Object value = values.remove("TaxDistributionCode1");
                if( (value == null) || (!value.equals(getTaxDistributionCode1())) ) {
                    setTaxDistributionCode1(((String) value));
                }
            }
            if( values.containsKey("TaxDistributionCode2") ) {
                final Object value = values.remove("TaxDistributionCode2");
                if( (value == null) || (!value.equals(getTaxDistributionCode2())) ) {
                    setTaxDistributionCode2(((String) value));
                }
            }
            if( values.containsKey("TaxDistributionCode3") ) {
                final Object value = values.remove("TaxDistributionCode3");
                if( (value == null) || (!value.equals(getTaxDistributionCode3())) ) {
                    setTaxDistributionCode3(((String) value));
                }
            }
            if( values.containsKey("InvoiceReference") ) {
                final Object value = values.remove("InvoiceReference");
                if( (value == null) || (!value.equals(getInvoiceReference())) ) {
                    setInvoiceReference(((String) value));
                }
            }
            if( values.containsKey("InvoiceReferenceFiscalYear") ) {
                final Object value = values.remove("InvoiceReferenceFiscalYear");
                if( (value == null) || (!value.equals(getInvoiceReferenceFiscalYear())) ) {
                    setInvoiceReferenceFiscalYear(((String) value));
                }
            }
            if( values.containsKey("InvoiceItemReference") ) {
                final Object value = values.remove("InvoiceItemReference");
                if( (value == null) || (!value.equals(getInvoiceItemReference())) ) {
                    setInvoiceItemReference(((String) value));
                }
            }
            if( values.containsKey("FollowOnDocumentType") ) {
                final Object value = values.remove("FollowOnDocumentType");
                if( (value == null) || (!value.equals(getFollowOnDocumentType())) ) {
                    setFollowOnDocumentType(((String) value));
                }
            }
            if( values.containsKey("StateCentralBankPaymentReason") ) {
                final Object value = values.remove("StateCentralBankPaymentReason");
                if( (value == null) || (!value.equals(getStateCentralBankPaymentReason())) ) {
                    setStateCentralBankPaymentReason(((String) value));
                }
            }
            if( values.containsKey("SupplyingCountry") ) {
                final Object value = values.remove("SupplyingCountry");
                if( (value == null) || (!value.equals(getSupplyingCountry())) ) {
                    setSupplyingCountry(((String) value));
                }
            }
            if( values.containsKey("InvoiceList") ) {
                final Object value = values.remove("InvoiceList");
                if( (value == null) || (!value.equals(getInvoiceList())) ) {
                    setInvoiceList(((String) value));
                }
            }
            if( values.containsKey("BillOfExchangeUsage") ) {
                final Object value = values.remove("BillOfExchangeUsage");
                if( (value == null) || (!value.equals(getBillOfExchangeUsage())) ) {
                    setBillOfExchangeUsage(((String) value));
                }
            }
            if( values.containsKey("DunningKey") ) {
                final Object value = values.remove("DunningKey");
                if( (value == null) || (!value.equals(getDunningKey())) ) {
                    setDunningKey(((String) value));
                }
            }
            if( values.containsKey("DunningBlockingReason") ) {
                final Object value = values.remove("DunningBlockingReason");
                if( (value == null) || (!value.equals(getDunningBlockingReason())) ) {
                    setDunningBlockingReason(((String) value));
                }
            }
            if( values.containsKey("LastDunningDate") ) {
                final Object value = values.remove("LastDunningDate");
                if( (value == null) || (!value.equals(getLastDunningDate())) ) {
                    setLastDunningDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DunningLevel") ) {
                final Object value = values.remove("DunningLevel");
                if( (value == null) || (!value.equals(getDunningLevel())) ) {
                    setDunningLevel(((String) value));
                }
            }
            if( values.containsKey("DunningArea") ) {
                final Object value = values.remove("DunningArea");
                if( (value == null) || (!value.equals(getDunningArea())) ) {
                    setDunningArea(((String) value));
                }
            }
            if( values.containsKey("WithholdingTaxCertificate") ) {
                final Object value = values.remove("WithholdingTaxCertificate");
                if( (value == null) || (!value.equals(getWithholdingTaxCertificate())) ) {
                    setWithholdingTaxCertificate(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentNumber") ) {
                final Object value = values.remove("AccountAssignmentNumber");
                if( (value == null) || (!value.equals(getAccountAssignmentNumber())) ) {
                    setAccountAssignmentNumber(((String) value));
                }
            }
            if( values.containsKey("IsCompletelyDelivered") ) {
                final Object value = values.remove("IsCompletelyDelivered");
                if( (value == null) || (!value.equals(getIsCompletelyDelivered())) ) {
                    setIsCompletelyDelivered(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialPriceControl") ) {
                final Object value = values.remove("MaterialPriceControl");
                if( (value == null) || (!value.equals(getMaterialPriceControl())) ) {
                    setMaterialPriceControl(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("VATRegistration") ) {
                final Object value = values.remove("VATRegistration");
                if( (value == null) || (!value.equals(getVATRegistration())) ) {
                    setVATRegistration(((String) value));
                }
            }
            if( values.containsKey("DelivOfGoodsDestCountry") ) {
                final Object value = values.remove("DelivOfGoodsDestCountry");
                if( (value == null) || (!value.equals(getDelivOfGoodsDestCountry())) ) {
                    setDelivOfGoodsDestCountry(((String) value));
                }
            }
            if( values.containsKey("PaymentDifferenceReason") ) {
                final Object value = values.remove("PaymentDifferenceReason");
                if( (value == null) || (!value.equals(getPaymentDifferenceReason())) ) {
                    setPaymentDifferenceReason(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterName") ) {
                final Object value = values.remove("ProfitCenterName");
                if( (value == null) || (!value.equals(getProfitCenterName())) ) {
                    setProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((String) value));
                }
            }
            if( values.containsKey("JointVentureCostRecoveryCode") ) {
                final Object value = values.remove("JointVentureCostRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureCostRecoveryCode())) ) {
                    setJointVentureCostRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityGroup") ) {
                final Object value = values.remove("JointVentureEquityGroup");
                if( (value == null) || (!value.equals(getJointVentureEquityGroup())) ) {
                    setJointVentureEquityGroup(((String) value));
                }
            }
            if( values.containsKey("TreasuryContractType") ) {
                final Object value = values.remove("TreasuryContractType");
                if( (value == null) || (!value.equals(getTreasuryContractType())) ) {
                    setTreasuryContractType(((String) value));
                }
            }
            if( values.containsKey("AssetContract") ) {
                final Object value = values.remove("AssetContract");
                if( (value == null) || (!value.equals(getAssetContract())) ) {
                    setAssetContract(((String) value));
                }
            }
            if( values.containsKey("CashFlowType") ) {
                final Object value = values.remove("CashFlowType");
                if( (value == null) || (!value.equals(getCashFlowType())) ) {
                    setCashFlowType(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("RealEstateObject") ) {
                final Object value = values.remove("RealEstateObject");
                if( (value == null) || (!value.equals(getRealEstateObject())) ) {
                    setRealEstateObject(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate") ) {
                final Object value = values.remove("SettlementReferenceDate");
                if( (value == null) || (!value.equals(getSettlementReferenceDate())) ) {
                    setSettlementReferenceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("OrderIntBillOfOperationsItem") ) {
                final Object value = values.remove("OrderIntBillOfOperationsItem");
                if( (value == null) || (!value.equals(getOrderIntBillOfOperationsItem())) ) {
                    setOrderIntBillOfOperationsItem(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityType") ) {
                final Object value = values.remove("JointVentureEquityType");
                if( (value == null) || (!value.equals(getJointVentureEquityType())) ) {
                    setJointVentureEquityType(((String) value));
                }
            }
            if( values.containsKey("IsEUTriangularDeal") ) {
                final Object value = values.remove("IsEUTriangularDeal");
                if( (value == null) || (!value.equals(getIsEUTriangularDeal())) ) {
                    setIsEUTriangularDeal(((Boolean) value));
                }
            }
            if( values.containsKey("CostOriginGroup") ) {
                final Object value = values.remove("CostOriginGroup");
                if( (value == null) || (!value.equals(getCostOriginGroup())) ) {
                    setCostOriginGroup(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrencyDetnMethod") ) {
                final Object value = values.remove("CompanyCodeCurrencyDetnMethod");
                if( (value == null) || (!value.equals(getCompanyCodeCurrencyDetnMethod())) ) {
                    setCompanyCodeCurrencyDetnMethod(((String) value));
                }
            }
            if( values.containsKey("ClearingIsReversed") ) {
                final Object value = values.remove("ClearingIsReversed");
                if( (value == null) || (!value.equals(getClearingIsReversed())) ) {
                    setClearingIsReversed(((Boolean) value));
                }
            }
            if( values.containsKey("PaymentMethodSupplement") ) {
                final Object value = values.remove("PaymentMethodSupplement");
                if( (value == null) || (!value.equals(getPaymentMethodSupplement())) ) {
                    setPaymentMethodSupplement(((String) value));
                }
            }
            if( values.containsKey("AlternativeGLAccount") ) {
                final Object value = values.remove("AlternativeGLAccount");
                if( (value == null) || (!value.equals(getAlternativeGLAccount())) ) {
                    setAlternativeGLAccount(((String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenter") ) {
                final Object value = values.remove("PartnerProfitCenter");
                if( (value == null) || (!value.equals(getPartnerProfitCenter())) ) {
                    setPartnerProfitCenter(((String) value));
                }
            }
            if( values.containsKey("Reference1IDByBusinessPartner") ) {
                final Object value = values.remove("Reference1IDByBusinessPartner");
                if( (value == null) || (!value.equals(getReference1IDByBusinessPartner())) ) {
                    setReference1IDByBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("Reference2IDByBusinessPartner") ) {
                final Object value = values.remove("Reference2IDByBusinessPartner");
                if( (value == null) || (!value.equals(getReference2IDByBusinessPartner())) ) {
                    setReference2IDByBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("IsNegativePosting") ) {
                final Object value = values.remove("IsNegativePosting");
                if( (value == null) || (!value.equals(getIsNegativePosting())) ) {
                    setIsNegativePosting(((Boolean) value));
                }
            }
            if( values.containsKey("PaymentCardItem") ) {
                final Object value = values.remove("PaymentCardItem");
                if( (value == null) || (!value.equals(getPaymentCardItem())) ) {
                    setPaymentCardItem(((String) value));
                }
            }
            if( values.containsKey("PaymentCardPaymentSettlement") ) {
                final Object value = values.remove("PaymentCardPaymentSettlement");
                if( (value == null) || (!value.equals(getPaymentCardPaymentSettlement())) ) {
                    setPaymentCardPaymentSettlement(((String) value));
                }
            }
            if( values.containsKey("CreditControlArea") ) {
                final Object value = values.remove("CreditControlArea");
                if( (value == null) || (!value.equals(getCreditControlArea())) ) {
                    setCreditControlArea(((String) value));
                }
            }
            if( values.containsKey("Reference3IDByBusinessPartner") ) {
                final Object value = values.remove("Reference3IDByBusinessPartner");
                if( (value == null) || (!value.equals(getReference3IDByBusinessPartner())) ) {
                    setReference3IDByBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("DataExchangeInstruction1") ) {
                final Object value = values.remove("DataExchangeInstruction1");
                if( (value == null) || (!value.equals(getDataExchangeInstruction1())) ) {
                    setDataExchangeInstruction1(((String) value));
                }
            }
            if( values.containsKey("DataExchangeInstruction2") ) {
                final Object value = values.remove("DataExchangeInstruction2");
                if( (value == null) || (!value.equals(getDataExchangeInstruction2())) ) {
                    setDataExchangeInstruction2(((String) value));
                }
            }
            if( values.containsKey("DataExchangeInstruction3") ) {
                final Object value = values.remove("DataExchangeInstruction3");
                if( (value == null) || (!value.equals(getDataExchangeInstruction3())) ) {
                    setDataExchangeInstruction3(((String) value));
                }
            }
            if( values.containsKey("DataExchangeInstruction4") ) {
                final Object value = values.remove("DataExchangeInstruction4");
                if( (value == null) || (!value.equals(getDataExchangeInstruction4())) ) {
                    setDataExchangeInstruction4(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("HasPaymentOrder") ) {
                final Object value = values.remove("HasPaymentOrder");
                if( (value == null) || (!value.equals(getHasPaymentOrder())) ) {
                    setHasPaymentOrder(((Boolean) value));
                }
            }
            if( values.containsKey("PaymentReference") ) {
                final Object value = values.remove("PaymentReference");
                if( (value == null) || (!value.equals(getPaymentReference())) ) {
                    setPaymentReference(((String) value));
                }
            }
            if( values.containsKey("TaxDeterminationDate") ) {
                final Object value = values.remove("TaxDeterminationDate");
                if( (value == null) || (!value.equals(getTaxDeterminationDate())) ) {
                    setTaxDeterminationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClearingItem") ) {
                final Object value = values.remove("ClearingItem");
                if( (value == null) || (!value.equals(getClearingItem())) ) {
                    setClearingItem(((BigDecimal) value));
                }
            }
            if( values.containsKey("BusinessPlace") ) {
                final Object value = values.remove("BusinessPlace");
                if( (value == null) || (!value.equals(getBusinessPlace())) ) {
                    setBusinessPlace(((String) value));
                }
            }
            if( values.containsKey("TaxSection") ) {
                final Object value = values.remove("TaxSection");
                if( (value == null) || (!value.equals(getTaxSection())) ) {
                    setTaxSection(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("AccountsReceivableIsPledged") ) {
                final Object value = values.remove("AccountsReceivableIsPledged");
                if( (value == null) || (!value.equals(getAccountsReceivableIsPledged())) ) {
                    setAccountsReceivableIsPledged(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("FunctionalAreaName") ) {
                final Object value = values.remove("FunctionalAreaName");
                if( (value == null) || (!value.equals(getFunctionalAreaName())) ) {
                    setFunctionalAreaName(((String) value));
                }
            }
            if( values.containsKey("CustomerIsInExecution") ) {
                final Object value = values.remove("CustomerIsInExecution");
                if( (value == null) || (!value.equals(getCustomerIsInExecution())) ) {
                    setCustomerIsInExecution(((Boolean) value));
                }
            }
            if( values.containsKey("FundedProgram") ) {
                final Object value = values.remove("FundedProgram");
                if( (value == null) || (!value.equals(getFundedProgram())) ) {
                    setFundedProgram(((String) value));
                }
            }
            if( values.containsKey("ClearingDocFiscalYear") ) {
                final Object value = values.remove("ClearingDocFiscalYear");
                if( (value == null) || (!value.equals(getClearingDocFiscalYear())) ) {
                    setClearingDocFiscalYear(((String) value));
                }
            }
            if( values.containsKey("LedgerGLLineItem") ) {
                final Object value = values.remove("LedgerGLLineItem");
                if( (value == null) || (!value.equals(getLedgerGLLineItem())) ) {
                    setLedgerGLLineItem(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("SegmentName") ) {
                final Object value = values.remove("SegmentName");
                if( (value == null) || (!value.equals(getSegmentName())) ) {
                    setSegmentName(((String) value));
                }
            }
            if( values.containsKey("PartnerSegment") ) {
                final Object value = values.remove("PartnerSegment");
                if( (value == null) || (!value.equals(getPartnerSegment())) ) {
                    setPartnerSegment(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea") ) {
                final Object value = values.remove("PartnerFunctionalArea");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea())) ) {
                    setPartnerFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((String) value));
                }
            }
            if( values.containsKey("CostElement") ) {
                final Object value = values.remove("CostElement");
                if( (value == null) || (!value.equals(getCostElement())) ) {
                    setCostElement(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("OriginalReferenceDocument") ) {
                final Object value = values.remove("OriginalReferenceDocument");
                if( (value == null) || (!value.equals(getOriginalReferenceDocument())) ) {
                    setOriginalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentLogicalSystem") ) {
                final Object value = values.remove("ReferenceDocumentLogicalSystem");
                if( (value == null) || (!value.equals(getReferenceDocumentLogicalSystem())) ) {
                    setReferenceDocumentLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentItemRef") ) {
                final Object value = values.remove("AccountingDocumentItemRef");
                if( (value == null) || (!value.equals(getAccountingDocumentItemRef())) ) {
                    setAccountingDocumentItemRef(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCategory") ) {
                final Object value = values.remove("AccountingDocumentCategory");
                if( (value == null) || (!value.equals(getAccountingDocumentCategory())) ) {
                    setAccountingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCategoryName") ) {
                final Object value = values.remove("AccountingDocumentCategoryName");
                if( (value == null) || (!value.equals(getAccountingDocumentCategoryName())) ) {
                    setAccountingDocumentCategoryName(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AccountingDocumentType") ) {
                final Object value = values.remove("AccountingDocumentType");
                if( (value == null) || (!value.equals(getAccountingDocumentType())) ) {
                    setAccountingDocumentType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentTypeName") ) {
                final Object value = values.remove("AccountingDocumentTypeName");
                if( (value == null) || (!value.equals(getAccountingDocumentTypeName())) ) {
                    setAccountingDocumentTypeName(((String) value));
                }
            }
            if( values.containsKey("NetDueDate") ) {
                final Object value = values.remove("NetDueDate");
                if( (value == null) || (!value.equals(getNetDueDate())) ) {
                    setNetDueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CashDiscount1DueDate") ) {
                final Object value = values.remove("CashDiscount1DueDate");
                if( (value == null) || (!value.equals(getCashDiscount1DueDate())) ) {
                    setCashDiscount1DueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CashDiscount2DueDate") ) {
                final Object value = values.remove("CashDiscount2DueDate");
                if( (value == null) || (!value.equals(getCashDiscount2DueDate())) ) {
                    setCashDiscount2DueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OffsettingAccount") ) {
                final Object value = values.remove("OffsettingAccount");
                if( (value == null) || (!value.equals(getOffsettingAccount())) ) {
                    setOffsettingAccount(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccountType") ) {
                final Object value = values.remove("OffsettingAccountType");
                if( (value == null) || (!value.equals(getOffsettingAccountType())) ) {
                    setOffsettingAccountType(((String) value));
                }
            }
            if( values.containsKey("PartnerFund") ) {
                final Object value = values.remove("PartnerFund");
                if( (value == null) || (!value.equals(getPartnerFund())) ) {
                    setPartnerFund(((String) value));
                }
            }
            if( values.containsKey("PartnerGrant") ) {
                final Object value = values.remove("PartnerGrant");
                if( (value == null) || (!value.equals(getPartnerGrant())) ) {
                    setPartnerGrant(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("PartnerBudgetPeriod") ) {
                final Object value = values.remove("PartnerBudgetPeriod");
                if( (value == null) || (!value.equals(getPartnerBudgetPeriod())) ) {
                    setPartnerBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("BranchCode") ) {
                final Object value = values.remove("BranchCode");
                if( (value == null) || (!value.equals(getBranchCode())) ) {
                    setBranchCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInCompanyCodeCurrency") ) {
                final Object value = values.remove("AmountInCompanyCodeCurrency");
                if( (value == null) || (!value.equals(getAmountInCompanyCodeCurrency())) ) {
                    setAmountInCompanyCodeCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxAmountInCoCodeCrcy") ) {
                final Object value = values.remove("TaxAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getTaxAmountInCoCodeCrcy())) ) {
                    setTaxAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxBaseAmountInCoCodeCrcy") ) {
                final Object value = values.remove("TaxBaseAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getTaxBaseAmountInCoCodeCrcy())) ) {
                    setTaxBaseAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("ValuationDiffAmtInCoCodeCrcy") ) {
                final Object value = values.remove("ValuationDiffAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getValuationDiffAmtInCoCodeCrcy())) ) {
                    setValuationDiffAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountAmtInCoCodeCrcy") ) {
                final Object value = values.remove("CashDiscountAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getCashDiscountAmtInCoCodeCrcy())) ) {
                    setCashDiscountAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("InvoiceAmtInCoCodeCrcy") ) {
                final Object value = values.remove("InvoiceAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getInvoiceAmtInCoCodeCrcy())) ) {
                    setInvoiceAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("OriginalTaxBaseAmount") ) {
                final Object value = values.remove("OriginalTaxBaseAmount");
                if( (value == null) || (!value.equals(getOriginalTaxBaseAmount())) ) {
                    setOriginalTaxBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxAmount") ) {
                final Object value = values.remove("TaxAmount");
                if( (value == null) || (!value.equals(getTaxAmount())) ) {
                    setTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxBaseAmountInTransCrcy") ) {
                final Object value = values.remove("TaxBaseAmountInTransCrcy");
                if( (value == null) || (!value.equals(getTaxBaseAmountInTransCrcy())) ) {
                    setTaxBaseAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("WithholdingTaxBaseAmount") ) {
                final Object value = values.remove("WithholdingTaxBaseAmount");
                if( (value == null) || (!value.equals(getWithholdingTaxBaseAmount())) ) {
                    setWithholdingTaxBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedAmtInTransactionCrcy") ) {
                final Object value = values.remove("PlannedAmtInTransactionCrcy");
                if( (value == null) || (!value.equals(getPlannedAmtInTransactionCrcy())) ) {
                    setPlannedAmtInTransactionCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountBaseAmount") ) {
                final Object value = values.remove("CashDiscountBaseAmount");
                if( (value == null) || (!value.equals(getCashDiscountBaseAmount())) ) {
                    setCashDiscountBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountAmount") ) {
                final Object value = values.remove("CashDiscountAmount");
                if( (value == null) || (!value.equals(getCashDiscountAmount())) ) {
                    setCashDiscountAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentAmount") ) {
                final Object value = values.remove("NetPaymentAmount");
                if( (value == null) || (!value.equals(getNetPaymentAmount())) ) {
                    setNetPaymentAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("WithholdingTaxAmount") ) {
                final Object value = values.remove("WithholdingTaxAmount");
                if( (value == null) || (!value.equals(getWithholdingTaxAmount())) ) {
                    setWithholdingTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("WithholdingTaxExemptionAmt") ) {
                final Object value = values.remove("WithholdingTaxExemptionAmt");
                if( (value == null) || (!value.equals(getWithholdingTaxExemptionAmt())) ) {
                    setWithholdingTaxExemptionAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("InvoiceAmountInFrgnCurrency") ) {
                final Object value = values.remove("InvoiceAmountInFrgnCurrency");
                if( (value == null) || (!value.equals(getInvoiceAmountInFrgnCurrency())) ) {
                    setInvoiceAmountInFrgnCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("BalanceTransactionCurrency") ) {
                final Object value = values.remove("BalanceTransactionCurrency");
                if( (value == null) || (!value.equals(getBalanceTransactionCurrency())) ) {
                    setBalanceTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInBalanceTransacCrcy") ) {
                final Object value = values.remove("AmountInBalanceTransacCrcy");
                if( (value == null) || (!value.equals(getAmountInBalanceTransacCrcy())) ) {
                    setAmountInBalanceTransacCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdditionalCurrency1") ) {
                final Object value = values.remove("AdditionalCurrency1");
                if( (value == null) || (!value.equals(getAdditionalCurrency1())) ) {
                    setAdditionalCurrency1(((String) value));
                }
            }
            if( values.containsKey("ValuationDiffAmtInAddlCrcy1") ) {
                final Object value = values.remove("ValuationDiffAmtInAddlCrcy1");
                if( (value == null) || (!value.equals(getValuationDiffAmtInAddlCrcy1())) ) {
                    setValuationDiffAmtInAddlCrcy1(((BigDecimal) value));
                }
            }
            if( values.containsKey("AmountInAdditionalCurrency1") ) {
                final Object value = values.remove("AmountInAdditionalCurrency1");
                if( (value == null) || (!value.equals(getAmountInAdditionalCurrency1())) ) {
                    setAmountInAdditionalCurrency1(((BigDecimal) value));
                }
            }
            if( values.containsKey("AdditionalCurrency2") ) {
                final Object value = values.remove("AdditionalCurrency2");
                if( (value == null) || (!value.equals(getAdditionalCurrency2())) ) {
                    setAdditionalCurrency2(((String) value));
                }
            }
            if( values.containsKey("AmountInAdditionalCurrency2") ) {
                final Object value = values.remove("AmountInAdditionalCurrency2");
                if( (value == null) || (!value.equals(getAmountInAdditionalCurrency2())) ) {
                    setAmountInAdditionalCurrency2(((BigDecimal) value));
                }
            }
            if( values.containsKey("ValuationDiffAmtInAddlCrcy2") ) {
                final Object value = values.remove("ValuationDiffAmtInAddlCrcy2");
                if( (value == null) || (!value.equals(getValuationDiffAmtInAddlCrcy2())) ) {
                    setValuationDiffAmtInAddlCrcy2(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentCurrency") ) {
                final Object value = values.remove("PaymentCurrency");
                if( (value == null) || (!value.equals(getPaymentCurrency())) ) {
                    setPaymentCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInPaymentCurrency") ) {
                final Object value = values.remove("AmountInPaymentCurrency");
                if( (value == null) || (!value.equals(getAmountInPaymentCurrency())) ) {
                    setAmountInPaymentCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditControlAreaCurrency") ) {
                final Object value = values.remove("CreditControlAreaCurrency");
                if( (value == null) || (!value.equals(getCreditControlAreaCurrency())) ) {
                    setCreditControlAreaCurrency(((String) value));
                }
            }
            if( values.containsKey("HedgedAmount") ) {
                final Object value = values.remove("HedgedAmount");
                if( (value == null) || (!value.equals(getHedgedAmount())) ) {
                    setHedgedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("GoodsMovementEntryUnit") ) {
                final Object value = values.remove("GoodsMovementEntryUnit");
                if( (value == null) || (!value.equals(getGoodsMovementEntryUnit())) ) {
                    setGoodsMovementEntryUnit(((String) value));
                }
            }
            if( values.containsKey("QuantityInEntryUnit") ) {
                final Object value = values.remove("QuantityInEntryUnit");
                if( (value == null) || (!value.equals(getQuantityInEntryUnit())) ) {
                    setQuantityInEntryUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingDocumentPriceUnit") ) {
                final Object value = values.remove("PurchasingDocumentPriceUnit");
                if( (value == null) || (!value.equals(getPurchasingDocumentPriceUnit())) ) {
                    setPurchasingDocumentPriceUnit(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderQty") ) {
                final Object value = values.remove("PurchaseOrderQty");
                if( (value == null) || (!value.equals(getPurchaseOrderQty())) ) {
                    setPurchaseOrderQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialPriceUnitQty") ) {
                final Object value = values.remove("MaterialPriceUnitQty");
                if( (value == null) || (!value.equals(getMaterialPriceUnitQty())) ) {
                    setMaterialPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfItems") ) {
                final Object value = values.remove("NumberOfItems");
                if( (value == null) || (!value.equals(getNumberOfItems())) ) {
                    setNumberOfItems(((BigDecimal) value));
                }
            }
            if( values.containsKey("AccountingDocumentCreationDate") ) {
                final Object value = values.remove("AccountingDocumentCreationDate");
                if( (value == null) || (!value.equals(getAccountingDocumentCreationDate())) ) {
                    setAccountingDocumentCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ExchangeRateDate") ) {
                final Object value = values.remove("ExchangeRateDate");
                if( (value == null) || (!value.equals(getExchangeRateDate())) ) {
                    setExchangeRateDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AccountingDocCreatedByUser") ) {
                final Object value = values.remove("AccountingDocCreatedByUser");
                if( (value == null) || (!value.equals(getAccountingDocCreatedByUser())) ) {
                    setAccountingDocCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("TransactionCode") ) {
                final Object value = values.remove("TransactionCode");
                if( (value == null) || (!value.equals(getTransactionCode())) ) {
                    setTransactionCode(((String) value));
                }
            }
            if( values.containsKey("IntercompanyTransaction") ) {
                final Object value = values.remove("IntercompanyTransaction");
                if( (value == null) || (!value.equals(getIntercompanyTransaction())) ) {
                    setIntercompanyTransaction(((String) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((String) value));
                }
            }
            if( values.containsKey("RecurringAccountingDocument") ) {
                final Object value = values.remove("RecurringAccountingDocument");
                if( (value == null) || (!value.equals(getRecurringAccountingDocument())) ) {
                    setRecurringAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("ReverseDocument") ) {
                final Object value = values.remove("ReverseDocument");
                if( (value == null) || (!value.equals(getReverseDocument())) ) {
                    setReverseDocument(((String) value));
                }
            }
            if( values.containsKey("ReverseDocumentFiscalYear") ) {
                final Object value = values.remove("ReverseDocumentFiscalYear");
                if( (value == null) || (!value.equals(getReverseDocumentFiscalYear())) ) {
                    setReverseDocumentFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentHeaderText") ) {
                final Object value = values.remove("AccountingDocumentHeaderText");
                if( (value == null) || (!value.equals(getAccountingDocumentHeaderText())) ) {
                    setAccountingDocumentHeaderText(((String) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BusinessTransactionType") ) {
                final Object value = values.remove("BusinessTransactionType");
                if( (value == null) || (!value.equals(getBusinessTransactionType())) ) {
                    setBusinessTransactionType(((String) value));
                }
            }
            if( values.containsKey("BatchInputSession") ) {
                final Object value = values.remove("BatchInputSession");
                if( (value == null) || (!value.equals(getBatchInputSession())) ) {
                    setBatchInputSession(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("ReversalIsPlanned") ) {
                final Object value = values.remove("ReversalIsPlanned");
                if( (value == null) || (!value.equals(getReversalIsPlanned())) ) {
                    setReversalIsPlanned(((Boolean) value));
                }
            }
            if( values.containsKey("PlannedReversalDate") ) {
                final Object value = values.remove("PlannedReversalDate");
                if( (value == null) || (!value.equals(getPlannedReversalDate())) ) {
                    setPlannedReversalDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxIsCalculatedAutomatically") ) {
                final Object value = values.remove("TaxIsCalculatedAutomatically");
                if( (value == null) || (!value.equals(getTaxIsCalculatedAutomatically())) ) {
                    setTaxIsCalculatedAutomatically(((Boolean) value));
                }
            }
            if( values.containsKey("TaxBaseAmountIsNetAmount") ) {
                final Object value = values.remove("TaxBaseAmountIsNetAmount");
                if( (value == null) || (!value.equals(getTaxBaseAmountIsNetAmount())) ) {
                    setTaxBaseAmountIsNetAmount(((Boolean) value));
                }
            }
            if( values.containsKey("SourceCompanyCode") ) {
                final Object value = values.remove("SourceCompanyCode");
                if( (value == null) || (!value.equals(getSourceCompanyCode())) ) {
                    setSourceCompanyCode(((String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("TaxExchangeRate") ) {
                final Object value = values.remove("TaxExchangeRate");
                if( (value == null) || (!value.equals(getTaxExchangeRate())) ) {
                    setTaxExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReversalReason") ) {
                final Object value = values.remove("ReversalReason");
                if( (value == null) || (!value.equals(getReversalReason())) ) {
                    setReversalReason(((String) value));
                }
            }
            if( values.containsKey("Branch") ) {
                final Object value = values.remove("Branch");
                if( (value == null) || (!value.equals(getBranch())) ) {
                    setBranch(((String) value));
                }
            }
            if( values.containsKey("Reference1InDocumentHeader") ) {
                final Object value = values.remove("Reference1InDocumentHeader");
                if( (value == null) || (!value.equals(getReference1InDocumentHeader())) ) {
                    setReference1InDocumentHeader(((String) value));
                }
            }
            if( values.containsKey("Reference2InDocumentHeader") ) {
                final Object value = values.remove("Reference2InDocumentHeader");
                if( (value == null) || (!value.equals(getReference2InDocumentHeader())) ) {
                    setReference2InDocumentHeader(((String) value));
                }
            }
            if( values.containsKey("InvoiceReceiptDate") ) {
                final Object value = values.remove("InvoiceReceiptDate");
                if( (value == null) || (!value.equals(getInvoiceReceiptDate())) ) {
                    setInvoiceReceiptDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("LedgerGroup") ) {
                final Object value = values.remove("LedgerGroup");
                if( (value == null) || (!value.equals(getLedgerGroup())) ) {
                    setLedgerGroup(((String) value));
                }
            }
            if( values.containsKey("AlternativeReferenceDocument") ) {
                final Object value = values.remove("AlternativeReferenceDocument");
                if( (value == null) || (!value.equals(getAlternativeReferenceDocument())) ) {
                    setAlternativeReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("TaxReportingDate") ) {
                final Object value = values.remove("TaxReportingDate");
                if( (value == null) || (!value.equals(getTaxReportingDate())) ) {
                    setTaxReportingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AccountingDocumentClass") ) {
                final Object value = values.remove("AccountingDocumentClass");
                if( (value == null) || (!value.equals(getAccountingDocumentClass())) ) {
                    setAccountingDocumentClass(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateType") ) {
                final Object value = values.remove("ExchangeRateType");
                if( (value == null) || (!value.equals(getExchangeRateType())) ) {
                    setExchangeRateType(((String) value));
                }
            }
            if( values.containsKey("LatePaymentReason") ) {
                final Object value = values.remove("LatePaymentReason");
                if( (value == null) || (!value.equals(getLatePaymentReason())) ) {
                    setLatePaymentReason(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentCondition") ) {
                final Object value = values.remove("SalesDocumentCondition");
                if( (value == null) || (!value.equals(getSalesDocumentCondition())) ) {
                    setSalesDocumentCondition(((String) value));
                }
            }
            if( values.containsKey("IsReversal") ) {
                final Object value = values.remove("IsReversal");
                if( (value == null) || (!value.equals(getIsReversal())) ) {
                    setIsReversal(((Boolean) value));
                }
            }
            if( values.containsKey("IsReversed") ) {
                final Object value = values.remove("IsReversed");
                if( (value == null) || (!value.equals(getIsReversed())) ) {
                    setIsReversed(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> OperationalAcctgDocItemCubeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new OperationalAcctgDocItemCubeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OperationalAcctgDocItemCubeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OperationalAcctgDocItemCubeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService.DEFAULT_SERVICE_PATH);
    }

}
