/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.selectable.OperationalAcctgDocItemCubeSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube
 * OperationalAcctgDocItemCube} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class OperationalAcctgDocItemCubeByKeyFluentHelper
    extends
    FluentHelperByKey<OperationalAcctgDocItemCubeByKeyFluentHelper, OperationalAcctgDocItemCube, OperationalAcctgDocItemCubeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube
     * OperationalAcctgDocItemCube} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code OperationalAcctgDocItemCube}
     * @param accountingDocumentItem
     *            Journal Entry Posting View Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code OperationalAcctgDocItemCube}
     * @param accountingDocument
     *            Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public OperationalAcctgDocItemCubeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String companyCode,
        final String fiscalYear,
        final String accountingDocument,
        final String accountingDocumentItem )
    {
        super(servicePath, entityCollection);
        this.key.put("CompanyCode", companyCode);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("AccountingDocument", accountingDocument);
        this.key.put("AccountingDocumentItem", accountingDocumentItem);
    }

    @Override
    @Nonnull
    protected Class<OperationalAcctgDocItemCube> getEntityClass()
    {
        return OperationalAcctgDocItemCube.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
