/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link AccountingDocumentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService AccountingDocumentService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultAccountingDocumentServiceBatch
    extends
    BatchFluentHelperBasic<AccountingDocumentServiceBatch, AccountingDocumentServiceBatchChangeSet>
    implements
    AccountingDocumentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultAccountingDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultAccountingDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultAccountingDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultAccountingDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultAccountingDocumentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public AccountingDocumentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultAccountingDocumentServiceBatchChangeSet(this, service);
    }

}
