/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link AccountingDocumentServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService AccountingDocumentService}.
 *
 */
public class DefaultAccountingDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<AccountingDocumentServiceBatch, AccountingDocumentServiceBatchChangeSet>
    implements
    AccountingDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultAccountingDocumentServiceBatchChangeSet(
        @Nonnull final DefaultAccountingDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AccountingDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultAccountingDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

}
