/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube
 * OperationalAcctgDocItemCube}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.field.OperationalAcctgDocItemCubeField
 * OperationalAcctgDocItemCubeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.link.OperationalAcctgDocItemCubeLink
 * OperationalAcctgDocItemCubeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_ITEM
 * ACCOUNTING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_ITEM_TYPE
 * ACCOUNTING_DOCUMENT_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CLEARING_DATE
 * CLEARING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CLEARING_CREATION_DATE
 * CLEARING_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CLEARING_ACCOUNTING_DOCUMENT
 * CLEARING_ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_CLEARED
 * IS_CLEARED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#POSTING_KEY
 * POSTING_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FINANCIAL_ACCOUNT_TYPE
 * FINANCIAL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SPECIAL_GL_CODE
 * SPECIAL_GL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SPECIAL_GL_TRANSACTION_TYPE
 * SPECIAL_GL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BUSINESS_AREA_NAME
 * BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#WITHHOLDING_TAX_CODE
 * WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_TYPE
 * TAX_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TRANSACTION_TYPE_DETERMINATION
 * TRANSACTION_TYPE_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#VALUE_DATE
 * VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CORPORATE_GROUP_ACCOUNT
 * CORPORATE_GROUP_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PLANNING_LEVEL
 * PLANNING_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PROJECT
 * PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BILLING_DOCUMENT
 * BILLING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ASSET_TRANSACTION_TYPE
 * ASSET_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ASSET_VALUE_DATE
 * ASSET_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PERSONNEL_NUMBER
 * PERSONNEL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_SALES_RELATED
 * IS_SALES_RELATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LINE_ITEM_DISPLAY_IS_ENABLED
 * LINE_ITEM_DISPLAY_IS_ENABLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_OPEN_ITEM_MANAGED
 * IS_OPEN_ITEM_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_NOT_CASH_DISCOUNT_LIABLE
 * IS_NOT_CASH_DISCOUNT_LIABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_AUTOMATICALLY_CREATED
 * IS_AUTOMATICALLY_CREATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_USED_IN_PAYMENT_TRANSACTION
 * IS_USED_IN_PAYMENT_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#OPERATIONAL_GL_ACCOUNT
 * OPERATIONAL_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#GL_ACCOUNT_NAME
 * GL_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#GL_ACCOUNT_LONG_NAME
 * GL_ACCOUNT_LONG_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CUSTOMER_NAME
 * CUSTOMER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SUPPLIER_NAME
 * SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BRANCH_ACCOUNT
 * BRANCH_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_BALANCE_SHEET_ACCOUNT
 * IS_BALANCE_SHEET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PROFIT_LOSS_ACCOUNT_TYPE
 * PROFIT_LOSS_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SPECIAL_GL_ACCOUNT_ASSIGNMENT
 * SPECIAL_GL_ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DUE_CALCULATION_BASE_DATE
 * DUE_CALCULATION_BASE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT1_DAYS
 * CASH_DISCOUNT1_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT2_DAYS
 * CASH_DISCOUNT2_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#NET_PAYMENT_DAYS
 * NET_PAYMENT_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT1_PERCENT
 * CASH_DISCOUNT1_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT2_PERCENT
 * CASH_DISCOUNT2_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_BLOCKING_REASON
 * PAYMENT_BLOCKING_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FIXED_CASH_DISCOUNT
 * FIXED_CASH_DISCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BP_BANK_ACCOUNT_INTERNAL_ID
 * BP_BANK_ACCOUNT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_DISTRIBUTION_CODE1
 * TAX_DISTRIBUTION_CODE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_DISTRIBUTION_CODE2
 * TAX_DISTRIBUTION_CODE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_DISTRIBUTION_CODE3
 * TAX_DISTRIBUTION_CODE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVOICE_REFERENCE
 * INVOICE_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVOICE_REFERENCE_FISCAL_YEAR
 * INVOICE_REFERENCE_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVOICE_ITEM_REFERENCE
 * INVOICE_ITEM_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FOLLOW_ON_DOCUMENT_TYPE
 * FOLLOW_ON_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#STATE_CENTRAL_BANK_PAYMENT_REASON
 * STATE_CENTRAL_BANK_PAYMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SUPPLYING_COUNTRY
 * SUPPLYING_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVOICE_LIST
 * INVOICE_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BILL_OF_EXCHANGE_USAGE
 * BILL_OF_EXCHANGE_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DUNNING_KEY
 * DUNNING_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DUNNING_BLOCKING_REASON
 * DUNNING_BLOCKING_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LAST_DUNNING_DATE
 * LAST_DUNNING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DUNNING_LEVEL
 * DUNNING_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DUNNING_AREA
 * DUNNING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#WITHHOLDING_TAX_CERTIFICATE
 * WITHHOLDING_TAX_CERTIFICATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNT_ASSIGNMENT_NUMBER
 * ACCOUNT_ASSIGNMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_COMPLETELY_DELIVERED
 * IS_COMPLETELY_DELIVERED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#MATERIAL_PRICE_CONTROL
 * MATERIAL_PRICE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#VALUATION_AREA
 * VALUATION_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVENTORY_VALUATION_TYPE
 * INVENTORY_VALUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#VAT_REGISTRATION
 * VAT_REGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DELIV_OF_GOODS_DEST_COUNTRY
 * DELIV_OF_GOODS_DEST_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_DIFFERENCE_REASON
 * PAYMENT_DIFFERENCE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PROFIT_CENTER_NAME
 * PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#JOINT_VENTURE
 * JOINT_VENTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#JOINT_VENTURE_COST_RECOVERY_CODE
 * JOINT_VENTURE_COST_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#JOINT_VENTURE_EQUITY_GROUP
 * JOINT_VENTURE_EQUITY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TREASURY_CONTRACT_TYPE
 * TREASURY_CONTRACT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ASSET_CONTRACT
 * ASSET_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_FLOW_TYPE
 * CASH_FLOW_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REAL_ESTATE_OBJECT
 * REAL_ESTATE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SETTLEMENT_REFERENCE_DATE
 * SETTLEMENT_REFERENCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COMMITMENT_ITEM
 * COMMITMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ORDER_INT_BILL_OF_OPERATIONS_ITEM
 * ORDER_INT_BILL_OF_OPERATIONS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#JOINT_VENTURE_EQUITY_TYPE
 * JOINT_VENTURE_EQUITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_EU_TRIANGULAR_DEAL
 * IS_EU_TRIANGULAR_DEAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COST_ORIGIN_GROUP
 * COST_ORIGIN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COMPANY_CODE_CURRENCY_DETN_METHOD
 * COMPANY_CODE_CURRENCY_DETN_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CLEARING_IS_REVERSED
 * CLEARING_IS_REVERSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_METHOD_SUPPLEMENT
 * PAYMENT_METHOD_SUPPLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ALTERNATIVE_GL_ACCOUNT
 * ALTERNATIVE_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FUNDS_CENTER
 * FUNDS_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REFERENCE1_I_D_BY_BUSINESS_PARTNER
 * REFERENCE1_I_D_BY_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REFERENCE2_I_D_BY_BUSINESS_PARTNER
 * REFERENCE2_I_D_BY_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_NEGATIVE_POSTING
 * IS_NEGATIVE_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_CARD_ITEM
 * PAYMENT_CARD_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_CARD_PAYMENT_SETTLEMENT
 * PAYMENT_CARD_PAYMENT_SETTLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CREDIT_CONTROL_AREA
 * CREDIT_CONTROL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REFERENCE3_I_D_BY_BUSINESS_PARTNER
 * REFERENCE3_I_D_BY_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DATA_EXCHANGE_INSTRUCTION1
 * DATA_EXCHANGE_INSTRUCTION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DATA_EXCHANGE_INSTRUCTION2
 * DATA_EXCHANGE_INSTRUCTION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DATA_EXCHANGE_INSTRUCTION3
 * DATA_EXCHANGE_INSTRUCTION3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DATA_EXCHANGE_INSTRUCTION4
 * DATA_EXCHANGE_INSTRUCTION4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#HAS_PAYMENT_ORDER
 * HAS_PAYMENT_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_REFERENCE
 * PAYMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_DETERMINATION_DATE
 * TAX_DETERMINATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CLEARING_ITEM
 * CLEARING_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BUSINESS_PLACE
 * BUSINESS_PLACE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_SECTION
 * TAX_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTS_RECEIVABLE_IS_PLEDGED
 * ACCOUNTS_RECEIVABLE_IS_PLEDGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FUNCTIONAL_AREA_NAME
 * FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CUSTOMER_IS_IN_EXECUTION
 * CUSTOMER_IS_IN_EXECUTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FUNDED_PROGRAM
 * FUNDED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CLEARING_DOC_FISCAL_YEAR
 * CLEARING_DOC_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LEDGER_GL_LINE_ITEM
 * LEDGER_GL_LINE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SEGMENT
 * SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SEGMENT_NAME
 * SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#HOUSE_BANK_ACCOUNT
 * HOUSE_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COST_ELEMENT
 * COST_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SEPA_MANDATE
 * SEPA_MANDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ORIGINAL_REFERENCE_DOCUMENT
 * ORIGINAL_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REFERENCE_DOCUMENT_LOGICAL_SYSTEM
 * REFERENCE_DOCUMENT_LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_ITEM_REF
 * ACCOUNTING_DOCUMENT_ITEM_REF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_CATEGORY
 * ACCOUNTING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_CATEGORY_NAME
 * ACCOUNTING_DOCUMENT_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_TYPE
 * ACCOUNTING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_TYPE_NAME
 * ACCOUNTING_DOCUMENT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#NET_DUE_DATE
 * NET_DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT1_DUE_DATE
 * CASH_DISCOUNT1_DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT2_DUE_DATE
 * CASH_DISCOUNT2_DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#OFFSETTING_ACCOUNT
 * OFFSETTING_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#OFFSETTING_ACCOUNT_TYPE
 * OFFSETTING_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_FUND
 * PARTNER_FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_GRANT
 * PARTNER_GRANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PARTNER_BUDGET_PERIOD
 * PARTNER_BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BRANCH_CODE
 * BRANCH_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_AMOUNT_IN_CO_CODE_CRCY
 * TAX_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_BASE_AMOUNT_IN_CO_CODE_CRCY
 * TAX_BASE_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#VALUATION_DIFF_AMT_IN_CO_CODE_CRCY
 * VALUATION_DIFF_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT_AMT_IN_CO_CODE_CRCY
 * CASH_DISCOUNT_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVOICE_AMT_IN_CO_CODE_CRCY
 * INVOICE_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ORIGINAL_TAX_BASE_AMOUNT
 * ORIGINAL_TAX_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_AMOUNT
 * TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_BASE_AMOUNT_IN_TRANS_CRCY
 * TAX_BASE_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#WITHHOLDING_TAX_BASE_AMOUNT
 * WITHHOLDING_TAX_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PLANNED_AMT_IN_TRANSACTION_CRCY
 * PLANNED_AMT_IN_TRANSACTION_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT_BASE_AMOUNT
 * CASH_DISCOUNT_BASE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CASH_DISCOUNT_AMOUNT
 * CASH_DISCOUNT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#NET_PAYMENT_AMOUNT
 * NET_PAYMENT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#WITHHOLDING_TAX_AMOUNT
 * WITHHOLDING_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#WITHHOLDING_TAX_EXEMPTION_AMT
 * WITHHOLDING_TAX_EXEMPTION_AMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVOICE_AMOUNT_IN_FRGN_CURRENCY
 * INVOICE_AMOUNT_IN_FRGN_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BALANCE_TRANSACTION_CURRENCY
 * BALANCE_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#AMOUNT_IN_BALANCE_TRANSAC_CRCY
 * AMOUNT_IN_BALANCE_TRANSAC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ADDITIONAL_CURRENCY1
 * ADDITIONAL_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#VALUATION_DIFF_AMT_IN_ADDL_CRCY1
 * VALUATION_DIFF_AMT_IN_ADDL_CRCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#AMOUNT_IN_ADDITIONAL_CURRENCY1
 * AMOUNT_IN_ADDITIONAL_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ADDITIONAL_CURRENCY2
 * ADDITIONAL_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#AMOUNT_IN_ADDITIONAL_CURRENCY2
 * AMOUNT_IN_ADDITIONAL_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#VALUATION_DIFF_AMT_IN_ADDL_CRCY2
 * VALUATION_DIFF_AMT_IN_ADDL_CRCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PAYMENT_CURRENCY
 * PAYMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#AMOUNT_IN_PAYMENT_CURRENCY
 * AMOUNT_IN_PAYMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CREDIT_CONTROL_AREA_CURRENCY
 * CREDIT_CONTROL_AREA_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#HEDGED_AMOUNT
 * HEDGED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#GOODS_MOVEMENT_ENTRY_UNIT
 * GOODS_MOVEMENT_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#QUANTITY_IN_ENTRY_UNIT
 * QUANTITY_IN_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PURCHASING_DOCUMENT_PRICE_UNIT
 * PURCHASING_DOCUMENT_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PURCHASE_ORDER_QTY
 * PURCHASE_ORDER_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#MATERIAL_PRICE_UNIT_QTY
 * MATERIAL_PRICE_UNIT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#NUMBER_OF_ITEMS
 * NUMBER_OF_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_CREATION_DATE
 * ACCOUNTING_DOCUMENT_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#EXCHANGE_RATE_DATE
 * EXCHANGE_RATE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOC_CREATED_BY_USER
 * ACCOUNTING_DOC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TRANSACTION_CODE
 * TRANSACTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INTERCOMPANY_TRANSACTION
 * INTERCOMPANY_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#DOCUMENT_REFERENCE_ID
 * DOCUMENT_REFERENCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#RECURRING_ACCOUNTING_DOCUMENT
 * RECURRING_ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REVERSE_DOCUMENT
 * REVERSE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REVERSE_DOCUMENT_FISCAL_YEAR
 * REVERSE_DOCUMENT_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_HEADER_TEXT
 * ACCOUNTING_DOCUMENT_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#EXCHANGE_RATE
 * EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BUSINESS_TRANSACTION_TYPE
 * BUSINESS_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BATCH_INPUT_SESSION
 * BATCH_INPUT_SESSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REVERSAL_IS_PLANNED
 * REVERSAL_IS_PLANNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#PLANNED_REVERSAL_DATE
 * PLANNED_REVERSAL_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_IS_CALCULATED_AUTOMATICALLY
 * TAX_IS_CALCULATED_AUTOMATICALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_BASE_AMOUNT_IS_NET_AMOUNT
 * TAX_BASE_AMOUNT_IS_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SOURCE_COMPANY_CODE
 * SOURCE_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LOGICAL_SYSTEM
 * LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_EXCHANGE_RATE
 * TAX_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REVERSAL_REASON
 * REVERSAL_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#BRANCH
 * BRANCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REFERENCE1_IN_DOCUMENT_HEADER
 * REFERENCE1_IN_DOCUMENT_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#REFERENCE2_IN_DOCUMENT_HEADER
 * REFERENCE2_IN_DOCUMENT_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#INVOICE_RECEIPT_DATE
 * INVOICE_RECEIPT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LEDGER_GROUP
 * LEDGER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ALTERNATIVE_REFERENCE_DOCUMENT
 * ALTERNATIVE_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#TAX_REPORTING_DATE
 * TAX_REPORTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#ACCOUNTING_DOCUMENT_CLASS
 * ACCOUNTING_DOCUMENT_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#EXCHANGE_RATE_TYPE
 * EXCHANGE_RATE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#LATE_PAYMENT_REASON
 * LATE_PAYMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#SALES_DOCUMENT_CONDITION
 * SALES_DOCUMENT_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_REVERSAL
 * IS_REVERSAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.accountingdocument.OperationalAcctgDocItemCube#IS_REVERSED
 * IS_REVERSED}</li>
 * </ul>
 *
 */
public interface OperationalAcctgDocItemCubeSelectable extends EntitySelectable<OperationalAcctgDocItemCube>
{

}
