/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ActivityTypeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService ActivityTypeService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultActivityTypeServiceBatch
    extends
    BatchFluentHelperBasic<ActivityTypeServiceBatch, ActivityTypeServiceBatchChangeSet>
    implements
    ActivityTypeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultActivityTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultActivityTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultActivityTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultActivityTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultActivityTypeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ActivityTypeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultActivityTypeServiceBatchChangeSet(this, service);
    }

}
