/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ActivityTypeServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService ActivityTypeService}.
 *
 */
public class DefaultActivityTypeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ActivityTypeServiceBatch, ActivityTypeServiceBatchChangeSet>
    implements
    ActivityTypeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService service;

    @SuppressWarnings( "deprecation" )
    DefaultActivityTypeServiceBatchChangeSet(
        @Nonnull final DefaultActivityTypeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ActivityTypeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultActivityTypeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
