/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType
 * CostCenterActivityType}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.field.CostCenterActivityTypeField
 * CostCenterActivityTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.link.CostCenterActivityTypeLink
 * CostCenterActivityTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#COST_CTR_ACTIVITY_TYPE_QTY_UNIT
 * COST_CTR_ACTIVITY_TYPE_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#COST_CTR_ACTIVITY_TYPE_CATEGORY
 * COST_CTR_ACTIVITY_TYPE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#ALLOCATION_COST_ELEMENT
 * ALLOCATION_COST_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#COST_CTR_ACTIVITY_TYPE_OUTP_QTY_UNIT
 * COST_CTR_ACTIVITY_TYPE_OUTP_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#ENTERED_BY_USER
 * ENTERED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#COST_ORIGIN_GROUP
 * COST_ORIGIN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#ACTL_POSTG_COST_CENTER_ACTY_TYPE_CAT
 * ACTL_POSTG_COST_CENTER_ACTY_TYPE_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#OUTPUT_QUANTITY_FACTOR
 * OUTPUT_QUANTITY_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#ACTIVITY_TYPE_IS_BLOCKED
 * ACTIVITY_TYPE_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#FIXED_COST_IS_PREDISTRIBUTED
 * FIXED_COST_IS_PREDISTRIBUTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#PRICE_ALLOCATION_METHOD
 * PRICE_ALLOCATION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#PERIOD_PRICE_IS_AVERAGE
 * PERIOD_PRICE_IS_AVERAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#ACTUAL_PRICE_ALLOCATION_METHOD
 * ACTUAL_PRICE_ALLOCATION_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#ACTUAL_QUANTITY_IS_SET_MANUALLY
 * ACTUAL_QUANTITY_IS_SET_MANUALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#PLAN_QUANTITY_IS_SET_MANUALLY
 * PLAN_QUANTITY_IS_SET_MANUALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#COST_CTR_ACTIVITY_TYPE_VALID_CAT
 * COST_CTR_ACTIVITY_TYPE_VALID_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityType#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface CostCenterActivityTypeSelectable extends EntitySelectable<CostCenterActivityType>
{

}
