/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.field.AllowlistField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.selectable.AllowlistSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Allowlist Company Codes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AllowlistType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Allowlist extends VdmEntity<Allowlist>
{

    /**
     * Selector for all available fields of Allowlist.
     *
     */
    public final static AllowlistSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SenderCompanyCode</b>
     * </p>
     *
     * @return Sender Company Code
     */
    @Key
    @SerializedName( "SenderCompanyCode" )
    @JsonProperty( "SenderCompanyCode" )
    @Nullable
    @ODataField( odataName = "SenderCompanyCode" )
    private String senderCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>SenderCompanyCode</b> field to query operations.
     *
     */
    public final static AllowlistField<String> SENDER_COMPANY_CODE = new AllowlistField<String>("SenderCompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceiverCompanyCode</b>
     * </p>
     *
     * @return Receiver Company Code
     */
    @Key
    @SerializedName( "ReceiverCompanyCode" )
    @JsonProperty( "ReceiverCompanyCode" )
    @Nullable
    @ODataField( odataName = "ReceiverCompanyCode" )
    private String receiverCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>ReceiverCompanyCode</b> field to query operations.
     *
     */
    public final static AllowlistField<String> RECEIVER_COMPANY_CODE =
        new AllowlistField<String>("ReceiverCompanyCode");

    @Nonnull
    @Override
    public Class<Allowlist> getType()
    {
        return Allowlist.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SenderCompanyCode</b>
     * </p>
     *
     * @param senderCompanyCode
     *            Sender Company Code
     */
    public void setSenderCompanyCode( @Nullable final String senderCompanyCode )
    {
        rememberChangedField("SenderCompanyCode", this.senderCompanyCode);
        this.senderCompanyCode = senderCompanyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceiverCompanyCode</b>
     * </p>
     *
     * @param receiverCompanyCode
     *            Receiver Company Code
     */
    public void setReceiverCompanyCode( @Nullable final String receiverCompanyCode )
    {
        rememberChangedField("ReceiverCompanyCode", this.receiverCompanyCode);
        this.receiverCompanyCode = receiverCompanyCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Allowlist";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SenderCompanyCode", getSenderCompanyCode());
        result.put("ReceiverCompanyCode", getReceiverCompanyCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SenderCompanyCode", getSenderCompanyCode());
        values.put("ReceiverCompanyCode", getReceiverCompanyCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SenderCompanyCode") ) {
                final Object value = values.remove("SenderCompanyCode");
                if( (value == null) || (!value.equals(getSenderCompanyCode())) ) {
                    setSenderCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ReceiverCompanyCode") ) {
                final Object value = values.remove("ReceiverCompanyCode");
                if( (value == null) || (!value.equals(getReceiverCompanyCode())) ) {
                    setReceiverCompanyCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> AllowlistField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AllowlistField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AllowlistField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AllowlistField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService.DEFAULT_SERVICE_PATH);
    }

}
