/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.selectable.AllowlistSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist Allowlist} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class AllowlistByKeyFluentHelper
    extends
    FluentHelperByKey<AllowlistByKeyFluentHelper, Allowlist, AllowlistSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist Allowlist}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code Allowlist}
     * @param senderCompanyCode
     *            Sender Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code Allowlist}
     * @param receiverCompanyCode
     *            Receiver Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public AllowlistByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String senderCompanyCode,
        final String receiverCompanyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("SenderCompanyCode", senderCompanyCode);
        this.key.put("ReceiverCompanyCode", receiverCompanyCode);
    }

    @Override
    @Nonnull
    protected Class<Allowlist> getEntityClass()
    {
        return Allowlist.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
