/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link AllowlistIntercompanyPostingServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService
 * AllowlistIntercompanyPostingService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultAllowlistIntercompanyPostingServiceBatch
    extends
    BatchFluentHelperBasic<AllowlistIntercompanyPostingServiceBatch, AllowlistIntercompanyPostingServiceBatchChangeSet>
    implements
    AllowlistIntercompanyPostingServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultAllowlistIntercompanyPostingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultAllowlistIntercompanyPostingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultAllowlistIntercompanyPostingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultAllowlistIntercompanyPostingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultAllowlistIntercompanyPostingServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public AllowlistIntercompanyPostingServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultAllowlistIntercompanyPostingServiceBatchChangeSet(this, service);
    }

}
