/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link AllowlistIntercompanyPostingServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService
 * AllowlistIntercompanyPostingService}.
 *
 */
public class DefaultAllowlistIntercompanyPostingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<AllowlistIntercompanyPostingServiceBatch, AllowlistIntercompanyPostingServiceBatchChangeSet>
    implements
    AllowlistIntercompanyPostingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService service;

    @SuppressWarnings( "deprecation" )
    DefaultAllowlistIntercompanyPostingServiceBatchChangeSet(
        @Nonnull final DefaultAllowlistIntercompanyPostingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.AllowlistIntercompanyPostingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultAllowlistIntercompanyPostingServiceBatchChangeSet getThis()
    {
        return this;
    }

}
