/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist Allowlist}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.field.AllowlistField
 * AllowlistField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.link.AllowlistLink
 * AllowlistLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist#SENDER_COMPANY_CODE
 * SENDER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.Allowlist#RECEIVER_COMPANY_CODE
 * RECEIVER_COMPANY_CODE}</li>
 * </ul>
 *
 */
public interface AllowlistSelectable extends EntitySelectable<Allowlist>
{

}
