/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>AssignDocument</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AssignDocument extends VdmComplex<AssignDocument>
{

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>IsAssigned</b>
     * </p>
     *
     * @param isAssigned
     *
     * @return IsAssigned
     */
    @SerializedName( "IsAssigned" )
    @JsonProperty( "IsAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsAssigned" )
    private Boolean isAssigned;

    @Nonnull
    @Override
    public Class<AssignDocument> getType()
    {
        return AssignDocument.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsAssigned", getIsAssigned());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsAssigned") ) {
                final Object value = values.remove("IsAssigned");
                if( (value == null) || (!value.equals(getIsAssigned())) ) {
                    setIsAssigned(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>IsAssigned</b>
     * </p>
     *
     * @param isAssigned
     *            IsAssigned
     */
    public void setIsAssigned( @Nullable final Boolean isAssigned )
    {
        rememberChangedField("IsAssigned", this.isAssigned);
        this.isAssigned = isAssigned;
    }

}
