/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.net.URI;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>AssignDocumentToBusinessObject</b> OData function import.
 *
 */
public class AssignDocumentToBusinessObjectFluentHelper
    extends
    SingleValuedFluentHelperFunction<AssignDocumentToBusinessObjectFluentHelper, AssignDocument, AssignDocument>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>AssignDocumentToBusinessObject</b> OData function import
     * with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param targetLinkedSAPObjectKey
     *            TargetLinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetLinkedSAPObjectKey</b>
     *            </p>
     * @param sourceSAPObjectNodeType
     *            SourceSAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceSAPObjectNodeType</b>
     *            </p>
     * @param sourceSAPObjectType
     *            SourceSAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceSAPObjectType</b>
     *            </p>
     * @param sourceLinkedSAPObjectKey
     *            SourceLinkedSAPObjectKey
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceLinkedSAPObjectKey</b>
     *            </p>
     * @param targetBusinessObjectTypeName
     *            TargetBusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetBusinessObjectTypeName</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ArchiveDocumentID</b>
     *            </p>
     * @param targetSAPObjectNodeType
     *            TargetSAPObjectNodeType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetSAPObjectNodeType</b>
     *            </p>
     * @param sourceBusinessObjectTypeName
     *            SourceBusinessObjectTypeName
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceBusinessObjectTypeName</b>
     *            </p>
     * @param targetSAPObjectType
     *            TargetSAPObjectType
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetSAPObjectType</b>
     *            </p>
     */
    public AssignDocumentToBusinessObjectFluentHelper(
        @Nonnull final String servicePath,
        @Nullable final String targetSAPObjectType,
        @Nullable final String targetSAPObjectNodeType,
        @Nullable final String targetBusinessObjectTypeName,
        @Nonnull final String targetLinkedSAPObjectKey,
        @Nullable final String archiveDocumentID,
        @Nullable final String sourceSAPObjectType,
        @Nullable final String sourceSAPObjectNodeType,
        @Nullable final String sourceBusinessObjectTypeName,
        @Nonnull final String sourceLinkedSAPObjectKey )
    {
        super(servicePath);
        if( targetSAPObjectType != null ) {
            values.put("TargetSAPObjectType", targetSAPObjectType);
        }
        if( targetSAPObjectNodeType != null ) {
            values.put("TargetSAPObjectNodeType", targetSAPObjectNodeType);
        }
        if( targetBusinessObjectTypeName != null ) {
            values.put("TargetBusinessObjectTypeName", targetBusinessObjectTypeName);
        }
        values.put("TargetLinkedSAPObjectKey", targetLinkedSAPObjectKey);
        if( archiveDocumentID != null ) {
            values.put("ArchiveDocumentID", archiveDocumentID);
        }
        if( sourceSAPObjectType != null ) {
            values.put("SourceSAPObjectType", sourceSAPObjectType);
        }
        if( sourceSAPObjectNodeType != null ) {
            values.put("SourceSAPObjectNodeType", sourceSAPObjectNodeType);
        }
        if( sourceBusinessObjectTypeName != null ) {
            values.put("SourceBusinessObjectTypeName", sourceBusinessObjectTypeName);
        }
        values.put("SourceLinkedSAPObjectKey", sourceLinkedSAPObjectKey);
    }

    @Override
    @Nonnull
    protected Class<AssignDocument> getEntityClass()
    {
        return AssignDocument.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "AssignDocumentToBusinessObject";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public AssignDocument executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
