/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmMediaEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.AttachmentContentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable.AttachmentContentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Document Management
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AttachmentContent</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AttachmentContent extends VdmMediaEntity<AttachmentContent>
{

    /**
     * Selector for all available fields of AttachmentContent.
     *
     */
    public final static AttachmentContentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return DocumentInfoRecordDocType
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new AttachmentContentField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return DocumentInfoRecordDocNumber
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new AttachmentContentField<String>("DocumentInfoRecordDocNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return DocumentInfoRecordDocVersion
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new AttachmentContentField<String>("DocumentInfoRecordDocVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return DocumentInfoRecordDocPart
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new AttachmentContentField<String>("DocumentInfoRecordDocPart");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>LogicalDocument</b>
     * </p>
     *
     * @return LogicalDocument
     */
    @Key
    @SerializedName( "LogicalDocument" )
    @JsonProperty( "LogicalDocument" )
    @Nullable
    @ODataField( odataName = "LogicalDocument" )
    private String logicalDocument;
    /**
     * Use with available fluent helpers to apply the <b>LogicalDocument</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> LOGICAL_DOCUMENT =
        new AttachmentContentField<String>("LogicalDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveDocumentID</b>
     * </p>
     *
     * @return ArchiveDocumentID
     */
    @Key
    @SerializedName( "ArchiveDocumentID" )
    @JsonProperty( "ArchiveDocumentID" )
    @Nullable
    @ODataField( odataName = "ArchiveDocumentID" )
    private String archiveDocumentID;
    /**
     * Use with available fluent helpers to apply the <b>ArchiveDocumentID</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> ARCHIVE_DOCUMENT_ID =
        new AttachmentContentField<String>("ArchiveDocumentID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @return LinkedSAPObjectKey
     */
    @Key
    @SerializedName( "LinkedSAPObjectKey" )
    @JsonProperty( "LinkedSAPObjectKey" )
    @Nullable
    @ODataField( odataName = "LinkedSAPObjectKey" )
    private String linkedSAPObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>LinkedSAPObjectKey</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> LINKED_SAP_OBJECT_KEY =
        new AttachmentContentField<String>("LinkedSAPObjectKey");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectTypeName</b>
     * </p>
     *
     * @return BusinessObjectTypeName
     */
    @Key
    @SerializedName( "BusinessObjectTypeName" )
    @JsonProperty( "BusinessObjectTypeName" )
    @Nullable
    @ODataField( odataName = "BusinessObjectTypeName" )
    private String businessObjectTypeName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessObjectTypeName</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> BUSINESS_OBJECT_TYPE_NAME =
        new AttachmentContentField<String>("BusinessObjectTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SemanticObject</b>
     * </p>
     *
     * @return SemanticObject
     */
    @SerializedName( "SemanticObject" )
    @JsonProperty( "SemanticObject" )
    @Nullable
    @ODataField( odataName = "SemanticObject" )
    private String semanticObject;
    /**
     * Use with available fluent helpers to apply the <b>SemanticObject</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> SEMANTIC_OBJECT =
        new AttachmentContentField<String>("SemanticObject");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkstationApplication</b>
     * </p>
     *
     * @return WorkstationApplication
     */
    @SerializedName( "WorkstationApplication" )
    @JsonProperty( "WorkstationApplication" )
    @Nullable
    @ODataField( odataName = "WorkstationApplication" )
    private String workstationApplication;
    /**
     * Use with available fluent helpers to apply the <b>WorkstationApplication</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> WORKSTATION_APPLICATION =
        new AttachmentContentField<String>("WorkstationApplication");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FileSize</b>
     * </p>
     *
     * @return FileSize
     */
    @SerializedName( "FileSize" )
    @JsonProperty( "FileSize" )
    @Nullable
    @ODataField( odataName = "FileSize" )
    private String fileSize;
    /**
     * Use with available fluent helpers to apply the <b>FileSize</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> FILE_SIZE = new AttachmentContentField<String>("FileSize");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @return FileName
     */
    @SerializedName( "FileName" )
    @JsonProperty( "FileName" )
    @Nullable
    @ODataField( odataName = "FileName" )
    private String fileName;
    /**
     * Use with available fluent helpers to apply the <b>FileName</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> FILE_NAME = new AttachmentContentField<String>("FileName");
    /**
     * Constraints: Not nullable, Maximum length: 4096
     * <p>
     * Original property name from the Odata EDM: <b>DocumentURL</b>
     * </p>
     *
     * @return DocumentURL
     */
    @SerializedName( "DocumentURL" )
    @JsonProperty( "DocumentURL" )
    @Nullable
    @ODataField( odataName = "DocumentURL" )
    private String documentURL;
    /**
     * Use with available fluent helpers to apply the <b>DocumentURL</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> DOCUMENT_URL = new AttachmentContentField<String>("DocumentURL");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     *
     * @return MimeType
     */
    @SerializedName( "MimeType" )
    @JsonProperty( "MimeType" )
    @Nullable
    @ODataField( odataName = "MimeType" )
    private String mimeType;
    /**
     * Use with available fluent helpers to apply the <b>MimeType</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> MIME_TYPE = new AttachmentContentField<String>("MimeType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Content</b>
     * </p>
     *
     * @return AttachmentContent
     */
    @SerializedName( "Content" )
    @JsonProperty( "Content" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBinaryAdapter.class )
    @ODataField( odataName = "Content" )
    private byte[] content;
    /**
     * Use with available fluent helpers to apply the <b>Content</b> field to query operations.
     *
     */
    public final static AttachmentContentField<byte[]> CONTENT = new AttachmentContentField<byte[]>("Content");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return CreatedByUser
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> CREATED_BY_USER =
        new AttachmentContentField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserFullName</b>
     * </p>
     *
     * @return CreatedByUserFullName
     */
    @SerializedName( "CreatedByUserFullName" )
    @JsonProperty( "CreatedByUserFullName" )
    @Nullable
    @ODataField( odataName = "CreatedByUserFullName" )
    private String createdByUserFullName;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUserFullName</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> CREATED_BY_USER_FULL_NAME =
        new AttachmentContentField<String>("CreatedByUserFullName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return CreationDateTime
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static AttachmentContentField<LocalDateTime> CREATION_DATE_TIME =
        new AttachmentContentField<LocalDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectType</b>
     * </p>
     *
     * @return BusinessObjectType
     */
    @SerializedName( "BusinessObjectType" )
    @JsonProperty( "BusinessObjectType" )
    @Nullable
    @ODataField( odataName = "BusinessObjectType" )
    private String businessObjectType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessObjectType</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> BUSINESS_OBJECT_TYPE =
        new AttachmentContentField<String>("BusinessObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return LastChangedByUser
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> LAST_CHANGED_BY_USER =
        new AttachmentContentField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUserFullName</b>
     * </p>
     *
     * @return LastChangedByUserFullName
     */
    @SerializedName( "LastChangedByUserFullName" )
    @JsonProperty( "LastChangedByUserFullName" )
    @Nullable
    @ODataField( odataName = "LastChangedByUserFullName" )
    private String lastChangedByUserFullName;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUserFullName</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> LAST_CHANGED_BY_USER_FULL_NAME =
        new AttachmentContentField<String>("LastChangedByUserFullName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return ChangedDateTime
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static AttachmentContentField<LocalDateTime> CHANGED_DATE_TIME =
        new AttachmentContentField<LocalDateTime>("ChangedDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageCategory</b>
     * </p>
     *
     * @return StorageCategory
     */
    @SerializedName( "StorageCategory" )
    @JsonProperty( "StorageCategory" )
    @Nullable
    @ODataField( odataName = "StorageCategory" )
    private String storageCategory;
    /**
     * Use with available fluent helpers to apply the <b>StorageCategory</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> STORAGE_CATEGORY =
        new AttachmentContentField<String>("StorageCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveLinkRepository</b>
     * </p>
     *
     * @return ArchiveLinkRepository
     */
    @SerializedName( "ArchiveLinkRepository" )
    @JsonProperty( "ArchiveLinkRepository" )
    @Nullable
    @ODataField( odataName = "ArchiveLinkRepository" )
    private String archiveLinkRepository;
    /**
     * Use with available fluent helpers to apply the <b>ArchiveLinkRepository</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> ARCHIVE_LINK_REPOSITORY =
        new AttachmentContentField<String>("ArchiveLinkRepository");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAPObjectType
     */
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> SAP_OBJECT_TYPE =
        new AttachmentContentField<String>("SAPObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectNodeType</b>
     * </p>
     *
     * @return SAPObjectNodeType
     */
    @SerializedName( "SAPObjectNodeType" )
    @JsonProperty( "SAPObjectNodeType" )
    @Nullable
    @ODataField( odataName = "SAPObjectNodeType" )
    private String sAPObjectNodeType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectNodeType</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> SAP_OBJECT_NODE_TYPE =
        new AttachmentContentField<String>("SAPObjectNodeType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HarmonizedDocumentType</b>
     * </p>
     *
     * @return HarmonizedDocumentType
     */
    @SerializedName( "HarmonizedDocumentType" )
    @JsonProperty( "HarmonizedDocumentType" )
    @Nullable
    @ODataField( odataName = "HarmonizedDocumentType" )
    private String harmonizedDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>HarmonizedDocumentType</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> HARMONIZED_DOCUMENT_TYPE =
        new AttachmentContentField<String>("HarmonizedDocumentType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentDeletionIsAllowed</b>
     * </p>
     *
     * @return AttachmentDeletionIsAllowed
     */
    @SerializedName( "AttachmentDeletionIsAllowed" )
    @JsonProperty( "AttachmentDeletionIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AttachmentDeletionIsAllowed" )
    private Boolean attachmentDeletionIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>AttachmentDeletionIsAllowed</b> field to query operations.
     *
     */
    public final static AttachmentContentField<Boolean> ATTACHMENT_DELETION_IS_ALLOWED =
        new AttachmentContentField<Boolean>("AttachmentDeletionIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentRenameIsAllowed</b>
     * </p>
     *
     * @return AttachmentRenameIsAllowed
     */
    @SerializedName( "AttachmentRenameIsAllowed" )
    @JsonProperty( "AttachmentRenameIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AttachmentRenameIsAllowed" )
    private Boolean attachmentRenameIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>AttachmentRenameIsAllowed</b> field to query operations.
     *
     */
    public final static AttachmentContentField<Boolean> ATTACHMENT_RENAME_IS_ALLOWED =
        new AttachmentContentField<Boolean>("AttachmentRenameIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Source</b>
     * </p>
     *
     * @return Source
     */
    @SerializedName( "Source" )
    @JsonProperty( "Source" )
    @Nullable
    @ODataField( odataName = "Source" )
    private String source;
    /**
     * Use with available fluent helpers to apply the <b>Source</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> SOURCE = new AttachmentContentField<String>("Source");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentContentHash</b>
     * </p>
     *
     * @return AtttachmentContentHash
     */
    @SerializedName( "AttachmentContentHash" )
    @JsonProperty( "AttachmentContentHash" )
    @Nullable
    @ODataField( odataName = "AttachmentContentHash" )
    private String attachmentContentHash;
    /**
     * Use with available fluent helpers to apply the <b>AttachmentContentHash</b> field to query operations.
     *
     */
    public final static AttachmentContentField<String> ATTACHMENT_CONTENT_HASH =
        new AttachmentContentField<String>("AttachmentContentHash");

    @Nonnull
    @Override
    public Class<AttachmentContent> getType()
    {
        return AttachmentContent.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            DocumentInfoRecordDocType
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            DocumentInfoRecordDocNumber
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            DocumentInfoRecordDocVersion
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            DocumentInfoRecordDocPart
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>LogicalDocument</b>
     * </p>
     *
     * @param logicalDocument
     *            LogicalDocument
     */
    public void setLogicalDocument( @Nullable final String logicalDocument )
    {
        rememberChangedField("LogicalDocument", this.logicalDocument);
        this.logicalDocument = logicalDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveDocumentID</b>
     * </p>
     *
     * @param archiveDocumentID
     *            ArchiveDocumentID
     */
    public void setArchiveDocumentID( @Nullable final String archiveDocumentID )
    {
        rememberChangedField("ArchiveDocumentID", this.archiveDocumentID);
        this.archiveDocumentID = archiveDocumentID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     */
    public void setLinkedSAPObjectKey( @Nullable final String linkedSAPObjectKey )
    {
        rememberChangedField("LinkedSAPObjectKey", this.linkedSAPObjectKey);
        this.linkedSAPObjectKey = linkedSAPObjectKey;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectTypeName</b>
     * </p>
     *
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     */
    public void setBusinessObjectTypeName( @Nullable final String businessObjectTypeName )
    {
        rememberChangedField("BusinessObjectTypeName", this.businessObjectTypeName);
        this.businessObjectTypeName = businessObjectTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SemanticObject</b>
     * </p>
     *
     * @param semanticObject
     *            SemanticObject
     */
    public void setSemanticObject( @Nullable final String semanticObject )
    {
        rememberChangedField("SemanticObject", this.semanticObject);
        this.semanticObject = semanticObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkstationApplication</b>
     * </p>
     *
     * @param workstationApplication
     *            WorkstationApplication
     */
    public void setWorkstationApplication( @Nullable final String workstationApplication )
    {
        rememberChangedField("WorkstationApplication", this.workstationApplication);
        this.workstationApplication = workstationApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FileSize</b>
     * </p>
     *
     * @param fileSize
     *            FileSize
     */
    public void setFileSize( @Nullable final String fileSize )
    {
        rememberChangedField("FileSize", this.fileSize);
        this.fileSize = fileSize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @param fileName
     *            FileName
     */
    public void setFileName( @Nullable final String fileName )
    {
        rememberChangedField("FileName", this.fileName);
        this.fileName = fileName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4096
     * <p>
     * Original property name from the Odata EDM: <b>DocumentURL</b>
     * </p>
     *
     * @param documentURL
     *            DocumentURL
     */
    public void setDocumentURL( @Nullable final String documentURL )
    {
        rememberChangedField("DocumentURL", this.documentURL);
        this.documentURL = documentURL;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     *
     * @param mimeType
     *            MimeType
     */
    public void setMimeType( @Nullable final String mimeType )
    {
        rememberChangedField("MimeType", this.mimeType);
        this.mimeType = mimeType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Content</b>
     * </p>
     *
     * @param content
     *            AttachmentContent
     */
    public void setContent( @Nullable final byte[] content )
    {
        rememberChangedField("Content", this.content);
        this.content = content;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            CreatedByUser
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserFullName</b>
     * </p>
     *
     * @param createdByUserFullName
     *            CreatedByUserFullName
     */
    public void setCreatedByUserFullName( @Nullable final String createdByUserFullName )
    {
        rememberChangedField("CreatedByUserFullName", this.createdByUserFullName);
        this.createdByUserFullName = createdByUserFullName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            CreationDateTime
     */
    public void setCreationDateTime( @Nullable final LocalDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectType</b>
     * </p>
     *
     * @param businessObjectType
     *            BusinessObjectType
     */
    public void setBusinessObjectType( @Nullable final String businessObjectType )
    {
        rememberChangedField("BusinessObjectType", this.businessObjectType);
        this.businessObjectType = businessObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            LastChangedByUser
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUserFullName</b>
     * </p>
     *
     * @param lastChangedByUserFullName
     *            LastChangedByUserFullName
     */
    public void setLastChangedByUserFullName( @Nullable final String lastChangedByUserFullName )
    {
        rememberChangedField("LastChangedByUserFullName", this.lastChangedByUserFullName);
        this.lastChangedByUserFullName = lastChangedByUserFullName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            ChangedDateTime
     */
    public void setChangedDateTime( @Nullable final LocalDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageCategory</b>
     * </p>
     *
     * @param storageCategory
     *            StorageCategory
     */
    public void setStorageCategory( @Nullable final String storageCategory )
    {
        rememberChangedField("StorageCategory", this.storageCategory);
        this.storageCategory = storageCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveLinkRepository</b>
     * </p>
     *
     * @param archiveLinkRepository
     *            ArchiveLinkRepository
     */
    public void setArchiveLinkRepository( @Nullable final String archiveLinkRepository )
    {
        rememberChangedField("ArchiveLinkRepository", this.archiveLinkRepository);
        this.archiveLinkRepository = archiveLinkRepository;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAPObjectType
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectNodeType</b>
     * </p>
     *
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     */
    public void setSAPObjectNodeType( @Nullable final String sAPObjectNodeType )
    {
        rememberChangedField("SAPObjectNodeType", this.sAPObjectNodeType);
        this.sAPObjectNodeType = sAPObjectNodeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HarmonizedDocumentType</b>
     * </p>
     *
     * @param harmonizedDocumentType
     *            HarmonizedDocumentType
     */
    public void setHarmonizedDocumentType( @Nullable final String harmonizedDocumentType )
    {
        rememberChangedField("HarmonizedDocumentType", this.harmonizedDocumentType);
        this.harmonizedDocumentType = harmonizedDocumentType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentDeletionIsAllowed</b>
     * </p>
     *
     * @param attachmentDeletionIsAllowed
     *            AttachmentDeletionIsAllowed
     */
    public void setAttachmentDeletionIsAllowed( @Nullable final Boolean attachmentDeletionIsAllowed )
    {
        rememberChangedField("AttachmentDeletionIsAllowed", this.attachmentDeletionIsAllowed);
        this.attachmentDeletionIsAllowed = attachmentDeletionIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentRenameIsAllowed</b>
     * </p>
     *
     * @param attachmentRenameIsAllowed
     *            AttachmentRenameIsAllowed
     */
    public void setAttachmentRenameIsAllowed( @Nullable final Boolean attachmentRenameIsAllowed )
    {
        rememberChangedField("AttachmentRenameIsAllowed", this.attachmentRenameIsAllowed);
        this.attachmentRenameIsAllowed = attachmentRenameIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Source</b>
     * </p>
     *
     * @param source
     *            Source
     */
    public void setSource( @Nullable final String source )
    {
        rememberChangedField("Source", this.source);
        this.source = source;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentContentHash</b>
     * </p>
     *
     * @param attachmentContentHash
     *            AtttachmentContentHash
     */
    public void setAttachmentContentHash( @Nullable final String attachmentContentHash )
    {
        rememberChangedField("AttachmentContentHash", this.attachmentContentHash);
        this.attachmentContentHash = attachmentContentHash;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AttachmentContentSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        result.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        result.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        result.put("LogicalDocument", getLogicalDocument());
        result.put("ArchiveDocumentID", getArchiveDocumentID());
        result.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        result.put("BusinessObjectTypeName", getBusinessObjectTypeName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("LogicalDocument", getLogicalDocument());
        values.put("ArchiveDocumentID", getArchiveDocumentID());
        values.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        values.put("BusinessObjectTypeName", getBusinessObjectTypeName());
        values.put("SemanticObject", getSemanticObject());
        values.put("WorkstationApplication", getWorkstationApplication());
        values.put("FileSize", getFileSize());
        values.put("FileName", getFileName());
        values.put("DocumentURL", getDocumentURL());
        values.put("MimeType", getMimeType());
        values.put("Content", getContent());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreatedByUserFullName", getCreatedByUserFullName());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("BusinessObjectType", getBusinessObjectType());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangedByUserFullName", getLastChangedByUserFullName());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("StorageCategory", getStorageCategory());
        values.put("ArchiveLinkRepository", getArchiveLinkRepository());
        values.put("SAPObjectType", getSAPObjectType());
        values.put("SAPObjectNodeType", getSAPObjectNodeType());
        values.put("HarmonizedDocumentType", getHarmonizedDocumentType());
        values.put("AttachmentDeletionIsAllowed", getAttachmentDeletionIsAllowed());
        values.put("AttachmentRenameIsAllowed", getAttachmentRenameIsAllowed());
        values.put("Source", getSource());
        values.put("AttachmentContentHash", getAttachmentContentHash());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("LogicalDocument") ) {
                final Object value = values.remove("LogicalDocument");
                if( (value == null) || (!value.equals(getLogicalDocument())) ) {
                    setLogicalDocument(((String) value));
                }
            }
            if( values.containsKey("ArchiveDocumentID") ) {
                final Object value = values.remove("ArchiveDocumentID");
                if( (value == null) || (!value.equals(getArchiveDocumentID())) ) {
                    setArchiveDocumentID(((String) value));
                }
            }
            if( values.containsKey("LinkedSAPObjectKey") ) {
                final Object value = values.remove("LinkedSAPObjectKey");
                if( (value == null) || (!value.equals(getLinkedSAPObjectKey())) ) {
                    setLinkedSAPObjectKey(((String) value));
                }
            }
            if( values.containsKey("BusinessObjectTypeName") ) {
                final Object value = values.remove("BusinessObjectTypeName");
                if( (value == null) || (!value.equals(getBusinessObjectTypeName())) ) {
                    setBusinessObjectTypeName(((String) value));
                }
            }
            if( values.containsKey("SemanticObject") ) {
                final Object value = values.remove("SemanticObject");
                if( (value == null) || (!value.equals(getSemanticObject())) ) {
                    setSemanticObject(((String) value));
                }
            }
            if( values.containsKey("WorkstationApplication") ) {
                final Object value = values.remove("WorkstationApplication");
                if( (value == null) || (!value.equals(getWorkstationApplication())) ) {
                    setWorkstationApplication(((String) value));
                }
            }
            if( values.containsKey("FileSize") ) {
                final Object value = values.remove("FileSize");
                if( (value == null) || (!value.equals(getFileSize())) ) {
                    setFileSize(((String) value));
                }
            }
            if( values.containsKey("FileName") ) {
                final Object value = values.remove("FileName");
                if( (value == null) || (!value.equals(getFileName())) ) {
                    setFileName(((String) value));
                }
            }
            if( values.containsKey("DocumentURL") ) {
                final Object value = values.remove("DocumentURL");
                if( (value == null) || (!value.equals(getDocumentURL())) ) {
                    setDocumentURL(((String) value));
                }
            }
            if( values.containsKey("MimeType") ) {
                final Object value = values.remove("MimeType");
                if( (value == null) || (!value.equals(getMimeType())) ) {
                    setMimeType(((String) value));
                }
            }
            if( values.containsKey("Content") ) {
                final Object value = values.remove("Content");
                if( (value == null) || (!value.equals(getContent())) ) {
                    setContent(((byte[]) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreatedByUserFullName") ) {
                final Object value = values.remove("CreatedByUserFullName");
                if( (value == null) || (!value.equals(getCreatedByUserFullName())) ) {
                    setCreatedByUserFullName(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessObjectType") ) {
                final Object value = values.remove("BusinessObjectType");
                if( (value == null) || (!value.equals(getBusinessObjectType())) ) {
                    setBusinessObjectType(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUserFullName") ) {
                final Object value = values.remove("LastChangedByUserFullName");
                if( (value == null) || (!value.equals(getLastChangedByUserFullName())) ) {
                    setLastChangedByUserFullName(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StorageCategory") ) {
                final Object value = values.remove("StorageCategory");
                if( (value == null) || (!value.equals(getStorageCategory())) ) {
                    setStorageCategory(((String) value));
                }
            }
            if( values.containsKey("ArchiveLinkRepository") ) {
                final Object value = values.remove("ArchiveLinkRepository");
                if( (value == null) || (!value.equals(getArchiveLinkRepository())) ) {
                    setArchiveLinkRepository(((String) value));
                }
            }
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("SAPObjectNodeType") ) {
                final Object value = values.remove("SAPObjectNodeType");
                if( (value == null) || (!value.equals(getSAPObjectNodeType())) ) {
                    setSAPObjectNodeType(((String) value));
                }
            }
            if( values.containsKey("HarmonizedDocumentType") ) {
                final Object value = values.remove("HarmonizedDocumentType");
                if( (value == null) || (!value.equals(getHarmonizedDocumentType())) ) {
                    setHarmonizedDocumentType(((String) value));
                }
            }
            if( values.containsKey("AttachmentDeletionIsAllowed") ) {
                final Object value = values.remove("AttachmentDeletionIsAllowed");
                if( (value == null) || (!value.equals(getAttachmentDeletionIsAllowed())) ) {
                    setAttachmentDeletionIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("AttachmentRenameIsAllowed") ) {
                final Object value = values.remove("AttachmentRenameIsAllowed");
                if( (value == null) || (!value.equals(getAttachmentRenameIsAllowed())) ) {
                    setAttachmentRenameIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("Source") ) {
                final Object value = values.remove("Source");
                if( (value == null) || (!value.equals(getSource())) ) {
                    setSource(((String) value));
                }
            }
            if( values.containsKey("AttachmentContentHash") ) {
                final Object value = values.remove("AttachmentContentHash");
                if( (value == null) || (!value.equals(getAttachmentContentHash())) ) {
                    setAttachmentContentHash(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> AttachmentContentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AttachmentContentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AttachmentContentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AttachmentContentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService.DEFAULT_SERVICE_PATH);
    }

}
