/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent
 * AttachmentContent} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class AttachmentContentCreateFluentHelper
    extends
    FluentHelperCreate<AttachmentContentCreateFluentHelper, AttachmentContent>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent AttachmentContent} entity
     * object that will be created in the S/4HANA system.
     *
     */
    private final AttachmentContent entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentContent AttachmentContent} entity
     * on the OData endpoint. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The AttachmentContent to create.
     */
    public AttachmentContentCreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final AttachmentContent entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected AttachmentContent getEntity()
    {
        return entity;
    }

}
