/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.AttachmentHarmonizedOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable.AttachmentHarmonizedOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Harmonized Document Management
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>AttachmentHarmonizedOperation</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AttachmentHarmonizedOperation extends VdmEntity<AttachmentHarmonizedOperation>
{

    /**
     * Selector for all available fields of AttachmentHarmonizedOperation.
     *
     */
    public final static AttachmentHarmonizedOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return DocumentInfoRecordDocType
     */
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new AttachmentHarmonizedOperationField<String>("DocumentInfoRecordDocType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return DocumentInfoRecordDocNumber
     */
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new AttachmentHarmonizedOperationField<String>("DocumentInfoRecordDocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return DocumentInfoRecordDocVersion
     */
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new AttachmentHarmonizedOperationField<String>("DocumentInfoRecordDocVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return DocumentInfoRecordDocPart
     */
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new AttachmentHarmonizedOperationField<String>("DocumentInfoRecordDocPart");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>LogicalDocument</b>
     * </p>
     *
     * @return LogicalDocument
     */
    @Key
    @SerializedName( "LogicalDocument" )
    @JsonProperty( "LogicalDocument" )
    @Nullable
    @ODataField( odataName = "LogicalDocument" )
    private String logicalDocument;
    /**
     * Use with available fluent helpers to apply the <b>LogicalDocument</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> LOGICAL_DOCUMENT =
        new AttachmentHarmonizedOperationField<String>("LogicalDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveDocumentID</b>
     * </p>
     *
     * @return ArchiveDocumentID
     */
    @Key
    @SerializedName( "ArchiveDocumentID" )
    @JsonProperty( "ArchiveDocumentID" )
    @Nullable
    @ODataField( odataName = "ArchiveDocumentID" )
    private String archiveDocumentID;
    /**
     * Use with available fluent helpers to apply the <b>ArchiveDocumentID</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> ARCHIVE_DOCUMENT_ID =
        new AttachmentHarmonizedOperationField<String>("ArchiveDocumentID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @return LinkedSAPObjectKey
     */
    @Key
    @SerializedName( "LinkedSAPObjectKey" )
    @JsonProperty( "LinkedSAPObjectKey" )
    @Nullable
    @ODataField( odataName = "LinkedSAPObjectKey" )
    private String linkedSAPObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>LinkedSAPObjectKey</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> LINKED_SAP_OBJECT_KEY =
        new AttachmentHarmonizedOperationField<String>("LinkedSAPObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectTypeName</b>
     * </p>
     *
     * @return BusinessObjectTypeName
     */
    @SerializedName( "BusinessObjectTypeName" )
    @JsonProperty( "BusinessObjectTypeName" )
    @Nullable
    @ODataField( odataName = "BusinessObjectTypeName" )
    private String businessObjectTypeName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessObjectTypeName</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> BUSINESS_OBJECT_TYPE_NAME =
        new AttachmentHarmonizedOperationField<String>("BusinessObjectTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FileSize</b>
     * </p>
     *
     * @return FileSize
     */
    @SerializedName( "FileSize" )
    @JsonProperty( "FileSize" )
    @Nullable
    @ODataField( odataName = "FileSize" )
    private String fileSize;
    /**
     * Use with available fluent helpers to apply the <b>FileSize</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> FILE_SIZE =
        new AttachmentHarmonizedOperationField<String>("FileSize");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @return FileName
     */
    @SerializedName( "FileName" )
    @JsonProperty( "FileName" )
    @Nullable
    @ODataField( odataName = "FileName" )
    private String fileName;
    /**
     * Use with available fluent helpers to apply the <b>FileName</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> FILE_NAME =
        new AttachmentHarmonizedOperationField<String>("FileName");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     *
     * @return MimeType
     */
    @SerializedName( "MimeType" )
    @JsonProperty( "MimeType" )
    @Nullable
    @ODataField( odataName = "MimeType" )
    private String mimeType;
    /**
     * Use with available fluent helpers to apply the <b>MimeType</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> MIME_TYPE =
        new AttachmentHarmonizedOperationField<String>("MimeType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CheckoutUser</b>
     * </p>
     *
     * @return CheckoutUser
     */
    @SerializedName( "CheckoutUser" )
    @JsonProperty( "CheckoutUser" )
    @Nullable
    @ODataField( odataName = "CheckoutUser" )
    private String checkoutUser;
    /**
     * Use with available fluent helpers to apply the <b>CheckoutUser</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> CHECKOUT_USER =
        new AttachmentHarmonizedOperationField<String>("CheckoutUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CheckoutUserFullName</b>
     * </p>
     *
     * @return CheckoutUserFullName
     */
    @SerializedName( "CheckoutUserFullName" )
    @JsonProperty( "CheckoutUserFullName" )
    @Nullable
    @ODataField( odataName = "CheckoutUserFullName" )
    private String checkoutUserFullName;
    /**
     * Use with available fluent helpers to apply the <b>CheckoutUserFullName</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> CHECKOUT_USER_FULL_NAME =
        new AttachmentHarmonizedOperationField<String>("CheckoutUserFullName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return CreatedByUser
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> CREATED_BY_USER =
        new AttachmentHarmonizedOperationField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserFullName</b>
     * </p>
     *
     * @return CreatedByUserFullName
     */
    @SerializedName( "CreatedByUserFullName" )
    @JsonProperty( "CreatedByUserFullName" )
    @Nullable
    @ODataField( odataName = "CreatedByUserFullName" )
    private String createdByUserFullName;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUserFullName</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> CREATED_BY_USER_FULL_NAME =
        new AttachmentHarmonizedOperationField<String>("CreatedByUserFullName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return CreationDateTime
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<LocalDateTime> CREATION_DATE_TIME =
        new AttachmentHarmonizedOperationField<LocalDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return LastChangedByUser
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> LAST_CHANGED_BY_USER =
        new AttachmentHarmonizedOperationField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUserFullName</b>
     * </p>
     *
     * @return LastChangedByUserFullName
     */
    @SerializedName( "LastChangedByUserFullName" )
    @JsonProperty( "LastChangedByUserFullName" )
    @Nullable
    @ODataField( odataName = "LastChangedByUserFullName" )
    private String lastChangedByUserFullName;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUserFullName</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> LAST_CHANGED_BY_USER_FULL_NAME =
        new AttachmentHarmonizedOperationField<String>("LastChangedByUserFullName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return ChangedDateTime
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<LocalDateTime> CHANGED_DATE_TIME =
        new AttachmentHarmonizedOperationField<LocalDateTime>("ChangedDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageCategory</b>
     * </p>
     *
     * @return StorageCategory
     */
    @SerializedName( "StorageCategory" )
    @JsonProperty( "StorageCategory" )
    @Nullable
    @ODataField( odataName = "StorageCategory" )
    private String storageCategory;
    /**
     * Use with available fluent helpers to apply the <b>StorageCategory</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> STORAGE_CATEGORY =
        new AttachmentHarmonizedOperationField<String>("StorageCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveLinkRepository</b>
     * </p>
     *
     * @return ArchiveLinkRepository
     */
    @SerializedName( "ArchiveLinkRepository" )
    @JsonProperty( "ArchiveLinkRepository" )
    @Nullable
    @ODataField( odataName = "ArchiveLinkRepository" )
    private String archiveLinkRepository;
    /**
     * Use with available fluent helpers to apply the <b>ArchiveLinkRepository</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> ARCHIVE_LINK_REPOSITORY =
        new AttachmentHarmonizedOperationField<String>("ArchiveLinkRepository");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAPObjectType
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> SAP_OBJECT_TYPE =
        new AttachmentHarmonizedOperationField<String>("SAPObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectNodeType</b>
     * </p>
     *
     * @return SAPObjectNodeType
     */
    @SerializedName( "SAPObjectNodeType" )
    @JsonProperty( "SAPObjectNodeType" )
    @Nullable
    @ODataField( odataName = "SAPObjectNodeType" )
    private String sAPObjectNodeType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectNodeType</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> SAP_OBJECT_NODE_TYPE =
        new AttachmentHarmonizedOperationField<String>("SAPObjectNodeType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HarmonizedDocumentType</b>
     * </p>
     *
     * @return HarmonizedDocumentType
     */
    @Key
    @SerializedName( "HarmonizedDocumentType" )
    @JsonProperty( "HarmonizedDocumentType" )
    @Nullable
    @ODataField( odataName = "HarmonizedDocumentType" )
    private String harmonizedDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>HarmonizedDocumentType</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> HARMONIZED_DOCUMENT_TYPE =
        new AttachmentHarmonizedOperationField<String>("HarmonizedDocumentType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentDeletionIsAllowed</b>
     * </p>
     *
     * @return AttachmentDeletionIsAllowed
     */
    @SerializedName( "AttachmentDeletionIsAllowed" )
    @JsonProperty( "AttachmentDeletionIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AttachmentDeletionIsAllowed" )
    private Boolean attachmentDeletionIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>AttachmentDeletionIsAllowed</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<Boolean> ATTACHMENT_DELETION_IS_ALLOWED =
        new AttachmentHarmonizedOperationField<Boolean>("AttachmentDeletionIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentRenameIsAllowed</b>
     * </p>
     *
     * @return AttachmentRenameIsAllowed
     */
    @SerializedName( "AttachmentRenameIsAllowed" )
    @JsonProperty( "AttachmentRenameIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AttachmentRenameIsAllowed" )
    private Boolean attachmentRenameIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>AttachmentRenameIsAllowed</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<Boolean> ATTACHMENT_RENAME_IS_ALLOWED =
        new AttachmentHarmonizedOperationField<Boolean>("AttachmentRenameIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 4096
     * <p>
     * Original property name from the Odata EDM: <b>URLToUploadAttachment</b>
     * </p>
     *
     * @return URLToUploadAttachment
     */
    @SerializedName( "URLToUploadAttachment" )
    @JsonProperty( "URLToUploadAttachment" )
    @Nullable
    @ODataField( odataName = "URLToUploadAttachment" )
    private String uRLToUploadAttachment;
    /**
     * Use with available fluent helpers to apply the <b>URLToUploadAttachment</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> URL_TO_UPLOAD_ATTACHMENT =
        new AttachmentHarmonizedOperationField<String>("URLToUploadAttachment");
    /**
     * Constraints: Not nullable, Maximum length: 4096
     * <p>
     * Original property name from the Odata EDM: <b>URLToReadAttachment</b>
     * </p>
     *
     * @return URLToReadAttachment
     */
    @SerializedName( "URLToReadAttachment" )
    @JsonProperty( "URLToReadAttachment" )
    @Nullable
    @ODataField( odataName = "URLToReadAttachment" )
    private String uRLToReadAttachment;
    /**
     * Use with available fluent helpers to apply the <b>URLToReadAttachment</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> URL_TO_READ_ATTACHMENT =
        new AttachmentHarmonizedOperationField<String>("URLToReadAttachment");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>OneTimeValidTokenForAttachment</b>
     * </p>
     *
     * @return OneTimeValidTokenForAttachment
     */
    @SerializedName( "OneTimeValidTokenForAttachment" )
    @JsonProperty( "OneTimeValidTokenForAttachment" )
    @Nullable
    @ODataField( odataName = "OneTimeValidTokenForAttachment" )
    private String oneTimeValidTokenForAttachment;
    /**
     * Use with available fluent helpers to apply the <b>OneTimeValidTokenForAttachment</b> field to query operations.
     *
     */
    public final static AttachmentHarmonizedOperationField<String> ONE_TIME_VALID_TOKEN_FOR_ATTACHMENT =
        new AttachmentHarmonizedOperationField<String>("OneTimeValidTokenForAttachment");

    @Nonnull
    @Override
    public Class<AttachmentHarmonizedOperation> getType()
    {
        return AttachmentHarmonizedOperation.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            DocumentInfoRecordDocType
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            DocumentInfoRecordDocNumber
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            DocumentInfoRecordDocVersion
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            DocumentInfoRecordDocPart
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>LogicalDocument</b>
     * </p>
     *
     * @param logicalDocument
     *            LogicalDocument
     */
    public void setLogicalDocument( @Nullable final String logicalDocument )
    {
        rememberChangedField("LogicalDocument", this.logicalDocument);
        this.logicalDocument = logicalDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveDocumentID</b>
     * </p>
     *
     * @param archiveDocumentID
     *            ArchiveDocumentID
     */
    public void setArchiveDocumentID( @Nullable final String archiveDocumentID )
    {
        rememberChangedField("ArchiveDocumentID", this.archiveDocumentID);
        this.archiveDocumentID = archiveDocumentID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     */
    public void setLinkedSAPObjectKey( @Nullable final String linkedSAPObjectKey )
    {
        rememberChangedField("LinkedSAPObjectKey", this.linkedSAPObjectKey);
        this.linkedSAPObjectKey = linkedSAPObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessObjectTypeName</b>
     * </p>
     *
     * @param businessObjectTypeName
     *            BusinessObjectTypeName
     */
    public void setBusinessObjectTypeName( @Nullable final String businessObjectTypeName )
    {
        rememberChangedField("BusinessObjectTypeName", this.businessObjectTypeName);
        this.businessObjectTypeName = businessObjectTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FileSize</b>
     * </p>
     *
     * @param fileSize
     *            FileSize
     */
    public void setFileSize( @Nullable final String fileSize )
    {
        rememberChangedField("FileSize", this.fileSize);
        this.fileSize = fileSize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @param fileName
     *            FileName
     */
    public void setFileName( @Nullable final String fileName )
    {
        rememberChangedField("FileName", this.fileName);
        this.fileName = fileName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     *
     * @param mimeType
     *            MimeType
     */
    public void setMimeType( @Nullable final String mimeType )
    {
        rememberChangedField("MimeType", this.mimeType);
        this.mimeType = mimeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CheckoutUser</b>
     * </p>
     *
     * @param checkoutUser
     *            CheckoutUser
     */
    public void setCheckoutUser( @Nullable final String checkoutUser )
    {
        rememberChangedField("CheckoutUser", this.checkoutUser);
        this.checkoutUser = checkoutUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CheckoutUserFullName</b>
     * </p>
     *
     * @param checkoutUserFullName
     *            CheckoutUserFullName
     */
    public void setCheckoutUserFullName( @Nullable final String checkoutUserFullName )
    {
        rememberChangedField("CheckoutUserFullName", this.checkoutUserFullName);
        this.checkoutUserFullName = checkoutUserFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            CreatedByUser
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserFullName</b>
     * </p>
     *
     * @param createdByUserFullName
     *            CreatedByUserFullName
     */
    public void setCreatedByUserFullName( @Nullable final String createdByUserFullName )
    {
        rememberChangedField("CreatedByUserFullName", this.createdByUserFullName);
        this.createdByUserFullName = createdByUserFullName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            CreationDateTime
     */
    public void setCreationDateTime( @Nullable final LocalDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            LastChangedByUser
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUserFullName</b>
     * </p>
     *
     * @param lastChangedByUserFullName
     *            LastChangedByUserFullName
     */
    public void setLastChangedByUserFullName( @Nullable final String lastChangedByUserFullName )
    {
        rememberChangedField("LastChangedByUserFullName", this.lastChangedByUserFullName);
        this.lastChangedByUserFullName = lastChangedByUserFullName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            ChangedDateTime
     */
    public void setChangedDateTime( @Nullable final LocalDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageCategory</b>
     * </p>
     *
     * @param storageCategory
     *            StorageCategory
     */
    public void setStorageCategory( @Nullable final String storageCategory )
    {
        rememberChangedField("StorageCategory", this.storageCategory);
        this.storageCategory = storageCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ArchiveLinkRepository</b>
     * </p>
     *
     * @param archiveLinkRepository
     *            ArchiveLinkRepository
     */
    public void setArchiveLinkRepository( @Nullable final String archiveLinkRepository )
    {
        rememberChangedField("ArchiveLinkRepository", this.archiveLinkRepository);
        this.archiveLinkRepository = archiveLinkRepository;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAPObjectType
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectNodeType</b>
     * </p>
     *
     * @param sAPObjectNodeType
     *            SAPObjectNodeType
     */
    public void setSAPObjectNodeType( @Nullable final String sAPObjectNodeType )
    {
        rememberChangedField("SAPObjectNodeType", this.sAPObjectNodeType);
        this.sAPObjectNodeType = sAPObjectNodeType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HarmonizedDocumentType</b>
     * </p>
     *
     * @param harmonizedDocumentType
     *            HarmonizedDocumentType
     */
    public void setHarmonizedDocumentType( @Nullable final String harmonizedDocumentType )
    {
        rememberChangedField("HarmonizedDocumentType", this.harmonizedDocumentType);
        this.harmonizedDocumentType = harmonizedDocumentType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentDeletionIsAllowed</b>
     * </p>
     *
     * @param attachmentDeletionIsAllowed
     *            AttachmentDeletionIsAllowed
     */
    public void setAttachmentDeletionIsAllowed( @Nullable final Boolean attachmentDeletionIsAllowed )
    {
        rememberChangedField("AttachmentDeletionIsAllowed", this.attachmentDeletionIsAllowed);
        this.attachmentDeletionIsAllowed = attachmentDeletionIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentRenameIsAllowed</b>
     * </p>
     *
     * @param attachmentRenameIsAllowed
     *            AttachmentRenameIsAllowed
     */
    public void setAttachmentRenameIsAllowed( @Nullable final Boolean attachmentRenameIsAllowed )
    {
        rememberChangedField("AttachmentRenameIsAllowed", this.attachmentRenameIsAllowed);
        this.attachmentRenameIsAllowed = attachmentRenameIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4096
     * <p>
     * Original property name from the Odata EDM: <b>URLToUploadAttachment</b>
     * </p>
     *
     * @param uRLToUploadAttachment
     *            URLToUploadAttachment
     */
    public void setURLToUploadAttachment( @Nullable final String uRLToUploadAttachment )
    {
        rememberChangedField("URLToUploadAttachment", this.uRLToUploadAttachment);
        this.uRLToUploadAttachment = uRLToUploadAttachment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4096
     * <p>
     * Original property name from the Odata EDM: <b>URLToReadAttachment</b>
     * </p>
     *
     * @param uRLToReadAttachment
     *            URLToReadAttachment
     */
    public void setURLToReadAttachment( @Nullable final String uRLToReadAttachment )
    {
        rememberChangedField("URLToReadAttachment", this.uRLToReadAttachment);
        this.uRLToReadAttachment = uRLToReadAttachment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>OneTimeValidTokenForAttachment</b>
     * </p>
     *
     * @param oneTimeValidTokenForAttachment
     *            OneTimeValidTokenForAttachment
     */
    public void setOneTimeValidTokenForAttachment( @Nullable final String oneTimeValidTokenForAttachment )
    {
        rememberChangedField("OneTimeValidTokenForAttachment", this.oneTimeValidTokenForAttachment);
        this.oneTimeValidTokenForAttachment = oneTimeValidTokenForAttachment;
    }

    @Override
    protected String getEntityCollection()
    {
        return "AttachmentHarmonizedOperationSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LogicalDocument", getLogicalDocument());
        result.put("ArchiveDocumentID", getArchiveDocumentID());
        result.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        result.put("SAPObjectType", getSAPObjectType());
        result.put("HarmonizedDocumentType", getHarmonizedDocumentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("LogicalDocument", getLogicalDocument());
        values.put("ArchiveDocumentID", getArchiveDocumentID());
        values.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        values.put("BusinessObjectTypeName", getBusinessObjectTypeName());
        values.put("FileSize", getFileSize());
        values.put("FileName", getFileName());
        values.put("MimeType", getMimeType());
        values.put("CheckoutUser", getCheckoutUser());
        values.put("CheckoutUserFullName", getCheckoutUserFullName());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreatedByUserFullName", getCreatedByUserFullName());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangedByUserFullName", getLastChangedByUserFullName());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("StorageCategory", getStorageCategory());
        values.put("ArchiveLinkRepository", getArchiveLinkRepository());
        values.put("SAPObjectType", getSAPObjectType());
        values.put("SAPObjectNodeType", getSAPObjectNodeType());
        values.put("HarmonizedDocumentType", getHarmonizedDocumentType());
        values.put("AttachmentDeletionIsAllowed", getAttachmentDeletionIsAllowed());
        values.put("AttachmentRenameIsAllowed", getAttachmentRenameIsAllowed());
        values.put("URLToUploadAttachment", getURLToUploadAttachment());
        values.put("URLToReadAttachment", getURLToReadAttachment());
        values.put("OneTimeValidTokenForAttachment", getOneTimeValidTokenForAttachment());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("LogicalDocument") ) {
                final Object value = values.remove("LogicalDocument");
                if( (value == null) || (!value.equals(getLogicalDocument())) ) {
                    setLogicalDocument(((String) value));
                }
            }
            if( values.containsKey("ArchiveDocumentID") ) {
                final Object value = values.remove("ArchiveDocumentID");
                if( (value == null) || (!value.equals(getArchiveDocumentID())) ) {
                    setArchiveDocumentID(((String) value));
                }
            }
            if( values.containsKey("LinkedSAPObjectKey") ) {
                final Object value = values.remove("LinkedSAPObjectKey");
                if( (value == null) || (!value.equals(getLinkedSAPObjectKey())) ) {
                    setLinkedSAPObjectKey(((String) value));
                }
            }
            if( values.containsKey("BusinessObjectTypeName") ) {
                final Object value = values.remove("BusinessObjectTypeName");
                if( (value == null) || (!value.equals(getBusinessObjectTypeName())) ) {
                    setBusinessObjectTypeName(((String) value));
                }
            }
            if( values.containsKey("FileSize") ) {
                final Object value = values.remove("FileSize");
                if( (value == null) || (!value.equals(getFileSize())) ) {
                    setFileSize(((String) value));
                }
            }
            if( values.containsKey("FileName") ) {
                final Object value = values.remove("FileName");
                if( (value == null) || (!value.equals(getFileName())) ) {
                    setFileName(((String) value));
                }
            }
            if( values.containsKey("MimeType") ) {
                final Object value = values.remove("MimeType");
                if( (value == null) || (!value.equals(getMimeType())) ) {
                    setMimeType(((String) value));
                }
            }
            if( values.containsKey("CheckoutUser") ) {
                final Object value = values.remove("CheckoutUser");
                if( (value == null) || (!value.equals(getCheckoutUser())) ) {
                    setCheckoutUser(((String) value));
                }
            }
            if( values.containsKey("CheckoutUserFullName") ) {
                final Object value = values.remove("CheckoutUserFullName");
                if( (value == null) || (!value.equals(getCheckoutUserFullName())) ) {
                    setCheckoutUserFullName(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreatedByUserFullName") ) {
                final Object value = values.remove("CreatedByUserFullName");
                if( (value == null) || (!value.equals(getCreatedByUserFullName())) ) {
                    setCreatedByUserFullName(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUserFullName") ) {
                final Object value = values.remove("LastChangedByUserFullName");
                if( (value == null) || (!value.equals(getLastChangedByUserFullName())) ) {
                    setLastChangedByUserFullName(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StorageCategory") ) {
                final Object value = values.remove("StorageCategory");
                if( (value == null) || (!value.equals(getStorageCategory())) ) {
                    setStorageCategory(((String) value));
                }
            }
            if( values.containsKey("ArchiveLinkRepository") ) {
                final Object value = values.remove("ArchiveLinkRepository");
                if( (value == null) || (!value.equals(getArchiveLinkRepository())) ) {
                    setArchiveLinkRepository(((String) value));
                }
            }
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("SAPObjectNodeType") ) {
                final Object value = values.remove("SAPObjectNodeType");
                if( (value == null) || (!value.equals(getSAPObjectNodeType())) ) {
                    setSAPObjectNodeType(((String) value));
                }
            }
            if( values.containsKey("HarmonizedDocumentType") ) {
                final Object value = values.remove("HarmonizedDocumentType");
                if( (value == null) || (!value.equals(getHarmonizedDocumentType())) ) {
                    setHarmonizedDocumentType(((String) value));
                }
            }
            if( values.containsKey("AttachmentDeletionIsAllowed") ) {
                final Object value = values.remove("AttachmentDeletionIsAllowed");
                if( (value == null) || (!value.equals(getAttachmentDeletionIsAllowed())) ) {
                    setAttachmentDeletionIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("AttachmentRenameIsAllowed") ) {
                final Object value = values.remove("AttachmentRenameIsAllowed");
                if( (value == null) || (!value.equals(getAttachmentRenameIsAllowed())) ) {
                    setAttachmentRenameIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("URLToUploadAttachment") ) {
                final Object value = values.remove("URLToUploadAttachment");
                if( (value == null) || (!value.equals(getURLToUploadAttachment())) ) {
                    setURLToUploadAttachment(((String) value));
                }
            }
            if( values.containsKey("URLToReadAttachment") ) {
                final Object value = values.remove("URLToReadAttachment");
                if( (value == null) || (!value.equals(getURLToReadAttachment())) ) {
                    setURLToReadAttachment(((String) value));
                }
            }
            if( values.containsKey("OneTimeValidTokenForAttachment") ) {
                final Object value = values.remove("OneTimeValidTokenForAttachment");
                if( (value == null) || (!value.equals(getOneTimeValidTokenForAttachment())) ) {
                    setOneTimeValidTokenForAttachment(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> AttachmentHarmonizedOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new AttachmentHarmonizedOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AttachmentHarmonizedOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AttachmentHarmonizedOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService.DEFAULT_SERVICE_PATH);
    }

}
