/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable.AttachmentHarmonizedOperationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
 * AttachmentHarmonizedOperation} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class AttachmentHarmonizedOperationByKeyFluentHelper
    extends
    FluentHelperByKey<AttachmentHarmonizedOperationByKeyFluentHelper, AttachmentHarmonizedOperation, AttachmentHarmonizedOperationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.AttachmentHarmonizedOperation
     * AttachmentHarmonizedOperation} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code AttachmentHarmonizedOperation}
     * @param servicePath
     *            Service path to be used to fetch a single {@code AttachmentHarmonizedOperation}
     * @param archiveDocumentID
     *            ArchiveDocumentID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param linkedSAPObjectKey
     *            LinkedSAPObjectKey
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param sAPObjectType
     *            SAPObjectType
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param harmonizedDocumentType
     *            HarmonizedDocumentType
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param logicalDocument
     *            LogicalDocument
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     */
    public AttachmentHarmonizedOperationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String logicalDocument,
        final String archiveDocumentID,
        final String linkedSAPObjectKey,
        final String sAPObjectType,
        final String harmonizedDocumentType )
    {
        super(servicePath, entityCollection);
        this.key.put("LogicalDocument", logicalDocument);
        this.key.put("ArchiveDocumentID", archiveDocumentID);
        this.key.put("LinkedSAPObjectKey", linkedSAPObjectKey);
        this.key.put("SAPObjectType", sAPObjectType);
        this.key.put("HarmonizedDocumentType", harmonizedDocumentType);
    }

    @Override
    @Nonnull
    protected Class<AttachmentHarmonizedOperation> getEntityClass()
    {
        return AttachmentHarmonizedOperation.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
