/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>AttachmentsCount</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AttachmentsCount extends VdmComplex<AttachmentsCount>
{

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>AttachmentCount</b>
     * </p>
     *
     * @param attachmentCount
     *
     * @return AttachmentCount
     */
    @SerializedName( "AttachmentCount" )
    @JsonProperty( "AttachmentCount" )
    @Nullable
    @ODataField( odataName = "AttachmentCount" )
    private Short attachmentCount;

    @Nonnull
    @Override
    public Class<AttachmentsCount> getType()
    {
        return AttachmentsCount.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AttachmentCount", getAttachmentCount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AttachmentCount") ) {
                final Object value = values.remove("AttachmentCount");
                if( (value == null) || (!value.equals(getAttachmentCount())) ) {
                    setAttachmentCount(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>AttachmentCount</b>
     * </p>
     *
     * @param attachmentCount
     *            AttachmentCount
     */
    public void setAttachmentCount( @Nullable final Short attachmentCount )
    {
        rememberChangedField("AttachmentCount", this.attachmentCount);
        this.attachmentCount = attachmentCount;
    }

}
