/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.field.DocumentInfoRecordAttchField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.link.DocumentInfoRecordAttchLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.attachment.selectable.DocumentInfoRecordAttchSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Attachments for Document Info Record
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DocumentInfoRecordAttchType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentInfoRecordAttch extends VdmEntity<DocumentInfoRecordAttch>
{

    /**
     * Selector for all available fields of DocumentInfoRecordAttch.
     *
     */
    public final static DocumentInfoRecordAttchSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new DocumentInfoRecordAttchField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new DocumentInfoRecordAttchField<String>("DocumentInfoRecordDocNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new DocumentInfoRecordAttchField<String>("DocumentInfoRecordDocVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return Document Part
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new DocumentInfoRecordAttchField<String>("DocumentInfoRecordDocPart");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @return Document Info Record key in concatenated form
     */
    @SerializedName( "DocumentInfoRecord" )
    @JsonProperty( "DocumentInfoRecord" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecord" )
    private String documentInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecord</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> DOCUMENT_INFO_RECORD =
        new DocumentInfoRecordAttchField<String>("DocumentInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDescription</b>
     * </p>
     *
     * @return Document Description
     */
    @SerializedName( "DocumentDescription" )
    @JsonProperty( "DocumentDescription" )
    @Nullable
    @ODataField( odataName = "DocumentDescription" )
    private String documentDescription;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDescription</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> DOCUMENT_DESCRIPTION =
        new DocumentInfoRecordAttchField<String>("DocumentDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentStatus</b>
     * </p>
     *
     * @return Status of a document (language-dependent)
     */
    @SerializedName( "ExternalDocumentStatus" )
    @JsonProperty( "ExternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "ExternalDocumentStatus" )
    private String externalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>ExternalDocumentStatus</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> EXTERNAL_DOCUMENT_STATUS =
        new DocumentInfoRecordAttchField<String>("ExternalDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentStatusName</b>
     * </p>
     *
     * @return Description of document status
     */
    @SerializedName( "DocumentStatusName" )
    @JsonProperty( "DocumentStatusName" )
    @Nullable
    @ODataField( odataName = "DocumentStatusName" )
    private String documentStatusName;
    /**
     * Use with available fluent helpers to apply the <b>DocumentStatusName</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<String> DOCUMENT_STATUS_NAME =
        new DocumentInfoRecordAttchField<String>("DocumentStatusName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocInfoRecdIsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "DocInfoRecdIsMarkedForDeletion" )
    @JsonProperty( "DocInfoRecdIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocInfoRecdIsMarkedForDeletion" )
    private Boolean docInfoRecdIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>DocInfoRecdIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordAttchField<Boolean> DOC_INFO_RECD_IS_MARKED_FOR_DELETION =
        new DocumentInfoRecordAttchField<Boolean>("DocInfoRecdIsMarkedForDeletion");
    /**
     * Navigation property <b>DocumentInfoRecordToAttachmentNavigation</b> for <b>DocumentInfoRecordAttch</b> to
     * multiple <b>AttachmentContent</b>.
     *
     */
    @SerializedName( "DocumentInfoRecordToAttachmentNavigation" )
    @JsonProperty( "DocumentInfoRecordToAttachmentNavigation" )
    @ODataField( odataName = "DocumentInfoRecordToAttachmentNavigation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<AttachmentContent> toDocumentInfoRecordToAttachmentNavigation;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordToAttachmentNavigation</b> navigation
     * property to query operations.
     *
     */
    public final static DocumentInfoRecordAttchLink<AttachmentContent> TO_DOCUMENT_INFO_RECORD_TO_ATTACHMENT_NAVIGATION =
        new DocumentInfoRecordAttchLink<AttachmentContent>("DocumentInfoRecordToAttachmentNavigation");

    @Nonnull
    @Override
    public Class<DocumentInfoRecordAttch> getType()
    {
        return DocumentInfoRecordAttch.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            Document Type
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            Document number
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            Document Version
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            Document Part
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @param documentInfoRecord
     *            Document Info Record key in concatenated form
     */
    public void setDocumentInfoRecord( @Nullable final String documentInfoRecord )
    {
        rememberChangedField("DocumentInfoRecord", this.documentInfoRecord);
        this.documentInfoRecord = documentInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDescription</b>
     * </p>
     *
     * @param documentDescription
     *            Document Description
     */
    public void setDocumentDescription( @Nullable final String documentDescription )
    {
        rememberChangedField("DocumentDescription", this.documentDescription);
        this.documentDescription = documentDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentStatus</b>
     * </p>
     *
     * @param externalDocumentStatus
     *            Status of a document (language-dependent)
     */
    public void setExternalDocumentStatus( @Nullable final String externalDocumentStatus )
    {
        rememberChangedField("ExternalDocumentStatus", this.externalDocumentStatus);
        this.externalDocumentStatus = externalDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentStatusName</b>
     * </p>
     *
     * @param documentStatusName
     *            Description of document status
     */
    public void setDocumentStatusName( @Nullable final String documentStatusName )
    {
        rememberChangedField("DocumentStatusName", this.documentStatusName);
        this.documentStatusName = documentStatusName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocInfoRecdIsMarkedForDeletion</b>
     * </p>
     *
     * @param docInfoRecdIsMarkedForDeletion
     *            Deletion Indicator
     */
    public void setDocInfoRecdIsMarkedForDeletion( @Nullable final Boolean docInfoRecdIsMarkedForDeletion )
    {
        rememberChangedField("DocInfoRecdIsMarkedForDeletion", this.docInfoRecdIsMarkedForDeletion);
        this.docInfoRecdIsMarkedForDeletion = docInfoRecdIsMarkedForDeletion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DocumentInfoRecordAttch";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        result.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        result.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("DocumentInfoRecord", getDocumentInfoRecord());
        values.put("DocumentDescription", getDocumentDescription());
        values.put("ExternalDocumentStatus", getExternalDocumentStatus());
        values.put("DocumentStatusName", getDocumentStatusName());
        values.put("DocInfoRecdIsMarkedForDeletion", getDocInfoRecdIsMarkedForDeletion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecord") ) {
                final Object value = values.remove("DocumentInfoRecord");
                if( (value == null) || (!value.equals(getDocumentInfoRecord())) ) {
                    setDocumentInfoRecord(((String) value));
                }
            }
            if( values.containsKey("DocumentDescription") ) {
                final Object value = values.remove("DocumentDescription");
                if( (value == null) || (!value.equals(getDocumentDescription())) ) {
                    setDocumentDescription(((String) value));
                }
            }
            if( values.containsKey("ExternalDocumentStatus") ) {
                final Object value = values.remove("ExternalDocumentStatus");
                if( (value == null) || (!value.equals(getExternalDocumentStatus())) ) {
                    setExternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("DocumentStatusName") ) {
                final Object value = values.remove("DocumentStatusName");
                if( (value == null) || (!value.equals(getDocumentStatusName())) ) {
                    setDocumentStatusName(((String) value));
                }
            }
            if( values.containsKey("DocInfoRecdIsMarkedForDeletion") ) {
                final Object value = values.remove("DocInfoRecdIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getDocInfoRecdIsMarkedForDeletion())) ) {
                    setDocInfoRecdIsMarkedForDeletion(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("DocumentInfoRecordToAttachmentNavigation") ) {
                final Object value = (values).remove("DocumentInfoRecordToAttachmentNavigation");
                if( value instanceof Iterable ) {
                    if( toDocumentInfoRecordToAttachmentNavigation == null ) {
                        toDocumentInfoRecordToAttachmentNavigation = Lists.newArrayList();
                    } else {
                        toDocumentInfoRecordToAttachmentNavigation =
                            Lists.newArrayList(toDocumentInfoRecordToAttachmentNavigation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        AttachmentContent entity;
                        if( toDocumentInfoRecordToAttachmentNavigation.size() > i ) {
                            entity = toDocumentInfoRecordToAttachmentNavigation.get(i);
                        } else {
                            entity = new AttachmentContent();
                            toDocumentInfoRecordToAttachmentNavigation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DocumentInfoRecordAttchField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DocumentInfoRecordAttchField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentInfoRecordAttchField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentInfoRecordAttchField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.AttachmentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDocumentInfoRecordToAttachmentNavigation != null ) {
            (values).put("DocumentInfoRecordToAttachmentNavigation", toDocumentInfoRecordToAttachmentNavigation);
        }
        return values;
    }

    /**
     * Fetches the <b>AttachmentContent</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>DocumentInfoRecordToAttachmentNavigation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>AttachmentContent</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<AttachmentContent> fetchDocumentInfoRecordToAttachmentNavigation()
    {
        return fetchFieldAsList("DocumentInfoRecordToAttachmentNavigation", AttachmentContent.class);
    }

    /**
     * Retrieval of associated <b>AttachmentContent</b> entities (one to many). This corresponds to the OData navigation
     * property <b>DocumentInfoRecordToAttachmentNavigation</b>.
     * <p>
     * If the navigation property <b>DocumentInfoRecordToAttachmentNavigation</b> of a queried
     * <b>DocumentInfoRecordAttch</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an OData
     * query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>AttachmentContent</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<AttachmentContent> getDocumentInfoRecordToAttachmentNavigationOrFetch()
    {
        if( toDocumentInfoRecordToAttachmentNavigation == null ) {
            toDocumentInfoRecordToAttachmentNavigation = fetchDocumentInfoRecordToAttachmentNavigation();
        }
        return toDocumentInfoRecordToAttachmentNavigation;
    }

    /**
     * Retrieval of associated <b>AttachmentContent</b> entities (one to many). This corresponds to the OData navigation
     * property <b>DocumentInfoRecordToAttachmentNavigation</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecordAttch</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>DocumentInfoRecordToAttachmentNavigation</b> is already
     *         loaded, the result will contain the <b>AttachmentContent</b> entities. If not, an <code>Option</code>
     *         with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<AttachmentContent>> getDocumentInfoRecordToAttachmentNavigationIfPresent()
    {
        return Option.of(toDocumentInfoRecordToAttachmentNavigation);
    }

    /**
     * Overwrites the list of associated <b>AttachmentContent</b> entities for the loaded navigation property
     * <b>DocumentInfoRecordToAttachmentNavigation</b>.
     * <p>
     * If the navigation property <b>DocumentInfoRecordToAttachmentNavigation</b> of a queried
     * <b>DocumentInfoRecordAttch</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an OData
     * query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>AttachmentContent</b> entities.
     */
    public void setDocumentInfoRecordToAttachmentNavigation( @Nonnull final List<AttachmentContent> value )
    {
        if( toDocumentInfoRecordToAttachmentNavigation == null ) {
            toDocumentInfoRecordToAttachmentNavigation = Lists.newArrayList();
        }
        toDocumentInfoRecordToAttachmentNavigation.clear();
        toDocumentInfoRecordToAttachmentNavigation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>AttachmentContent</b> entities. This corresponds to the OData
     * navigation property <b>DocumentInfoRecordToAttachmentNavigation</b>.
     * <p>
     * If the navigation property <b>DocumentInfoRecordToAttachmentNavigation</b> of a queried
     * <b>DocumentInfoRecordAttch</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an OData
     * query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>AttachmentContent</b> entities.
     */
    public void addDocumentInfoRecordToAttachmentNavigation( AttachmentContent... entity )
    {
        if( toDocumentInfoRecordToAttachmentNavigation == null ) {
            toDocumentInfoRecordToAttachmentNavigation = Lists.newArrayList();
        }
        toDocumentInfoRecordToAttachmentNavigation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of DocumentInfoRecordAttch instances.
     *
     */
    public final static class DocumentInfoRecordAttchBuilder
    {

        private List<AttachmentContent> toDocumentInfoRecordToAttachmentNavigation = Lists.newArrayList();

        private DocumentInfoRecordAttch.DocumentInfoRecordAttchBuilder toDocumentInfoRecordToAttachmentNavigation(
            final List<AttachmentContent> value )
        {
            toDocumentInfoRecordToAttachmentNavigation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>DocumentInfoRecordToAttachmentNavigation</b> for <b>DocumentInfoRecordAttch</b> to
         * multiple <b>AttachmentContent</b>.
         *
         * @param value
         *            The AttachmentContents to build this DocumentInfoRecordAttch with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecordAttch.DocumentInfoRecordAttchBuilder documentInfoRecordToAttachmentNavigation(
            AttachmentContent... value )
        {
            return toDocumentInfoRecordToAttachmentNavigation(Lists.newArrayList(value));
        }

    }

}
